/*-----------------------------------------------------------------------------
   gensync.h     Inclusion file for "C" General Synchronous Support

   Use this inclusion file to define the external function calls and the
   data types used in conjunction with the General Synchronous Communications
   Support facility (linked in gensync.o)				     */

extern unsigned gsc_open();	/* function calls---see documentation */
extern unsigned gsc_close();
extern unsigned gsc_read();
extern unsigned gsc_read_ovl();
extern unsigned gsc_check_read_ovl();
extern unsigned gsc_write();
extern unsigned gsc_write_ovl();
extern unsigned gsc_check_write_ovl();
extern unsigned gsc_control();
extern unsigned gsc_deinstall();
extern unsigned gsc_status();

#define BUFFER_OVERFLOW		8001	/* return codes for above functions */
#define LOST_CTS		8002
#define LOST_RLSD		8003
#define RX_OVERRUN		8005
#define PARITY_ERROR		8006
#define CRC_ERROR		8007
#define LOST_DSR		8009
#define PARAMETER_ERROR		8094
#define INVALID_COMM_HANDLE	8095
#define LOST_SYNCHRONIZATION	8096
#define TX_UNDERRUN		8097
#define TIMEOUT			8098
#define UNABLE_TO_DEINSTALL	8099
#define UNKNOWN_DEVICE		8400
#define DEVICE_IN_USE		8401

#define BOOLEAN	char		/* one byte true/false value */
#define TRUE	(1)		/* any non-zero value would do */
#define FALSE	(0)
#define BYTE	char		/* same as character, but intent is byte */
#define RS232C	unsigned	/* status or control; bits used as follows: */

#define RTS	0X0080		/* request to send */
#define CTS	0X0040		/* clear to send */
#define DSR	0X0020		/* data set ready */
#define RLSD	0X0010		/* receive line signal detect (carrier) */
#define SRLSD	0X0008		/* secondary receive line signal detect */
#define SCTS	0X0004		/* secondary clear to send */
#define STD	0X0002		/* secondary transmit data */
#define SRD	0X0001		/* secondary receive data */
#define SRTS	0X8000		/* secondary request to send */
#define DTR	0X4000		/* data terminal ready */
#define SQ	0X2000		/* signal quality */
#define RI	0X1000		/* ring indicator */
#define RS	0X0800		/* rate select */

#define	EVEN		0	/* even parity */
#define	ODD		1	/* odd parity */
#define CRC_16		0	/* select (x**16) + (x**15) + (x**2) + 1 */
#define CCITT_CRC	1	/* select (x**16) + (x**12) + (x**5) + 1 */
#define	FDX		0	/* full-duplex transmissions */
#define	HDX		1	/* half-duplex transmissions */
#define	ASCII		0	/* ASCII character set */
#define EBCDIC		1	/* EBCDIC character set */
#define	EXT_CLK		0	/* external clocking */
#define	INT_CLK		1	/* clocking from workstation */
#define	NONTRANSP	0	/* nontransparent (normal) transmission */
#define	TRANSP		1	/* transparent transmission */

typedef struct {		/* General Synchronous Parameter Block */
    BYTE char_size;		/* character size in bits (5..8) */
    BYTE parity;		/* odd/even parity */
    BOOLEAN parity_enable;	/* parity disable/enable */
    BYTE n_syn_char;		/* number of SYN characters */
    char syn_char[2];		/* SYN character(s) */
    BOOLEAN syn_strip;		/* SYN char(s) reception disable/enable */
    BYTE crc_select;		/* select CRC-16 or CCITT-CRC (see defines) */
    BOOLEAN crc_enable;		/* CRC calculation disable/enable */
    BYTE n_wires;		/* full- or half-duplex */
    unsigned reserved[11];	/* used by System Service */
} GSPB, *GSPB_PTR;
