/***************************************************************************\
*
* Module Name: PMSPL.H
*
* OS/2 Presentation Manager Spooler constants, types and function declarations
*
* Copyright (c) 1989  IBM Corporation
* Copyright (c) 1989-1990, Microsoft Corporation. All rights reserved.
* Copyright 1991, Unisys Corporation.  All rights reserved.
*
* =============================================================================
*
* The following symbols are used in this file for conditional sections.
*
* INCL_SPLERRORS                - defined if INCL_ERRORS defined
*
\***************************************************************************/

/* if error definitions are required then allow Spooler errors */
#ifdef INCL_ERRORS
    #define INCL_SPLERRORS
#endif /* INCL_ERRORS */

/* common types, constants and function declarations             */

/* General SPL return values */
#define SPL_ERROR     0L
#define SPL_OK        1L

/* handle to a spool file */
typedef LHANDLE HSPL;               /* hspl */
/* handle to a spooler queue processor */
typedef LHANDLE HPROC;              /* hproc */
/* spooler manager open data */
typedef PSZ FAR *PQMOPENDATA;       /* pqmdop */
/* spooler processor open data */
typedef PSZ FAR *PQPOPENDATA;       /* pqpdop */
/* Used in recording of IBMQSTD data via SplStdxxx calls */
typedef LHANDLE HSTD;               /* hstd */

/* Spooler Queue Manager Interface */
HSPL   APIENTRY SplQmOpen( PSZ, LONG, PQMOPENDATA );
BOOL   APIENTRY SplQmStartDoc( HSPL, PSZ );
BOOL   APIENTRY SplQmWrite( HSPL, LONG, PBYTE );
USHORT APIENTRY SplQmEndDoc( HSPL );
BOOL   APIENTRY SplQmClose( HSPL );
BOOL   APIENTRY SplQmAbort( HSPL );

/* Spool Queue Processor Functions     */
BOOL  APIENTRY SplQpQueryDt( PLONG, PSZ * );
BOOL  APIENTRY SplQpInstall( HWND );

/* Error information for SplMessageBox */
#define SPLINFO_QPERROR       0x0001
#define SPLINFO_DDERROR       0x0002
#define SPLINFO_SPLERROR      0x0004
#define SPLINFO_OTHERERROR    0x0080
#define SPLINFO_INFORMATION   (SEVERITY_NOERROR << 16)
#define SPLINFO_WARNING       (SEVERITY_WARNING << 16)
#define SPLINFO_ERROR         (SEVERITY_ERROR   << 16)
#define SPLINFO_SEVERE        (SEVERITY_SEVERE  << 16)
#define SPLINFO_USERINTREQD   0x1000

/* Error Data for SplMessageBox */
#define SPLDATA_PRINTERJAM    1
#define SPLDATA_FORMCHGREQD   2
#define SPLDATA_CARTCHGREQD   4
#define SPLDATA_PENCHGREQD    8
#define SPLDATA_DATAERROR     16
#define SPLDATA_UNEXPECTERROR 32
#define SPLDATA_OTHER         32768

/* Style for SplMessageBox */
/* Same as for WinMsgBox see PMWIN.H for details */

/* Spooler message interface */
USHORT  APIENTRY SplMessageBox( PSZ, USHORT, USHORT
                              , PSZ, PSZ, USHORT, USHORT );

/* return code for SplStdQueryLength */
#define SSQL_ERROR (-1L)

/* PM_Q_STD Datatype functions  */
BOOL APIENTRY SplStdOpen( HDC );
BOOL APIENTRY SplStdClose( HDC );
BOOL APIENTRY SplStdStart( HDC );
HSTD APIENTRY SplStdStop( HDC );
BOOL APIENTRY SplStdDelete( HSTD );
BOOL APIENTRY SplStdGetBits ( HSTD, LONG, LONG, PCH );
LONG APIENTRY SplStdQueryLength (HSTD);

#ifdef INCL_SPLERRORS

#define PMERR_SPL_DRIVER_ERROR             0x4001
#define PMERR_SPL_DEVICE_ERROR             0x4002
#define PMERR_SPL_DEVICE_NOT_INSTALLED     0x4003
#define PMERR_SPL_QUEUE_ERROR              0x4004
#define PMERR_SPL_INV_HSPL                 0x4005
#define PMERR_SPL_NO_DISK_SPACE            0x4006
#define PMERR_SPL_NO_MEMORY                0x4007
#define PMERR_SPL_PRINT_ABORT              0x4008
#define PMERR_SPL_SPOOLER_NOT_INSTALLED    0x4009
#define PMERR_SPL_INV_FORMS_CODE           0x400A
#define PMERR_SPL_INV_PRIORITY             0x400B
#define PMERR_SPL_NO_FREE_JOB_ID           0x400C
#define PMERR_SPL_NO_DATA                  0x400D
#define PMERR_SPL_INV_TOKEN                0x400E
#define PMERR_SPL_INV_DATATYPE             0x400F
#define PMERR_SPL_PROCESSOR_ERROR          0x4010
#define PMERR_SPL_INV_JOB_ID               0x4011
#define PMERR_SPL_JOB_NOT_PRINTING         0x4012
#define PMERR_SPL_JOB_PRINTING             0x4013
#define PMERR_SPL_QUEUE_ALREADY_EXISTS     0x4014
#define PMERR_SPL_INV_QUEUE_NAME           0x4015
#define PMERR_SPL_QUEUE_NOT_EMPTY          0x4016
#define PMERR_SPL_DEVICE_ALREADY_EXISTS    0x4017
#define PMERR_SPL_DEVICE_LIMIT_REACHED     0x4018
#define PMERR_SPL_STATUS_STRING_TRUNC      0x4019
#define PMERR_SPL_INV_LENGTH_OR_COUNT      0x401A
#define PMERR_SPL_FILE_NOT_FOUND           0x401B
#define PMERR_SPL_CANNOT_OPEN_FILE         0x401C
#define PMERR_SPL_DRIVER_NOT_INSTALLED     0x401D
#define PMERR_SPL_INV_PROCESSOR_DATTYPE    0x401E
#define PMERR_SPL_INV_DRIVER_DATATYPE      0x401F
#define PMERR_SPL_PROCESSOR_NOT_INST       0x4020
#define PMERR_SPL_NO_SUCH_LOG_ADDRESS      0x4021
#define PMERR_SPL_PRINTER_NOT_FOUND        0x4022
#define PMERR_SPL_DD_NOT_FOUND             0x4023
#define PMERR_SPL_QUEUE_NOT_FOUND          0x4024
#define PMERR_SPL_MANY_QUEUES_ASSOC        0x4025
#define PMERR_SPL_NO_QUEUES_ASSOCIATED     0x4026
#define PMERR_SPL_INI_FILE_ERROR           0x4027
#define PMERR_SPL_NO_DEFAULT_QUEUE         0x4028
#define PMERR_SPL_NO_CURRENT_FORMS_CODE    0x4029
#define PMERR_SPL_NOT_AUTHORISED           0x402A
#define PMERR_SPL_TEMP_NETWORK_ERROR       0x402B
#define PMERR_SPL_HARD_NETWORK_ERROR       0x402C
#define PMERR_DEL_NOT_ALLOWED              0x402D
#define PMERR_CANNOT_DEL_QP_REF            0x402E
#define PMERR_CANNOT_DEL_QNAME_REF         0x402F
#define PMERR_CANNOT_DEL_PRINTER_DD_REF    0x4030
#define PMERR_CANNOT_DEL_PRN_NAME_REF      0x4031
#define PMERR_CANNOT_DEL_PRN_ADDR_REF      0x4032
#define PMERR_SPOOLER_QP_NOT_DEFINED       0x4033
#define PMERR_PRN_NAME_NOT_DEFINED         0x4034
#define PMERR_PRN_ADDR_NOT_DEFINED         0x4035
#define PMERR_PRINTER_DD_NOT_DEFINED       0x4036
#define PMERR_PRINTER_QUEUE_NOT_DEFINED    0x4037
#define PMERR_PRN_ADDR_IN_USE              0x4038
#define PMERR_SPL_TOO_MANY_OPEN_FILES      0x4039
#define PMERR_UNABLE_TO_CLOSE_DEVICE       0x4040

#endif /* INCL_SPLERRORS */
