/***
*signal.h - function declarations for signal handling
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This include file contains the function declarations for the library
*	functions related to signal handling.
*	[POSIX/ANSI]
*
****/

#if !defined(_SIGNAL_DEFINED)

#define _SIGNAL_DEFINED

#if defined(_POSIX_SOURCE) /* all posix source, then !posix original */
#include <sys/types.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/* signal #defines */

#define NSIG 32

#define DEFAULTSIGNALS 0xF1F5AF
#define ALLSIGNALS     0xFBF5AF

#define SA_NOCLDSTOP 0x0001

#define SIG_BLOCK   0
#define SIG_UNBLOCK 1
#define SIG_SETMASK 2
#endif

#define SIG_BAD ((void (_FAR_ * _FAR_ _cdecl)(signed int)) -1)
#define SIG_DFL ((void (_FAR_ * _FAR_ _cdecl)(signed int)) 0)
#define SIG_IGN ((void (_FAR_ * _FAR_ _cdecl)(signed int)) 1)
#define SIG_ERR ((void (_FAR_ * _FAR_ _cdecl)(signed int)) 2)

#define SIGHUP   1
#define SIGINT   2
#define SIGQUIT  3
#define SIGILL   4
#define SIGABRT  6
#define SIGFPE   8
#define SIGKILL  9
#define SIGSEGV 11
#define SIGPIPE 13
#define SIGALRM 14
#define SIGTERM 15
#define SIGUSR1 16
#define SIGUSR2 17
#define SIGCHLD 18
#define SIGCONT 20
#define SIGSTOP 21
#define SIGTSTP 22
#define SIGTTIN 23
#define SIGTTOU 24

#define SIGTRAP    5
#define SIGIOT     6
#define SIGEMT     7
#define SIGBUS    10
#define SIGSYS    12
#define SIGCLD    18
#define SIGPWR    19
#define SIGUNUSED 32


/* signal structures */

typedef  signed int     sig_atomic_t;
typedef  unsigned long  sigset_t;

struct sigaction {
	void (_FAR_ * _FAR_ _cdecl sa_handler)(signed int);
	sigset_t sa_mask;
	signed int sa_flags;
	};


/* function prototypes */

extern signed int _FAR_ _cdecl kill(pid_t, signed int);
extern signed int _FAR_ _cdecl raise(signed int);
extern signed int _FAR_ _cdecl sigemptyset(sigset_t _FAR_ *);
extern signed int _FAR_ _cdecl sigfillset(sigset_t _FAR_ *);
extern signed int _FAR_ _cdecl sigaddset(sigset_t _FAR_ *, signed int);
extern signed int _FAR_ _cdecl sigdelset(sigset_t _FAR_ *, signed int);
extern signed int _FAR_ _cdecl sigismember(const sigset_t _FAR_ *,
	signed int);
extern signed int _FAR_ _cdecl sigaction(signed int,
	const struct sigaction _FAR_ *, struct sigaction _FAR_ *);
extern signed int _FAR_ _cdecl sigprocmask(signed int, const sigset_t _FAR_ *,
	sigset_t _FAR_ *);
extern signed int _FAR_ _cdecl sigpending(sigset_t _FAR_ *);
extern signed int _FAR_ _cdecl sigsuspend(const sigset_t _FAR_ *);
extern void (_FAR_ * _FAR_ _cdecl signal(signed int,
	void (_FAR_ * _FAR_ _cdecl)(signed int)))(signed int);

#else /************** !_POSIX_SOURCE ****************/

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#ifdef _MT
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

#ifdef	_DLL
#define _LOADDS_ _loadds
#else
#define _LOADDS_
#endif

#ifndef _SIG_ATOMIC_T_DEFINED
typedef int sig_atomic_t;
#define _SIG_ATOMIC_T_DEFINED
#endif


#define NSIG 23     /* maximum signal number + 1 */

/* signal types */
/* SIGINT, SIGFPE, SIGILL, SIGSEGV, and SIGABRT are recognized on DOS 3.x */

#define SIGINT		2	/* interrupt - corresponds to DOS 3.x int 23H */
#define SIGILL		4	/* illegal instruction - invalid function image */
#define SIGFPE		8	/* floating point exception */
#define SIGSEGV 	11	/* segment violation */
#define SIGTERM 	15	/* Software termination signal from kill */
#define SIGUSR1 	16	/* User defined signal 1 */
#define SIGUSR2 	17	/* User defined signal 2 */
#define SIGUSR3 	20	/* User defined signal 3 */
#define SIGBREAK	21	/* Ctrl-Break sequence */
#define SIGABRT 	22	/* abnormal termination triggered by abort call */


/* signal action codes */
/* SIG_DFL and SIG_IGN are recognized on DOS 3.x */

#define SIG_DFL (void (_FAR_ _cdecl _LOADDS_ *)())0	 /* default signal action */
#define SIG_IGN (void (_FAR_ _cdecl _LOADDS_ *)())1	 /* ignore */
#define SIG_SGE (void (_FAR_ _cdecl _LOADDS_ *)())3	 /* signal gets error */
#define SIG_ACK (void (_FAR_ _cdecl _LOADDS_ *)())4	 /* error if handler not setup */


/* signal error value (returned by signal call on error) */

#define SIG_ERR (void (_FAR_ _cdecl _LOADDS_ *)())-1	 /* signal error value */


/* function prototypes */

void (_FAR_ _cdecl _LOADDS_ * _FAR_ _cdecl signal(int,
	void (_FAR_ _cdecl _LOADDS_ *)()))();
#ifndef _MT
int _FAR_ _cdecl raise(int);
#endif

#endif /* #else !_POSIX_SOURCE */
#endif /* !_SIGNAL_DEFINED */
