/***
*string.h - declarations for string manipulation functions
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file contains the function declarations for the string
*	manipulation functions.
*	[POSIX/ANSI/System V]
*
****/

#if !defined(_STRING_DEFINED)

#define _STRING_DEFINED

#include <stddef.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif

/* function prototypes */

#if !defined(_POSIX_SOURCE)
extern char _FAR_ * _FAR_ _cdecl _strerror(const char _FAR_ *);
extern void _FAR_ * _FAR_ _cdecl memccpy(void _FAR_ *, const void _FAR_ *,
	signed int, unsigned int);
extern signed int _FAR_ _cdecl memicmp(const void _FAR_ *, const void _FAR_ *,
	unsigned int);
extern void _FAR_ _cdecl movedata(unsigned int, unsigned int, unsigned int,
	unsigned int, unsigned int);
extern signed int _FAR_ _cdecl strcmpi(const char _FAR_ *,
	const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strdup(const char _FAR_ *);
extern signed int _FAR_ _cdecl stricmp(const char _FAR_ *,
	const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strlwr(char _FAR_ *);
extern signed int _FAR_ _cdecl strnicmp(const char _FAR_ *,
	const char _FAR_ *, size_t);
extern char _FAR_ * _FAR_ _cdecl strnset(char _FAR_ *, signed int, size_t);
extern char _FAR_ * _FAR_ _cdecl strrev(char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strset(char _FAR_ *, signed int);
extern char _FAR_ * _FAR_ _cdecl strupr(char _FAR_ *);
#endif /* !_POSIX_SOURCE */
extern void _FAR_ * _FAR_ _cdecl memchr(const void _FAR_ *, signed int,
	size_t);
extern signed int _FAR_ _cdecl memcmp(const void _FAR_ *, const void _FAR_ *,
	size_t);
extern void _FAR_ * _FAR_ _cdecl memcpy(void _FAR_ *, const void _FAR_ *,
	size_t);
extern void _FAR_ * _FAR_ _cdecl memmove(void _FAR_ *, const void _FAR_ *,
	size_t);
extern void _FAR_ * _FAR_ _cdecl memset(void _FAR_ *, signed int, size_t);
extern char _FAR_ * _FAR_ _cdecl strcat(char _FAR_ *, const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strchr(const char _FAR_ *, signed int);
extern signed int _FAR_ _cdecl strcmp(const char _FAR_ *, const char _FAR_ *);
extern signed int _FAR_ _cdecl strcoll(const char _FAR_ *,
	const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strcpy(char _FAR_ *, const char _FAR_ *);
extern size_t _FAR_ _cdecl strcspn(const char _FAR_ *, const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strerror(signed int);
extern size_t _FAR_ _cdecl strlen(const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strncat(char _FAR_ *, const char _FAR_ *,
	size_t);
extern signed int _FAR_ _cdecl strncmp(const char _FAR_ *, const char _FAR_ *,
	size_t);
extern char _FAR_ * _FAR_ _cdecl strncpy(char _FAR_ *, const char _FAR_ *,
	size_t);
extern char _FAR_ * _FAR_ _cdecl strpbrk(const char _FAR_ *,
	const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strrchr(const char _FAR_ *, signed int);
extern size_t _FAR_ _cdecl strspn(const char _FAR_ *, const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strstr(const char _FAR_ *,
	const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl strtok(char _FAR_ *, const char _FAR_ *);
extern size_t _FAR_ _cdecl strxfrm (char _FAR_ *, const char _FAR_ *,
	size_t);

#if !defined(_POSIX_SOURCE)
/* model independent function prototypes */

extern void _far * _far _cdecl _fmemccpy(void _far *, const void _far *,
	signed int, unsigned int);
extern void _far * _far _cdecl _fmemchr(const void _far *, signed int,
	size_t);
extern signed int _far _cdecl _fmemcmp(const void _far *, const void _far *,
	size_t);
extern void _far * _far _cdecl _fmemcpy(void _far *, const void _far *,
	size_t);
extern signed int _far _cdecl _fmemicmp(const void _far *, const void _far *,
	unsigned int);
extern void _far * _far _cdecl _fmemmove(void _far *, const void _far *,
	size_t);
extern void _far * _far _cdecl _fmemset(void _far *, signed int, size_t);
extern char _far * _far _cdecl _fstrcat(char _far *, const char _far *);
extern char _far * _far _cdecl _fstrchr(const char _far *, signed int);
extern signed int _far _cdecl _fstrcmp(const char _far *, const char _far *);
extern signed int _far _cdecl _fstricmp(const char _far *, const char _far *);
extern char _far * _far _cdecl _fstrcpy(char _far *, const char _far *);
extern size_t _far _cdecl _fstrcspn(const char _far *, const char _far *);
extern char _far * _far _cdecl _fstrdup(const char _far *);
extern char _near * _far _cdecl _nstrdup(const char _far *);
extern size_t _far _cdecl _fstrlen(const char _far *);
extern char _far * _far _cdecl _fstrlwr(char _far *);
extern char _far * _far _cdecl _fstrncat(char _far *, const char _far *,
	size_t);
extern signed int _far _cdecl _fstrncmp(const char _far *, const char _far *,
	size_t);
extern signed int _far _cdecl _fstrnicmp(const char _far *, const char _far *,
	size_t);
extern char _far * _far _cdecl _fstrncpy(char _far *, const char _far *,
	size_t);
extern char _far * _far _cdecl _fstrnset(char _far *, signed int, size_t);
extern char _far * _far _cdecl _fstrpbrk(const char _far *,
	const char _far *);
extern char _far * _far _cdecl _fstrrchr(const char _far *, signed int);
extern char _far * _far _cdecl _fstrrev(char _far *);
extern char _far * _far _cdecl _fstrset(char _far *, signed int);
extern size_t _far _cdecl _fstrspn(const char _far *, const char _far *);
extern char _far * _far _cdecl _fstrstr(const char _far *,
	const char _far *);
extern char _far * _far _cdecl _fstrtok(char _far *, const char _far *);
extern char _far * _far _cdecl _fstrupr(char _far *);
#endif /* !_POSIX_SOURCE */

#endif /* _STRING_DEFINED */
