/***
*sys\times.h - defines structure used by times()
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the structure used by the times() routine.
*	[POSIX]
*
****/

#if !defined(_SYS_TIMES_DEFINED)

#define _SYS_TIMES_DEFINED

#include <time.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/* tms structure */

struct tms {
	clock_t tms_utime;
	clock_t tms_stime;
	clock_t tms_cutime;
	clock_t tms_cstime;
	};


/* function prototype */

extern clock_t _FAR_ _cdecl times(struct tms _FAR_ *);

#endif /* !_SYS_TIMES_DEFINED */
