public Lq_DWord_Div, Lq_DWord_Mul
extrn ErrorExit:far
;
; MODS --
;	7/19/83	JK	Create
;	7/30/83 JK  Fix Mul bug
;	4/23/84 JK  Fix Div bug
;
; This module emulates the DWord routines in Intel's PLM86.Lib which are
; used by the PLM86 V2 compiler.
;
; Routine calls ErrorExit(27) instead of dividing by 0.
;
; The PUSH/POP BP are to keep the Linker happy.
;
Lq_Dword_Code segment public 'Code'
assume cs: Lq_Dword_Code
;
; Q  = D1  /  D2
; R  = D1 MOD D2
;
;		L: H:
;
;	D1	AX DX
;	D2	CX DI
;	Q	AX DX
;	R	DI SI
;

Lq_DWord_Div proc far
	push bp

	or di, di			; test divisor (di,cx) for 0
	jnz Div_Full
	or cx, cx
	jz Div_Error

	cmp cx, dx
	jbe Div_Medium

	div cx				; first division = 1 R 0
	xor si, si
	mov di, dx
	xor dx, dx
	jmp Div_Exit

Div_Medium:
	mov di, ax
	mov ax, dx
	xor dx, dx
	div cx
	xchg ax, di
	div cx
	xchg dx, di
	xor si, si
	jmp Div_Exit

Div_Error:
	mov ax, 27
	push ax
	call errorexit

Div_Full:
	mov bp, cx
	mov bx, di
	xor si, si
	mov di, si
	mov cx, 20h

Div_Loop:
	shl di, 1
	rcl si, 1
	shl ax, 1
	rcl dx, 1
	adc di, 0
	sub di, bp
	sbb si, bx
	inc ax
	jae Div_EndLoop
	add di, bp
	adc si, bx
	dec ax

Div_EndLoop:
	loop Div_Loop

Div_Exit:
	pop bp
	ret
Lq_DWord_Div endp
;
; D0  = D1 * D2
;
;		L: H:
;
;	D1	AX DX
;	D2	CX DI
;	D0	AX DX
;
;	D0L = (D1L*D2L)L
;
;	D0H = (D1L*D2L)H + (D1H*D2L)L + (D1L*D2H)L 
;
Lq_DWord_Mul proc far
	push bp
	mov bx, ax
	mov si, dx
	mul di
	xchg ax, si
	mul cx
	add si, ax
	mov ax, bx
	mul cx
	add dx, si
	pop bp
	ret
Lq_DWord_Mul endp
Lq_Dword_Code ends
end
