/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  ngen_qic.h                                                               */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  12/13/90  121E.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

#define QIC_REG_ADDR 0x80

#define SELECT_DRIVE 0x01
#define LOCK_CARTRIDGE 0x10		/* Modifier for SELECT_DRIVE */
#define REWIND 0x21
#define ERASE 0x22
#define RETENSION 0x24
#define READ_DATA 0x80
#define READ_FILEMARK 0xA0
#define WRITE_DATA 0x40
#define WRITE_FILEMARK 0x60
#define READ_STATUS 0xC0
#define RESET_QIC_FIRMWARE 0xFF		/* Not a real command */

#define EXCEPTION_STATUS 0x80
#define NO_CARTRIDGE 0x40
#define NOT_ONLINE 0x20
#define WRITE_PROTECT 0x10
#define EOM 0x08
#define UNRECOVERABLE_DATA 0x04
#define UNKNOWN_ERROR 0x02
#define FILEMARK 0x01

#define EXCEPTION_STATUS 0x80
#define ILLEGAL_COMMAND 0x40
#define NO_DATA 0x20
#define EIGHT_RETRIES 0x10
#define BOM 0x08
#define DATA_PARITY 0x04
#define EOD 0x02
#define POWER_UP_RESET 0x01

#define END_OF_COMMAND 0x20
#define TERMINAL_COUNT 0x10
#define QIC_DIRECTION 0x08
#define QIC_EXCEPTION 0x04
#define QIC_READY 0x02
#define QIC_ACKNOWLEDGE 0x01

#define QIC_SELECT 0x80
#define QIC_DMA_WRITE 0x40	/* NB: These are WRITE to MEMORY... */
#define QIC_DMA_READ 0x20	/* ...and READ from MEMORY (not the device!) */
#define QIC_ONLINE 0x02
#define QIC_RESET 0x01

