/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  seq_service.h                                                            */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  04/28/91  121J.06  P. Johansson  /  Added 'awaiting_controller'.         */
/*  04/05/91  121H.05  P. Johansson  /  Added 'cant_deinstall' for Pertec.   */
/*  03/08/91  121H.04  P. Johansson  /  Added 'ignore_EOM' for checkpoint.   */
/*  02/01/91  121F.02  P. Johansson  /  Added 'watchdog' structure; added    */
/*                                      SeqAccessRecoverBufferData request.  */
/*  01/02/91  121F.01  P. Johansson  /  Changed 'version_info' structure.    */
/*  12/13/90  121E.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/
/*-----------------------------------------------------------------------------
 The executive command form for the installation of the Sequential Access
 Service is as follows:

 	Install Sequential Access service
 	    [Device(s) ([QIC])]
 	    [Buffer pool size (in Kb, default 64)]
 	    [QIC interface slot (SRP/XE 530 only, default 77)]

 The Sequential Access Service, once installed, runs at a default priority
 defined below. */

#define DEVICE_NAME_PARAM 1
#define BUFFER_POOL_PARAM 2
#define QIC_SLOT_PARAM 3

#define MAX_NODE_LENGTH 12
#define MAX_DEVICE_LENGTH 12
#define MAX_VOLUME_LENGTH 12
#define MAX_DIRECTORY_LENGTH 12
#define MAX_FILENAME_LENGTH 50
#define MAX_PASSWORD_LENGTH 12
#define MAX_FILE_SPECIFICATION_LENGTH 105
#define MAX_PASSWORD_LENGTH 12

#define MAX_SEQ_DEVICES 8
#define SEQ_SERVICE_PRIORITY 32

/*-----------------------------------------------------------------------------
 On workstations, a determination of which hardware modules are present must
 be made before the Sequential Access service decides to continue with its own
 installation or not. */

#define XBUS 2				/* Literal value for GetModuleID */

#define CP_001 0x0100			/* 8 Mhz 80186 CPU (aka B26) */
#define CP_002 0x0700			/* 8 MHz 80286 CPU (aka B28) */
#define CP_0A2 0x0700			/* 8 MHz 80286 CPU (aka B28) */
#define CWS 0x0900			/* 8 MHz 80186 CPU (diskless) */
#define CP_003 0x0A00			/* 16 MHz 80386 CPU (aka B38) */
#define CP_0A3 0x0A00			/* 16 MHz 80386 CPU (aka B38) */
#define SERIES_286I 0x0B00		/* Series 286i CPU */
#define SERIES_386I 0x0F00		/* Series 386i CPU (aka B39) */
#define NGEN_SCSI_PLUS_FLOPPY 0x2041	/* SCSI module ID (with floppy) */
#define NGEN_SCSI 0x2141		/* SCSI module ID */
#define NGEN_QIC 0x3141			/* Convergent QIC-36 module ID */
#define FLEMINGTON_QIC 0x8410		/* Flemington QIC-36 module ID */
#define SUPERGEN 0x6000			/* SuperGen 80486 CPU */

/*-----------------------------------------------------------------------------
 On the SRP, when data must be transferred between procesors, the remote
 address base register(s) and the remote slot ID register must be programmed.
 Real-mode processors use these registers for buffer movement (the CTOS DMA
 service is used on the GP) and both real- and protected-mode processors use
 these registers to access the QICI interface board. */

#define BASE_REG0 0x0048
#define BASE_REG1 0x0050
#define REMOTE_ADDRESS_SELECTOR	0xC000
#define REMOTE_SLOT_REG 0x0040

#define BASE_REG0_386 0x0148
#define REMOTE_SLOT_REG_386 0x0140

/*-----------------------------------------------------------------------------
 Request codes served by the Sequential Access service.  Any others that
 arrive at the service exchange are turned away with 'ercNotImplemented'. */

#define CLUSTER_AGENT_SERV_EXCH 12	/* To check for local installation */

#define SEQ_ACCESS_VERSION_RQ_CODE 0x81C9
#define SEQ_ACCESS_OPEN_RQ_CODE 0x81CA
#define SEQ_ACCESS_CLOSE_RQ_CODE 0x81CB
#define SEQ_ACCESS_MODE_QUERY_RQ_CODE 0x81CC
#define SEQ_ACCESS_MODE_SET_RQ_CODE 0x81CD
#define SEQ_ACCESS_CONTROL_RQ_CODE 0x81CE
#define SEQ_ACCESS_STATUS_RQ_CODE 0x81CF
#define SEQ_ACCESS_WRITE_RQ_CODE 0x81D0
#define SEQ_ACCESS_READ_RQ_CODE 0x81D1
#define SEQ_ACCESS_CHECKPOINT_RQ_CODE 0x81D2
#define SEQ_ACCESS_RECOVER_BUFFER_DATA_RQ_CODE 0x81D3
#define SEQ_ACCESS_DISCARD_BUFFER_DATA_RQ_CODE 0x81D4
#define SEQ_ACCESS_DEINSTALL_RQ_CODE 0x9043
#define SEQ_ACCESS_TERMINATION_RQ_CODE 0x9044

#define INBOUND 0x0001		/* Bits assigned in local service code */
#define VALIDATE_HANDLE 0x0002
#define BUFFERED_RQ 0x0004
#define RESIDUAL 0x0010

/*-----------------------------------------------------------------------------
 Request block templates for the Sequential Access service are defined
 below.  Most patterns fit into one generic class, but a few (SeqAccessOpen,
 in particular) differ greatly.  In order to avoid the syntactic awkwardness
 of multiple levels of C union dereferences, separate types are defined for
 these request blocks. */

typedef struct {		/* This template is for:		*/
   char s_cnt_info;		/*	SeqAccessCheckpoint		*/
   char rt_code;		/*	SeqAccessClose			*/
   char n_req_pb_cb;		/*	SeqAccessControl		*/
   char n_resp_pb_cb;		/*	SeqAccessModeQuery		*/
   unsigned user_num;		/*	SeqAccessModeSet		*/
   unsigned exch_resp;		/*	SeqAccessRead			*/
   unsigned erc_ret;		/*	SeqAccessRecoverBufferData	*/
   unsigned rq_code;		/*	SeqAccessStatus			*/
   unsigned seq_handle;		/*	SeqAccessWrite			*/
   unsigned ctrl_function;
   signed ctrl_qualifier;	
   char *data;			
   unsigned data_len;
   signed long *residual;
   unsigned size_residual;
} seq_access_rq_type;

typedef struct {		/* This template is for:		*/
   char s_cnt_info;		/*	SeqAccessVersion		*/
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   unsigned access_mode;
   unsigned reserved[2];
   char *device_name;
   unsigned device_name_len;
   void *version_info_ret;
   unsigned version_info_max;
} seq_access_version_rq_type;

typedef struct {		/* This template is for:		*/
   char s_cnt_info;		/*	SeqAccessOpen			*/
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   unsigned access_mode;
   unsigned reserved[2];
   char *device_name;
   unsigned device_name_len;
   char *password;
   unsigned password_len;
   char *mode_params;
   unsigned mode_params_len;
   unsigned *seq_handle_ret;
   unsigned size_seq_handle;
} seq_access_open_rq_type;

typedef struct {		/* This template is for:		*/
   char s_cnt_info;		/*	SeqAccessDeinstall		*/
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   unsigned reserved[3];
   char *device_name;
   unsigned device_name_len;
   unsigned *ph;
   unsigned ph_size;
} seq_access_deinstall_rq_type;

typedef struct {
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned active_dcbs;
   unsigned rq_code;
   unsigned term_erc;
} seq_access_term_rq_type;

#define MODE_READ 0x6D72
#define MODE_MODIFY 0x6D6D

#define CTRL_REWIND 1		/* Control function value assignments */
#define CTRL_UNLOAD 2
#define CTRL_RETENSION 3
#define CTRL_ERASE_MEDIUM 4
#define CTRL_WRITE_FILEMARK 5
#define CTRL_SCAN_FILEMARK 6
#define CTRL_SPACE_RECORD 7
#define CTRL_ERASE_GAP 8

#define SYNCHRONIZE 0		/* Control qualifiers (wait until done...) */
#define IMMEDIATE 0xFFFF	/* (...or buffered mode) */

#define SEQ_RESET 0x0080	/* Status unsigned bit assignments */
#define SEQ_ON_LINE 0x0040
#define SEQ_BOM 0x0020
#define SEQ_EOM 0x0010
#define SEQ_READY 0x0008
#define SEQ_BUSY 0x0004
#define SEQ_WRITE_PROTECT 0x0002
#define SEQ_MEDIUM_LOADED 0x0001

/*-----------------------------------------------------------------------------
 The version information returned by the Sequential Access service is
 structured as shown below. */

typedef struct {
   unsigned version;
   unsigned revision;
   unsigned subrevision;
   unsigned devices;
   char version_text[65];
   char node[MAX_NODE_LENGTH + 1];
   char device[MAX_SEQ_DEVICES][MAX_DEVICE_LENGTH + 1];
} version_info_type;

typedef struct {		/* Mode parameters used by SeqAccessOpen,   */
   Boolean write_protected;	/*  SeqAccessModeQuery and SeqAccessModeSet */
   Boolean variable_length;
   Boolean unbuffered;
   Boolean suppress_default_mode_on_open;
   unsigned speed;
   unsigned density;
   unsigned long total_blocks;
   unsigned long block_size;
   unsigned min_record_size;
   unsigned long max_record_size;
   unsigned long device_buffer_size;
   unsigned long service_buffer_pool_size;
   unsigned service_buffers;
   unsigned service_buffer_size;
   unsigned long write_buffer_threshold;
   unsigned long read_buffer_threshold;
   Boolean data_buffer_nonrecoverable;
   Boolean disable_automatic_velocity;
   Boolean buffer_recovery_LIFO;
   Boolean checkpoint_EOM;
   Boolean data_compression;
   char gap_size;
   unsigned long buffer_size_EOM;
   Boolean report_soft_errors;
   Boolean disable_error_correction;
   Boolean disable_read_retries;
   Boolean disable_write_retries;
   unsigned read_retry_limit;
   unsigned write_retry_limit;
} seq_parameters_type;

/*-----------------------------------------------------------------------------
 Because the Sequential Access service is not permitted to block (so that one
 device thread cannot impede another's progress), SCSI requests must have
 their own request blocks built rather than using the procedural interface.
 The definition of a CTOS SCSI Manager request is given below, as well as a
 DoDirectRead/DoDirectWrite request (used for SCSI in CTOS prior to 3.0). */

typedef struct {		/* Generic CTOS request block */
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   unsigned constant_info[3];
   struct {
      pointer pb;
      unsigned cb;
   } param[6];
} rq_type;

typedef struct {		/* QIC-02 "request" block */
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
#if defined(CtQIC)
   Boolean send_msg;
   Boolean interrupt;
   char qic_control;
   char qic_ctrl_lines;
#endif
#if defined(FlemingtonQIC)
   Boolean command_accepted;
   Boolean interrupt;
   char qic_control;
   char qic_ctrl_lines;
#endif
#if defined(SrpQIC)
   Boolean send_msg;
   Boolean interrupt;
   char reserved;
   char qic_flags;
#endif
} qic_iob_type;

typedef struct {		/* SCSI Manager request block */
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   unsigned path_handle;
   Boolean bus_reset;
   char reserved;
   unsigned timeout;
   pointer cdb;
   unsigned cdb_len;
   pointer data;
   unsigned data_len;
   pointer xfer_count;
   unsigned size_xfer_count;
   pointer target_status;
   unsigned size_target_status;
   pointer ext_sense;
   unsigned ext_sense_len;
} scsi_rq_type;

#define SCSI_OPEN_PATH_RQ_CODE 355
#define SCSI_GET_PATH_PARAMETERS_RQ_CODE 356
#define SCSI_SET_PATH_PARAMETERS_RQ_CODE 357
#define SCSI_CLOSE_PATH_RQ_CODE 358
#define SCSI_RESET_RQ_CODE 359
#define SCSI_CDB_DATA_IN_RQ_CODE 360
#define SCSI_CDB_DATA_OUT_RQ_CODE 361
#define SCSI_REQUEST_SENSE_RQ_CODE 362
#define SCSI_MANAGER_NAME_RQ_CODE 363

typedef struct {		/* Direct I/O request block */
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   unsigned file_handle;
   char options;
   char timeout;
   unsigned dma_xfer_size;
   pointer cdb;
   unsigned cdb_len;
   pointer data;
   unsigned data_len;
   pointer result;
   unsigned size_result;
} direct_rq_type;

#define DO_DIRECT_READ_RQ_CODE 318
#define DO_DIRECT_WRITE_RQ_CODE 319

#define DIRECT_IO_TIME_UNIT 15		/* High char of options is timeout */
#define DIRECT_IO_DMA 0x01		/* Modifier bit for 'options' */

typedef struct {		/* Used at installation time on the SRP */
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   char operation;
   char slot_id;
   char *device_name;
   unsigned device_name_len;
   char *volume;
   unsigned volume_len;
} update_route_table_rq_type;

#define UPDATE_ROUTE_TABLE_RQ_CODE 0x3010
#define ROUTE_TABLE_ADD 0
#define ROUTE_TABLE_DELETE 1

typedef struct {
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   pointer interrupt_service;
   unsigned data_segment;
   pointer interrupt_handle_ret;
   unsigned size_interrupt_handle_ret;
} set_xbus_misr_rq_type;

typedef struct {
   char s_cnt_info;
   char rt_code;
   char n_req_pb_cb;
   char n_resp_pb_cb;
   unsigned user_num;
   unsigned exch_resp;
   unsigned erc_ret;
   unsigned rq_code;
   unsigned interrupt_handle;
} reset_xbus_misr_rq_type;

#define SET_XBUS_MISR_RQ_CODE 0x200C
#define OLD_SET_XBUS_MISR_RQ_CODE 0x801F
#define RESET_XBUS_MISR_RQ_CODE 0x200D
#define OLD_RESET_XBUS_MISR_RQ_CODE 0x8020

/*-----------------------------------------------------------------------------
 The buffer pool managed by the Sequential Access service for all the devices
 it controls is allocated with a minimum granularity of one segment (64 Kb).
 Within each segment, the buffer space is allocated by the "buddy" algorithm
 and a bit map describes the available 64 Kb, 32 Kb, ... 1Kb, 512 char buffers
 available t users.  Although the buddy system may sometimes result in more
 buffer space being allocated than is actually needed, most applications can
 be easily optimized for buffers of size 2**n.  The advantages of the buddy
 system are a) all buffer addresses within each segment can be calculated from
 the selector that addresses the segment without having to worry about buffers
 that span segment boundaries and b) all buffers fit within or span an
 integral number of contiguous 4K frames (relevant for demand paging and/or
 SRP GP DMA considerations). */

#define PAGE_SIZE 512ul
#define LOG2_PAGE_SIZE 9u
#define SEGMENT_SIZE 65536ul
#define LOG2_SEGMENT_SIZE 16u
#define PAGES_PER_SEGMENT ((unsigned) (SEGMENT_SIZE / PAGE_SIZE))

typedef struct buffer_descriptor_struct {
   struct buffer_descriptor_struct *next;
   pointer base;
   pointer data;
   unsigned long bus_address;
   unsigned available;
   unsigned size;
   unsigned index;
} buffer_descriptor_type;

typedef struct {
   pointer raw_buffer;
   unsigned bit_map[(2 * PAGES_PER_SEGMENT) / 16];
} segment_descriptor_type;

/*-----------------------------------------------------------------------------
 Each sequential access device, regardless of its device interface class
 (SCSI, Pertec 1/2" tape, workstation or SRP QIC) is assigned a device control
 block.  This block is used to manage the current status of the device, its
 operating modes or characteristics and the queues of buffers that are either
 being emptied (written to the medium) or filled (read from the medium.  Parts
 of the control block are generic and parts are unique to the interface class.
 */

typedef _unpacked struct {	/* One device control block per tape */
   enum {SCSI_class, ngen_QIC_class, flemington_QIC_class, srp_QIC_class,
         Pertec_class} device_class;
   Boolean cant_deinstall;
   char device_name[MAX_DEVICE_LENGTH + 1];
   char device_password[MAX_PASSWORD_LENGTH + 1];
   char direct_io_name[2];
   char erasable_part;
   unsigned user_num;		/* 0xFFFF if the device is not opened */
   unsigned mode;		/* Either MODE_READ or MODE_MODIFY */
   seq_access_rq_type *rq;	/* Currently active (or last active) request */
   unsigned service_code;	/* Local service code for the request */
   char rq_slot_id;		/* Originating slot ID (SRP only ) */
   void *rq_data;		/* Current data pointer for request */
   signed long rq_residual;	/* Amount remaining to transfer for request */
   buffer_descriptor_type unbuffered;		/* Used when not buffered */
   unsigned long client_buffer_available;	/* "Ready" in client queue */
   buffer_descriptor_type *client_buffer;
   unsigned long device_buffer_available;	/* "Ready" in device queue */
   buffer_descriptor_type *device_buffer;
   unsigned long write_buffer_full_threshold;	/* Initiate I/O above... */
   unsigned long read_buffer_empty_threshold;	/* ...or below these limits */
   Boolean suppress_default_mode_on_open;
   struct {			/* Operational characteristics of the device */
      Boolean buffered :1;
      Boolean buffer_recoverable :1;
      Boolean variable_length :1;
      Boolean data_compression :1;
      Boolean data_encryption :1;
      Boolean scsi2 :1;
   } operating_mode;
   unsigned min_record_size;	/* For fixed, minimum is equal to... */
   unsigned long max_record_size;	/* ...maximum */
   unsigned block_size;		/* Current block size (0 == variable) */
   struct {			/* Logical state of device operations */
      Boolean ignore_EOM :1;
      Boolean rewinding :1;		/* For overlapped operations */
      Boolean awaiting_controller :1;	/* For multiple unit controllers */
      Boolean autosense :1;		/* Needed for CTOS pre SCSI Manager */
      Boolean status_available :1;	/* Status already retrieved */
      Boolean inbound :1;		/* Reading from the medium... */
      Boolean pending_status :1;	/* Exception status not yet reported */
      Boolean data_transfer :1;		/* Buffered operations in progress */
      Boolean term_pending :1;		/* Client has terminated */
      Boolean quiet_io :1;		/* Quiesce I/O as soon as possible */
      Boolean rq_pending :1;		/* Client request waiting to start */
      Boolean rq_active :1;		/* Client request not yet responded */
   } state;
   struct {			/* Current operational status of the device */
      Boolean on_line :1;
      Boolean write_protected :1;
      Boolean ready :1;
      Boolean busy :1;
      Boolean reset :1;
   } unit_status;
   struct {			/* Medium position information */
      Boolean beginning_of_medium :1;
      Boolean beginning_of_partition :1;
      Boolean end_of_data :1;
      Boolean end_of_partition :1;
      Boolean end_of_medium :1;
   } position;
   struct {			/* Exception status condition information */
      Boolean file_mark :1;
      Boolean illegal_length :1;
      Boolean illegal_operation :1;
      Boolean recovered_error :1;
      Boolean hard_error :1;
   } command_status;
   rq_type own_rq;		/* Private request block building area */
   unsigned timeout;		/* Time limit (1/10th seconds) for oepration */
   void *io_data;		/* Starting transfer address */
   unsigned io_xfer_count;	/* Amount to transfer on this operation */
   unsigned io_xfer_actual;	/* Amount actually transferred OK */
   unsigned long residual;	/* Amount remaining in device's buffers */
   unsigned device_specific[60];/* Rest is unique to each particular driver */
} dcb_type;

typedef struct {
   dcb_type *dcb;
   unsigned long device_buffer_size;
   unsigned long recommended_buffer_pool_size;
   unsigned recommended_buffers;
   unsigned recommended_buffer_size;
   unsigned long recommended_write_buffer_full_threshold;
   unsigned long recommended_read_buffer_empty_threshold;
   unsigned long eom_medium_capacity;
} default_info_type;

typedef _unpacked struct {	/* One device control block per tape */
   char device_class;
   Boolean cant_deinstall;
   char device_name[MAX_DEVICE_LENGTH + 1];
   char device_password[MAX_PASSWORD_LENGTH + 1];
   char direct_io_name[2];
   char erasable_part;
   unsigned user_num;		/* 0xFFFF if the device is not opened */
   unsigned mode;		/* Either MODE_READ or MODE_MODIFY */
   seq_access_rq_type *rq;	/* Currently active (or last active) request */
   unsigned service_code;	/* Local service code for the request */
   char rq_slot_id;		/* Originating slot ID (SRP only ) */
   void *rq_data;		/* Current data pointer for request */
   signed long rq_residual;	/* Amount remaining to transfer for request */
   buffer_descriptor_type unbuffered;		/* Used when not buffered */
   unsigned long client_buffer_available;	/* "Ready" in client queue */
   buffer_descriptor_type *client_buffer;
   unsigned long device_buffer_available;	/* "Ready" in device queue */
   buffer_descriptor_type *device_buffer;
   unsigned long write_buffer_full_threshold;	/* Initiate I/O above... */
   unsigned long read_buffer_empty_threshold;	/* ...or below these limits */
   Boolean suppress_default_mode_on_open;
   struct {			/* Operational characteristics of the device */
      Boolean buffered :1;
      Boolean buffer_recoverable :1;
      Boolean variable_length :1;
      Boolean data_compression :1;
      Boolean data_encryption :1;
      Boolean scsi2 :1;
   } operating_mode;
   unsigned min_record_size;	/* For fixed, minimum is equal to... */
   unsigned long max_record_size;	/* ...maximum */
   unsigned block_size;		/* Current block size (0 == variable) */
   struct {			/* Logical state of device operations */
      Boolean ignore_EOM :1;
      Boolean rewinding :1;		/* For overlapped operations */
      Boolean awaiting_controller :1;	/* For multiple unit controllers */
      Boolean autosense :1;		/* Needed for CTOS pre SCSI Manager */
      Boolean status_available :1;	/* Status already retrieved */
      Boolean inbound :1;		/* Reading from the medium... */
      Boolean pending_status :1;	/* Exception status not yet reported */
      Boolean data_transfer :1;		/* Buffered operations in progress */
      Boolean term_pending :1;		/* Client has terminated */
      Boolean quiet_io :1;		/* Quiesce I/O as soon as possible */
      Boolean rq_pending :1;		/* Client request waiting to start */
      Boolean rq_active :1;		/* Client request not yet responded */
   } state;
   struct {			/* Current operational status of the device */
      Boolean on_line :1;
      Boolean write_protected :1;
      Boolean ready :1;
      Boolean busy :1;
      Boolean reset :1;
   } unit_status;
   struct {			/* Medium position information */
      Boolean beginning_of_medium :1;
      Boolean beginning_of_partition :1;
      Boolean end_of_data :1;
      Boolean end_of_partition :1;
      Boolean end_of_medium :1;
   } position;
   struct {			/* Exception status condition information */
      Boolean file_mark :1;
      Boolean illegal_length :1;
      Boolean illegal_operation :1;
      Boolean recovered_error :1;
      Boolean hard_error :1;
   } command_status;
   rq_type own_rq;		/* Private request block building area */
   unsigned timeout;		/* Time limit (1/10th seconds) for oepration */
   void *io_data;		/* Starting transfer address */
   unsigned io_xfer_count;	/* Amount to transfer on this operation */
   unsigned io_xfer_actual;	/* Amount actually transferred OK */
   unsigned long residual;	/* Amount remaining in device's buffers */
   buffer_descriptor_type unbuffered_descriptor;
   void *chain;
   unsigned unit;
   Boolean high_speed;
   char density;
   unsigned tape_status;
   unsigned ctrl_function;
   unsigned ctrl_qualifier;
   unsigned command;
   unsigned retry_count;
   unsigned read_retry_limit;
   unsigned write_retry_limit;
   unsigned soft_errors;
   unsigned hard_errors;
} dcb_pertec_type;

typedef _unpacked struct {	/* One device control block per tape */
   char device_class;
   Boolean cant_deinstall;
   char device_name[MAX_DEVICE_LENGTH + 1];
   char device_password[MAX_PASSWORD_LENGTH + 1];
   char direct_io_name[2];
   char erasable_part;
   unsigned user_num;		/* 0xFFFF if the device is not opened */
   unsigned mode;		/* Either MODE_READ or MODE_MODIFY */
   seq_access_rq_type *rq;	/* Currently active (or last active) request */
   unsigned service_code;	/* Local service code for the request */
   char rq_slot_id;		/* Originating slot ID (SRP only ) */
   void *rq_data;		/* Current data pointer for request */
   signed long rq_residual;	/* Amount remaining to transfer for request */
   buffer_descriptor_type unbuffered;		/* Used when not buffered */
   unsigned long client_buffer_available;	/* "Ready" in client queue */
   buffer_descriptor_type *client_buffer;
   unsigned long device_buffer_available;	/* "Ready" in device queue */
   buffer_descriptor_type *device_buffer;
   unsigned long write_buffer_full_threshold;	/* Initiate I/O above... */
   unsigned long read_buffer_empty_threshold;	/* ...or below these limits */
   Boolean suppress_default_mode_on_open;
   struct {			/* Operational characteristics of the device */
      Boolean buffered :1;
      Boolean buffer_recoverable :1;
      Boolean variable_length :1;
      Boolean data_compression :1;
      Boolean data_encryption :1;
      Boolean scsi2 :1;
   } operating_mode;
   unsigned min_record_size;	/* For fixed, minimum is equal to... */
   unsigned long max_record_size;	/* ...maximum */
   unsigned block_size;		/* Current block size (0 == variable) */
   struct {			/* Logical state of device operations */
      Boolean ignore_EOM :1;
      Boolean rewinding :1;		/* For overlapped operations */
      Boolean awaiting_controller :1;	/* For multiple unit controllers */
      Boolean autosense :1;		/* Needed for CTOS pre SCSI Manager */
      Boolean status_available :1;	/* Status already retrieved */
      Boolean inbound :1;		/* Reading from the medium... */
      Boolean pending_status :1;	/* Exception status not yet reported */
      Boolean data_transfer :1;		/* Buffered operations in progress */
      Boolean term_pending :1;		/* Client has terminated */
      Boolean quiet_io :1;		/* Quiesce I/O as soon as possible */
      Boolean rq_pending :1;		/* Client request waiting to start */
      Boolean rq_active :1;		/* Client request not yet responded */
   } state;
   struct {			/* Current operational status of the device */
      Boolean on_line :1;
      Boolean write_protected :1;
      Boolean ready :1;
      Boolean busy :1;
      Boolean reset :1;
   } unit_status;
   struct {			/* Medium position information */
      Boolean beginning_of_medium :1;
      Boolean beginning_of_partition :1;
      Boolean end_of_data :1;
      Boolean end_of_partition :1;
      Boolean end_of_medium :1;
   } position;
   struct {			/* Exception status condition information */
      Boolean file_mark :1;
      Boolean illegal_length :1;
      Boolean illegal_operation :1;
      Boolean recovered_error :1;
      Boolean hard_error :1;
   } command_status;
   rq_type own_rq;		/* Private request block building area */
   unsigned timeout;		/* Time limit (1/10th seconds) for oepration */
   void *io_data;		/* Starting transfer address */
   unsigned io_xfer_count;	/* Amount to transfer on this operation */
   unsigned io_xfer_actual;	/* Amount actually transferred OK */
   unsigned long residual;	/* Amount remaining in device's buffers */
   unsigned xbus_handle;	/* Returned when XBus MISR established */
   char command;		/* Last QIC-02 command sent */
   char qic_control;		/* Image of module control signals */
   char qic_ctrl_lines;		/* Image of QIC-02 interface signals */
   char qic_status[6];		/* QIC status returned by QIC-02 interface */
   char reserved;
   unsigned soft_errors;	/* Cumulative (since last open operation) */
   unsigned underruns;		/* Ditto */
   unsigned ctrl_function;
   unsigned ctrl_qualifier;	/* Count of filemarks, records to space over */
#if defined(CtQIC)
   unsigned qic_reg_addr[12];	/* Hardware I/O space addresses for module */
#endif
#if defined(FlemingtonQIC)
   tpib_type tpib;
   void *tpib_rq;
   unsigned qic_reg_addr[6];	/* Hardware I/O space addresses for module */
   unsigned dma_command_reg;
   unsigned dma_count_reg;
   unsigned dma_mask_reg;
   unsigned dma_mode_reg;
   unsigned dma_clear_flip_flop;
   unsigned dma_master_command_reg;
   unsigned dma_master_mask_reg;
   unsigned dma_master_mode_reg;
   Boolean slave_dma;
   char mask_dma;
   char unmask_dma;
   char dma_mode;
   unsigned dma_xfer_limit;
   char int_vector;
   Boolean program_8237;
#endif
#if defined(SrpQIC)
   tpib_type tpib;
   void *tpib_rq;
   char qic_flags;
   char qic_slot;
   unsigned remote_slot;
   unsigned br0;
   unsigned br1;
   char *qic_memory_map[14];	/* QICI on SRP is meory-mapped I/O device */
#endif
} dcb_qic_type;

#if defined(CtQIC)		/* CT QIC-02 module I/O addresses */
#define qic_status_reg qic_reg_addr[0]
#define qic_command_reg qic_reg_addr[0]
#define qic_control_reg qic_reg_addr[1]
#define qic_ctrl_line_reg qic_reg_addr[2]
#define qic_clear_int_reg qic_reg_addr[4]
#define qic_dma_addr_low_reg qic_reg_addr[5]
#define qic_dma_addr_mid_reg qic_reg_addr[6]
#define qic_dma_addr_high_reg qic_reg_addr[7]
#define qic_counter0_reg qic_reg_addr[8]
#define qic_counter1_reg qic_reg_addr[9]
#define qic_counter2_reg qic_reg_addr[10]
#define qic_timer_mode_reg qic_reg_addr[11]
#endif

#if defined(FlemingtonQIC)	/* Flemington QIC-02 module I/O addresses */
#define qic_status_reg qic_reg_addr[0]
#define qic_control_reg qic_reg_addr[0]
#define qic_data_reg qic_reg_addr[1]
#define qic_command_reg qic_reg_addr[1]
#define qic_block_count_reg qic_reg_addr[2]
#define qic_dma_addr_low_reg qic_reg_addr[3]
#define qic_dma_addr_mid_reg qic_reg_addr[4]
#define qic_dma_addr_high_reg qic_reg_addr[5]
#endif

#if defined(SrpQIC)
#define qic_command_reg qic_memory_map	/* First six are for QIC-02 commands */
#define qic_flags_reg qic_memory_map[7]
#define qic_write_buffer_reg qic_memory_map[8]
#define qic_read_buffer_reg qic_memory_map[9]
#define qic_status_reg qic_memory_map[10]
#define qic_offline_reg qic_memory_map[11]
#define qic_REQ_reg qic_memory_map[12]
#define qic_reset_reg qic_memory_map[13]
#endif

typedef _unpacked struct {	/* One device control block per tape */
   char device_class;
   Boolean cant_deinstall;
   char device_name[MAX_DEVICE_LENGTH + 1];
   char device_password[MAX_PASSWORD_LENGTH + 1];
   char direct_io_name[2];
   char erasable_part;
   unsigned user_num;		/* 0xFFFF if the device is not opened */
   unsigned mode;		/* Either MODE_READ or MODE_MODIFY */
   seq_access_rq_type *rq;	/* Currently active (or last active) request */
   unsigned service_code;	/* Local service code for the request */
   char rq_slot_id;		/* Originating slot ID (SRP only ) */
   void *rq_data;		/* Current data pointer for request */
   signed long rq_residual;	/* Amount remaining to transfer for request */
   buffer_descriptor_type unbuffered;		/* Used when not buffered */
   unsigned long client_buffer_available;	/* "Ready" in client queue */
   buffer_descriptor_type *client_buffer;
   unsigned long device_buffer_available;	/* "Ready" in device queue */
   buffer_descriptor_type *device_buffer;
   unsigned long write_buffer_full_threshold;	/* Initiate I/O above... */
   unsigned long read_buffer_empty_threshold;	/* ...or below these limits */
   Boolean suppress_default_mode_on_open;
   struct {			/* Operational characteristics of the device */
      Boolean buffered :1;
      Boolean buffer_recoverable :1;
      Boolean variable_length :1;
      Boolean data_compression :1;
      Boolean data_encryption :1;
      Boolean scsi2 :1;
   } operating_mode;
   unsigned min_record_size;	/* For fixed, minimum is equal to... */
   unsigned long max_record_size;	/* ...maximum */
   unsigned block_size;		/* Current block size (0 == variable) */
   struct {			/* Logical state of device operations */
      Boolean ignore_EOM :1;
      Boolean rewinding :1;		/* For overlapped operations */
      Boolean awaiting_controller :1;	/* For multiple unit controllers */
      Boolean autosense :1;		/* Needed for CTOS pre SCSI Manager */
      Boolean status_available :1;	/* Status already retrieved */
      Boolean inbound :1;		/* Reading from the medium... */
      Boolean pending_status :1;	/* Exception status not yet reported */
      Boolean data_transfer :1;		/* Buffered operations in progress */
      Boolean term_pending :1;		/* Client has terminated */
      Boolean quiet_io :1;		/* Quiesce I/O as soon as possible */
      Boolean rq_pending :1;		/* Client request waiting to start */
      Boolean rq_active :1;		/* Client request not yet responded */
   } state;
   struct {			/* Current operational status of the device */
      Boolean on_line :1;
      Boolean write_protected :1;
      Boolean ready :1;
      Boolean busy :1;
      Boolean reset :1;
   } unit_status;
   struct {			/* Medium position information */
      Boolean beginning_of_medium :1;
      Boolean beginning_of_partition :1;
      Boolean end_of_data :1;
      Boolean end_of_partition :1;
      Boolean end_of_medium :1;
   } position;
   struct {			/* Exception status condition information */
      Boolean file_mark :1;
      Boolean illegal_length :1;
      Boolean illegal_operation :1;
      Boolean recovered_error :1;
      Boolean hard_error :1;
   } command_status;
   rq_type own_rq;		/* Private request block building area */
   unsigned timeout;		/* Time limit (1/10th seconds) for oepration */
   void *io_data;		/* Starting transfer address */
   unsigned io_xfer_count;	/* Amount to transfer on this operation */
   unsigned io_xfer_actual;	/* Amount actually transferred OK */
   unsigned long residual;	/* Amount remaining in device's buffers */
   unsigned scsi_handle;	/* Rest is unique to SCSI use of the Dcb */
   unsigned density;
   char host_adapter;		/* SCSI Manager physical address information */
   char scsi_id;
   char lun;
   char scsi_manager_name[MAX_DEVICE_LENGTH + 1];
   enum {NO_DATA_PHASE, DATA_IN, DATA_OUT} data_phase;
   char cdb_len;		/* Command block size (6, 10 or 12) */
   char cdb[12];		/* SCSI command descriptor block */
   unsigned target_status;	/* Target status after operation */
   unsigned autosense_status;	/* Target status if REQUEST SENSE attempted */
   char ext_sense[18];		/* Extended sense data */
} dcb_scsi_type;

#define REQUEST_IN_PROGRESS 0xFFFF	/* Special sentinel value for erc */

/*-----------------------------------------------------------------------------
 In addition to the request blocks previously defined, timer request blocks
 (TRB's) for the sequential access service watchdogs also arrive at the service
 exchange.  The TRB has embedded within it a pointer to the Dcb for which
 the sands of time are running.  This is used to dispatch to the correct
 device-specific routine for the watchdog. */

typedef struct {
   unsigned counter;
   unsigned counter_reload;
   unsigned events;
   unsigned exch_resp;
   unsigned user_count;
   unsigned rq_code;
   dcb_type *dcb;
} watchdog_type;

/*-----------------------------------------------------------------------------
 Message codes and the default file name from which to retrieve them are
 defined below.  An array of message descriptors that maps the message number
 to a pointer to the message and its length is kept by the Sequential Access
 service. */

#define MSG_FILE "[Sys]<Sys>SeqServiceMsg.Bin"
#define default_msg(INDEX, TEXT) INDEX, TEXT, last(TEXT)

typedef struct {
   unsigned msg_num;
   char *msg_text;
   unsigned msg_len;
} msg_descriptor_type;

#define NLS_COMMAND_VERSION			40300
#define NLS_NGEN_SERVICE			40301
#define NLS_SRP_SERVICE				40302
#define NLS_PERTEC_SERVICE			40303
#define NLS_SERVER_SYS_VOLUME			40304
#define NLS_DEFAULT_SEQ_DEVICE			40305
#define NLS_DEVICE_DEINSTALLED_OK		40306
#define NLS_DEVICE_UNKNOWN			40307
#define NLS_DEVICE_DEINSTALLATION_ERROR		40308
#define NLS_SERVICE_DEINSTALLED_OK		40309
#define NLS_SERVICE_NOT_INSTALLED		40310
#define NLS_SERVICE_DEINSTALLATION_ERROR	40311
#define NLS_QIC36_CLASS				40312
#define NLS_HALF_INCH_CLASS			40313
#define NLS_SCSI_CLASS				40314
#define NLS_WRONG_OS				40315
#define NLS_WRONG_HARDWARE			40316
#define NLS_NO_XBIF				40317
#define NLS_ALREADY_INSTALLED			40318
#define NLS_INSTALLED_OK			40319
#define NLS_PARTITION_NAME			40320
#define NLS_CANT_INSTALL			40121
#define NLS_NO_DEVICES				40322
#define NLS_CASE_INVALID			40323

/*-----------------------------------------------------------------------------
 The sequential access message type(s) for the system log file. */

typedef struct {
   unsigned log_type;
   unsigned erc;
   char retry_count;
   Boolean recovered;
   char device_class;
   char unit_num;
   unsigned status[4];
} seq_access_log_msg_type;
