$save nogen
%'###########################################################################
%' File:    Scgen.asm                                                       #
%' Version: 2.1                                                             #
%' Revised: May 14, 1986                                                    #
%' Copyright (c) 1986 by Convergent Technologies                            #
%'                                                                          #
%'                                                                          #
%' Function                                                                 #
%'                                                                          #
%' Scgen.asm defines the parameter information used by C to mediate         #
%' function calls.                                                          #
%'                                                                          #
%'                                                                          #
%' Using Existing Entries                                                   #
%'                                                                          #
%' Many CTOS procedures are defined below. When you assemble this           #
%' module, the assembler asks you questions such as:                        #
%'                                                                          #
%'                 Are you calling Forms (y or n)?                          #
%'                                                                          #
%' If you type y (for yes) followed by RETURN, an entry is made in          #
%' rgProcedures for each procedure in the corresponding software package    #
%' In this case, an entry is made for each procedure in the FORMS package.  #
%'                                                                          #
%' You can determine the procedures associated with each software package   #
%' by inspecting this module.                                               #
%'                                                                          #
%'                                                                          #
%' Defining New Entries                                                     #
%'                                                                          #
%' If you are calling CTOS procedures that are not already defined in       #
%' this module, you must invoke the Editor (see the Editor Manual for       #
%' details) and add a table entry for each procedure.                       #
%'                                                                          #
%' Use the macro                                                            #
%'                                                                          #
%'       %TableEntry(procName,cParams,param1,...,paramN)                    #
%'                                                                          #
%' to define an entry for each new procedure. %TableEntry requires three or #
%' more parameters, as follows:                                             #
%'                                                                          #
%'              1) procName is the procedure name.                          #
%'                                                                          #
%'              2) cbParams is the number bytes for parameters.             #
%'                                                                          #
%'              3) param1,...,paramN are parameter types, whose values are: #
%'                                                                          #
%'                 p if the parameter is a pointer                          #
%'                 w if the parameter is a word or byte                     #
%'                 q if the parameter is a quad                             #
%'                                                                          #
%' For example, the following macro invocation defines a procedure          #
%' named INITIALIZE which takes a pointer and a word.                       #
%'                                                                          #
%'                 %TableEntry(INITIALIZE,2,p,w)                            #
%'                                                                          #
%' If INITIALIZE required no parameters, its definition would be:           #
%'                                                                          #
%'                 %TableEntry(INITIALIZE,0)                                #
%'                                                                          #
%' Add all new entries immediately following the comment                    #
%'                                                                          #
%'                           ADD NEW ENTRIES HERE                           #
%'                                                                          #
%'###########################################################################

$restore

Code		segment	byte	public	'Code'
extrn	Scmediator:near
Code		ends

Zerodata	segment	word	common	'Data'
	dw	?
Zerodata	ends

Data		segment	word	public	'Data'
Data   		ends

Const		segment	word	public	'Const'
Const  		ends

Stack		segment	word	stack	'Stack'
Stack  		ends

Memory		segment	word	memory	'Memory'
Memory 		ends

dgroup	group	zerodata, data, const, stack, memory
cgroup	group	code
assume	cs:cgroup, ds:dgroup, ss:dgroup

%*define (Dtype(prm,procname))(%if (%eqs(%prm,p)) then (0) else (%if (%eqs(%prm,w)) then (1) else (%if(%eqs(%prm,q)) then (2) else (%out(Error in %procname
)) fi) fi) fi)

%*define (TableEntry(procName,cParam,param)) local thisproc (
extrn	%procName:far

data	segment
%thisproc label byte
	dd	%procName
	db	%cParam
%define(paramtemp)(%param)%while(%len(%paramtemp) gt 0)(%match(head,paramtemp)(%paramtemp)	db	%dtype(%head,%procname)
)
data	ends

code	segment
public	%procname%(_)
%procname%(_):
	mov 	bx, offset Dgroup:%thisproc
	jmp 	scmediator
code	ends
)

;##############################################################################
;                           ADD NEW ENTRIES HERE                              #
;##############################################################################

%'	%TableEntry(INITIALIZE,2,p,w)        - a sample entry

;##############################################################################
;                            END OF NEW ENTRIES                               #
;##############################################################################

%IF(%pass1 eq -1) then (
	%out(
Are you calling FORMS (y or n)? )
	%define(bFORMS)(%in)
	%set(fFORMS,0)
	%IF (%eqs(%substr(%bFORMS,1,1),Y)) then (%set(fFORMS,1)) FI
	%IF (%eqs(%substr(%bFORMS,1,1),y)) then (%set(fFORMS,1)) FI

	%out(
Are you calling Sort/Merge (y or n)? )
	%define(bSM)(%in)
	%set(fSM,0)
	%IF (%eqs(%substr(%bSM,1,1),Y)) then (%set(fSM,1)) FI
	%IF (%eqs(%substr(%bSM,1,1),y)) then (%set(fSM,1)) FI

	%out(
Are you calling ISAM (y or n)? )
	%define(bISAM)(%in)
	%set(fISAM,0)
	%IF (%eqs(%substr(%bISAM,1,1),Y)) then (%set(fISAM,1)) FI
	%IF (%eqs(%substr(%bISAM,1,1),y)) then (%set(fISAM,1)) FI

	%out(
Are you calling the Sequential Access Method (y or n)? )
	%define(bSAM)(%in)
	%set(fSAM,0)
	%IF (%eqs(%substr(%bSAM,1,1),Y)) then (%set(fSAM,1)) FI
	%IF (%eqs(%substr(%bSAM,1,1),y)) then (%set(fSAM,1)) FI

	%out(
Are you calling the Record Sequential Access Method (y or n)? )
	%define(bRSAM)(%in)
	%set(fRSAM,0)
	%IF (%eqs(%substr(%bRSAM,1,1),Y)) then (%set(fRSAM,1)) FI
	%IF (%eqs(%substr(%bRSAM,1,1),y)) then (%set(fRSAM,1)) FI

	%out(
Are you calling the Direct Access Method (y or n)? )
	%define(bDAM)(%in)
	%set(fDAM,0)
	%IF (%eqs(%substr(%bDAM,1,1),Y)) then (%set(fDAM,1)) FI
	%IF (%eqs(%substr(%bDAM,1,1),y)) then (%set(fDAM,1)) FI

	%out(
Are you calling the Video Access Method (y or n)? )
	%define(bVAM)(%in)
	%set(fVAM,0)
	%IF (%eqs(%substr(%bVAM,1,1),Y)) then (%set(fVAM,1)) FI
	%IF (%eqs(%substr(%bVAM,1,1),y)) then (%set(fVAM,1)) FI

	%out(
Are you calling the Video Display Manager (y or n)? )
	%define(bVDM)(%in)
	%set(fVDM,0)
	%IF (%eqs(%substr(%bVDM,1,1),Y)) then (%set(fVDM,1)) FI
	%IF (%eqs(%substr(%bVDM,1,1),y)) then (%set(fVDM,1)) FI

	%out(
Are you calling the Swapper (y or n)? )
	%define(bSWAP)(%in)
	%set(fSWAP,0)
	%IF (%eqs(%substr(%bSWAP,1,1),Y)) then (%set(fSWAP,1)) FI
	%IF (%eqs(%substr(%bSWAP,1,1),y)) then (%set(fSWAP,1)) FI

	%out(
Are you calling CTOS Memory Management (y or n)? )
	%define(bCTOSmm)(%in)
	%set(fCTOSmm,0)
	%IF (%eqs(%substr(%bCTOSmm,1,1),Y)) then (%set(fCTOSmm,1)) FI
	%IF (%eqs(%substr(%bCTOSmm,1,1),y)) then (%set(fCTOSmm,1)) FI

	%out(
Are you calling CTOS Task Management (y or n)? )
	%define(bCTOStm)(%in)
	%set(fCTOStm,0)
	%IF (%eqs(%substr(%bCTOStm,1,1),Y)) then (%set(fCTOStm,1)) FI
	%IF (%eqs(%substr(%bCTOStm,1,1),y)) then (%set(fCTOStm,1)) FI

	%out(
Are you calling CTOS OpenFile or CloseFile (y or n)? )
	%define(bCTOSoc)(%in)
	%set(fCTOSoc,0)
	%IF (%eqs(%substr(%bCTOSoc,1,1),Y)) then (%set(fCTOSoc,1)) FI
	%IF (%eqs(%substr(%bCTOSoc,1,1),y)) then (%set(fCTOSoc,1)) FI

	%out(
Are you calling CTOS File Management (y or n)? )
	%define(bCTOSfm)(%in)
	%set(fCTOSfm,0)
	%IF (%eqs(%substr(%bCTOSfm,1,1),Y)) then (%set(fCTOSfm,1)) FI
	%IF (%eqs(%substr(%bCTOSfm,1,1),y)) then (%set(fCTOSfm,1)) FI

	%out(
Are you calling CTOS Keyboard Management (y or n)? )
	%define(bCTOSkm)(%in)
	%set(fCTOSkm,0)
	%IF (%eqs(%substr(%bCTOSkm,1,1),Y)) then (%set(fCTOSkm,1)) FI
	%IF (%eqs(%substr(%bCTOSkm,1,1),y)) then (%set(fCTOSkm,1)) FI

	%out(
Are you calling CTOS Timer Management (y or n)? )
	%define(bCTOScm)(%in)
	%set(fCTOScm,0)
	%IF (%eqs(%substr(%bCTOScm,1,1),Y)) then (%set(fCTOScm,1)) FI
	%IF (%eqs(%substr(%bCTOScm,1,1),y)) then (%set(fCTOScm,1)) FI

	%out(
Are you calling CTOS IPC Management (y or n)? )
	%define(bCTOSim)(%in)
	%set(fCTOSim,0)
	%IF (%eqs(%substr(%bCTOSim,1,1),Y)) then (%set(fCTOSim,1)) FI
	%IF (%eqs(%substr(%bCTOSim,1,1),y)) then (%set(fCTOSim,1)) FI

	%out(
Are you calling CTOS Exchange Management (y or n)? )
	%define(bCTOSem)(%in)
	%set(fCTOSem,0)
	%IF (%eqs(%substr(%bCTOSem,1,1),Y)) then (%set(fCTOSem,1)) FI
	%IF (%eqs(%substr(%bCTOSem,1,1),y)) then (%set(fCTOSem,1)) FI


) FI

%if (%fSWAP eq 1) then (
$title( Swapper) eject
%if (%pass1 eq -1) then (
	%out(
Small model C programs cannot use the Swapper
) ) fi
%'	%TableEntry(InitOverlays,2,p,w)
%'	%TableEntry(InitLargeOverlays,2,p,w)
%'	%TableEntry(ReInitOverlays,1,w)
%'	%TableEntry(ReInitLargeOverlays,1,w)
%'	%TableEntry(GetCParasOvlyZone,0)
) fi

%if (%fFORMS eq 1) then (
$title( Forms Package) eject
	%TableEntry(DEFAULTFIELD,4,p,p,w,w)
	%TableEntry(DEFAULTFORM,1,p)
	%TableEntry(DISPLAYFORM,4,p,w,w,w)
	%TableEntry(GETFIELDINFO,6,p,p,w,w,p,w)
	%TableEntry(LOCKKBD,0)
	%TableEntry(OPENFORM,5,w,p,w,p,w)
	%TableEntry(READFIELD,8,p,p,w,w,p,w,p,p)
	%TableEntry(SETFIELDATTRS,5,p,p,w,w,w)
	%TableEntry(UNDISPLAYFORM,1,p)
	%TableEntry(USERFILLFIELD,6,p,p,w,w,p,p)
	%TableEntry(WRITEFIELD,7,p,p,w,w,p,w,p)
) fi

%if (%fSM eq 1) then (
$title( Sort/Merge Package) eject
%'	%TableEntry(BASICPREPAREKEYSORT,17,p,p,w,p,w,p,w,p,w,q,w,q,w,w,p,p,p)
%'	%TableEntry(BASICPREPARESORT,16,p,p,w,p,w,p,w,p,w,q,w,q,w,p,p,p)
	%TableEntry(CONCLUDESORT,1,p)
	%TableEntry(DOSORT,1,p)
	%TableEntry(PREPAREKEYSORT,4,p,p,p,p)
	%TableEntry(PREPARESORT,4,p,p,p,p)
	%TableEntry(RELEASERECORD,3,p,p,p)
	%TableEntry(RELEASERECORDANDKEY,5,p,p,p,p,p)
	%TableEntry(RETURNRECORD,3,p,p,p)
	%TableEntry(RETURNRECORDANDKEY,5,p,p,p,p,p)
	%TableEntry(TERMINATESORT,1,p)
) fi

%if (%fISAM eq 1) then (
$title( ISAM Package) eject
	%TableEntry(CLOSEISAM,2,w,p)
	%TableEntry(CREATEISAM,11,p,w,p,w,p,w,p,w,p,w,p)
	%TableEntry(DELETEISAM,2,w,p)
	%TableEntry(DELETEISAMRECORD,3,w,q,p)
	%TableEntry(DELETEISAMRECORDBYKEY,6,w,w,p,w,p,p)  ;###NEW
	%TableEntry(ENDISAMTRANSACTION,1,p); new
	%TableEntry(GETISAMRECORDS,6,w,w,p,w,p,p)
	%TableEntry(GETISAMRECORDSHOLD,6,w,w,p,w,p,p); new
	%TableEntry(INSTALLISAM,15,w,w,w,w,w,w,w,w,w,w,p,w,p,p,p)
	%TableEntry(HOLDISAMRECORD,3,w,q,p); new
	%TableEntry(LOCKISAM,4,w,p,w,p)
	%TableEntry(MODIFYISAMRECORD,5,w,q,p,w,p)
	%TableEntry(MODIFYISAMRECORDBYKEY,6,w,w,p,w,p,p)  ;###NEW
	%TableEntry(OPENISAM,8,p,p,w,p,w,w,w,p)
	%TableEntry(PURGEISAMTRANSACTION,1,p); new
	%TableEntry(READISAMRECORDBYURI,5,w,q,p,w,p)
	%TableEntry(READISAMRECORDBYURIHOLD,5,w,q,p,w,p); new
	%TableEntry(READNEXTISAMRECORD,5,w,p,w,p,p)
	%TableEntry(READNEXTISAMRECORDHOLD,5,w,p,w,p,p); new
	%TableEntry(READUNIQUEISAMRECORD,8,w,w,p,w,p,w,p,p)
	%TableEntry(READUNIQUEISAMRECORDHOLD,8,w,w,p,w,p,w,p,p); new
	%TableEntry(RELEASEISAMRECORD,3,w,q,p); new
	%TableEntry(RENAMEISAM,10,w,p,w,p,w,p,w,p,w,p)
	%TableEntry(SETISAMPROTECTION,6,w,p,w,p,w,p)
	%TableEntry(SETUPISAMITERATION,5,w,w,p,w,p); new
	%TableEntry(SETUPISAMITERATIONKEY,5,w,w,p,w,p)
	%TableEntry(SETUPISAMITERATIONPREFIX,5,w,w,p,w,p)
	%TableEntry(SETUPISAMITERATIONRANGE,9,w,w,p,w,w,p,w,w,p)
	%TableEntry(STARTISAMTRANSACTION,5,w,w,p,w,p); new
	%TableEntry(STOREISAMRECORD,5,w,p,w,p,p)
	%TableEntry(UNLOCKISAM,1,p)
) fi

%if (%fSAM eq 1) then (
$title( Sequential Access Method) eject
	%TableEntry(CHECKPOINTBS,1,p)
	%TableEntry(CLOSEBYTESTREAM,1,p)
	%TableEntry(GETBSLFA,2,p,p)
	%TableEntry(OPENBYTESTREAM,8,p,p,w,p,w,w,p,w)
	%TableEntry(PUTBACKBYTE,2,p,w)
	%TableEntry(QUERYVIDBS,2,p,p)
	%TableEntry(READBSRECORD,4,p,p,w,p)
	%TableEntry(READBYTE,2,p,p)
%'	%TableEntry(READBYTES,4,p,w,p,p)	# Returns ppointer
	%TableEntry(RELEASEBYTESTREAM,1,p)
	%TableEntry(SETBSLFA,2,p,q)
	%TableEntry(SETIMAGEMODE,2,p,w)
	%TableEntry(WRITEBSRECORD,4,p,p,w,p)
	%TableEntry(WRITEBYTE,2,p,w)
) fi

%if (%fRSAM eq 1) then (
$title( Record Sequential Access Method) eject
	%TableEntry(CHECKPOINTRSFILE,1,p)
	%TableEntry(CLOSERSFILE,1,p)
 	%TableEntry(GETRSLFA,2,p,p)
	%TableEntry(GETSTAMFILEHEADER,5,p,w,p,w,p)
	%TableEntry(OPENRSFILE,8,p,p,w,p,w,w,p,w)
	%TableEntry(READRSRECORD,4,p,p,w,p)
	%TableEntry(RELEASERSFILE,1,p)
	%TableEntry(SCANTOGOODRSRECORD,4,p,q,p,p)
	%TableEntry(WRITERSRECORD,3,p,p,w)
) fi

%if (%fDAM eq 1) then (
$title( Direct Access Method)  eject
	%TableEntry(CLOSEDAFILE,1,p)
	%TableEntry(DELETEDARECORD,2,p,q)
	%TableEntry(OPENDAFILE,9,p,p,w,p,w,w,p,w,w)
	%TableEntry(QUERYDALASTRECORD,2,p,p)
	%TableEntry(QUERYDARECORDSTATUS,3,p,q,p)
	%TableEntry(READDAFRAGMENT,5,p,q,p,w,w)
	%TableEntry(READDARECORD,3,p,q,p)
	%TableEntry(SETDABUFFERMODE,2,p,w)
	%TableEntry(TRUNCATEDAFILE,2,p,q)
	%TableEntry(WRITEDAFRAGMENT,5,p,q,p,w,w)
	%TableEntry(WRITEDARECORD,3,p,q,p)
) fi

%if (%fVAM eq 1) then (
$title( Video Access Method)  eject
	%TableEntry(POSFRAMECURSOR,3,w,w,w)
	%TableEntry(PUTFRAMEATTRS,5,w,w,w,w,w)
	%TableEntry(PUTFRAMECHARS,5,w,w,w,p,w)
	%TableEntry(QUERYFRAMECHAR,4,w,w,w,p)
	%TableEntry(RESETFRAME,1,w)
	%TableEntry(SCROLLFRAME,5,w,w,w,w,w)
) fi

%if (%fVDM eq 1) then (
$title( Video Display Managep)  eject
	%TableEntry(INITCHARMAP,2,p,w)
	%TableEntry(INITVIDFRAME,10,w,w,w,w,w,w,w,w,w,w)
	%TableEntry(LOADCURSORRAM,2,p,w)
	%TableEntry(LOADFONTRAM,3,w,p,w)
	%TableEntry(LOADSTYLERAM,2,p,w)
	%TableEntry(QUERYVIDHDW,2,p,w)
	%TableEntry(RESETVIDEO,5,w,w,w,w,p)
	%TableEntry(SETSCREENVIDATTR,2,w,w)
) fi

%if (%fCTOSmm eq 1) then (
$title( CTOS Memory Management)  eject
%if (%pass1 eq -1) then (
	%out(
Small model C programs cannot use Memory Management
) ) fi
%'	%TableEntry(ALLOCALLMEMORYSL,2,p,p)
%'	%TableEntry(ALLOCMEMORYLL,2,w,p)
%'	%TableEntry(ALLOCMEMORYSL,2,w,p)
%'	%TableEntry(DEALLOCMEMORYLL,2,p,w)
%'	%TableEntry(DEALLOCMEMORYSL,2,p,w)
%'	%TableEntry(RESETMEMORYLL,0)
%'	%TableEntry(QUERYMEMAVAIL,1,p)
) fi

%if (%fCTOStm eq 1) then (
$title( CTOS Task Management)  eject
	%TableEntry(CHAIN,7,p,w,p,w,w,w,w)
	%TableEntry(ERROREXIT,1,w)
	%TableEntry(LOADTASK,3,w,w,w)
) fi

%if (%fCTOSoc eq 1) then (
$title( CTOS OpenFile/CloseFile)  eject
	%TableEntry(CLOSEFILE,1,w)
	%TableEntry(OPENFILE,6,p,p,w,p,w,w)
) fi

%if (%fCTOSfm eq 1) then (
$title( CTOS File Management)  eject
	%TableEntry(CHANGEFILELENGTH,2,w,q)
	%TableEntry(CHECKREADASYNC,2,p,p)
	%TableEntry(CHECKWRITEASYNC,2,p,p)
	%TableEntry(CLEARPATH,0)
	%TableEntry(CLOSEALLFILES,0)
	%TableEntry(CLOSEALLFILESLL,0)
	%TableEntry(CREATEDIR,8,p,w,p,w,p,w,w,w)
	%TableEntry(CREATEFILE,5,p,w,p,w,q)
	%TableEntry(DELETEDIR,4,p,w,p,w)
	%TableEntry(DELETEFILE,1,w)
	%TableEntry(GETFHLONGEVITY,2,w,p)
	%TableEntry(GETFILESTATUS,4,w,w,p,w)
	%TableEntry(GETUCB,2,p,w)
	%TableEntry(OPENFILELL,6,p,p,w,p,w,w)  ;###NEW
	%TableEntry(QUERYWSNUM,1,p)
	%TableEntry(QUIETIO,0)
	%TableEntry(READFILE,5,w,p,w,q,p)
	%TableEntry(READASYNC,6,w,p,w,q,p,w)
	%TableEntry(READDIRSECTOR,6,p,w,p,w,w,p)
	%TableEntry(RENAMEFILE,5,w,p,w,p,w)
	%TableEntry(SETFHLONGEVITY,2,w,w)
	%TableEntry(SETFILESTATUS,4,w,w,p,w)
	%TableEntry(SETPATH,6,p,w,p,w,p,w)
	%TableEntry(SETPREFIX,2,p,w)
	%TableEntry(WRITEFILE,5,w,p,w,q,p)
	%TableEntry(WRITEASYNC,6,w,p,w,q,p,w)
) fi

%if (%fCTOSkm eq 1) then (
$title( CTOS Keyboard Management)  eject
	%TableEntry(BEEP,0)
	%TableEntry(CHECKPOINTSYSIN,0)
	%TableEntry(DISABLEACTIONFINISH,1,w)
	%TableEntry(QUERYKBDLEDS,1,p)
	%TableEntry(QUERYKBDSTATE,1,p)
	%TableEntry(READACTIONCODE,1,p)
	%TableEntry(READKBD,1,p)
	%TableEntry(READKBDDIRECT,2,w,p)
	%TableEntry(SETKBDLED,2,w,w)
	%TableEntry(SETKBDUNENCODEDMODE,1,w)
	%TableEntry(SETSYSINMODE,2,w,w)
) fi

%if (%fCTOScm eq 1) then (
$title( CTOS Timer Management)  eject
	%TableEntry(CLOSERTCLOCK,1,p)
	%TableEntry(COMPACTDATETIME,2,p,p)
	%TableEntry(DELAY,1,w)
	%TableEntry(EXPANDDATETIME,2,q,p)
	%TableEntry(GETDATETIME,1,p)
	%TableEntry(OPENRTCLOCK,1,p)
	%TableEntry(RESETTIMERINT,1,p)
	%TableEntry(SETDATETIME,2,w,w)
	%TableEntry(SETTIMERINT,1,p)
) fi

%if (%fCTOSim eq 1) then (
$title( CTOS IPC Management)  eject
%'	%TableEntry(CHECK,2,w,p)	# Uses ppointer
	%TableEntry(PSEND,2,w,p)
	%TableEntry(REQUEST,1,p)
	%TableEntry(RESPOND,1,p)
	%TableEntry(SEND,2,w,p)
%'	%TableEntry(WAIT,2,w,p)		# Uses ppointer
) fi

%if (%fCTOSem eq 1) then (
$title( CTOS Exchange Management)  eject
	%TableEntry(ALLOCEXCH,1,p)
	%TableEntry(DEALLOCEXCH,1,w)
	%TableEntry(QUERYDEFAULTRESPEXCH,1,p)
) fi
end
