;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpCnfgC.asm                                                         *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Editor message text.                                                      *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 10/24/89 120D/01 T. Ball      / Added cmidDspColors2                      *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpCnfgC.asm


$include(WpKbd.mdf)
$include(WpCmid.mdf)
$include(WpCmdd.mdf)
$include(WpMsg.mdf)
$include(WpCnfg.mdf)


extrn cmidInsHexHelp: abs
extrn cmidColorsHelp: abs
extrn cmidConvertHelp: abs


DGroup group CmidSeg, CmddSeg, MenuSeg, Const
assume ds: DGroup


%DefineMenu(cmidDspCmr, 0, false, 1,
~~,
~
~,
~
	<idMsg>
~,
~
~)%'


%DefineMenu(cmidDspInitialCmr, 0, false, 2,
~~,
~|
Press any key to continue
~,
~
<idParMsg>
	<idMsg>
~,
~
~)%'

public cmidInitialCmrMenu
Const segment word public 'Const'
cmidInitialCmrMenu dw cmidDspInitialCmr
Const ends


%DefineMenu(cmidDspInsHex, iCmrDisplayMenu, false, 3,
~ INSERT HEXADECIMAL ~,
~|(Press GO to execute, CANCEL to dismiss)|
|
Hexadecimal code(s):  |	|
~,
~
<idParTitle>
	<idMsg,	typSysBlank>
	<idMsg>
<idParBlank>
	<1,		typInsert>
<idParNoise>
~,
~
<chGo, cmidInsHex>
<chHelp, cmidInsHexHelp>
~)%'


%DefineMenu(cmidDspColors, iCmrDisplayColors, true, 11,
~ DISPLAY COLORS ~,
~|(Press GO to execute, NEXT for next item, CANCEL to dismiss)|
|
Normal display
   Red level            |0|   |1|   |2|   |3|	|
   Green level          |0|   |1|   |2|   |3|	|
   Blue level           |0|   |1|   |2|   |3|	|
Half-bright display
   Red level            |0|   |1|   |2|   |3|	|
   Green level          |0|   |1|   |2|   |3|	|
   Blue level           |0|   |1|   |2|   |3|	|
Save to user file?      |Yes|     |No|      (Press Y or N)	|
~,
~
<idParTitle>
	<idMsg,	typSysBlank>
	<idMsg>
<idParChoice>
	<1,	 typProtected,	'0',	false>
	<>
	<2,	 typProtected,	'1',	false>
	<>
	<3,	 typProtected,	'2',	false>
	<>
	<4,	 typProtected,	'3',	true>
	<>
<idParChoice>
	<5,	 typProtected,	'0',	false>
	<>
	<6,	 typProtected,	'1',	false>
	<>
	<7,	 typProtected,	'2',	false>
	<>
	<8,	 typProtected,	'3',	true>
	<>
<idParChoice>
	<9,	 typProtected,	'0',	false>
	<>
	<10,	typProtected,	'1',	false>
	<>
	<11,	typProtected,	'2',	false>
	<>
	<12,	typProtected,	'3',	true>
	<>
<idParChoice>
	<13,	typProtected,	'0',	false>
	<>
	<14,	typProtected,	'1',	false>
	<>
	<15,	typProtected,	'2',	false>
	<>
	<16,	typProtected,	'3',	true>
	<>
<idParChoice>
	<17,	typProtected,	'0',	false>
	<>
	<18,	typProtected,	'1',	false>
	<>
	<19,	typProtected,	'2',	false>
	<>
	<20,	typProtected,	'3',	true>
	<>
<idParChoice>
	<21,	typProtected,	'0',	false>
	<>
	<22,	typProtected,	'1',	false>
	<>
	<23,	typProtected,	'2',	false>
	<>
	<24,	typProtected,	'3',	true>
	<>
<idParChoice>
	<25,	typProtected,	'y',	false>
	<>
	<26,	typProtected,	'n',	true>
	<>
<idParNoise>
~,
~
<chGo, cmidSetColors>
<chHelp, cmidColorsHelp>
~)%'


%DefineMenu(cmidDspColors2, iCmrDisplayColors, true, 15,
~ DISPLAY COLORS ~,
~|(Press GO to execute, NEXT for next item, CANCEL to dismiss)|
|
Normal display
   Red level            |0|   |1|   |2|   |3|	|
   Green level          |0|   |1|   |2|   |3|	|
   Blue level           |0|   |1|   |2|   |3|	|
Half-bright display
   Red level            |0|   |1|   |2|   |3|	|
   Green level          |0|   |1|   |2|   |3|	|
   Blue level           |0|   |1|   |2|   |3|	|
Background display
   Red level            |0|   |1|   |2|   |3|	|
   Green level          |0|   |1|   |2|   |3|	|
   Blue level           |0|   |1|   |2|   |3|	|
Save to user file?      |Yes|     |No|      (Press Y or N)	|
~,
~
<idParTitle>
	<idMsg,	typSysBlank>
	<idMsg>
<idParChoice>
	<1,	 typProtected,	'0',	false>
	<>
	<2,	 typProtected,	'1',	false>
	<>
	<3,	 typProtected,	'2',	false>
	<>
	<4,	 typProtected,	'3',	true>
	<>
<idParChoice>
	<5,	 typProtected,	'0',	false>
	<>
	<6,	 typProtected,	'1',	false>
	<>
	<7,	 typProtected,	'2',	false>
	<>
	<8,	 typProtected,	'3',	true>
	<>
<idParChoice>
	<9,	 typProtected,	'0',	false>
	<>
	<10,	typProtected,	'1',	false>
	<>
	<11,	typProtected,	'2',	false>
	<>
	<12,	typProtected,	'3',	true>
	<>
<idParChoice>
	<13,	typProtected,	'0',	false>
	<>
	<14,	typProtected,	'1',	false>
	<>
	<15,	typProtected,	'2',	false>
	<>
	<16,	typProtected,	'3',	true>
	<>
<idParChoice>
	<17,	typProtected,	'0',	false>
	<>
	<18,	typProtected,	'1',	false>
	<>
	<19,	typProtected,	'2',	false>
	<>
	<20,	typProtected,	'3',	true>
	<>
<idParChoice>
	<21,	typProtected,	'0',	false>
	<>
	<22,	typProtected,	'1',	false>
	<>
	<23,	typProtected,	'2',	false>
	<>
	<24,	typProtected,	'3',	true>
	<>
<idParChoice>
	<27,	typProtected,	'0',	false>
	<>
	<28,	typProtected,	'1',	false>
	<>
	<29,	typProtected,	'2',	false>
	<>
	<30,	typProtected,	'3',	true>
	<>
<idParChoice>
	<31,	typProtected,	'0',	false>
	<>
	<32,	typProtected,	'1',	false>
	<>
	<33,	typProtected,	'2',	false>
	<>
	<34,	typProtected,	'3',	true>
	<>
<idParChoice>
	<35,	typProtected,	'0',	false>
	<>
	<36,	typProtected,	'1',	false>
	<>
	<37,	typProtected,	'2',	false>
	<>
	<38,	typProtected,	'3',	true>
	<>
<idParChoice>
	<25,	typProtected,	'y',	false>
	<>
	<26,	typProtected,	'n',	true>
	<>
<idParNoise>
~,
~
<chGo, cmidSetColors>
<chHelp, cmidColorsHelp>
~)%'


%DefineMenu(cmidDspConvert, iCmrDisplayMenu, false, 3,
~ CONVERT LINE ENDINGS ~,
~|(Press GO to execute, CANCEL to dismiss)|
|
Line mapping mode:   |Lf (CTOS)|   |CrLf (DOS)|   (Press L or C)   |
~,
~
<idParTitle>
	<idMsg,	typSysBlank>
	<idMsg>
<idParChoice>
	<1, typProtected, 'l', true>
	<>
	<2, typProtected, 'c', false>
	<>
<idParNoise>
~,
~
<chGo, cmidConvert>
<chHelp, cmidConvertHelp>
~)%'


end; WpCnfgC.asm