;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpCnfgHC.asm                                                        *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:  help for menus defined in WpCnfgB.asm                       *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/16/89 120F/01 T. Ball      / Cleaned up wording per Pubs               *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpCnfgHC.asm -- help for menus defined in WpCnfgC.asm

$include(WpKbd.mdf)
$include(WpCmid.mdf)
$include(WpCmdd.mdf)
$include(WpMsg.mdf)
$include(WpCnfg.mdf)


extrn cmidDspHelp: abs

DGroup group CmidSeg, CmddSeg, MenuSeg
assume ds: DGroup


%DefineMenu(cmidInsHexHelp, iCmrDisplayHelpMenu, false, 10,
~ INSERT HEXADECIMAL HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Insert Hexadecimal command is used to insert one or more characters by 
their hexadecimal equivalent rather than by a literal keyboard character.  For
example, to insert a GO character into a submit file, the hexadecimal value 
for GO, 1B, can be entered using this menu.  

The string specifying the hexadecimal numbers can be any length as long as it 
consists of numbers and the letters A through F only.  The characters are 
inserted where the cursor is positioned in the file.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidColorsHelp, iCmrDisplayHelpMenu, false, 16,
~ DISPLAY COLORS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Display Colors command allows you to modify the two colors displayed by
the Editor.  Any of sixty-four colors can be chosen for the normal and half-
bright parts of the display, although not all of these combinations are 
visible or asthetically pleasing.  

The normal and half-bright colors are configured by specifying a value of zero
to three for the red, green, and blue parts of the color.  A zero for a color
indicates that that color is turned off, while a one, two, or three indicate
increasing intensities of that color.  When a color combination has been
entered, press Go to change the display to that color combination.

Once the desired color combination is determined, the color defaults can be 
made permanent by storing them in your .user file, by specifying Yes to the 
Save to User File option.  
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidConvertHelp, iCmrDisplayHelpMenu, false, 11,
~ CONVERT LINE ENDINGS ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Convert Line Endings command changes all line endings to the type speci-
fied.  This command is normally used under two circumstances:  when first 
opening a file created under another operating system, such as DOS, or when
preparing a file to be copied to another operating system.

CTOS and Unix use a linefeed (LF) character to end a text line.  DOS uses a 
carriage-return (CR) followed by a linefeed to end text lines.  Choose CrLf if 
editing a file created under DOS; otherwise, use the default Lf option for 
normal CTOS editing.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


end; WpCnfgHC.asm
