; WpKbd.asm

$include(WpKbd.mdf)
$include(WpCmd.mdf)
$include(WpCmid.mdf)
$include(WpCmdd.mdf)
$include(WpCnfg.mdf)
$include(WpMsg.mdf)

extrn cmidDspCmr: abs
extrn cmidDspClock: abs
extrn cmidDspCopyDoc: abs
extrn cmidDspDeleteDoc: abs
extrn cmidDspDocuments: abs
extrn cmidDspFind: abs
extrn cmidDspGotoLine: abs
extrn cmidDspHelp: abs
extrn cmidDspHelpKeys: abs
extrn cmidDspInsHex: abs
extrn cmidDspListDocs: abs
extrn cmidDspOpenDoc: abs
extrn cmidDspRenameDoc: abs
extrn cmidDspSubst: abs
extrn cmidDspWorkArea: abs
extrn cmidDspBlkChk: abs
extrn cmidDspListVol: abs
extrn cmidDspWindows: abs
extrn cmidDspDefaults: abs
extrn cmidDspColors: abs
extrn cmidDspConvert: abs
extrn cmidDspMarkBlk: abs

DGroup group Const, CmddSeg, CmchSeg, CmfopSeg, MenuSeg
assume ds: DGroup


public rgiledRetain, iledRetainMac, iledMac
public dmikey, upper, lower


Const segment word public 'Const'


; KEYBOARD LEDs:
; rgiledRetain is a global array which controls which LEDs are cleared 
; (turned off) during initialization.  You should put into this array
; the iled numbers (as known to the OS) for all LEDs whose state is to
; be unchanged by the initialization code - all others will be cleared.

; iledRetainMac must be set to equal the number of entries in rgiledRetain.

rgiledRetain    db 6, 7  ; i.e. LOCK and OVERTYPE
iledRetainMac   db 2

; iledMac must equal the total number of LEDs on the keyboard
iledMac      db 8 


; NON-STANDARD CHARACTER ENCODINGS:
; The majority of keys are translated into characters codes via the OS
; Keyboard Translation Table found in SysGen.asm.  Exceptions to the standard
; encodings (such as CODE-characters) may be accomplished here using the macro
; DefineCmch.  The macro takes as parameters a cmid name (used in the
; functional encoding table below), the ASCII code of the character to be
; encoded, and a flag indicating whether this character should repeat when the
; key is held down.  The result of the macro call is to bind the character
; encoding to the cmid supplied; this may then be bound to a key via the
; functional encoding table (dmikey) below.


%DefineCmch(cmidNewLine, 0Ah, true)  ; required carriage return
;CAUTION the following declaration uses knowledge that CmidType is a word
cmidForRealNewLine dw cmidNewLine
public cmidForRealNewLine


; terminate various cmid tables:

CmchSeg segment byte public 'Const'
	dw cmidNil
CmchSeg ends

CmfopSeg segment byte public 'Const'
	dw cmidNil
CmfopSeg ends

MenuSeg segment byte public 'Data'
	dw cmidNil
MenuSeg ends


; FUNCTION KEY ENCODINGS
; The table dmikey defines semantics of function keys.
; Function keys are those keys which generate commands rather than characters.
; For each function key there are four command identifiers (cmid's) defining
; the unshifted, shifted, coded, and code-shifted interpretations of that key.
;
; mpikeyFuncKey maps ikey values (for unencoded input) to the
; entry in this table which defines that function key.
;
; EXAMPLE:
; Suppose you want to move the Redo command from F1 to code-A (for
; "Again", say).  Find the table entry for F1 (ikey = 15h); observe
; that the first-column cmid is cmidRedo.  Change this to
; cmidNoSuchCmd to obtain the "No such command" message when F1 is
; depressed.  Now locate the entry for the "A" key (ikey = 61h).  Change the
; cmidNoSuchCmd in the third column (coded) to cmidRedo.  Depressing code-A
; will now invoke the Redo function.

dmikey label byte
;  (unshifted)     (shifted)       (coded)         (code-shift)   (keytop)
dw cmidDspHelpKeys, cmidDspHelp,   cmidDspHelp,    cmidDspHelp   ;0 HELP
dw cmidCursorU,    cmidFastU,      cmidTop,        cmidNoSuchCmd ;1 up arrow
dw cmidMarkChar,   cmidUnmark,     cmidUnmark,     cmidNoSuchCmd ;2 MARK
dw cmidBound,      cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;3 BOUND
dw cmidFinish,     cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;4 FINISH
dw cmidScreenDn,   cmidPrevPage,   cmidScreenDn,   cmidNoSuchCmd ;5 PREV PAGE
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;6 1/2
dw cmidCancel,     cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;7 CANCEL
dw cmidBackspace,  cmidBackspace,  cmidBackWord,   cmidNoSuchCmd ;8 BACKSPACE
dw cmidTyping,     cmidTyping,     cmidInsertTab,  cmidNoSuchCmd ;9 TAB
dw cmidNewPara,    cmidNewLine,    cmidNoSuchCmd,  cmidNoSuchCmd ;A RETURN
dw cmidCursorD,    cmidFastD,      cmidBottom,     cmidNoSuchCmd ;B down arrow
dw cmidScreenUp,   cmidNextPage,   cmidForcePage,  cmidNoSuchCmd ;C NEXT PAGE
dw cmidNext,       cmidNoSuchCmd,  cmidNextWindow, cmidNoSuchCmd ;D NEXT
dw cmidCursorL,    cmidFastL,      cmidLeft,       cmidNoSuchCmd ;E left arrow
dw cmidCursorR,    cmidFastR,      cmidRight,      cmidNoSuchCmd ;F right arrow

;  (unshifted)     (shifted)       (coded)         (code-shift)   (keytop)
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;10 [L SHIFT]
dw cmidScrollUp,   cmidScreenUp,   cmidScreenUp,   cmidNoSuchCmd ;11 SCROLL UP
dw cmidMoveDn,     cmidNoSuchCmd,  cmidCodeMove,   cmidNoSuchCmd ;12 MOVE
dw cmidScrollDn,   cmidScreenDn,   cmidScreenDn,   cmidNoSuchCmd ;13 SCROLL DN
dw cmidCopyDn,     cmidNoSuchCmd,  cmidCodeCopy,   cmidNoSuchCmd ;14 COPY
dw cmidRedo,     cmidLastInstPt, cmidDspDocuments, cmidNoSuchCmd ;15 f1
dw cmidUndo,       cmidNoSuchCmd,  cmidDiscard,    cmidNoSuchCmd ;16 f2
dw cmidDspBlkChk,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;17 f3
dw cmidDspWindows, cmidNoSuchCmd,  cmidDspConvert, cmidNoSuchCmd ;18 f4
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;19 f5
dw cmidDspFind,    cmidDspSubst,   cmidNoSuchCmd,  cmidNoSuchCmd ;1A f6
dw cmidGo,         cmidNoSuchCmd,  cmidDspWindows, cmidNoSuchCmd ;1B GO
dw cmidDspDefaults, cmidDspColors, cmidNoSuchCmd,  cmidNoSuchCmd ;1C f7
dw cmidMarkWord,   cmidNoSuchCmd,  cmidDspMarkBlk, cmidNoSuchCmd ;1D f8
dw cmidMarkLine,   cmidMarkToEOL,  cmidNoSuchCmd,  cmidNoSuchCmd ;1E f9
dw cmidNoSuchCmd,  cmidMarkToEOF,  cmidMarkDoc,    cmidNoSuchCmd ;1F f10

;  (unshifted)     (shifted)       (coded)         (code-shift)   (keytop)
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;20 space bar
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;21 numeric 9
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;22 [R SHIFT]
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;23 numeric 0
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;24 [NEXT]
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;25 no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;26 no key 
dw cmidTyping,     cmidTyping,     cmidLiteralIns, cmidLiteralIns ;27 ' "
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;28 no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;29 no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;2A no key 
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;2B = +
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;2C , ,
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;2D - _
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;2E . .
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;2F / ?

;  (unshifted)     (shifted)       (coded)         (code-shift)   (keytop)
dw cmidTyping,     cmidTyping,     cmidThumb100,   cmidNoSuchCmd ;30 0 )
dw cmidTyping,     cmidTyping,     cmidThumb10,    cmidNoSuchCmd ;31 1 !
dw cmidTyping,     cmidTyping,     cmidThumb20,    cmidNoSuchCmd ;32 2 @
dw cmidTyping,     cmidTyping,     cmidThumb30,    cmidNoSuchCmd ;33 3 #
dw cmidTyping,     cmidTyping,     cmidThumb40,    cmidNoSuchCmd ;34 4 $
dw cmidTyping,     cmidTyping,     cmidThumb50,    cmidNoSuchCmd ;35 5 percent
dw cmidTyping,     cmidTyping,     cmidThumb60,    cmidNoSuchCmd ;36 6 cent
dw cmidTyping,     cmidTyping,     cmidThumb70,    cmidNoSuchCmd ;37 7 &
dw cmidTyping,     cmidTyping,     cmidThumb80,    cmidNoSuchCmd ;38 8 *
dw cmidTyping,     cmidTyping,     cmidThumb90,    cmidNoSuchCmd ;39 9 (
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;3A no key 
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;3B ; :
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;3C no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;3D no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;3E no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;3F no key 

;  (unshifted)     (shifted)       (coded)         (code-shift)   (keytop)
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;40 no key 
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;41 numeric 6
dw cmidTyping,     cmidTyping,     cmidPrevWindow, cmidNoSuchCmd ;42 numeric -
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;43 ACTION
dw cmidShift,      iledOvertype,   maskOvertype,   cmidNoSuchCmd ;44 OVERTYPE
dw cmidShift,      iledLock,       maskLock,       cmidNoSuchCmd ;45 LOCK
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;46 numeric 2
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;47 numeric 3
dw cmidShift,      iledNil,        maskLShift,     cmidNoSuchCmd ;48 left SHIFT
dw cmidShift,      iledNil,        maskRShift,     cmidNoSuchCmd ;49 right SHFT
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;4A numeric 0
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;4B numeric .
dw cmidShift,      iledNil,        maskLCode,      cmidNoSuchCmd ;4C left CODE
dw cmidShift,      iledNil,        maskRCode,      cmidNoSuchCmd ;4D right CODE
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;4E no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;4F no key 

;  (unshifted)     (shifted)       (coded)         (code-shift)   (keytop)
dw cmidNil,        cmidNil,        cmidNil,        cmidNil       ;50 nil
dw cmidUpdate,     cmidUpdate,     cmidUpdate,     cmidUpdate    ;51 update
dw cmidIdle,       cmidIdle,       cmidIdle,       cmidIdle      ;52 idle
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;53 no key
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;54 no key
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;55 no key
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;56 no key
dw cmidClock,      cmidClock,      cmidClock,      cmidClock     ;57 clock
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;58 no key
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;59 no key 
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;5A no key 
dw cmidTyping,     cmidTyping,   cmidConvertLower, cmidNoSuchCmd ;5B [ <
dw cmidTyping,     cmidTyping,     cmidNoSuchCmd,  cmidNoSuchCmd ;5C numeric 7
dw cmidTyping,     cmidTyping,   cmidConvertUpper, cmidNoSuchCmd ;5D ] >
dw cmidTyping,     cmidTyping,     cmidThumb0,     cmidNoSuchCmd ;5E ^ ~
dw cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd,  cmidNoSuchCmd ;5F no key 

;  (unshifted)  (shifted)       (coded)         (code-shift)   (keytop)
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;60 numeric 1
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;61 A
dw cmidTyping,  cmidTyping,  cmidThumb0,     cmidNoSuchCmd     ;62 B
dw cmidTyping,  cmidTyping,  cmidCloseWnd,   cmidDspCopyDoc    ;63 C
dw cmidTyping,  cmidTyping,  cmidDivideWnd,  cmidDspDeleteDoc  ;64 D
dw cmidTyping,  cmidTyping,  cmidThumb100,   cmidMarkDoc       ;65 E
dw cmidTyping,  cmidTyping,  cmidDspFind,    cmidLstOpenFls    ;66 F
dw cmidTyping,  cmidTyping,  cmidDspGotoLine,cmidDspGotoLine   ;67 G
dw cmidTyping,  cmidTyping,  cmidDspHex,     cmidNoSuchCmd     ;68 H
dw cmidTyping,  cmidTyping,  cmidDspInsHex,  cmidNoSuchCmd     ;69 I
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;6A J
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;6B K
dw cmidTyping,  cmidTyping,  cmidLocate,     cmidDspListDocs   ;6C L
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;6D M
dw cmidTyping,  cmidTyping,  cmidDspCurLine, cmidDspCharCnt    ;6E N
dw cmidTyping,  cmidTyping,  cmidDspOpenDoc, cmidDspOpenDoc    ;6F O

;  (unshifted)   (shifted)     (coded)        (code-shift)     (keytop)
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidDspWorkArea   ;70 P
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;71 Q
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidDspRenameDoc  ;72 R
dw cmidTyping,  cmidTyping,  cmidSave,       cmidNoSuchCmd     ;73 S
dw cmidTyping,  cmidTyping,  cmidDspClock,   cmidNoSuchCmd     ;74 T
dw cmidTyping,  cmidTyping,  cmidDiscard,    cmidNoSuchCmd     ;75 U
dw cmidTyping,  cmidTyping,  cmidVisible,    cmidDspListVol    ;76 V
dw cmidTyping,  cmidTyping,  cmidBackWord,   cmidNoSuchCmd     ;77 W
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;78 X
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;79 Y
dw cmidTyping,  cmidTyping,  cmidZoom,       cmidNoSuchCmd     ;7A Z
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;7B numeric 4
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;7C numeric 8
dw cmidTyping,  cmidTyping,  cmidNoSuchCmd,  cmidNoSuchCmd     ;7D numeric 5
dw cmidNoSuchCmd, cmidNoSuchCmd, cmidNoSuchCmd, cmidNoSuchCmd  ;7E no key here
dw cmidDelete,  cmidNoSuchCmd, cmidClearBlank, cmidNoSuchCmd   ;7F DELETE
;  (unshifted)   (shifted)     (coded)        (code-shift)     (keytop)


; SPECIAL EVENTS
; Various significant input events (such as timeout and keystream empty) are
; represented as pseudo-keystrokes in the command processor front end.  These
; pseudo-keystrokes must be assigned key numbers (ikey's) distinct from all
; actual keystrokes defined by the keyboard proper; i.e. they must be chosen
; from the "no key here" entries in the above table.

public ikeyNil, ikeyUpdate, ikeyIdle, ikeyClock
public ikeyTimeout, ikeyEndReplay
ikeyNil           db 50h
ikeyUpdate        db 51h
ikeyIdle          db 52h
ikeyTimeout       db 55h
ikeyEndReplay     db 56h
ikeyClock         db 57h


; Array of cmids which are generated by pseudo-keystrokes
public rgcmidPseudoKeystrokes, icmidMacPseudoKeystrokes
rgcmidPseudoKeystrokes label word

 dw cmidNil
 dw cmidUpdate
 dw cmidIdle
 dw cmidClock

; icmidMacPseudoKeystrokes measures the length of the table
icmidMacPseudoKeystrokes dw ($ - rgcmidPseudoKeystrokes)/2


; DEFAULT MENU:
; The static scalar cmidDefaultMenu determines which menu (if any) gets
; displayed when the last window or menu is closed.

cmidDefaultMenu	dw cmidNil	; i.e. no menu
public cmidDefaultMenu


; STATUS MESSAGE MENU:
; The static scalar cmidCmrMenu determines which menu is used for displaying
; random status messages (cmr's).  This MUST be defined; it CANNOT be cmidNil.

cmidCmrMenu	dw cmidDspCmr
public cmidCmrMenu


Const ends

; Default upper and lower case tables, overwritten if NLS tables are available
; copied from 11.0 default Nls.asm

Data segment word public 'data'
Upper label byte
db 000h, 001h, 002h, 003h, 004h, 005h, 006h, 007h
db 008h, 009h, 00Ah, 00Bh, 00Ch, 00Dh, 00Eh, 00Fh
db 010h, 011h, 012h, 013h, 014h, 015h, 016h, 017h
db 018h, 019h, 01Ah, 01Bh, 01Ch, 01Dh, 01Eh, 01Fh
db 020h, 021h, 022h, 023h, 024h, 025h, 026h, 027h
db 028h, 029h, 02Ah, 02Bh, 02Ch, 02Dh, 02Eh, 02Fh
db 030h, 031h, 032h, 033h, 034h, 035h, 036h, 037h
db 038h, 039h, 03Ah, 03Bh, 03Ch, 03Dh, 03Eh, 03Fh
db 040h, 041h, 042h, 043h, 044h, 045h, 046h, 047h
db 048h, 049h, 04Ah, 04Bh, 04Ch, 04Dh, 04Eh, 04Fh
db 050h, 051h, 052h, 053h, 054h, 055h, 056h, 057h
db 058h, 059h, 05Ah, 05Bh, 05Ch, 05Dh, 05Eh, 05Fh
db 060h
db 'A' ;61h
db 'B' ;62h
db 'C' ;63h
db 'D' ;64h
db 'E' ;65h
db 'F' ;66h
db 'G' ;67h
db 'H' ;68h
db 'I' ;69h
db 'J' ;6Ah
db 'K' ;6Bh
db 'L' ;6Ch
db 'M' ;6Dh
db 'N' ;6Eh
db 'O' ;6Fh
db 'P' ;70h
db 'Q' ;71h
db 'R' ;72h
db 'S' ;73h
db 'T' ;74h
db 'U' ;75h
db 'V' ;76h
db 'W' ;77h
db 'X' ;78h
db 'Y' ;79h
db 'Z' ;7Ah
db 07Bh
db 07Ch
db 07Dh
db 07Eh
db 07Fh
db 080h, 081h, 082h, 083h, 084h, 085h, 086h, 087h
db 088h, 089h, 08Ah, 08Bh, 08Ch, 08Dh, 08Eh, 08Fh
db 090h, 091h, 092h, 093h, 094h, 095h, 096h, 097h
db 098h, 099h, 09Ah, 09Bh, 09Ch, 09Dh, 09Eh, 09Fh
db 0A0h
db 0A0h ;0A1h    goes to 
db 0A2h
db 0A2h ;0A3h    goes to 
db 0A4h
db 0A4h ;0A5h   little o umlaut goes to 
db 0A6h
db 0A6h ;0A7h    goes to 
db 0A8h
db 0A8h ;0A9h    goes to 
db 0AAh, 0ABh, 0ACh, 0ADh, 0AEh
db 0AEh ;0AFh    goes to 
db 0B0h, 0B1h, 0B2h, 0B3h, 0B4h, 0B5h, 0B6h, 0B7h
db 0B8h, 0B9h, 0BAh, 0BBh, 0BCh, 0BDh, 0BEh, 0BFh
db 0C0h, 0C1h, 0C2h, 0C3h, 0C4h, 0C5h, 0C6h, 0C7h
db 0C8h, 0C9h, 0CAh, 0CBh, 0CCh, 0CDh, 0CEh, 0CFh
db 0D0h, 0D1h, 0D2h, 0D3h, 0D4h, 0D5h, 0D6h, 0D7h
db 0D8h, 0D9h, 0DAh, 0DBh, 0DCh, 0DDh, 0DEh, 0DFh
db 0E0h, 0E1h, 0E2h, 0E3h, 0E4h, 0E5h, 0E6h, 0E7h
db 0E8h, 0E9h, 0EAh, 0EBh, 0ECh, 0EDh, 0EEh, 0EFh
db 0F0h, 0F1h, 0F2h, 0F3h, 0F4h, 0F5h, 0F6h, 0F7h
db 0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh, 0FFh

Lower label byte
db 000h, 001h, 002h, 003h, 004h, 005h, 006h, 007h
db 008h, 009h, 00Ah, 00Bh, 00Ch, 00Dh, 00Eh, 00Fh
db 010h, 011h, 012h, 013h, 014h, 015h, 016h, 017h
db 018h, 019h, 01Ah, 01Bh, 01Ch, 01Dh, 01Eh, 01Fh
db 020h, 021h, 022h, 023h, 024h, 025h, 026h, 027h
db 028h, 029h, 02Ah, 02Bh, 02Ch, 02Dh, 02Eh, 02Fh
db 030h, 031h, 032h, 033h, 034h, 035h, 036h, 037h
db 038h, 039h, 03Ah, 03Bh, 03Ch, 03Dh, 03Eh, 03Fh
db 040h
db 'a' ;41h
db 'b' ;42h
db 'c' ;43h
db 'd' ;44h
db 'e' ;45h
db 'f' ;46h
db 'g' ;47h
db 'h' ;48h
db 'i' ;49h
db 'j' ;4Ah
db 'k' ;4Bh
db 'l' ;4Ch
db 'm' ;4Dh
db 'n' ;4Eh
db 'o' ;4Fh
db 'p' ;50h
db 'q' ;51h
db 'r' ;52h
db 's' ;53h
db 't' ;54h
db 'u' ;55h
db 'v' ;56h
db 'w' ;57h
db 'x' ;58h
db 'y' ;59h
db 'z' ;5Ah
db 5Bh
db 5Ch
db 5Dh
db 5Eh
db 5Fh
db 060h, 061h, 062h, 063h, 064h, 065h, 066h, 067h
db 068h, 069h, 06Ah, 06Bh, 06Ch, 06Dh, 06Eh, 06Fh
db 070h, 071h, 072h, 073h, 074h, 075h, 076h, 077h
db 078h, 079h, 07Ah, 07Bh, 07Ch, 07Dh, 07Eh, 07Fh
db 080h, 081h, 082h, 083h, 084h, 085h, 086h, 087h
db 088h, 089h, 08Ah, 08Bh, 08Ch, 08Dh, 08Eh, 08Fh
db 090h, 091h, 092h, 093h, 094h, 095h, 096h, 097h
db 098h, 099h, 09Ah, 09Bh, 09Ch, 09Dh, 09Eh, 09Fh
db 0A1h ;0A0h    goes to 
db 0A1h
db 0A3h ;0A2h    goes to 
db 0A3h
db 0A5h ;0A4h    goes to little o umlaut
db 0A5h
db 0A7h ;0A6h    goes to 
db 0A7h
db 0A9h ;0A8h    goes to 
db 0A9h, 0AAh, 0ABh, 0ACh, 0ADh
db 0AFh ;0AEh    goes to 
db 0AFh
db 0B0h, 0B1h, 0B2h, 0B3h, 0B4h, 0B5h, 0B6h, 0B7h
db 0B8h, 0B9h, 0BAh, 0BBh, 0BCh, 0BDh, 0BEh, 0BFh
db 0C0h, 0C1h, 0C2h, 0C3h, 0C4h, 0C5h, 0C6h, 0C7h
db 0C8h, 0C9h, 0CAh, 0CBh, 0CCh, 0CDh, 0CEh, 0CFh
db 0D0h, 0D1h, 0D2h, 0D3h, 0D4h, 0D5h, 0D6h, 0D7h
db 0D8h, 0D9h, 0DAh, 0DBh, 0DCh, 0DDh, 0DEh, 0DFh
db 0E0h, 0E1h, 0E2h, 0E3h, 0E4h, 0E5h, 0E6h, 0E7h
db 0E8h, 0E9h, 0EAh, 0EBh, 0ECh, 0EDh, 0EEh, 0EFh
db 0F0h, 0F1h, 0F2h, 0F3h, 0F4h, 0F5h, 0F6h, 0F7h
db 0F8h, 0F9h, 0FAh, 0FBh, 0FCh, 0FDh, 0FEh, 0FFh

Data ends

end; WpKbd.asm