/* COPYRIGHT		1980 CONVERGENT TECHNOLOGIES, INC.
 ALL RIGHTS RESERVED
 THIS PROGRAM IS FURNISHED UNDER A LICENSE RESTRICTING ITS USE SOLELY FOR THE
 OPERATION OF A DESIGNATED COMPUTER FOR A PARTICULAR PURPOSE, AND MAY NOT BE
 COPIED OR OTHERWISE USED WITHOUT THE PRIOR WRITTEN CONSENT OF
 CONVERGENT TECHNOLOGIES, INC. TITLE TO AND OWNERSHIP OF THE PROGRAM,
 INCLUDING ITS SOURCE CODE,
 SHALL AT ALL TIMES REMAIN IN CONVERGENT TECHNOLOGIES.
*/

/* ERROR CODES erc.edf */
/* updated:
	1/08/81		RH: ercServiceNotAvail
	2/05/81		BK: redid ercHighLevelError, ercTimerFailure
		added ercInvalidLine, ercLineInUse, ercBootFailure
	3/17/81		BK: added ercNoIds, ercIdSearchFailure
	3/26/81		RH: ercLpIsrAlreadyExist
	4/27/81		RH: ercClusterGoingDown
	5/30/81		RH: ercCannotLog
	7/28/81		RH : ercCannotOpenSysImage, ercCannotReadOvlay
	11/20/81	RH: ercNoExitRunFile
	12/22/81	RH: Queue manager errors, multi-partition errors
	12/29/81	RH: ercNoAvailUserNum
	1/7/81		RH: ercInternalError
	12/15/82	Jim Frandeen: ercWrongOverlay, ercInvalidTerminationRequest,
		ercOddDmaCount
	5/24/83		JA: ercMissedStatus, ercPartitionNotPrimary,
		ercNotForegroundPartition, ercPartitionSwapped, 
		ercPartitionNotSwapped, ercPartitionCantSwap
	9/22/83		Jim Frandeen: Add ercInvalidWindowSize
	9/27/83		JA: ercTimeoutTooLarge
	2/16/84		DR: ercNotParaAligned
	2/26/85		DC: CommLineErc group, and ercBogusIProc
	3/14/85		DC: ercInterruptStackOverflow
	4/24/85		AM: Added tape ercs for qictape.
	5/14/85		AM:	Added xbufnotinstalled erc for qictape.
	09/03/86	KLH	added: ercNotYesOrNo.
	10/15/86	PBC	Added ercs 353-355 (5.0 MegaFrame for MIvolume)
	01/20/87	DR:	Repaired ercServerNotUnique syntax error
	06/22/87	PBC	ErcNoXbif
	03/21/88    DWS Converted for C use.
	01/11/91    PJ  Added ercDontOverwriteTape
	02/01/91    PJ  Added ercDeviceBufferNotEmpty
*/

#define ercEOF						1
#define ercEOM						2
#define ercInconsistency			3
#define ercOperatorIntervention		4
#define ercSyntax					5
#define ercSrpDown					6
#define ercNotImplemented			7
#define ercInternalError			8

#ifdef KernelErc
#define ercExchOutOfRange		10
#define ercBadPointer			11
#define ercNoMsgWait			12
#define ercBadVector			13
#define ercNoMessage			14
#define ercNoReserveBlk			15
#define ercInConsistentRq		16
#define ercMismatchedRespond	17
#define ercNoPcb				18
#define ercBadQueue				19
#define ercBadRespExch			20

#endif

#ifdef ContigencyErc
#define ercMemProtect			21
#define ercBusTimeOut			22
#define ercParity				23
#define ercPowerFail			24
#define ercUnKnownNonMask		25
#define ercStrayInterrupt		26
#define ercDivideOverflow		27
#define ercBusError				28
#define ercCoprocessorNotPresent 29
#endif

#ifdef RqErc
#define ercRqBadTable					30
#define ercNoSuchRc						31
#define ercWrongRqSync					32
#define ercServiceNotAvail				33
#define ercNoExitRunFile				34
#define ercWrongOverlay					35
#define ercInvalidTerminationRequest	36
#define ercInvalidTerminationReq 36
#define ercSwapping						37
#define ercInvalidWindowSize			38
#define ercInvalidServeRq				39
#define ercReturnDataAreaTooSmall 39
#endif

#ifdef ClErc
#define ercNotEnoughClustBufMem		40
#define ercAgentNoRoom				41
#define ercAgentSrpNoRoom			42
#define ercRcbNotInXmit				43
#define ercAgtUnmatchedRq			44
#define ercClusterGoingDown			46
#endif

#ifdef ClErcOrXblkErc
#define ercXbufTooSmall 45
#endif

#ifdef softBus
#define ercBogusIProc		50
#endif

#ifdef CommLineErc
#define ercInvalidCommLineSpec			60
#define ercCommLineBaudRatesMustMatch	61
#define ercInvalidCommLineHandle		62
#define ercInvalidCommLineStatusMask	63
#define ercInvalidCommLineArgument		64
#define ercCommLineDoesNotSupportNRZI	65
#define ercCommLineConfigBlockSize		66
#define ercInitCommLineRetSize			67
#define ercCommLineDoesNotSupportDma 68
#define ercBadCommLineDmaStatusSize 69
#endif

#define ercGPFault 80
#define ercRmosGPFault 81
#define ercStackFault 82
#define ercNotPresentFault 83
#define ercPageFault 84
#define ercOverflow 85
#define ercBoundsCheck 86
#define ercCoprocessorError 87
#define ercCoprocessorOverrun 88
#define ercDoubleFault 89
#define ercOSStackOverflow				90
#define ercOSChecksumError				91
#define ercInterruptStackOverflow		92
#define ercRealUser 93
#define ercNotSupportedInRMOS 94
#define ercSCHeapFull 95
#define ercSCParamListTooLong 96
#define ercSCEntryAlreadyExists 97
#define ercSCParamListUnknownChar 98
#define ercSCNoArgsPreDefined 99

#ifdef InitErc
#define ercInitMemoryFail			100
#define ercNoMemoryForOsInit		101
#define ercNoDcbForBootDevice		102
#define ercInitialization			103
#define ercNoYblks					104
#define ercHwConfiguration			105
#define ercInitFileFormat			106
#define ercNoMemoryForFsInit 108
#define ercConfigFileTooBig 109
#define ercInitEccFailure 110
#endif

#ifdef InitErc
#define ercWrongHardware		120
#define ercOldOS				121
#define ercReleaseTimeout		122
#define ercCantLoadLevel		123
#define ercRqTablesInconsistent	124
#define ercBadSysgenTable		125
#define ercNoXbif				126
#endif

#ifdef IccErc
#define ercSelfReference			150
#define ercYblkTooSmall				151
#define ercNoSuchProcessor			152
#define ercTargetInit				153
#define ercNoSuchCode				154
#define ercTooManyDevices			155
#define ercTooManyDevices 155
#define ercNoFixupAvail 156
#define ercNoGhAvail 157
#define ercOrphanRq 158
#define ercBadRouting 159
#define ercBadRouteTable 160
#define ercTooManyClusterLines 161
#define ercWait 162
#define ercCorruptIcc 163
#define ercOddCntlInfo 164
#endif

#ifdef SrpMapErc
#define ercBusAddressNotMapped 170
#define ercInvalidBusAddress 171
#define ercNoFreeMapSlot 172
#define ercNoMapperHardware 173
#define ercReservedSrpMapper174 174
#endif
#ifdef SrpDmaErc
#define ercDmaPending 175
#define ercChannelInUse 176
#define ercReservedSrpDMA177 177
#define ercReservedSrpDMA178 178
#define ercReservedSrpDMA179 179
#endif

#ifdef SvrErc
#define ercServerAlreadyInstalled 180
#define ercServiceCantBeDeinstalled 181
#endif

#ifdef FsErc
#define ercNoFreeVolumeStruct			201
#define ercDirectoryFull				202
#define ercNoSuchFile					203
#define ercNoSuchDir					204
#define ercBadFileSpec					205
#define ercBadUserNum					206
#define ercBadRequestCode				207
#define ercDuplicateVolume				208
#define ercFileIsReadOnly				209
#define ercBadFh						210
#define ercBadBufferSize				211
#define ercBadLfa						212
#define ercNoFreeFab					213
#define ercNoFreeFileNum				214
#define ercNoSuchVolume					215
#define ercNoSuchDevice 			ercNoSuchVolume
#define ercVolumeNotMounted				216
#define ercBadPassword					217
#define ercBadMode						218
#define ercAccessDenied					219
#define ercFileInUse					220
#define ercFileHeaderBadChecksum		221
#define ercFileHeaderBadPageNum			222
#define ercFileHeaderBadHeaderNum		223
#define ercFileAlreadyExists			224
#define ercNoFreeFileHeaders			225
#define ercFreeFileHeadersBroken		226
#define ercDeviceInUse					227
#define ercDeviceAlreadyMounted			228
#define ercDeviceNotMounted				229
#define ercDiskFull						230
#define ercNotMountableDevice			231
#define ercNoValidHomeBlock				232
#define ercFileHeaderBadFileName		233
#define ercOddByteBufferAddress			234
#define ercWrongVolumeMounted			235
#define ercBadDevSpec					236
#define ercDirPageInvalid				237
#define ercRequestNotValidForDevice		238
#define ercWrongVolumeDestination		239
#define ercDirAlreadyExists				240
#define ercDirNotEmpty					241
#define ercMfdFull						242
#define ercVerifyError					243
#define ercSystemDeviceNotReady			244
#define ercRunFileBadCksm				245
#define ercBadRunFile					246
#define ercOldFormatRunFile				247
#define ercWrongRq						248
#define ercNotPrimaryTask				249
#define ercFileTooManyRuns				250
#define ercCannotLog					251
#define ercCannotOpenSysImage			252
#define ercCannotReadOverlay			253
#define ercNoAvailUserNum				254
#define ercBadFileProtectionLevel 254
#define ercDontUse255 255
#define ercDontUse256 256
#define ercSwapSpaceFull 257
#define ercNoSwapFile 258
#define ercNoFreeSwapFabs 259
#define ercSwapFileInconsistent 260
#define ercCannotAccessSwapFile 261
#define ercVirtualCodeNotSupported 262
#define ercNotCTOS 263
#define ercInvalidFSConfigRq 264
#define ercNot512Multiple 265
#define ercNotDirectory 270
#define ercFileHeaderBadParentFhbNum 271
#define ercFileHeaderBadParentDirName 272
#define ercDirFileInvalid 273
#define ercBadDirRename 274
#define ercRequestNotValidForDir 275
#define ercNotFile 276
#define ercBadAccessCode 277
#define ercNoFreeFcb 278
#define ercBadLink 279
#define ercNameSpaceOverflow 280
#define ercNoVolPassword 281
#define ercRequestIncomplete 282
#define ercFsInternalErrFirst 283
#define ercFsBadOParent 283
#define ercFsFcbOnFreelistNotModeFree 283
#define ercFsFreeFcbHasFabs 283
#define ercFsBadOFcbInLruList 283
#define ercFsFcbInLruNotModeDormant 283
#define ercFsBadBackPtrInDormantFcbLru 283
#define ercFsBadFreeFcb1 283
#define ercFsBadFreeFcb2 283
#define ercFsBadFreeFcb3 283
#define ercFsBadOFcbInFreeList 283
#define ercFsOFcbExpected 283
#define ercFsFcbOnFreeAndDormantLists 283
#define ercFsBadOFcbInRgOFcb 283
#define ercFsFcbMissingFromList 283
#define ercFsBadOFcb 283
#define ercFsZombieFcbHasFabs 283
#define ercFsModeIncomplete 283
#define ercFsBadAccFlagsModeReadFcb 283
#define ercFsBadAccFlagsModeModifyFcb 283
#define ercFsFcbWithInvalidMode 283
#define ercFsFcbIsOwnAncestor 283
#define ercFsParentHasWrongChild 283
#define ercFsWeirdMfdFcb 283
#define ercFsNoParentFcb 283
#define ercFsNoNmb 283
#define ercFsMisalignedFabVda 283
#define ercFsOddSizedFab 283
#define ercFsZeroSizedFab 283
#define ercFsParentFcbHasNoUsers 283
#define ercFsFcbAlreadyFree 283
#define ercFsNameHeapDislocation 283
#define ercFsSpecBadObjectLevel 283
#define ercFsBadLinkNameAlloc 283
#define ercFsFcbNotDormant 283
#define ercFsBadOChildrenFcbs 284
#define ercFsBadOSiblingFcb 285
#define ercFsFcbBadUserCount 286
#define ercFsInternalErrLast 286
#define ercLogBuffOverflow				290
#define ercBadNodeSpec 291
#define ercBadVolumeSpec 292
#define ercBadDirectorySpec 293
#define ercBadFilenameSpec 294
#define ercBadPasswordSpec 295
#define ercFileSpecTooLong 296
#define ercMoreResvd 297
#define ercFileHeaderInvalid 298
#endif

#define ercDeviceNotReady			300
#define ercIoError					301
#define ercWriteProtected			302
#define ercNoFreeIob				303
#define ercOddDmaCount				304
#define ercUnformattedDrive			305
#define ercRecalFailure				306
#define ercWriteFault				307
#define ercIncompleteDma 308
#define ercNotLocalDma 309

#ifdef FdcErc
#define ercFdcBusyInCmd				320
#define ercFdcNeverReadyInCmd		321
#define ercFdcDataInputInCmd		322
#define ercFdcNeverReadyInResult	323
#define ercFdcNotDataInputInResult	324
#define ercFdcNotBusyAfterXferRq	325
#define ercFdcWrongUnitAfterXferRq	326
#define ercFdcBusyWithoutXferRq		327
#define ercFdcIntFromUndefUnit		328
#define ercFloppyTimeout			329
#define ercFdcDmaResidualWordCount	330
#endif

#ifdef HdcErc
#define ercHdcBusyInCmd				340
#define ercHdcNeverReadyInCmd		341
#define ercHdcDataInputInCmd		342
#define ercHdcNeverReadyInResult	343
#define ercHdcNotDataInputInResult	344
#define ercHdcNotBusyAfterXferRq	345
#define ercHdcWrongUnitAfterXferRq	346
#define ercHdcBusyWithoutXferRq		347
#define ercHdcIntFromUndefUnit		348
#define ercHardDiskTimeout			349
#define ercHdcDmaResidualWordCount	350
#define ercHdcBadController			351
#define ercHdcRemoteDMAFault		352
#define ercHdcCylOutOfRange			353
#define ercHdcEccNotAvailable		354
#define ercHdcNoSpiralFormat		355
#define ercHdcInvalidEccCrcMix 356
#endif

#ifdef ScsiErc
#define ercScsiCheckCondition 377
#define ercScsiPageNonexistent 378
#define ercScsiCommandAborted 379
#define ercBadHostAdapter 380
#define ercNoFreePathBlock 381
#define ercNoFreeLUCB 382
#define ercScsiBusBusy 383
#define ercScsiSelectTimeout 384
#define ercInvalidScsiPh 385
#define ercScsiBusReset 386
#define ercNoCdbAvailable 387
#define ercExcessDataPhase 388
#define ercScsiTimeout 389
#define ercUnexpectedDisconnect 390
#define ercInvalidHostAdapter 391
#define ercInvalidTargetId 392
#define ercInvalidLUN 393
#define ercScsiRequestsOutstanding 394
#define ercSenseDataUnavailable 395
#define ercScsiProtocolError 396
#define ercScsiMessageReject 397
#define ercScsiParityError 398
#define ercScsiTargetBusy 399
#endif

#ifdef RxErc
#define ercMemoryNotAvail		400
#define ercDbgLockedIn			401
#define ercBadDeallocate		402
#define ercNotParaAligned		403
#define ercNoFreeSelectorName	404
#define ercBadSelectorName		405
#define ercSegmentInUse			406
#define ercInvalidPointer 407
#define ercNotAddressable 408
#define ercNoMoreExchs			410
#define ercBadExchNumber		411
#define ercNot4KAligned 412
#define ercLpmSizeError 413
#define ercLpmNotDefined 414
#define ercSnNotLDT 415
#define ercInvalidBusAddress 416
#define ercBadSwapperData 417
#define ercLDTSlotUnavailable 418
#define ercNoFreeMapSlot 419
#endif

#ifdef RtcErc
#define ercRqTableFull		420
#define ercRqNonexist		421
#endif

#ifdef RxErc
#define ercCannotLoadExec		430
#define ercLpIsrAlreadyExist	431
#define ercKbdIsrAlreadyExist	432
#define ercNotAnOsCall 433
#endif

#ifdef svErc
#define ercSoftVecTableFull		440
#define ercBadTyDev 441
#endif

#ifdef VpErc
#define ercMapOverFlow				450
#define ercLargeMapBogus			451
#define ercWakeup					452
#define ercNoAvailableArib			453
#define ercInCreatingStat			454
#define ercRefZero					455
#define ercNoAvailableTib			456
#define ercAsibStatInconsistency	457
#define ercTibNotBindToAsib			458
#define ercAribInconsistency		459
#define ercKDSStatInconsistency		460
#define ercSaBogus					460
#define ercMapInconsistency			461
#define ercCodeNotSharable 462
#define ercSegmentNotInMemory		470
#define ercSegmentNotWritten 471
#define ercSwapSegInconsistent 472
#endif

#ifdef VidErc
#define ercBadFrameAddress			500 /*{frame,col,line} not in scrDesc*/
#define ercInvalidVidRq				501 /*from OS-resident*/
#define ercVidBufNotAlign			502 /*word-alignment is rqd*/
#define ercVidNotInit				503 /*vcb.pMap is invalid*/
#define ercVideoDmaFailure			504 /*font or refresh problem*/
#define ercInvalidLoadFont			507 /*cannot load font*/
#define ercTimeoutTooLarge			506 /*Blent time 109 minutes max*/
#define ercTooManyAttrs				505
#define ercTooManyAttributes 505
#define ercTimeoutTooLarge 506
#define ercInvalidLoadFont 507
#define ercBadVamParameters 508
#define ercVidNotInstalled 509
#endif

#ifdef KbdErc
#define ercReadOrPeekAlreadyReceived	601
#define ercNoCharactersInKeyboard		602
#define ercUnsyncEscapeSequence			603
#define ercInvalidRqKbd					604
#define ercBadReplayMode				605
#define erciKeyInvalid					606
#define ercResetIsDown					607
#define ercActionIsDown					ercResetIsDown
#define ercBeingReset					608
#define ercNoActionChar					609
#define ercKbdBufferOverflow			610
#define ercMissedStatus					611
#define ercInputFlushed 611
#define ercSoftKbdReset 612
#define ercOpenedAlready 612
#define ercIBusTableFull 613
#define ercIBusNoSuchHandler 614
#define ercIBusNoSuchId 615
#endif

#ifdef splErc
 #define ercCantDeconfigure			700
 #define ercNotWaitingForPswd		701
 #define ercInvalidPrinterName		702
 #define ercInvalidChannelNumber	703
 #define ercChannelInUse			704
 #define ercInvalidCnfgFile			705
 #define ercPrinterNameNotUnique	706
 #define ercInvalidCnfgSpec			707
 #define ercInvalidQueName			708
 #define ercPrintCanceled			709
 #define ercPrintRestarted			710
 #define ercPrinterFreed			711
 #define ercTooManyPrinters			720
 #define ercSplAlreadyInstalled		721
 #define ercNoSpoolerHdw			722
 #define ercNoQmgr					723
#endif

#ifdef mpErc
#define ercPartitionNotVacant		800
#define ercNoFreeParDesc			801
#define ercDuplicatePartitionName	802
#define ercBadPartitionHandle		803
#define ercBadPartitionName			804
#define ercPartitionVacant			805
#define ercPartitionLocked			806
#define ercPartitionNotLocked		807
#define ercPartitionExchNotSet		808
#define ercPartitionExchAlreadySet	809
#define ercPartitionNotPrimary		810
#define ercNotForegroundPartition 810
#define ercAssignTableFull 810
#define ercPartitionSwapped			811
#define ercPartitionNotSwapped		812
#define ercPartitionCantSwap		813
#define ercPartitionPrimary			814
#define ercPartitionCantSwapIn 815
#define ercNoUSegAvailable 816
#define ercBadPartitionSwapMode 817
#define ercCantQuiet 818
#endif

#ifdef qmgErc
#define ercEntryNotMarked		900
#define ercEntryMarked			901
#define ercEntryNotFound		902
#define ercNoEntryAvail			903
#define ercEntryDeleted			904
#define ercBadQueueSpec			905
#define ercTooManyServers		906
#define ercServerNotEstablished	907
#define ercNoEstablishedServers	908
#define ercBadQeh				909
#define ercBadServerNum			910
#define ercBadQueIndexFile		911
#define ercWrongQueueType		912
#define ercBadTime				913
#define ercNotUniqueServer		914
#endif

#ifdef BatchErc
#define ercNoKeywordMatch 1200
#define ercNonNumeric 1201
#define ercLineTooLong 1202
#define ercDuplicateLabels 1203
#define ercSymTableFull 1204
#define ercNoSuchLabel 1205
#define ercNoSuchVariable 1206
#define ercBadCmd 1207
#define ercUnexpectedEof 1208
#define ercUnexpectedEndIf 1209
#define ercUnexpectedEndWhile 1210
#define ercUnexpectedElse 1211
#define ercTooNested 1212
#define ercNotInCtrlStructure 1213
#define ercVarNameTooLong 1214
#define ercMustBeAlpha 1215
#define ercTypeConflict 1216
#define ercCurrentLineError 1217
#define ercProcessorNotFound 1218
#define ercProcessorNotListening 1218
#define ercBadStringLength 1219
#define ercBadExpression 1220
#define ercReadOnly 1221
#define ercIllegalStringOp 1222
#endif
#ifdef CacheErc
#define ercCacheMiss 1401
#define ercCacheEntryLocked 1402
#define ercNoFreeCacheEntry 1403
#define ercCacheHitDeferred 1404
#define ercRemoteCacheRqInProgress 1405
#define ercBadRemoteCacheHandle 1406
#define ercInvalidRemoteCacheParameter 1407
#define ercNoFreeRemoteCacheDescriptor 1408
#define ercNoSuchRemoteCachePool 1409
#define ercBadCacheHandle 1410
#define ercNoSuchCacheEntry 1411
#define ercBadCacheDescriptor 1412
#define ercNoCachePool 1413
#define ercCacheMemoryExhausted 1414
#define ercCachePoolBusy 1415
#define ercCacheDisabled 1416
#define ercBadCacheControlWord 1417
#define ercRemoteCachePoolBusy 1418
#define ercBadRemoteCacheControlWord 1419
#define ercDupRemoteCacheDescriptor 1420
#define ercBadRemoteCacheDescriptor 1421
#define ercBadRemoteCacheBufferSize 1422
#define ercBadCacheBufferSize 1423
#define ercCachePageUnlockable 1424
#endif

#ifdef IntraSegHeapErc
#define ercBogusHeap 1601
#define ercHeapTooSmall 1602
#define ercHeapFull 1603
#define ercBogusNode 1604
#endif

#ifdef BsErc
#define ercTooManyPutBacks 2305
#define ercNoSuchBSMode 2315
#define ercWrongBSType 2325
#define ercNotEnoughBuffer 2335
#define ercBadVidEsc 2336
#define ercParityError 2340
#define ercOverrunError 2341
#define ercFramingError 2342
#define ercWrongConfigType 2343
#define ercBadConfigFile 2344
#define ercBadTxltnFile 2345
#endif

#ifdef ParamErc
$RESET(ParamErc)
#define ercNoSuchIParam 2440
#define ercInvalidParam 2441
#define ercTooManySubParams 2442
#define ercNoSuchJParam 2450
#define ercMissingParam 2451
#define ercParamBlkFull 2470
#define ercIllegalIParam 2480
#define ercNotInList 2490
#endif

#define ercWildCardTooComplicated	2600
#define ercWCBufferTooSmall			2601
#define ercUnexpectedMacro			2602
#define ercNoNumberFound			2603
#define ercInvalidMacroExpCount		2604

#define ercStringTooLong 2605
#define ercNoUniqueMatch 2606
#define ercNoMatchingFile 2607
#define ercUninitializedBuffer 2608
#define ercInvalidDisplayType 2609
#define ercBadCommandFile 2610
#define ercNoCmdMatch 2611
#define ercNotUniqueCmd 2612
#define ercInvalidCmdCh 2613
#define ercResourceNotFound 2614
#define ercInvalidFieldDescType 2615
#define ercInvalidFieldDescSize 2616
#define ercTooMuchChoiceText 2617
#define ercInvalidChoiceText 2618
#define ercWorkAreaTooSmall 2619
#define ercInvalidMenuDescType 2620
#define ercDefaultExceedsChoices 2621
#define ercTooManyHighlights 2622
/* erc 2623 reserved */
#define ercMessageBufferTooSmall	2624

#define ercYearOutOfRange 2700
#define ercInvalidTimeOfDay 2703

#ifdef RsamErc
#define ercRswaInUse 3600
#define ercRswaInvalid 3601
#define ercRsamInternalError 3602
#define ercRsBadMode 3603
#define ercNotReadableByRsam 3604
#define ercRsWrongMode 3605
#define ercRsRecordTooLarge 3606
#define ercRsGoodRecordNotFound 3607
#define ercBadRsLfa 3608
#endif

#ifdef ClErc
#define ercBufferOverrun		8001
#define ercLostClear2Send		8002
#define ercLostCarrier			8003
#define ercInvalidRqAsyCom		8004
#define ercCharacterOverrun		8005
#define ercParityError			8006
#define ercFramingError			8007
#define ercInvalidParameterAsyCom		8008
#define ercDataSetNotReady		8009
#define ercIllogicalDeviceStatus		8010
#define ercNoData				8011
#define ercInternalConsistencyCheck		8012
#define ercBreak				8013
#define ercTimeOut				8100
#define ercInvalidState			8101
#define ercCommHardwareDead		8102
#define ercCrazyWS				8103
#define ercBadDmaAddr			8104
#define ercBusyBitIo			8105
#define ercInvalidCmdBitIo		8106
#define ercBadInterrupt			8107
#define ercXmitDmaUnderrun		8108
#define ercCrazySRP				8109
#define ercOverrun				8111
#define ercSrpDisconnect		8112
#define ercHighLevelError		8113
#define ercRequestBlockError	ercHighLevelError
#define ercTimerFailure			8114
#define ercBootFailure			8115
#define ercNoIds				8116
#define ercIdSearchFailure		8117
#define ercNoSuchWsNum			8118
#define ercDmaAddr 8126
#define ercAbort				8200
#define ercBusyBSCIo			8201
#define ercInvalidCmdBSCIo		8202
#define ercBadCharacterSequence	8203
#define ercCrazy370				8204
#define erc370Down				8205
#define ercBadFormat			8206
#define ercInvalidCommand3270	8207
#define ercUnexpectedResponse	8208
#define ercClstrBufferTooSmall 8209
#define ercBufferTooSmall		8209
#define ercRqFromUnknownWs		8210
#define ercTooManyWs			8211
#define ercReject				8212
#define ercProtocolFailure		8213
#define ercExcessiveRetries		8214
#define ercAssignedDifferent	8215
#define ercCancel				8216
#define ercCrc					8217
#define ercInterrupt			8300
#define ercNoFilesForReceive	8301
#define ercInvalidLine			8400
#define ercLineInUse			8401
#endif

/* error codes returned by Sequential Access service */
#ifdef TapeErc
#define ercTapeTimeout			9002
#define ercTapeBlank			9007
#define ercTapeEomWarning		9009
#define ercTapeIoError			9010
#define ercNoTapeBuffer			9012
#define ercTapeNotReady			9016
#define ercTapeWriteProtected		9017
#define ercDontOverwriteTape		9018
#define ercTapeFileMark			9021
#define ercInvalidTapeParams		9022
#define ercTapeHardwareError		9024
#define ercInvalidTapeHandle		9032
#define ercInvalidTapeRequest		9033
#define ercInvalidTapeSpecification	9035
#define ercTapeInUse			9036
#define ercTapeReadOnly			9037
#define ercInvalidTapeMode		9040
#define ercTapeOperationOutstanding	9041
#define ercTapeRecordTruncated		9043
#define ercCorruptTape			9051
#define ercInvalidTapePosition		9052
#define ercInvalidTapeReel		9053
#define ercInvalidTapeSequence		9054
#define ercInvalidTapeConfigFile	9055
#define ercInvalidTapeRecordSize	9057
#define ercNoTapeHardware		9058
#define ercXbifNotInstalled		9059
#define ercDeviceBufferNotEmpty		9061
#define ercOddAlignment			9071
#define ercTapeRemoved			9073
#define ercTapeCommandIllegal		9074
#define ercTapeOverflow			9077
#define ercQicException			9082
#define ercResidualData			9084
#define ercTapeStatusUnavailable	9089
#define ercTapeReset			9091
#define ercTapeBusy			9096
#define ercTapeCommandAborted		9097
#endif

#ifdef TpktErc
#define ercTpktBadMode						9992
#define ercTpktAlreadyOpen					9993
#define ercTpktNotEnoughBuffer				9994
#define ercTpktWrongMode					9995
#define ercTpktRecordBiggerThanBuffer		9996
#endif

#ifdef ApplErc
#define ercApplicationError 9999
#endif

#ifdef MbErc
/* multibus ercs */
#define ercMbIsrDuplicateEntry				11000
#define ercMbIsrNoEntry						11001
#define ercMbIsrBadSlot						11002
#define ercMbIsrTableFull					11003
#define ercMbIsrNoBoardPresent				11004
#define ercMbIsrWrongBoardPresent			11005
#define ercMbIsrBadBoard					11006
#define ercMbIsrAdapterInUse				11007
#define ercMbIsrBadDeleteUser				11008
#endif

/*		111xx ICC and TP ercs */
#define ercWaitYBLK							11800
#define ercDSRTimeOut						11801
#define ercTargetProcessorDead				11802
#define ercRouteAreaTooSmall				11803
#define ercBadParityConfig					11804
#define ercUserNumtabletoosmall				11805
#define ercMemInconsistency 11806


/* note:		11200-11299 are reserved for tm001 (telephone manager) */

#ifdef Utilerc
/* MegaFrame Utility ercs */
#define ercBadDefaultPath					11900
#define ercAdminAgentBusy					11901
#define ercBadAgentRequest					11902
#endif


#ifdef NLSErc
#define ercNoSuchTable						13500
#define ercBadSignature						13501
#define ercNotAMsgFile						13502
#define ercMsgNotFound						13503
#define ercMsgFileNotOpen					13504
#define ercCorruptMsgFile					13505
#define ercBadKeycapRange					13506
#define ercBadDateTable						13507
#define ercNotYesOrNo						13508
#define ercMsgFileNotFound 13509
#define ercInvalidMsgWorkArea 13510
#define ercNumberNotAfterColon 13511
#define ercBadCharacterInNumber 13512
#define ercMessageTooLong 13513
#define ercNoMessages 13514
#endif
#ifdef EnlsErc
#define ercInvalidOffset 40000
#define ercInvalidLineType 40001
#define ercBufferFull 40002
#define ercBadCharacter 40003
#define ercExitCharacter 40004
#define ercEndOfString 40005
#define ercBadFieldType 40006
#endif

#ifdef ToolKitErc
#define ercSectorsNotFree 58600
#define ercCannotUndelete 58601
#define ercInvalidFilename 58602
#define ercNoBufferSpace 58603
#endif

/* End of Erc.h */
