/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	excpt.h,v $
 * Revision 4.2.2.3  92/03/12  18:05:53  Keith_Mortensen
 * 	"195-mortens"
 * 
 * Revision 4.2.3.2  92/03/09  15:29:45  Keith_Mortensen
 * 	MIPS 3.0 FCS Integration.
 * 
 * Revision 4.2.2.2  91/12/05  15:00:55  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  18:56:55  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 4.2  91/09/20  05:07:44  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *       @(#)$RCSfile: excpt.h,v $ $Revision: 4.2.2.3 $ (DEC) $Date: 92/03/12 18:05:53 $
 */
/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1990 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Avenue                               |
 * |         Sunnyvale, California 94088-3650, USA             |
 * |-----------------------------------------------------------|
 */
#ifndef __EXCPT_H
#define __EXCPT_H

#ifdef _INCLUDE_ID
static char *excpt_h_id="$Header: /usr/sde/osf1/rcs/src/./usr/include/PMAX/excpt.h,v 4.2.2.3 92/03/12 18:05:53 Keith_Mortensen Exp $";
#endif

/* 
** C Structured Exception Handling.
*/



/* definitions of keywords and intrinsic function names */
#define try                    __builtin_try
#define except                 __builtin_except
#define finally                __builtin_finally
#define leave                  __builtin_leave
#define exception_code()       __exception_code
#define exception_info()       __exception_info
#define abnormal_termination() __abnormal_termination
 
typedef struct system_exrec *exrec_ptr;


#ifdef __unix__
/* UNIX Exception Record */
typedef struct system_exrec {
  long ExceptionCode;
  unsigned long ExceptionFlags;
  exrec_ptr ExceptionRecord;
  void *ExceptionAddress;
  unsigned long NumberParameters;
  unsigned long ExceptionInformation[1]; 
} system_exrec_type;
#endif



/*
** Langauge specific handlers
*/



#ifdef __unix__
typedef struct {
    int	sc_regmask;		/* regs to restore in sigcleanup */
    int	sc_mask;		/* signal mask to restore */
    int	sc_pc;			/* pc at time of signal */
    /*
     * General purpose registers
     */
    int	sc_regs[32];	/* processor regs 0 to 31 */
    /*
     * Floating point coprocessor state
     */
    int	sc_ownedfp;	/* fp has been used */
    int	sc_fpregs[32];	/* fp regs 0 to 31 */
    int	sc_fpc_csr;	/* floating point control and status reg */
    int	sc_fpc_eir;	/* floating point exception instruction reg */
    int	sc_mdhi;	/* Multiplier hi and low regs */
    int	sc_mdlo;
    /*
     * System coprocessor registers at time of signal
     */
    int	sc_cause;	/* cp0 cause register */
    int	sc_badvaddr;	/* cp0 bad virtual address */
    int	sc_badpaddr;	/* cpu bd bad physical address */
    int	is_sigset;
} CONTEXT, *PCONTEXT;

#endif

/*
 * Exception disposition return values.
*/

typedef enum _EXCEPTION_DISPOSITION {
    ExceptionContinueExecution,
    ExceptionContinueSearch,
    ExceptionNestedException,
    ExceptionCollidedUnwind
    } EXCEPTION_DISPOSITION;

/*
 * Exception flag definitions.
*/

#define EXCEPTION_NONCONTINUABLE 0x1    /* Noncontinuable exception */
#define EXCEPTION_UNWINDING      0x2    /* Unwind is in progress */
#define EXCEPTION_EXIT_UNWIND    0x4    /* Exit unwind is in progress */
#define TARGET_UNWIND            0x8    /* Execute termination handler for it*/
#define EXCEPTION_STACK_INVALID  0x10   /* Stack out of limits or unaligned */
#define EXCEPTION_NESTED_CALL    0x20   /* Nested exception handler call */

#define EXCEPTION_UNWIND       (EXCEPTION_UNWINDING | EXCEPTION_EXIT_UNWIND |\
				TARGET_UNWIND)
#define IS_UNWINDING(flag)     ((flag & EXCEPTION_UNWIND) != 0)
#define IS_DISPATCHING(flag)   ((flag & EXCEPTION_UNWIND) == 0)
#define IS_TARGET_UNWIND(flag) (flag & TARGET_UNWIND)

/*
 * Function table definition
*/

typedef struct {
    unsigned long  begin_address;
    unsigned long  end_address;
    unsigned long  lang_handler;
    unsigned long  handler_data;
    unsigned long  prolog_end_address;
} RUNTIME_FUNCTION, *pRUNTIME_FUNCTION;

/*
 * Scope table definition
*/

typedef struct {
    unsigned long count;   /* number of scope records follows */
    struct 
    {
	unsigned long  begin_address;
	unsigned long  end_address;
	unsigned long  handle_address;
	unsigned long  jmp_target;
    } scope_record[1];
} SCOPE_TABLE;


/*
 * Exception dispatcher routine definition.
*/

int
DispatchException (system_exrec_type *exceptionRecord,
		   CONTEXT *          contextRecord
		   );

/*
 * The dispatcher context structure.
*/
typedef struct {
    unsigned long     pc;
    pRUNTIME_FUNCTION functionTable;
} DISPATCHER_CONTEXT;

/*
 * Exception handler routine definition.
*/

typedef
EXCEPTION_DISPOSITION
(*exception_handler_type) (system_exrec_type *   exceptionRecord,
			   void *                EstablisherFrame,
			   CONTEXT *             contextRecord,
			   DISPATCHER_CONTEXT *  dispatcherContext
			   );

/*
 * Utility functions
 */
extern
pRUNTIME_FUNCTION
find_rtfunc(unsigned long pc);

extern
unsigned long
find_framePtr( pRUNTIME_FUNCTION pfunc, PCONTEXT context );

extern
void
virtual_unwind( pRUNTIME_FUNCTION pfunc, PCONTEXT context );

/* some temporary definitions, just to get things going */
#define STATUS_UNWIND          99999
#ifndef __boolean
#define __boolean
#define boolean int
#endif

/* function interfaces for MIPS implementation */
#define longjmp __excpt_longjmp

extern
EXCEPTION_DISPOSITION
__C_specific_handler(system_exrec_type *   exceptionRecord,
		     void *                EstablisherFrame,
		     PCONTEXT              contextRecord,
		     DISPATCHER_CONTEXT *  dispatcherContext);
/* Typedef for pointer returned by exception_info() */ 

typedef struct _EXCEPTION_POINTERS
{
    system_exrec_type* ExceptionRecord;
    PCONTEXT           ContextRecord;
} EXCEPTION_POINTERS, *PEXCEPTION_POINTERS, *Exception_info_ptr;

typedef
int
(* EXCEPTION_FILTER) ( EXCEPTION_POINTERS * ExceptionPtr );

typedef
void
(* TERMINATION_HANDLER) (boolean is_abnormal );

/* two linker defined variable */
extern RUNTIME_FUNCTION _fpdata[];
extern char _fpdata_size[];
#define function_table   _fpdata
#define function_table_size ((int) _fpdata_size)
extern void __jump_unwind(void *fp, void* target_pc);

#endif

/* $Log:	excpt.h,v $
 * Revision 4.2.2.3  92/03/12  18:05:53  Keith_Mortensen
 * 	"195-mortens"
 * 
 * Revision 4.2.3.2  92/03/09  15:29:45  Keith_Mortensen
 * 	MIPS 3.0 FCS Integration.
 * 
 * Revision 4.2.2.2  91/12/05  15:00:55  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  18:56:55  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 3000.5.1.2  91/12/13  07:55:51  sah
 * added leave
 * 
 * Revision 3000.5.1.1  91/05/31  18:24:52  bettina
 * fix DFARS in copyright
 * 
 * Revision 3000.5  91/04/08  17:39:50  bettina
 * fix copyright
 * 
 * Revision 3000.4  91/04/08  13:52:41  bettina
 * update copyright
 * 
 * Revision 3000.3  91/02/22  12:00:19  zaineb
 * ansify
 * 
 * Revision 3000.2  90/12/10  13:52:16  zaineb
 * Ansi Changes
 * 
 * Revision 2020.5.1.1  90/11/02  08:09:17  shin
 * merged with 2.21
 * 
 * Revision 2021.26  90/11/02  08:07:27  shin
 * renamed some type names, to be consistent with Hermes' definition
 * 
 * Revision 2021.25  90/08/30  10:22:08  shin
 * removed targetPc from dispatcher context structure
 * 
 * Revision 2021.24  90/08/28  10:51:28  shin
 * added targetPc in the DISPATCHER_oCONTEXT data structure
 * 
 * Revision 2021.23  90/08/26  16:41:40  sah
 * moved names to implementation.h
 * 
 * Revision 2021.22  90/08/26  14:48:03  shin
 * checked for shin
 * 
 * Revision 2021.21  90/08/23  14:41:06  sah
 * interface change
 * 
 * Revision 2021.20  90/08/22  09:20:29  sah
 * conformed to Herme naming convention
 * 
 * Revision 2021.19  90/08/15  16:11:45  sah
 * shorten names
 * 
 * Revision 2021.18  90/08/15  16:07:32  sah
 * added jump_unwind
 * 
 * Revision 2021.17  90/08/15  08:54:57  shin
 * updated DISPATCHER_CONTEXT data structure
 * 
 * Revision 2021.16  90/08/10  09:56:47  sah
 * added non-local goto call
 * 
 * Revision 2021.15  90/08/06  14:25:53  sah
 * added abnormal_termination
 * 
 * Revision 2021.14  90/08/02  15:54:36  sah
 * using exception names
 * 
 * Revision 2021.13  90/08/02  08:55:53  sah
 * nameget names rightuse exception names for better diagnositics
 * 
 * Revision 2021.12  90/08/01  20:02:14  sah
 * decl_sem.c sync
 * 
 * Revision 2021.11  90/08/01  17:05:53  shin
 * defined internal function definitions
 * 
 * Revision 2021.10  90/08/01  09:47:30  shin
 * more stuff
 * 
 * Revision 2021.9  90/07/31  10:07:27  sah
 * need jmp_target toso to commnumicateunicate target of exception handling target
 * to from filter to except handler.
 * 
 * Revision 2021.8  90/07/30  14:46:52  sah
 * initial exception_info() and exception_code() logic
 * ]
 * 
 * Revision 2021.7  90/07/30  11:43:45  shin
 * modified _fpdata_size declaration
 * 
 * Revision 2021.6  90/07/23  15:26:10  shin
 * changed runtime_function name
 * 
 * Revision 2021.5  90/07/16  11:33:03  sah
 * following herme name convention
 * 
 * Revision 2021.4  90/07/16  11:29:38  shin
 * check in for new types
 * 
 * Revision 2021.3  90/07/10  09:55:13  sah
 * added functions
 * 
 * Revision 2021.2  90/06/19  14:10:30  sah
 * cosmetic
 * 
 * Revision 2021.1  90/06/07  23:09:44  bettina
 * 2.21 - branching off 2.20 for ansi C
 * 
 * Revision 2020.5  90/04/20  11:28:46  sah
 * added prefixes
 * 
 * Revision 2020.4  90/04/20  08:18:22  sah
 * parameterize prefix name for scope table
 * 
 * Revision 2020.3  90/04/19  10:44:35  sah
 * __builtin convention
 * 
 * Revision 2020.2  90/04/19  10:34:21  sah
 * functions don't have arguments.
 * 
 * Revision 2020.1  90/04/18  16:10:55  sah
 * *** empty log message ***
 * 
*/
