#
# @DEC_COPYRIGHT@
#
#
# HISTORY
# $Log:	template.mk,v $
# Revision 4.5.2.11  92/05/05  07:19:04  Robin_Lewis
# 	Added a definition for SORT that was used and set by the ODE environmrnt
# 	but is undefined if used on an installed system.  Also added an awk script
# 	to allow builds of one object only.
# 	[92/05/05  07:17:08  Robin_Lewis]
# 
# Revision 4.5.2.10  92/04/21  12:39:58  Robin_Lewis
# 	Alpha/mips merged template
# 	[92/04/21  12:17:09  Robin_Lewis]
# 
# 	Made some changes to key off of MACHINE to set variable values.
# 	[92/04/20  14:25:45  Robin_Lewis]
# 
# Revision 4.5.2.9  92/03/24  17:53:25  halproject_Donald_Dutile
# 	Merged changes from HALPROJECT to AG
# 	[92/03/24  16:57:39  halproject_Donald_Dutile]
# 
# 	Added additional tool macros to allow for synchronization of toolsets
# 	with kernel libraries.
# 	[92/03/23  19:33:46  Dave_Gerson]
# 
# Revision 4.5.2.8  92/03/09  12:45:52  Philip_Cameron
# 	Merged with ag.latest
# 	[92/03/05  16:03:46  Philip_Cameron]
# 
# Revision 4.5.2.7  92/02/29  08:46:04  Sec_Proj_Michael_Fairbrother
# 	Can't use spaces when a tab is needed.
# 	[92/02/29  08:25:43  Sec_Proj_Michael_Fairbrother]
# 
# Revision 4.5.2.6  92/02/28  21:24:05  Sec_Proj_Michael_Fairbrother
# 	yet another bmerge
# 	[92/02/28  10:45:35  Michael_Fairbrother]
# 
# 	keep security pool upto date.
# 	[92/02/17  11:06:34  Michael_Fairbrother]
# 
# 	Added habitats.c back in.
# 	[92/02/10  09:08:04  Michael_Fairbrother]
# 
# 	Merge Phil Cameron's work with Security changes
# 	[92/02/05  09:01:17  Michael_Fairbrother]
# 
# Revision 4.5.2.5  92/02/28  14:43:12  Dave_Gerson
# 	Added targets: asflags and ccnflags for export of BINARY{,.rt}
# 	compiler/assembler flags in kernel Makefile.
# 	[92/02/28  14:42:21  Dave_Gerson]
# 
# Revision 4.5.2.4  92/02/27  15:53:32  cam_proj_Janet_Schank
# 	"bsubmitted from shared SB"
# 
# Revision 4.5.2.3  92/02/12  08:33:03  Brian_Stevens
# 	Changed the kernel TEXTBASE to be set from the config file rather
# 	than by the config program.  The default is 0x80050000, but can be
# 	overridden using the config file LOADADDR makeoptions flag.
# 	[92/02/05  14:16:15  Brian_Stevens]
# 
# Revision 4.5.2.2  91/12/20  14:28:56  William_Burns
# 	Merge from ODE/TIN: revision 3.9.9.3
# 	date: 91/12/20 11:59:02;  author: devrcs;  state: Exp;  lines added/del: 3/2
# 	sccs rev: 3.11;  orig date: 91/11/10 14:23:53;  orig author: fred
# 	Fred Canter - genassym, always usr /lib/libc.a not export/pmax libc.a.
# 	[91/12/20  14:24:43  William_Burns]
# 
# Revision 4.5.2.2  91/12/20  14:28:56  William_Burns
# 	Merge from ODE/TIN: revision 3.9.9.3
# 	date: 91/12/20 11:59:02;  author: devrcs;  state: Exp;  lines added/del: 3/2
# 	sccs rev: 3.11;  orig date: 91/11/10 14:23:53;  orig author: fred
# 	Fred Canter - genassym, always usr /lib/libc.a not export/pmax libc.a.
# 	[91/12/20  14:24:43  William_Burns]
# 
# Revision 4.5.7.3  92/02/27  10:35:42  cam_proj_Janet_Schank
# 	Added changes from Brian Stevens to divide the CFILES into four chunks.
# 
# Revision 4.5  91/11/27  15:50:12  devbld_zk3
# 	Incbaselevel update
# 
# Revision 4.2.2.4  91/11/20  13:51:08  Hal_Project
# 	Modified cpu var from dec/machine/mips to arch/25700{MACHINE} due to pool reorg.
# 	[91/11/17  13:13:10  Donald_Dutile]
# 
# 	Changed $cpu define from dec/machine/mips to arch/$machine for hw indep.
# 	[91/11/07  22:48:36  Donald_Dutile]
# 
# Revision 4.2.2.3  91/10/23  15:01:50  William_Burns
# 	Merge from ODE/TIN: revision 3.9.9.2
# 	date: 91/10/17 21:12:39;  author: devrcs;  state: Exp;  lines added/del: 5/4
# 	sccs rev: 3.10;  orig date: 91/10/02 08:32:06;  orig author: fred
# 	Fred Canter - headers and kernel warnings.
# 	[91/10/23  09:52:41  William_Burns]
# 
# Revision 4.2.2.2  91/09/24  10:44:23  devbld_zk3
# 	Brian Stevens changes for building in sandbox environment
# 	[91/09/24  10:25:49  devbld_zk3]
# 
# Revision 4.2  91/09/19  22:07:00  devbld
# 	Adding ODE Headers
# 
# $EndLog$
#
#
#	@(#)$RCSfile: template.mk,v $ $Revision: 4.5.2.11 $ (DEC) $Date: 92/05/05 07:19:04 $
#
# (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#
#
# Mach Operating System
# Copyright (c) 1989 Carnegie-Mellon University
# Copyright (c) 1988 Carnegie-Mellon University
# Copyright (c) 1987 Carnegie-Mellon University
# Copyright (c) 1986 Carnegie-Mellon University
# All rights reserved.  The CMU software License Agreement specifies
# the terms and conditions for use and redistribution.
#  
#
# OSF/1 Release 1.0

#
# Copyright (c) 1980, 1986 Regents of the University of California.
# All rights reserved.  The Berkeley software License Agreement
# specifies the terms and conditions for redistribution.
#

#
#  This must be here before any rules are possibly defined by the
#  machine dependent makefile fragment so that a plain "make" command
#  always works.  The config program will emit an appropriate rule to
#  cause "all" to depend on every kernel configuration it generates.
#

VPATH=..:../include:${MAKETOP}/kernel

build_all: all

_build_prefix_%: %

%MACHINE

cpu=arch/${MACHINE}

#
#  In order to move the link commands out of config and back into the
#  template makefile, config has been changed to emit a dendency rule
#  of the form *vmunix.sys: *vmunix.swap for each configuration so that
#  the common commands for building each configuration can be placed
#  directly in the template in the default rule for the .sys.swap
#  dependency.
#
.SUFFIXES: .swap .sys

#
#  Make sure we don't remove this by accident if interrupted at the wrong
#  time.
#
.PRECIOUS: Makefile

# tools needed.
AWK=	awk
ED=	ed
ECHO=	echo
EGREP=	egrep
EX=	ex
GREP=	grep
KSH=	ksh
LINT=	lint
MAKE=	make
SED=	sed
SHELL=	sh
SORT=	sort

#
#  Compilation components
#
# Contrain the search path of CC, CPP and C2 instead of absolute paths.
CC=	${COFF_GCC_EXEC_PREFIX}cc
CPP=	${CC} -ES
#C2=	c2
LN=	/bin/ln
LD=	${COFF_GCC_EXEC_PREFIX}ld
MD=	md
ENCODE=	uuencode
DECODE=	uudecode

# Note: need to remove NO_GCC.
VOLATILE=${NO_GCC?"-Dvolatile=":}
FORCE_VOLATILE=


# Note: I don't understand how/why this works (gcc does not exist).
KCC=	gcc
KCPP=	${KCC} -E

#   Dynamic linking components for creating surrogate ROSE kernel package and
#   for linking dynamic kernel modules
#
#DCC=		${MACHO_GCC_EXEC_PREFIX}gcc
#DAS=		${MACHO_GCC_EXEC_PREFIX}as
#DLD=		${MACHO_GCC_EXEC_PREFIX}ld
DLD=		${LD}
#DLD_FLAGS=	-R
DLD_FLAGS=	-r -d -G 0
#VMUNIX_LIB=	libvmunix.so
VMUNIX_LIB=
#VMUNIX_PICNAMES= vmunix.picnames

NM=		${COFF_GCC_EXEC_PREFIX}nm

#
#  This changed in the 4.3 CPP from .n to .d
#
MD_SUFFIX=d

#
#  Pre-processor environment
#
DEPENDS= -MD 
# Note: why did Brian remove genpath?
INCLUDES= -I -I. -I.. -I../include
#INCLUDES= -I -I. -I../include -I../../../../src/kernel
ALLDEFINES= -DKERNEL -D_KERNEL -D_BSD
ALLOPTS= ${INCLUDES} ${IDENT} ${ALLDEFINES}
LINTOPTS=${ALLOPTS} ${VOLATILE}

#
#  Common C-compilation flags
#
#  To build a DEBUGable kernel define CDEBUGOPTS=-g in config file
# 
COPTS_P=${CDEBUGOPTS} ${DEPENDS} ${ALLOPTS} ${GCC_OPTS}

_alpha_COPTS=  ${COPTS_P} ${${@}_MIG?-Imach:}  -Wb,-static -Wc,-nofloat
_alpha_CFLAGS= ${COPTS} ${CPP_ONLY} 

_mips_COPTS=  ${COPTS_P} ${${@}_MIG?-Imach:}
_mips_CFLAGS= ${COPTS} 

COPTS=${_${MACHINE}_COPTS}
CFLAGS=${_${MACHINE}_COPTS} 


#
#  Common assembly flags
#
SFLAGS=	${DEPENDS} ${ALLOPTS} ${GCC_OPTS} -DASSEMBLER


#
#  Path name of the version identification file.
#
FEATURES=${cpu}/FEATURES.h
VERSION_FILES= \
	conf/version.major \
	conf/version.minor \
	conf/version.variant \
	conf/version.build \
	conf/version.patch

#  LOBJS is a list of files that are unique to builds from BINARY systems.
#  That is, systems which do not have access to source code.  These files
#  are the files which will be compiled on each system because they tend
#  to be "tuned" to the specific system.
# For alpha - afd - note: scb is in machine/template.mk with entry.o
#	config program makes scb_vec.c for mips
_alpha_LOBJS=	param.o ioconf.o

_mips_LOBJS=	param.o ioconf.o scb_vec.o

LOBJS=${_${MACHINE}_LOBJS}

# alpha jestabro - do not look for scb_vec.c in depend clause...
# FIXME??

_mips_LCFILES= ioconf.c param.c scb_vec.c

_alpha_LCFILES= ioconf.c param.c

LCFILES=${_${MACHINE}_LCFILES}

#
#  LDOBJS is the set of object files which comprise the kernel.
#  It is used both in the dependency list for each *vmunix.swap
#  rule emitted by config and also in the .sys.swap rule
#  below which links the kernel from these objects.
#  
#  LDOBJS_PREFIX and LDOBJS_SUFFIX are defined in the machine
#  dependent Makefile (if necessary).
#
LDOBJS=${LDOBJS_PREFIX} ${OBJS} ${LOBJS} ${LDOBJS_SUFFIX}

#
#  LDDEPS is the set of extra dependencies associated with each
#  *vmunix.swap rule (in addition to $LDOBJS and the swap*.o file).
#
#  LDDEPS_PREFIX is defined in the machine dependent Makefile
#  (if necessary).
#
LDDEPS=${LDDEPS_PREFIX} ${VERSION_FILES} \
	conf/version.banner conf/newvers.sh conf/copyright

#
#  PRELDDEPS is another set of extra dependencies associated with each
#  *vmunix.swap rule (in addition to $LDOBJS and the swap*.o file).
#  It is defined in the machine dependent Makefile (if necessary).
#
#  The generated rule looks like
#	vmunix.sys : ${PRELDDEPS} ${LDOBJS} ${LDDEPS}
#

#
#  SWAPDEPS is the set of extra dependencies associated with each
#  swap*.o rule emitted by config (in addition to the
#  ../${cpu}/swap*.c file).
#
#  SWAPDEPS_PREFIX is defined in the machine dependent Makefile
#  (if necessary).
#
SWAPDEPS=${SWAPDEPS_PREFIX} 

#
#  SYSDEPS is the set of extra dependencies associated with each
#  *vmunix rule (in addition to *vmunix.sys).
#
#  SYSDEPS_PREFIX is defined in the machine dependent Makefile
#  (if necessary).
#
SYSDEPS=${SYSDEPS_PREFIX}



#
#  Compilation rules to generate *vmunix from *vmunix.sys
#
SYS_RULE_1=@eval `${AWK} 'NR==1{S=$$1;next;};\
END {\
  print "rm -f $@";\
  C = "ln $@.sys $@";\
  if (S != "") {\
    C = C "; ln $@ $@" S; \
    printf "rm -f $@%s; ", S; \
  }\
  printf "echo \"%s\"; %s\n", C, C; \
}' vers.suffix`
SYS_RULE_2=
SYS_RULE_3=
SYS_RULE_4=

#
# Compilation rules to generate .o from .b
#
B_RULE_1A=rm -f $*.o; ${DECODE} 
B_RULE_1B=$*.b

#
# Compilation rules to generate .o from .o
#
O_RULE_1A=rm -f $*.o; cp 
O_RULE_1B=$*.o .

#
# Compilation rules to generate .o from .s
#
S_RULE_1A=${KCPP} ${SFLAGS} 
S_RULE_1B=$*.s >$*.i 
S_RULE_2=${AS} -o $*.o $*.i
S_RULE_3=rm -f $*.i

#
# Compilation rules to generate .o from .c for normal files
#
C_RULE_1A=${KCC} -c ${CFLAGS} 
C_RULE_1B=$*.c
C_RULE_2=
C_RULE_3=
C_RULE_4=

#
# Compilation rules to generate .o from .c for driver files
#
C_RULE_1A_D=${C_RULE_1A}
C_RULE_1B_D=${C_RULE_1B}
C_RULE_2_D=${C_RULE_2}
C_RULE_3_D=${C_RULE_3}
C_RULE_4_D=${C_RULE_4}

#
# Compilation rules to generate .o from .c for profiling routine files
#
C_RULE_1A_P=${KCC} -c -S ${COPTS_P} 
C_RULE_1B_P=${C_RULE_1B}
C_RULE_2_P=ex - $*.s < ${GPROF.EX}
C_RULE_3_P=${AS} -o $*.o $*.s
C_RULE_4_P=rm -f $*.s


gprof: kgmon_on all kgmon_off

kgmon_on:
	kgmon -r -b

kgmon_off:
	kgmon -h -p
	gprof /mach >GPROF

_mips_TEXTBASE=${LOADADDR?${LOADADDR}:80030000}
_alpha_TEXTBASE=${LOADADDR?${LOADADDR}:20000000}
TEXTBASE=${_${MACHINE}_TEXTBASE}

#
#  Theses macros are filled in by the config program depending on the
#  current configuration.  The MACHDEP macro is replaced by the
#  contents of the machine dependent makefile template and the others
#  are replaced by the corresponding symbol definitions for the
#  configuration.
#

%OBJS

%CFILES

%SFILES

%BFILES

%ORDERED

%MACHDEP

CFILES=${CFILES1} ${CFILES2} ${CFILES3} ${CFILES4}

#
#
# ${ECHO} the list of CFILES used to build the system
#
#
cfiles:
	@${ECHO} ${CFILES}

objfiles:
	@${ECHO} ${OBJS}
#
#
# export flags for use by kernel lib makefiles
#
#
asflags:
	@${ECHO} ${CCASFLAGS}

ccnflags:
	@${ECHO} ${CCNFLAGS}
#
#  Default rule used to build a *vmunix.sys configuration from the
#  object list and a particular *vmunix.swap module.  The *vmunix.swap
#  module is a normal object file compiled from the appropriate swap*.c
#  file and then copied to the *vmunix.swap name to trigger the full
#  kernel link using this default rule.
#

#
#  OBJSDEPS is the set of files (defined in the machine dependent
#  template if necessary) which all objects depend on (such as an
#  in-line assembler expansion filter
#

${OBJS}: ${OBJSDEPS}



#
#  This macro is replaced by three rules per configuration, plus a
#  final definition for the LOAD symbol consisting of all configuration
#  names and a dependency of "all" on this symbol (so that the
#  "default" rule above will build everything).  The three rules in
#  each configuration are:
#
#  - a *vmunix from *vmunix.sys dependency using the SYS_RULE_* rules,
#  - a *vmunix.swap from LDDEPS, swap*.o, and LDDEPS dependency that
#    simply copies the swap file to the target name, and
#  - a swap*.o from swap*.c and SWAPDEPS dependency using the C_RULE_* rules.
#

%LOAD

#
# Special rules to make LOBJS
#
#
#  Rules for components which are not part of the kernel proper or that
#  need to be built in a special manner.
#


ioconf.o: ioconf.c
	-${RM} -f ioconf.o
	${KCC} ${CCNFLAGS} ioconf.c

param.c: conf/param.c
	-${RM} -f param.c
	${CP} conf/param.c .

param.o: param.c
	-${RM} -f param.o
	${KCC} ${CCNFLAGS} ${PARAM} param.c

scb_vec.o: scb_vec.c
	-${RM} -f scb_vec.o
	${KCC} ${CCNFLAGS} scb_vec.c

scalls: ${SYSENT} ${SEC_LEVEL?audit_table:}

audit_table:	conf/maketable.ksh conf/audit.master \
		${AUDIT} conf/auderrmsg
	rm -f auderrmsg 
	cp  conf/auderrmsg .
	${KSH} conf/maketable.ksh -hk \
		conf/audit.master ${AUDIT}
	rm -f ../include/sys/auditsysc.h
	mv ./auditsysc.h ../include/sys/auditsysc.h
	mv ./audit_table ../include/sys/audit_table
	rm -f auderrmsg reduce_mdep.h

genassym.o: ${cpu}/genassym.c
	if [ ${MACHINE} = alpha ]; then \
		${CC} -EL ${ALLOPTS} ${VOLATILE} -c ${cpu}/genassym.c; \
	else \
		${CC} -std0 -EL ${ALLOPTS} ${VOLATILE} -c ${cpu}/genassym.c; \
	fi

PMAX_CC_PREFIX=
MMAX_CC_PREFIX=LPATH=/usr/lib:/lib; export LPATH; 
I386_CC_PREFIX=LPATH=/usr/lib:/lib; export LPATH; 
CC_PREFIX=${${TARGET_MACHINE}_CC_PREFIX}
# Note: above 4 lines look bogus!

#assym.s: genassym.o
#	${CC_PREFIX}${CC} ${LIBDIRS} -w -std0 -EL -non_shared -o genassym genassym.o
#	./genassym  > assym.s; rm -f genassym

# For mips/alpha cross development - afd
# We build genassym and run it in the simulator!
# FIXME??
#
assym.s: genassym.o
	if [ ${MACHINE} = mips ]; then \
		${CC} -std0 -EL -non_shared -o genassym genassym.o; \
		./genassym  > assym.s; rm -f genassym; \
	else \
		${LD} -o genassym -L -L${COMP_HOST_ROOT}/usr/lib/cmplrs/acc \
	   	 ${COMP_HOST_ROOT}/usr/lib/cmplrs/acc/crt0_sa.o genassym.o \
	    	${COMP_HOST_ROOT}/usr/lib/cmplrs/acc/libc_sa.a -N -T ${TEXTBASE}; \
		/bin/sh ${SOURCEDIR}/../tools/alpha/hostbin/run-genassym; \
	fi

locore.o: assym.s ${LOCORE_HEADS}

#
#  Mach IPC-based interfaces
#

MACH_DEFSFILES=\
	mach/std_types.defs \
	mach/mach_types.defs \
	mach/mach.defs \
	mach/mach_host.defs \
	mach/exc.defs \
	mach/memory_object.defs \
	mach/memory_object_default.defs \
	mach/device_types.defs \
	mach/device.defs \
	mach/monitor.defs

MACH_GENFILES=\
	./mach/mach_server.c \
	./mach/mach_user_internal.h \
	./mach/mach_interface.h \
	./mach/mach_host_server.c \
	./mach/mach_host.h \
	./mach/memory_object_server.c \
	./mach/memory_object_user.c \
	./mach/memory_object_user.h \
	./mach/memory_object_default_server.c \
	./mach/memory_object_default_user.c \
	./mach/memory_object_default.h \
	./mach/device_server.c \
	./mach/exc_server.c \
	./mach/exc_user.c \
	./mach/exc.h \
	./mach/monitor_server.c \
	./mach/monitor.h

MACH_MKFILE=	mach/Makefile

$(MACH_GENFILES) : migfiles

migfiles :: $(MACH_DEFSFILES) $(MACH_MKFILE)
	rm -rf ./mach
	mkdir ./mach
	cd ./mach && \
	 ${MAKE} ${MFLAGS} VPATH=../../mach && touch ../migfiles

MACH_DEBUG_DEFSFILES=\
	mach_debug/mach_debug_types.defs \
	mach_debug/mach_debug.defs

MACH_DEBUG_GENFILES=\
	./mach_debug/mach_debug_server.c

MACH_DEBUG_MKFILE=	mach_debug/Makefile

$(MACH_DEBUG_GENFILES) : migdebugfiles

migdebugfiles :: $(MACH_DEBUG_DEFSFILES) $(MACH_DEBUG_MKFILE)
	rm -rf ./mach_debug
	mkdir ./mach_debug
	cd ./mach_debug && \
	 ${MAKE} ${MFLAGS} VPATH=../../mach_debug && touch ../migdebugfiles

MIG_ALL_FILES =	migfiles \
		migmachinefiles \
		migdebugfiles \
		migdebugmachinefiles

#
#  Update the Makefile when any dependency files exist rather than only
#  when they are newer than the makefile (since it often gets touched
#  during reconfigurations when dependency files have yet to be
#  integrated).  The makefile is copied before doing any potential
#  integration so that the new and old versions can be compared when
#  done (by the SYS_RULE_* rules) to prevent re-building things when no
#  dependencies change.
#
#  N.B.  There is always an empty artificial dependency file M.d
#  (created by config) which will never be integrated and simply
#  prevents the wild-card expansion below from failing.
#
#  The default exit rule now brings the Makefile up to date, so it
#  shouldn't be necessary to execute this rule manually.
#

.EXIT:

depend: param.c assym.s ${cpu}/genassym.c ${cpu}/swapgeneric.c ${CFILES} ${SFILES}
	${CP} Makefile makefile.bak
	-${RM} -f eddep
	${ECHO} '/^# DO NOT DELETE THIS LINE/+1,$$d' >eddep
	${ECHO} 'w' >>eddep
	${EX} - Makefile < eddep
	-if [ ! -f assym.h ]; then ${ECHO} >assym.h; else exit 0; fi
	${CC} -M ${CCNFLAGS} ${LCFILES} \
	    ${cpu}/swapgeneric.c ${SFILES} | \
	${AWK} '{ if ($$1 != prev) { prev = $$1 } else { print $$0 }}' | \
	${SED} -e ':loop' \
	    -e 's/\.\.\/[^ /]*\/\.\./../' \
	    -e 's/ \.\// /' \
	    -e 't loop' | \
	${SED} -e 's+	/.*kernel/+	+' |\
	${SORT} -u | \
	${AWK} ' { if ($$1 != prev) { \
 			print rec; rec = $$0; prev = $$1; \
 		} else { \
 			if (length(rec $$2) > 78) { \
 				print rec; rec = $$0; \
 			} else \
 				rec = rec " " $$2 \
 		} } \
	      END { print rec } ' >> Makefile
	${CC} -M ${CCNFLAGS} ${CFILES1} | \
	${AWK} '{ if ($$1 != prev) { prev = $$1 } else { print $$0 }}' | \
	${SED} -e ':loop' \
	    -e 's/\.\.\/[^ /]*\/\.\./../' \
	    -e 's/ \.\// /' \
	    -e 't loop' | \
	${SED} -e 's+	/.*kernel/+	+' |\
	${SORT} -u | \
	${AWK} ' { if ($$1 != prev) { \
 			print rec; rec = $$0; prev = $$1; \
 		} else { \
 			if (length(rec $$2) > 78) { \
 				print rec; rec = $$0; \
 			} else \
 				rec = rec " " $$2 \
 		} } \
	      END { print rec } ' >> Makefile
	${CC} -M ${CCNFLAGS} ${CFILES2} | \
	${AWK} '{ if ($$1 != prev) { prev = $$1 } else { print $$0 }}' | \
	${SED} -e ':loop' \
	    -e 's/\.\.\/[^ /]*\/\.\./../' \
	    -e 's/ \.\// /' \
	    -e 't loop' | \
	${SED} -e 's+	/.*kernel/+	+' |\
	${SORT} -u | \
	${AWK} ' { if ($$1 != prev) { \
 			print rec; rec = $$0; prev = $$1; \
 		} else { \
 			if (length(rec $$2) > 78) { \
 				print rec; rec = $$0; \
 			} else \
 				rec = rec " " $$2 \
 		} } \
	      END { print rec } ' >> Makefile
	${CC} -M ${CCNFLAGS} ${CFILES3} | \
	${AWK} '{ if ($$1 != prev) { prev = $$1 } else { print $$0 }}' | \
	${SED} -e ':loop' \
	    -e 's/\.\.\/[^ /]*\/\.\./../' \
	    -e 's/ \.\// /' \
	    -e 't loop' | \
	${SED} -e 's+	/.*kernel/+	+' |\
	${SORT} -u | \
	${AWK} ' { if ($$1 != prev) { \
 			print rec; rec = $$0; prev = $$1; \
 		} else { \
 			if (length(rec $$2) > 78) { \
 				print rec; rec = $$0; \
 			} else \
 				rec = rec " " $$2 \
 		} } \
	      END { print rec } ' >> Makefile
	${CC} -M ${CCNFLAGS} ${CFILES4} | \
	${AWK} '{ if ($$1 != prev) { prev = $$1 } else { print $$0 }}' | \
	${SED} -e ':loop' \
	    -e 's/\.\.\/[^ /]*\/\.\./../' \
	    -e 's/ \.\// /' \
	    -e 't loop' | \
	${SED} -e 's+	/.*kernel/+	+' |\
	${SORT} -u | \
	${AWK} ' { if ($$1 != prev) { \
 			print rec; rec = $$0; prev = $$1; \
 		} else { \
 			if (length(rec $$2) > 78) { \
 				print rec; rec = $$0; \
 			} else \
 				rec = rec " " $$2 \
 		} } \
	      END { print rec } ' >> Makefile

	-if [ -r swap*.c ]; \
	then \
		${CC} -M ${CCNFLAGS} swap*.c | \
		${AWK} '{ if ($$1 != prev) { prev = $$1 } else {print $$0}}' | \
		${SED} -e ':loop' \
		    -e 's/\.\.\/[^ /]*\/\.\./../' \
		    -e 's/ \.\// /' \
		    -e 't loop' | \
		${SED} -e 's+	/.*kernel/+	+' |\
		${AWK} ' { if ($$1 != prev) { \
				print rec; rec = $$0; prev = $$1; \
			} else { \
				if (length(rec $$2) > 78) { \
					print rec; rec = $$0; \
				} else \
					rec = rec " " $$2 \
			} } \
		      END { print rec } ' >> Makefile; \
	else exit 0; \
	fi
	${CC} -M ${CCNFLAGS} ${cpu}/genassym.c | \
	${AWK} '{ if ($$1 != prev) { prev = $$1 } else { print $$0 }}' | \
	${SED} -e ':loop' \
	    -e 's/\.\.\/[^ /]*\/\.\./../' \
	    -e 's/ \.\// /' \
	    -e 't loop' | \
	${SED} -e 's+	/.*kernel/+	+' |\
	${AWK} ' BEGIN { \
		rec = "assym.h:"; \
	      } \
	      { \
		if (length(rec $$2) > 78) { \
		    print rec; \
		    rec = "assym.h: " $$2; \
		} else \
		    rec = rec " " $$2; \
	      } \
	      END { \
		 print rec; \
	      } ' >> Makefile

#
#  Permit manually forced checkout of modules when the dependency
#  information is not current.
#

checkout:	${USE}



#
#  Clean up the current build directory.
#

clean:
	@for f in ${LOAD}; do ${ECHO} rm -f $$f $$f.* && rm -f $$f $$f.*; done
	rm -f eddep tags *.o locore.i \
		$(MIG_ALL_FILES) \
		errs linterrs makelinks *.log *LOG* ${CLEAN_EXTRA}


#
#  Run "lint" on the current build directory.  This will often be done
#  with a special configuration that defines the union of all options
#  used in all configurations so that all combinations are checked.
#  The LINTFILES variable allows lint to be easily run on an optional
#  sub-set of files specified on the make command line when this is
#  desired.
#

LINTFILES=${cpu}/Locore.c ${CFILES} ${cpu}/swapgeneric.c

lint .ORDER:	$(EXTERNAL_FILES) \
		$(MIG_ALL_FILES) \
		assym.s \
		ALWAYS
	@${LINT} -n -hbxn -DGENERIC ${LINTOPTS} ${LINTFILES} | \
	    ${EGREP} -v 'struct/union .* never defined' | \
	    ${EGREP} -v 'possible pointer alignment problem'

ALWAYS:

MACHINEDIR=${cpu}

symbols.sort: ${MACHINEDIR}/symbols.raw
	-${GREP} -v '^#' ${MACHINEDIR}/symbols.raw \
	    | ${SED} 's/^	//' | ${SORT} -u > symbols.tmp
	mv -f symbols.tmp symbols.sort

#
#  This macro is replaced by the set of rules which build everything in
#  OBJS.
#

%DYNAMIC

%RULES


