/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ws_data.c,v $
 * Revision 1.1.3.4  92/06/02  10:51:21  cam_proj_Janet_Schank
 * 	Moved devio.h from sys to io/common
 * 	[92/05/26  10:19:29  Janet_Schank]
 * 
 * Revision 1.1.3.3  92/03/01  17:08:32  William_Burns
 * 	Fix undefines
 * 	[92/03/01  17:07:37  William_Burns]
 * 
 * Revision 1.1.3.2  92/02/27  14:35:42  Barbara_Corriero
 * 	Ported to OSF. This data file allows the user to customize
 * 	keyboard and pointer devices.
 * 	[92/02/24  13:23:35  Barbara_Corriero]
 * 
 * $EndLog$
 */
/************************************************************************
 *									*
 *			Copyright (c) 1990 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/************************************************************************
 * Modification History
 * 3-July-91 -- Jim Gettys
 *	       Added HX (sfb) support for bt459
 *
 * 13-Aug-90 -- Sam Hsu
 * 
 *	       Created from fb_data.c, px_data.c, ws_device.c.
 *
 ************************************************************************/
#define _WS_DATA_C_

#include "tc.h"

/*#include "../machine/pte.h"*/
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/workstation.h>
#include <sys/inputdevice.h>
#include <sys/wsdevice.h>
#include <sys/lk201.h>
#include <io/common/devio.h>
#include <sys/buf.h>
/*#include <../io/uba/ubavar.h"		/* auto-config headers 		*/
/* #include <hal/cpuconf.h> */

/* #if NTC > 0 */
#include <io/dec/ws/bt463.h>		/* specific to BT463 VDAC 	*/
#include <io/dec/ws/bt459.h>		/* ditto */
#include <io/dec/ws/bt455.h>		/* ditto */
#include <io/dec/ws/bt431.h>		/* ditto */
#include <io/dec/ws/ims_g332.h>		/* not ditto */
#include <io/dec/ws/pmagaa.h>		/* ditto to mx module		*/
#include <io/dec/ws/pmagro.h>
#include <io/dec/ws/pmagdv.h>
#include <io/dec/ws/vfb03.h>		/* specific to cfb module 	*/
#include <io/dec/ws/pmagbba.h>		/* ditto to hx module (sfb)	*/
/*#endif */

/*#ifdef DS3100*/
#include <io/dec/ws/pmvdac.h> 		/* PMAX def			*/
/*#endif */

extern ws_keyboard 	keyboard;

#ifdef BINARY

extern ws_devices 	devices[];
extern ws_screens 	screens[];
extern ws_pointer	mouse;
extern ws_cursor_data	default_cursor;
extern ws_monitor	monitor_type[];
extern int		nmon_types;
extern struct lk201info lk201_softc[];
extern unsigned int	cdata[];
extern int		cpu;		/* XXX */

#else /*BINARY*/

unsigned int cdata[16] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

#define DEFAULT_CURSOR	0,16,16,0,0,cdata,cdata

ws_cursor_data default_cursor = {
    DEFAULT_CURSOR ,
};

#define NLK201 1

/* private keyboard data */
struct lk201info lk201_softc[NLK201] = {
    lk201_getc, lk201_putc, 90/* was 75 in 4.L */, 9, &keyboard,
    0, 0, 0, 0, 0, 0, 0,
    {0,0,0,0,0,0,0,0},
    0, 0, 0
    };

/* public keyboard data */
ws_keyboard keyboard = {
    LK_201,				/* by default */
    (caddr_t) lk201_softc,
    0,					/* no axis data */
    lk201_init_closure,
    NULL,				/* lk201_ioctl */
    lk201_up_down_mode,			/* init keyboard */
    lk201_reset_keyboard,		/* reset (close to def lk201) state */
    NULL,				/* always enabled */
    NULL,				/* can't disable */
    lk201_set_keyboard_control,
    NULL,
    lk201_ring_bell,
    { 0, 0, 50, 50, 400, 100,
	  1,				/* autorep on, except for modifiers,
					   return */
	  {
	      0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
	      0xffffffff, 0xdff807ff, 0xffffffff, 0xffffffff,
	  },
	  0},				/* leds */
    &lk201_definition,
    lk201_modifiers,
    lk201_keysyms,
    lk201_keycodes,
};

ws_hardware_type mouse_closure = {
    0,
    VSXXX,
    3
};

ws_pointer mouse = {
    VSXXX,
    (caddr_t)&mouse_closure,
    2,					/* 2 axis */
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    0,
    { 1, 1, 1, 1 },			/* pointer rates */
    { 0, 0, 0 },			/* current cursor position */
    { DEFAULT_CURSOR },			/* cursor data */
    { 0, 0, 0, { 0, 0, 0, 0 },},	/* no entries in q for motion	*/
					/* inside this box.		*/
    { 0, 0, 0, { 864, 1024, 0, 0}},	/* prevent cursor from leaving	*/
    0, 0,				/* tablet scale x,y */
    2200, 2200,				/* tablet max x,y */
    0, 0,				/* 0,0 is at bottom left of tablet */
    1					/* login screen is new screen */
};

ws_devices devices[NUMINPUTDEVICES];
ws_screens screens[NUMSCREENS];

/*
 * This is so an X server can deal with different phosphor types.
 */
ws_monitor monitor_type[] = {
    MONITOR_VRUNK,
    MONITOR_VR299,
    MONITOR_VR290,
    MONITOR_VR260,
    MONITOR_VR262,
    MONITOR_VR150,
    MONITOR_VRE01,
    MONITOR_VR160,
    MONITOR_VR297,
    MONITOR_VRT19,
};
int nmon_types = sizeof(monitor_type) / sizeof(ws_monitor);


#include "fb.h"

#if (NFB) > 0
#if (NFB) < NUMSCREENS
#define BT_SCREENS	(NFB)
#else
#define BT_SCREENS	(NUMSCREENS)
#endif /*nfb+npx<numscreens*/

/* #if NTC > 0 */

struct bt459info bt459_softc[BT_SCREENS];	/* up to one per option slot */
/*
 * Bt459 VDAC info indexed by BT459_<type>_TYPE in bt459.h.
 */
struct bt459type bt459_type[] = {
    {
	(struct bt459 *)VFB03_BT459_OFFSET,	/* CX		   */
	220, 35,				/* offsets to video position */
	256, 0,					/* range of dirty entries */
	0,					/* reset */
	0xff,					/* mask */
    },
    {
	(struct bt459 *)PMAGBBA_BT459_OFFSET,	/* HX		   */
	219, 34,				/* offsets to video position */
	256, 0,					/* range of dirty entries */
	0,					/* reset */
	0xff,					/* mask */
    },
};
int nbt_types = sizeof(bt459_type) / sizeof(struct bt459type);
int nbt_softc = sizeof(bt459_softc) / sizeof(struct bt459info);


#if NFB > 0

struct bt463info bt463_softc[NFB];
struct bt463info bt463_type[] = {
    {	
	(struct bt463 *)TCO_FB_REGISTERS, /*fix this jmg */
	1,			/* screen initally on 	   */
	0,			/* colormap clean		   */
	0,			/* cursor map clean		   */
	219, 34,		/* magic offsets to video position */
	NULL,			/* enable cfb interrupt on V.R.	   */
	NULL,			/* hack */
	{ 0, 0, 0, 0, },
	{ 0, 0, 0, 0, },
	{ 0, 0, 0, 0, },
	256, 0,
    },
};

struct bt431info bt431_softc[NFB];
struct bt431info bt431_type[] = {
    {	
	(struct bt431 *)PMAGAA_BT431_OFFSET,
	1,			/* screen initally on 	   	   */
	1,			/* cursor initially on		   */
	0,		        /* cursor clean 		   */
	0x168, 0x24,		/* magic offsets to video position */
	0, 0,			/* hot spot of current cursor 	   */
	0,			/* not initialized yet - hack!!!   */
	NULL,			/* enable cfb interrupt on V.R.	   */
    },
    {	
	(struct bt431 *)TCO_CURSOR0,
	1,			/* screen initally on 	   	   */
	1,			/* cursor initially on		   */
	0,		        /* cursor clean 		   */
	0x16c, 0x23,		/* magic offsets to video position */
	0, 0,			/* hot spot of current cursor 	   */
	0,			/* not initialized yet - hack!!!   */
	NULL,			/* enable cfb interrupt on V.R.	   */
    },
};


struct bt455info bt455_softc[NFB];
struct bt455info bt455_type[] = {
    {	
	(struct bt455 *)PMAGAA_BT455_OFFSET,
	0, 0xFF,		/* cursor fg and bg value      	   */
	NULL,
	0,
	0
    },
};

struct ims_g332info ims_g332_softc[NFB];
struct ims_g332info ims_g332_type[] = {
    {	
	0,			/* control reg cache! */
	1,			/* screen initally on 	   */
	1,			/* cursor initially on		   */
	0, 0,			/* cursor and colormap celan	   */
	1, 0,		 	/* magic offsets to video position */
	0, 0,			/* hot spot of current cursor 	   */
	NULL,			/* enable cfb interrupt on V.R.	   */
	{ 0, 0, 0, 0, },
	{ 0, 0, 0, 0, },
	{ 0, 0, 0, 0, },
	256, 0,
    },
};
#endif /*nfb*/
/*#endif /*NTC > 0*/
#endif /*nfb*/

/*#ifdef DS3100 */

struct pmvdacinfo pm_softc[1];
struct pmvdacinfo pmvdac_type[] = {
    {
	0,					/* vdac */
	0,					/* pcc */
	212, 34,				/* offsets to video position */
	0, 0,					/* hotspot of cursor 	   */
	{ 0, 0, 0, 0, },
	{ 0, 0, 0, 0, },
	{ 0, 0, 0, 0, },
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	},
};
/*#endif ds3100*/

#endif BINARY
