/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vmparam.h,v $
 * Revision 1.1.3.4  92/02/05  17:26:48  Donald_Dutile
 * 	Added cast to USRSTACK to eliminate warnings.  ifndef'd for
 * 	assembler code, just in case.
 * 	[92/01/31  16:20:33  Donald_Dutile]
 * 
 * Revision 1.1.3.3  91/12/18  21:39:46  William_Burns
 * 	date: 91/11/14 15:42:42;  author: devrcs;  state: Exp;  lines added/del: 3/1
 * 	sccs rev: 3.2;  orig date: 91/11/04 17:19:12;  orig author: fred
 * 	Fred Canter - config cleanup.
 * 	[91/12/17  15:09:55  William_Burns]
 * 
 * Revision 1.1.3.2  91/11/20  13:50:36  Hal_Project
 * 	Moved from dec/machine/mips; pool reorg.
 * 	[91/11/18  00:11:36  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:13:14  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: vmparam.h,v $ $Revision: 1.1.3.4 $ (DEC) $Date: 92/02/05 17:26:48 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)vmparam.h	7.1 (Berkeley) 6/5/86
 */
#ifndef	_MACHINE_VMPARAM_H_
#define	_MACHINE_VMPARAM_H_ 1


/*
 * Machine dependent constants for MIPS
 */

/*
 * USRTEXT is the start of the user text, USRDATA is the start of the
 * user data, and USRSTACK is the top (end) of the user stack.  
 * LOWPAGES is the number of pages from the beginning of the text region
 * to the beginning of text.
 * HIGHPAGES is the number of pages from the beginning of the stack region
 * to the beginning of the stack.
 */

#define	USRTEXT		0x400000	/* user text starts at 4 MB */
#define USRDATA		0x10000000	/* user data starts at 256 MB */
#define	EA_SIZE		32		/* EMULATE_AREA size */
#ifndef ASSEMBLER
#define	USRSTACK	(((vm_offset_t)0x80000000)-NBPG)/* Top of user stack */
#else
#define	USRSTACK	(0x80000000-NBPG)/* Top of user stack */
#endif	/* !ASSEMBLER */
#define EMULATE_AREA	USRSTACK-EA_SIZE/* area for bp emulation */

/*
 * Virtual memory related constants, all in bytes
 * Note: only used if not specified in the kernel
 *	 config file (maxdsiz, maxssiz, dfldsiz, & dflssiz).
 */
#ifndef DFLDSIZ
#define	DFLDSIZ		(32*1024*1024)		/* initial data size limit */
#endif
#ifndef MAXDSIZ
#define	MAXDSIZ		(32*1024*1024)		/* max data size */
#endif
#ifndef	DFLSSIZ
#define	DFLSSIZ		(1024*1024)		/* initial stack size limit */
#endif
#ifndef	MAXSSIZ
#define	MAXSSIZ		MAXDSIZ			/* max stack size */
#endif


#endif	/* _MACHINE_VMPARAM_H_ */
