/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	uagt.h,v $
 * Revision 1.1.3.2  92/06/02  11:26:53  cam_proj_Janet_Schank
 * 	Moved CAM include files from sys to io/cam
 * 	[92/05/13  08:29:06  Janet_Schank]
 * 
 * 	Made 64bit modifications
 * 	[92/01/31  10:05:17  Janet_Schank]
 * 
 * 	Merged in changes from LA.
 * 	[92/01/28  18:12:21  Janet_Schank]
 * 
 * 	CAM support added
 * 	[92/01/17  11:23:10  Janet_Schank]
 * 
 * Revision 1.1.3.2  92/02/27  16:15:10  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: uagt.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 92/06/02 11:26:53 $
 */
#ifndef _UAGT_INCL_
#define _UAGT_INCL_

/************************************************************************
 *
 *  uagt.h		Version 1.00 			June 20, 1990
 *
 *  This file contains the definitions and data structures for the User
 *  Agent Device Driver (UAGT) that controls access to the CAM Subsystem.
 *
 *  MODIFICATION HISTORY:
 *
 *  VERSION  DATE	WHO	REASON
 *
 *  1.00     06/20/90	jag	Created from User Agent Func. Spec.
 *
 *  1.01     10/18/90	maria	Added the count fields to the
 *				UAGT_CAM_CCB structure.
 *
 *  1.03     11/19/91	maria	Added new ioctl to scan a bus or nexus
 *				and a new data structure for these ioctls.
 *				Added a flags field to the UAGT_CAM_CCB
 *				for indicating non-interruptable sleep.
 *
 ************************************************************************/


/* 
 * This data structure is used for the communication process between the
 * User Agent Device Driver and the user level programs needing to have access
 * to the CAM SCSI subsystem.  It will be copied into kernel space as part of
 * of the ioctl(2) call from user space.  The user program must fill in the
 * various pointers in this structure and the user agent driver will correctly
 * fill in the corisponding pointers in the CCB.  From the CAM SCSI subsystem's
 * point of view the request will have come from the UAgt driver.
 */

typedef struct uagt_cam_ccb
{
    CCB_HEADER *uagt_ccb;		/* pointer to the users CCB */
    U32 uagt_ccblen;			/* length of the users CCB */
    u_char *uagt_buffer;		/* pointer for the data buffer */
    U32 uagt_buflen;			/* length of user request */
    u_char *uagt_snsbuf;		/* pointer for the sense buffer */
    U32 uagt_snslen;			/* length of user's sense buffer */
    CDB_UN *uagt_cdb;			/* ptr for a CDB if not in CCB */
    U32 uagt_cdblen;			/* CDB length if appropriate */
    U32 uagt_flags;			/* See below */
} UAGT_CAM_CCB;

typedef struct uagt_cam_scan  {
	u_char	ucs_bus;		/* Bus id for scan */
	u_char	ucs_target;		/* Target id for scan */
	u_char	ucs_lun;		/* LUN for scan */
} UAGT_CAM_SCAN;

/*
 * Uagt_flags field defines.
 */
#define UAGT_NO_INT_SLEEP	0x01	/* Indicates that the user agent */
					/* driver should not sleep at an */
					/* interruptable priority. */
					/* The default is to sleep at */
					/* an interruptable priority. */

/*
 * Ioctl() define for the calls to the UAgt driver. 
 */
#define	UAGT_CAM_IO		_IOWR('s', 00, struct uagt_cam_ccb)
#define	UAGT_CAM_SINGLE_SCAN	_IOWR('s', 01, struct uagt_cam_scan)
#define	UAGT_CAM_FULL_SCAN	_IOWR('s', 02, struct uagt_cam_scan)

#endif /* _UAGT_INCL_ */
