/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	msisysap.h,v $
 * Revision 1.1.2.3  92/05/05  12:49:22  Peter_Keilty
 * 	merged with ag.latest
 * 	[92/05/04  17:04:47  Peter_Keilty]
 * 
 * 	Modified for ALPHA
 * 	[92/03/28  11:34:45  Peter_Keilty]
 * 
 * Revision 1.1.2.2  92/02/24  11:52:21  Peter_Keilty
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:40:26  Peter_Keilty]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: msisysap.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/05/05 12:49:22 $
 */
/*
 * derived from msisysap.h	2.1	(ULTRIX)	5/9/89
 */
/*
 *   Facility:	Systems Communication Architecture
 *		Mayfair Storage Interconnect Port Driver
 *
 *   Abstract:	This module contains Mayfair Storage Interconnect Port
 *		Driver( MSI ) constants and data structure definitions
 *		visible to SYSAPs.
 *
 *   Creator:	Todd M. Katz	Creation Date:	December 06, 1988
 *
 *   Modification History:
 */

/* MSI Constants.
 */
#define	MSI_MAXNUM_PORT		 8	/*  DSSI( ports )		     */
#define	MSI_MAPSIZE ( MSI_MAXNUM_PORT / 8 ) /* Size of port bit map in bytes */

/* MSI Data Structure Definitions.
 */
typedef	struct _msilpib	{		/* MSI Local Port Information	     */
    u_int	dg_size;		/* Size of application datagram	     */
    u_int	msg_size;		/* Size of application sequenced msg */
    u_int	pd_ovhd;		/* Size of PD + PPD header overhead  */
    u_int	ppd_ovhd;		/* Size of PPD header overhead	     */
    u_char	rpslogmap[ MSI_MAPSIZE ];/* Remote port state port logmap    */
    u_int			: 24;
} MSILPIB;

typedef	struct	_msirpi {		/* MSI Remote Port Information	     */
    struct	{			/* Remote port microcode level	     */
	u_char	st_level;		/*  Self-test ucode rev level	     */
	u_char	fn_level;		/*  Functional ucode revision level  */
	u_short			: 16;	
    } ucode_rev;
    u_short	port_fcn[ 2 ];		/* Port functionality mask	     */
    struct	{			/* System state information	     */
	u_short	reset_port	:  8;	/*  Port which caused last reset     */
	u_short	port_state	:  3;	/*  Port state( defined by CIPIB )   */
			       /* PS_UNINIT	  - Uninitialized	     */
			       /* PS_UNINIT_MAINT - Maintenance/Uninitialized*/
			       /* PS_DISAB	  - Disabled		     */
			       /* PS_DISAB_MAINT  - Maintenance/Disabled     */
			       /* PS_ENAB	  - Enabled		     */
			       /* PS_ENAB_MAINT	  - Maintenance/Enabled	     */
	u_short	sys_state1	:  5;	/*  Implementation specific state    */
	u_short	sys_state2;
    } sys_state;
    struct	{			/* Port functionality extension	     */
	u_short			: 16;
	u_short	maxbodylen	: 13;	/*  Max num of bytes in packet body  */
	u_short			:  3;
    } port_fcn_ext;
} MSIRPI;

typedef struct _msipib	{		/* MSI Path Information		     */
    struct _msirpi	rpinfo;		/* Remote port information	     */
} MSIPIB;
