/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	scc_common.h,v $
 * Revision 1.1.2.2  92/02/24  12:27:38  Heather_Gray
 * 	18-July-1991 - mjm (Matt Muggeridge)
 * 	created file
 * 	[92/02/11  12:16:15  Heather_Gray]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: scc_common.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/24 12:27:38 $
 */
/*
 *
 * scc_common.h
 *
 * SCC SLU async driver and sync driver
 *
 */

/* SCC driver interrupt switch tables */

/*
 *  The SCC interrutps, described in the SIR, are called via these entry points.
 */
struct SIR_Interrupt_sw {
    int	(*RxOverrun)();		/* DMA Receive Overrun Interrupt     */
    int (*RxHalfPage)();	/* DMA Receive Half Page Interrupt   */
    int (*TxReadError)();	/* DMA Transmit Read Error Interrupt */
    int (*TxPageEnd)();		/* DMA Transmit Page End Interrupt   */
    int (*SCC)();		/* SCC Interrupt 		     */
};

/*
 *  The specific SCC ISRs are called via these entry points.
 */
struct SCC_Interrupt_sw {
    int (*RxSpecCond)();	/* Receive Special Condition Interrupt */
    int (*Transmit)();		/* Transmit Interrupt 		       */
    int (*ExtStatus)();		/* External Status Interrupt 	       */
};

/* Saved registers */
struct scc_saved_reg
{
    u_char      rr0;
    u_char      wr1;
    u_char      wr2;
    u_char      wr3;
    u_char      wr4;
    u_char      wr5;
    u_char      wr6;
    u_char      wr7;
    u_char      wr8;
    u_char      wr9;
    u_char      wr10;
    u_char      wr11;
    u_char      wr12;
    u_char      wr13;
    u_char      wr14;
    u_char      wr15;
};

#define NSCC_DEV        2
#define SCC_CHA		0
#define SCC_CHB		1
