/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	syscall_emulation.h,v $
 * Revision 4.2  91/09/19  22:27:25  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: syscall_emulation.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:27:25 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef	_KERN_SYSCALL_EMULATION_H_
#define _KERN_SYSCALL_EMULATION_H_

#define EML_MIN_SYSCALL		-9

#ifndef	ASSEMBLER
typedef	 unsigned long 	eml_routine_t;

typedef struct eml_dispatch {
	int		eml_ref;	/* reference count */
	int 		disp_count; 	/* count of entries in vector */
	eml_routine_t	disp_vector[1];	/* first entry in array (array is really disp_count large) */
					/* of dispatch routines */
} *eml_dispatch_t;

typedef struct syscall_val {
	int	rv_val1;
	int	rv_val2;
} syscall_val_t;


#define EML_ROUTINE_NULL	(eml_routine_t)0
#define EML_DISPATCH_NULL	(eml_dispatch_t)0

#define EML_SUCCESS		(0)

#define EML_MOD			(err_kern|err_sub(2))
#define EML_BAD_TASK		(EML_MOD|0x0001)
#define EML_BAD_CNT		(EML_MOD|0x0002)

#define EML_OFFSET(x)		((x)-EML_MIN_SYSCALL)

#endif	/* ASSEMBLER */
#endif	/* _KERN_SYSCALL_EMULATION_H_ */
