/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	fcntl.h,v $
 * Revision 4.2.2.8  92/04/24  15:20:46  Diane_Lebel
 * 	AG merge
 * 	[92/04/24  15:16:08  Diane_Lebel]
 * 
 * 	lockmgr fixes
 * 	[92/04/22  18:17:47  Diane_Lebel]
 * 
 * Revision 4.2.2.7  92/04/24  11:33:00  Stephen_Strange
 * 	AG merge
 * 	[92/04/24  11:10:52  Stephen_Strange]
 * 
 * 	Put locking flags in #ifdef KERNEL
 * 	[92/04/24  10:58:26  Stephen_Strange]
 * 
 * Revision 4.2.2.6  92/04/23  14:46:55  Stephen_Strange
 * 	Moved the locking flags outside of _POSIX_SOURCE (qar 3295)
 * 	[92/04/23  14:45:52  Stephen_Strange]
 * 
 * Revision 4.2.2.5  92/04/10  11:16:07  Stephen_Strange
 * 	POSIX compliance changes for ISO 9945-1 (1990)
 * 	[92/03/30  18:16:16  Stephen_Strange]
 * 
 * Revision 4.2.2.4  92/03/27  15:09:30  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:38:12  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:33:17  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  18:23:20  Craig_Horman]
 * 
 * Revision 4.2.2.3  92/03/25  19:41:54  Diane_Lebel
 * 	Merge with AG
 * 	[92/03/25  19:18:36  Diane_Lebel]
 * 
 * 	added support for lock mngr
 * 	[92/03/25  17:44:38  Diane_Lebel]
 * 
 * Revision 4.2.2.2  92/02/26  15:48:49  Charles_Briggs
 * 	Pool merge
 * 	[92/02/23  12:44:52  Charles_Briggs]
 * 
 * 	UBC merge.
 * 	[92/02/22  14:39:58  Charles_Briggs]
 * 
 * Revision 4.2  91/09/19  22:57:27  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: fcntl.h,v $ $Revision: 4.2.2.8 $ (DEC) $Date: 92/04/24 15:20:46 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 * COMPONENT_NAME: SYSLFS - Logical File System
 *
 * ORIGINS: 27, 3, 26
 *
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _SYS_FCNTL_H_
#define _SYS_FCNTL_H_


#include <standards.h>
#include <sys/types.h>

/*
 * POSIX requires that certain values be included in fcntl.h and that only
 * these values be present when _POSIX_SOURCE is defined.  This header
 * includes all the POSIX required entries.
 */

#ifdef _POSIX_SOURCE

struct  flock   {
        short   l_type;
        short   l_whence;
        off_t   l_start;
        off_t   l_len;          /* len = 0 means until end of file */
        pid_t   l_pid;
};
/* file segment locking set data type - information passed to system by user */

/* file segment locking types */
#define F_RDLCK 1       /* Read (shared) lock */
#define F_WRLCK 2       /* Write (exclusive) lock */
#define F_UNLCK 8       /* Remove lock(s) */

#ifdef _NO_PROTO
extern int open();
extern int creat();
extern int fcntl();

#else 		/* use POSIX required prototypes */
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
#ifndef _KERNEL
extern int open(const char *, int , ...);
extern int creat(const char *, mode_t );
extern int fcntl(int , int ,...);
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _KERNEL */
#endif /* _NO_PROTO */

/* File status flags accessible to open(2) and fcntl(2) */
#define O_NONBLOCK 00000004	/* non-blocking I/O, POSIX style */
#define	O_APPEND   00000010  	/* append (writes guaranteed at the end) */

/* Mask for use with file access modes */
#define O_ACCMODE	3		

/* Flag values accessible to open(2) */
#define	O_RDONLY 00000000
#define	O_WRONLY 00000001
#define	O_RDWR	 00000002
 
/* Flag values accessible only to open(2) */
#define	O_CREAT	 00001000    /*  open with file create (uses third open arg)*/
#define	O_TRUNC	 00002000    /* open with truncation		*/
#define	O_EXCL	 00004000    /* exclusive open			*/
#define O_NOCTTY 00010000    /* POSIX REQUIRED */
#ifdef	_KERNEL
#define	O_DOCLONE 00020000    /* make a cloned device */
#endif

/* File descriptor flags used for fcntl() */
/* POSIX REQUIRED */
#define FD_CLOEXEC      1	/* Close this file during exec */

/* fcntl() requests */
#define	 F_DUPFD	0	/* Duplicate fildes		*/
#define	 F_GETFD	1	/* Get fildes flags		*/
#define	 F_SETFD	2	/* Set fildes flags		*/
#define	 F_GETFL	3	/* Get file flags		*/
#define	 F_SETFL	4	/* Set file flags		*/
#define	 F_GETLK	7	/* Get file lock	POSIX REQUIRED	*/
#define	 F_SETLK	8	/* Set file lock	POSIX REQUIRED	*/
#define	 F_SETLKW	9	/* Set file lock and waitPOSIX REQUIRED	*/

#endif /* _POSIX_SOURCE */

/*
 * File locking flags.  First 8 bits for various commands.  Rest
 * are for options to those commands.  Also need to define
 * end of file for file locking.
 */
#ifdef _KERNEL
#define GETFLCK         0x1     /* Get the file lock */
#define SETFLCK         0x2     /* Set the file lock */
#define CLNFLCK         0x4     /* Clean file locks */
#define VNOFLCK         0x8     /* File is locked */

#define RGETFLCK        0x10    /* Remote Get of file lock */
#define RSETFLCK        0x20    /* Remote Set of file lock */

#define SLPFLCK         0x100   /* Wait if blocked */
#define VRDFLCK         0x200   /* Read lock use */
#define VMANFLCK        0x400   /* Mandatory locking */
#define ENFFLCK         0x800   /* Enforcement mode locks */

#define MAXEND          0x7fffffff
#endif /* _KERNEL */


#ifdef _XOPEN_SOURCE

/* XOPEN REQUIRED  */
#define O_SYNC		00040000	/* synchronous write option */

#endif /* _XOPEN_SOURCE */

#ifdef _OSF_SOURCE

/* Additional fcntl requests */

#define	 F_GETOWN	5	/* get async I/O owner		*/
#define	 F_SETOWN	6	/* set async I/O owner		*/

/*
 * Flock call.
 */
#define LOCK_SH         F_RDLCK       /* shared lock */
#define LOCK_EX         F_WRLCK       /* exclusive lock */
#define LOCK_NB         4       	/* don't block when locking */
#define LOCK_UN         F_UNLCK       /* unlock */


/*
 * Flag values accessible to open(2) and fcntl(2)
 */

/* O_NDELAY was defined as O_NONBLOCK.  The two definitions have been
 * seperated but the code has been modified so both flags still exhibit
 * the same behavior.  They will exhibit seperate behaviors in a future
 * release
 */
#define O_DEFER		00000040	/* defered update		*/
#define O_NDELAY	00100000	/* Non-blocking I/O		*/


#define FNDELAY		O_NDELAY
#define	FAPPEND		O_APPEND
#define FASYNC		00100
#define	FCREAT		O_CREAT
#define	FTRUNC		O_TRUNC
#define	FSYNC		O_SYNC
#define	FEXCL		O_EXCL

#define	FNONBLOCK 	O_NONBLOCK
#define FDEFER		O_DEFER

/*
 * These may be AIX only values and should possibly be removed
 */

/* Flag values accessible only to open(2) */
#define	FOPEN		(-1)
#define	FREAD		00001
#define	FWRITE		00002
/*
 * DEC/OSF advisory flags for VOP_FSYNC calls.
 * These flags are additive with FWRITE.
 * Local filesystem types need not necessarily recognize them.
 * These flags are treated as mutually exclusive, and apply
 * to VREG files only.
 */
#define FWRITE_DATA     00004   /* Data blocks only */
#define FWRITE_METADATA 00010   /* Meta-Data blocks only */

#define FMARK           00020           /* mark during gc() */
#define FSHLOCK         00200           /* shared lock present */
#define FEXLOCK         00400           /* exclusive lock present */

/* FFCNTL is all the bits that may be set via fcntl. */
#define	FFCNTL	(FNONBLOCK|FNDELAY|FAPPEND|FSYNC|FASYNC) 

/* bits to save after open */
#define FMASK           (FSYNC|FASYNC|FAPPEND|FNDELAY|FNONBLOCK|FWRITE|FREAD)
#define FCNTLCANT       (FREAD|FWRITE|FMARK|FDEFER|FSHLOCK|FEXLOCK)

/* fcntl reqs for the lock mngr */
#define F_RGETLK        10      /* Test a remote lock */
#define F_RSETLK        11      /* Set or unlock a remote lock */
#define F_CNVT          12      /* Convert a fhandle to an open fd */
#define F_RSETLKW       13      /* Set or Clear remote lock(Blocking) */

/* additional flag for l_type field of flock structure */
#define F_UNLKSYS  4   /* remove remote locks for a given system */

/* extended file segment locking set data type */
struct eflock {
        short   l_type;         /* F_RDLCK, F_WRLCK, or F_UNLCK */
        short   l_whence;       /* flag to choose starting offset */
        long    l_start;        /* relative offset, in bytes */
        long    l_len;          /* length, in bytes; 0 means lock to EOF */
        pid_t	l_pid;          /* returned with F_GETLK */
        pid_t	l_rpid;         /* Remote process id wanting this lock */
        long    l_rsys;         /* Remote system id wanting this lock */
};


#endif	/* _OSF_SOURCE	*/
#endif	/* _SYS_FCNTL_H_ */


















