/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	lmf.h,v $
 * Revision 1.1.2.2  92/03/24  17:25:10  Carlos_Christensen
 * 	Created from ULTRIX 4.2
 * 	[92/03/09  15:41:27  Carlos_Christensen]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: lmf.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/03/24 17:25:10 $
 */
/*
 *            @(#)lmf.h	4.1     (ULTRIX)        7/2/90
 */

/* Definitions necessary to use lmf library. */

/************************************************************************
 *									*
 *			Modification history				*
 *									*
 *  19-Sep-89	Lisa Allgood
 *	Moved LMF_TOKEN and LMF_HARDWARE from lmfklic.h to here
 *  4-Jul-89	Giles Atkinson						*
 *	Add definition of allocation codes				*
 *  1-Jun-89	Giles Atkinson						*
 *	Add definition of flag argument to probe/test license		*
 *									*
 * Lisa Allgood - 4th May 1989						*
 *	Original version						*
 *									*
 ************************************************************************/

/*
 *	Structure to hold version number
 */


typedef struct version {
	short v_major;
	short v_minor;
} ver_t;

/* Flag values for probe/test license */

#define LMFF_MORE   (1<<16)		/* Always allocate another unit */

/* Values returned by lmf_license_info to indicate authorisation
 * without allocation of units.
 */

#define LMF_ACTIVITY -1			/* Product is activity licensed */
#define LMF_FAMILY   -2			/* Process is member of family */

/* Length of product token and hardware id fields for use with
 * the lmf_license_info() function.
 */

#define LMF_TOKEN	32
#define LMF_HARDWARE	32

int lmf_license_info();
int lmf_probe_license();
int lmf_release_license();
int lmf_test_license();
