/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	heap_kmem.h,v $
 * Revision 1.1.2.3  92/04/24  09:30:51  Robert_Picco
 * 	Changes for reentrant allocator
 * 	[92/04/16  08:50:06  Robert_Picco]
 * 
 * Revision 1.1.2.2  92/02/26  15:52:24  Charles_Briggs
 * 	UBC merge.
 * 	[92/02/22  15:13:23  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: heap_kmem.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/04/24 09:30:51 $
 */
#ifndef	__HEAP_KMEM__
#define	__HEAP_KMEM__ 1
#ifdef	KERNEL

extern struct h_kmem_info *
	h_kmem_alloc_init(/* register vm_size_t space, boolean_t canwait */);

/*
 * Default heap allocator
 */

extern struct h_kmem_info *h_kmem;
extern struct h_kmem_info *h_kmem_alloc_init();

#define h_kmem_alloc(N) 					\
		h_kmem_alloc_memory_(h_kmem, (N), TRUE)

#define h_kmem_alloc_memory(N, WAIT)				\
		h_kmem_alloc_memory_(h_kmem, (N), (WAIT))

#define	h_kmem_free(PTR, PTRSIZE) 				\
		h_kmem_free_memory_(h_kmem, (PTR), 		\
			(PTRSIZE), TRUE)

#define	h_kmem_free_memory(PTR, PTRSIZE, WAIT)			\
		h_kmem_free_memory_(h_kmem, (PTR), 		\
			(PTRSIZE), (WAIT))

#define	h_kmem_zalloc(N)					\
		h_kmem_zalloc_memory_(h_kmem, (N), TRUE)

#define	h_kmem_zalloc_memory(N, WAIT)				\
		h_kmem_zalloc_memory_(h_kmem, (N), (WAIT))

#define h_kmem_fast_alloc(PTR, PTRSIZE, CHUNKS)			\
		h_kmem_fast_alloc_memory_(h_kmem,(PTR), 	\
			(PTRSIZE), (CHUNKS), TRUE)	

#define	h_kmem_fast_alloc_memory(PTR, PTRSIZE, CHUNKS, WAIT)	\
		h_kmem_fast_alloc_memory_(h_kmem, (PTR),	\
			(PTRSIZE), (CHUNKS), (WAIT))

#define h_kmem_fast_zalloc_(PTR, PTRSIZE, CHUNKS)		\
		h_kmem_fast_zalloc_memory_(h_kmem, (PTR), 	\
			(PTRSIZE), (CHUNKS), TRUE)	

#define	h_kmem_fast_zalloc_memory(PTR, PTRSIZE, CHUNKS, WAIT)	\
		h_kmem_fast_zalloc_memory_(h_kmem, (PTR),	\
			(PTRSIZE), (CHUNKS), (WAIT))

#endif	/* KERNEL */
#endif	/* !__HEAP_KMEM__ */
