/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vpage.h,v $
 * Revision 1.1.2.2  92/02/26  16:13:49  Charles_Briggs
 * 	UBC merge.
 * 	[92/02/22  14:46:27  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vpage.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/26 16:13:49 $
 */
#ifndef	__VP_PAGE__
#define	__VP_PAGE__	1

/*
 * The vpage structure should have any information
 * the is of value for pushes a page out.  This
 * must be true for non K map operations.
 * It is possible that vpage might become pageable
 * in the future.  Care must be taken in acquiring
 * vpage information before taking any spin locks
 * in map entry handlers that require the vpage
 * information.
 */

struct vpage {

	/*
	 * Union of kernel and user vpage fields.  Identical ones
	 * must be in the same bit field position.
	 */

	union {
		struct {
		unsigned int
		_uvp_prot	: 3,		/* Keep protection here */
		_uvp_plock	: 1,		/* Page locked */
				: 28;
		} _uvp;
		struct {
		unsigned int
		_kvp_prot	: 3,		/* Same as user */
				: 5,
		_kvp_kwire	: 8,		/* Wiring count */
				:16;
		} _kvp;
	} _uvpage;
};

#define vp_prot		_uvpage._uvp._uvp_prot
#define vp_plock	_uvpage._uvp._uvp_plock
#define	vp_kwire	_uvpage._kvp._kvp_kwire

#ifdef	KERNEL
extern kern_return_t u_vpage_alloc(/* struct vm_map *map,
		vm_size_t size, struct vpage **vpp, boolean_t canwait */);
extern void u_vpage_free(/* struct vm_map *map, struct vpage *vp, 
		vm_size_t size, boolean_t canwait */);
extern kern_return_t u_vpage_reserve(/* struct vm_map *map, int increase */);
extern void u_vpage_free_reserve(/* struct vm_map *map, int decrease */);
extern void u_vpage_expand(/* struct vpage **vpp, vm_size_t oldsize,
		vm_size_t increase, int offset */);
#endif	/* KERNEL */

#endif	/* !__VP_PAGE__ */
