	SUBROUTINE GETCRD(CARDIN,NCHARS,IFLAG)
C	  ROUTINE TO READ A CARD IMAGE FFROM THE REMOTE LINE
C	  MAKES IT EASIER FOR TYPICAL USER PROGRAMS TO COMMUNICATE
C	  WITH THE UNIVAC SYSTEM. USES TTYOUT SUBROUTINE PACKAGE
C	  FOR ACTUAL INTERFACING WITH THE REMOTE LINE
C
C	  WRITTEN BY MICHAEL LAMPI   MAY, 1979
C
C	  CALLING PARAMETERS:
C		CARDIN	-  LOGICAL*1 ARRAY TO CONTAIN 80 CHAR. IMAGE
C		NCHARS	-  ACTUAL NUMBER OF CHARACTERS IN IMAGE
C		IFLAG	-  INDICATES WHETHER OR NOT A CARD WAS AVAILABLE
C			   TO BE READ; 0 IF NO CARD, 1 IF CARD RETURNED
C
	IMPLICIT INTEGER(A-Z)
	LOGICAL*1 CARDIN(80),BUFF(320)
	COMMON/GTCRD0/PROMPT,PRMPTF,BUFF,ISTRT,IEND,MAXBUF,INTFLG
C
	DATA RETFLG/0/,ISTRT,IEND/1,1/,MAXBUF/320/,LSTCHR/0/
	DATA PROMPT,PRMPTF/0,0/,INTFLG/0/
C
C	  CHECK IF THERE ARE ANY CHARACTERS AVAILABLE IN TTY BUFFER
C
 10	I=INPTT1(DUMMY)
	IF(I.LT.0) GOTO 20
C	  WE HAVE SOME INPUT - SEE IF WE SHOULD IGNORE IT
	I=I.AND."177
C	  FIRST CHECK TO SEE IF IT IS THE PROMPT CHAR.
	IF(I.EQ.PROMPT) PRMPTF=1
C	  NOW SEE IF WE HAVE TWO CONSECUTIVE <CR>'S
	IF(LSTCHR.EQ."15.AND.I.EQ."15) GOTO 10
	LSTCHR=I
C	  IGNORE NULLS & RUBOUTS & LINEFEEDS
	IF(I.EQ.0.OR.I.EQ."12.OR.I.EQ."177) GOTO 10
C	  IF WE GET HERE WE HAVE SOME REAL INPUT
	ISTRT=ISTRT+1
	IF(ISTRT.GT.MAXBUF) ISTRT=1
C	  CHECK IF THIS CHARACTER IS A <CR>
	IF(I.EQ."15) RETFLG=RETFLG+1
C	  PLACE IN TEMPORARY BUFFER
	BUFF(ISTRT)=I
C	  CHECK FOR OVERFLOW
	IF(ISTRT.EQ.IEND) CALL PRINT('**GETCRD buffer overflow**')
C	  GET SOME MORE INPUT
	GOTO 10
C
C	  SEE IF WE HAVE A FULL CARD IMAGE AVAILABLE
 20	IF(RETFLG.GT.0) GOTO 30
C	  NO - RETURN
C	  IF THIS IS AN INTERNAL CALL JUST RETURN
	IF(INTFLG.NE.0) RETURN
	IFLAG=0
	NCHARS=0
	RETURN
C
C	  WE HAVE A CARD - SEND TO CALLING ROUTINE
C	  IF THIS IS AN INTERNAL CALL JUST RETURN
 30	IF(INTFLG.NE.0) RETURN
	J=1
 35	IF(IEND.EQ.ISTRT) GOTO 40
	IEND=IEND+1
	IF(IEND.GT.MAXBUF) IEND=1
	CARDIN(J)=BUFF(IEND)
C	  CHECK FOR END OF IMAGE
	IF(CARDIN(J).EQ."15) GOTO 40
	J=J+1
C	  CHECK FOR LIMITS OF CARD BUFFER
	IF(J.GT.80) GOTO 55
	GOTO 35
C
C	  ZAP REMAINDER OF CARDIN
 40	IF(J.EQ.80.AND.CARDIN(80).NE."15) GOTO 55
	DO 50 K=J,80
	CARDIN(K)=0
 50	CONTINUE
 55	RETFLG=RETFLG-1
	IFLAG=1
	NCHARS=J
	RETURN
	END



	SUBROUTINE PUTCRD(CARD,IPRMPT,FLAG)
C	  ROUTINE TO SEND A CARD IMAGE TO THE REMOTE LINE (UNIVAC)
C	  WAITS FOR A PROMPT TO APPEAR BEFORE SENDING ANY DATA
C
C	  WRITTEN BY MICHAEL LAMPI   MAY 1979
C
C	  CALLING PARAMETERS:
C		CARD	- LOGICAL*1 ARRAY OF 80 ELEMENTS IN ASCIZ FORMAT
C		IPRMPT	- INTEGER*2 VARIABLE CONTAINING PROMPT
C		FLAG	- INTEGER*2 VARIABLE INDICATING SUCCESS/FAILURE:
C			  0 = SUCCESS, -1 = FAILURE (NO PROMPT RECEIVED)
C
	IMPLICIT INTEGER(A-Z)
	LOGICAL*1 CARD(80),BUFF(320)
	COMMON/GTCRD0/PROMPT,PRMPTF,BUFF,ISTRT,IEND,MAXBUF,INTFLG
C
C	  FIRST CALL GETCRD INTERNALLY TO GET LAST INPUT
	INTLFG=1
	CALL GETCRD(DUMMY,DUMMY,DUMMY)
	INTFLG=0
C	  NOW CHECK IF HE CHANGED PROMPT CHARACTERS ON US
	J=IPRMPT.AND."177
	IF(J.EQ.PROMPT.AND.PRMPTF.NE.0) GOTO 100
C	  YUP - NEW PROMPT CHARACTER OR NO PROMPT YET RECOGNIZED
	PROMPT=J
C	  NOW WE GOTTA SCAN THE BUFFER TO SEE IF NEW PROMPT IS THERE
	I=ISTRT
	PRMPTF=0
 10	K=BUFF(I)
	IF(K.EQ.PROMPT) GOTO 103
	IF(I.EQ.IEND) GOTO 20
	I=I+1
	IF(I.GT.MAXBUF) I=1
	GOTO 10
C	  NO PROMPT FOUND - RETURN WITH FLAG=-1
 20	FLAG=-1
	RETURN
C	  PROMPT CHAR WASN'T CHANGED - CHECK IF PROMPT WAS
C	  RECEIVED BY INPUT ROUTINE GETCRD
 100	IF(PRMPTF.EQ.0) GOTO 20
C	  PROMPT WAS FOUND - START TRANSMITTING
 103	DO 110 I=1,80
C	  CHECK FOR END OF CARD
	K=CARD(I)
	IF(K.EQ.0) GOTO 120
C	  SEND A CHARACTER AT A TIME
 105	IF(IOUTT1(K).NE.0) GOTO 105
 110	CONTINUE
C	  FINISHED TRANSFERRING CARD - RETURN WITH FLAG=0 (SUCCESS)
 120	FLAG=0
	PRMPTF=0
	RETURN
	END
