/******************************************************************;
;*                                                                *;
;*          INTEL CORPORATION PROPRIETARY INFORMATION.            *;
;*   THIS LISTING IS SUPPLIED UNDER THE TERMS OF A LICENSE        *;
;*   AGREEMENT OR NON-DISCLOSURE AGREEMENT WITH INTEL CORPORATION *;
;*   AND MAY NOT BE COPIED NOR DISCLOSED EXCEPT IN ACCORDANCE     *;
;*   WITH THE TERMS OF THAT AGREEMENT.                            *;
;*                                                                *;
;******************************************************************/

/* Flag values accessible to open(2) and fcntl(2) */
/*  (The first three can only be set by open) */
#define	O_RDONLY	0x00
#define	O_WRONLY	0x01
#define	O_RDWR		0x02
#define	O_NDELAY	0x04	/* Non-blocking I/O */
#define	O_APPEND	0010	/* append (writes guaranteed at the end) */
#define O_SYNCW		0x40

/* Flag values accessible only to open(2) */
#define	O_CREAT	0x0100	/* open with file create (uses third open arg)*/
#define	O_TRUNC	0x0200	/* open with truncation */
#define	O_EXCL	0x0400	/* exclusive open */

/* fcntl(2) requests */
#define	F_DUPFD	0	/* Duplicate fildes */
#define	F_GETFD	1	/* Get fildes flags */
#define	F_SETFD	2	/* Set fildes flags */
#define	F_GETFL	3	/* Get file flags */
#define	F_SETFL	4	/* Set file flags */

/* access requests */

#define F_OK   0   /* check existence of file */
#define X_OK   1   /* check if executable/searchable */
#define W_OK   2   /* check if writable (deleteable) */
#define R_OK   4   /* check if readable */
