;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Monitor program (subsystem 4)                                        *
;*****************************************************************************
;*      Purpose: Monitor program for EE424 SBC.  resides in lower portion of *
;*              the EPROM.  Responds to the following commands:              *
;*                      T = Type memory   (T SSSS,BBBB)                      *
;*                              SSSS = Start Address                         *
;*                              BBBB = Number of BYTES to type               *
;*                      M = Modify Memory (M SSSS)                           *
;*                              SSSS = Start Address                         *
;*                              Should display address & contents.  If <cr>  *
;*                              is pressed, mem remains unchanged, & next    *
;*                              address is displayed.  If a hex number & <CR>*
;*                              is enterd, changes that loction to the new   *
;*                              (entered) value & shows next address.  '$'   *
;*                              exits.                                       *
;*                      E = Execute Program     (E SSSS)                     *
;*                              SSSS = starting address                      *
;*                              End of program must be marked by a JMP to    *
;*                              @END_EXECUTION (hhhh)                        *
;*                      C = Copy Memory (C SSSS,DDDD,BBBB)                   *
;*                              SSSS = Starting Address of Source            *
;*                              DDDD = Starting Address of Destination       *
;*                              BBBB = Number of bytes to copy               *
;*****************************************************************************
;*      Last Rev: 18 Nov 95                                                  *
;*****************************************************************************
;*	Copyright Oct 1996 - Tom Burke - All rights reserved		     *
;*****************************************************************************
.model  small

org     0000h

.code
main    proc
        
        dtaseg  equ     0fe00h                  ;data segment
        stckseg equ     0f800h                  ;stack segment
        memstt  equ     08000h                  ;RAM start address (physical)
        memend  equ     03fffh                  ;RAM end address (physical)
        mode    equ     11101110b               ;USART mode
        comstat equ     00002h                  ;USART com/stat address
        txrx    equ     00004h                  ;USART Tx/Rx address
        parall  equ     00000h                  ;parallel port addr
        command equ     00005h                  ;USART command

@begin:                                         ;start of code        

        mov     ax,stckseg                      ;put memory segment in 
        mov     ss,ax                           ;stack register

        mov     ax,dtaseg                       ;put memory segment in 
        mov     ds,ax                           ;data segment register

        mov     ax,memstt                       ;mov start of RAM into DI
        mov     di,ax

        mov     ax,memend                       ;mov end of RAM into SP
        mov     sp,ax
        
        
        call    init_usart                      ;initialize USART


        @loop1:
                lea     dx,clrscr               ;print menu
                call    print_string
        
                call    read_char               ;read a character from term
                call    switch                  ;test for valid character
                                                ;if valid, goto appropriate
                                                ;routine
                
                lea     dx,prompt               ;"press any key to continue"
                call    print_string

                call    read_char
                
                jmp     @loop1




;*****  Set up some data  *****
        clrscr  db      01ah
        menu0   db      '                       Tom',39,'s monitor',13,10
        menu    db      13,10,13,10
        menu1   db      '                                    MENU'
        menu2   db      13,10
        menu3   db      '                                T SSSS,BBBB'
        menu4   db      13,10
        menu5   db      '                                M SSSS'
        menu6   db      13,10
        menu7   db      '                                E SSSS'
        menu8   db      13,10
        menu9   db      '                                C SSSS,DDDD,BBBB',13,10,10,'$'
        prompt  db      '                        -=<Press Any Key To Continue>=-$'

main    endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Code to print a string from memory                                   *
;*****************************************************************************
;*      Input:  DX contains offset of string -string must be terminated by $ *                                                                           
;*                                                                           *
;*      Output: String to screen                                             *
;*****************************************************************************
;*      Calls:  print_char                                                   *
;*****************************************************************************
;*      Last Rev: 9 Nov 95                                                   *
;*****************************************************************************
public  print_string

.code
print_string    proc
        push    dx                              ;save registers used
        push    si


        mov     si,dx                           ;set up source index

        xor     dx,dx                           ;clear DX

        @loop:
        ;if [SI] = '$'
                cmp     byte ptr [si],'$'       ;[SI] = '$' ?
        ;then
                je      @end                    ;end routine
        ;endif

                mov     dl,[si]                 ;print character in [SI]
                inc     si

                call    print_char

                jmp     @loop                   ;do it again

        @end:                                   ;done, exit routine

                pop     si                      ;restore registers
                pop     dx

                ret                             ;return

print_string    endp


;*****************************************************************************
;*      Tom burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Code to print a character the terminal                               *
;*****************************************************************************
;*      Input:  DL                                                           *
;*                                                                           *
;*      Output: character in DL to terminal                                  *
;*****************************************************************************
;*      Last Rev: 9 Nov 95                                                   *
;*****************************************************************************
public  print_char

.code
print_char      proc
        
        push    ax                              ;save registers used
        push    dx


@testing_txready:
        in      al,comstat                      ;get status of usart
        
;if usart not ready to get data
        and     al,1                            ;usart ready?
;then
        jz      @testing_txready                ;no, test again
;endif

        mov     al,dl                           ;output data
        out     txrx,al

        pop     dx                              ;restore registers
        pop     ax

        ret                                     ;return

print_char      endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Code to get character from terminal                                  *
;*****************************************************************************
;*      Returns received character in DL                                     *
;*****************************************************************************
;*      Last Rev: 9 Nov 95                                                   *
;*****************************************************************************
public  read_char

.code
read_char       proc
        
        push    ax                              ;save registers used


@testing_rxready:
        in      al,comstat                      ;get status of usart
        
;if usart not ready to send data
        and     al,2                            ;usart ready?
;then
        jz      @testing_rxready                ;no, test again
;endif

        in      al,txrx                         ;get data
        mov     dl,al                           ;move data to DL

        pop     ax

        ret                                     ;return

read_char      endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *   
;*****************************************************************************
;*      procedure to initialize usart                                        *
;*****************************************************************************
public  init_usart

.code
init_usart      proc
        mov     al,mode                         ;initialize USART
        out     comstat,al
        
        mov     al,command                      
        out     comstat,al

        ret                                     ;return

init_usart      endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: switch                                                    *
;*                                                                           *
;*      Purpose: tests for valid characters (T M E C t m e c)                *
;*              and switches to appropriate subroutine to run                *
;*****************************************************************************
;*      Input:  DL = character to be tested                                  *
;*                                                                           *
;*      Output: none                                                         *
;*****************************************************************************
;*      Calls: type_mem                                                      *
;*              modify_mem                                                   *
;*              exec_prog                                                    *
;*              copy_mem                                                     *
;*****************************************************************************
;*      Last Rev: 16 Nov 95                                                  *
;*****************************************************************************
public  switch

.code
switch   proc

;if DL = 'T'
        cmp     dl,'T'                          ;DL = 'T' ?
;then
        je      @call_t                         ;call t
;elseif DL = 't'
        cmp     dl,'t'                          ;DL = 't' ?
;then
        je      @call_t                         ;call t
;elseif DL = 'M'
        cmp     dl,'M'                          ;DL = 'M' ?
;then
        je      @call_m                         ;call m
;elseif DL = 'm'
        cmp     dl,'m'                          ;DL = 'm' ?
;then
        je      @call_m                         ;call m
;elsif DL = 'E'
        cmp     dl,'E'                          ;DL = 'E' ?
;then
        je      @call_e                         ;call e
;elsif DL = 'e'
        cmp     dl,'e'                          ;DL = 'e' ?
;then
        je      @call_e                         ;call e
;elsif DL = 'C'
        cmp     dl,'C'                          ;DL = 'C' ?
;then
        je      @call_c                         ;call c
;elsif DL = 'c'
        cmp     dl,'c'                          ;DL = 'c' ?
;then
        je      @call_c                         ;call c
;else
        jmp     @end_switch        
        
        @call_t:
                call    type_mem                ;goto type_mem
                jmp     @end_switch

        @call_m:
                call    modify_mem              ;goto modify_mem
                jmp     @end_switch

        @call_e:
                call    exec_prog               ;goto exec_prog
                jmp     @end_switch

        @call_c:
                call    copy_mem                ;goto copy_mem

        
        @end_switch:

                ret                             ;ret

switch  endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: print_crlf                                                *
;*                                                                           *
;*      Purpose: prints a <CR/LF>                                            *
;*****************************************************************************
;*      Input: none                                                          *
;*                                                                           *
;*      Output: CR/LF to terminal                                            *
;*****************************************************************************
;*      Calls: print_char                                                    *
;*****************************************************************************
;*      Last Rev: 20 Nov 95                                                  *
;*****************************************************************************
public  print_crlf

.code
print_crlf      proc

        push    dx                              ;save registers used

        mov     dl,13
        call    print_char
        mov     dl,10
        call    print_char

        pop     dx

        ret

print_crlf      endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: type_mem                                                  *
;*                                                                           *
;*      Purpose: displays BBBB bytes of memory from starting address SSSS    *
;*****************************************************************************
;*      Input: from keyboard, SSSS = 4 "digit" hex number                    *
;*                              BBBB = 4 "digit" hex number                  *
;*                                                                           *
;*      Output: displays BBBB bytes of memory starting from SSSS to screen   *
;*****************************************************************************
;*      Calls: get_hex_num                                                   *
;*              print_hex_num                                                *
;*              print_char                                                   *
;*              print_crlf                                                   *
;*****************************************************************************
;*      Last Rev: 18 Nov 95                                                  *
;*****************************************************************************
public  type_mem

type_mem        proc
        push    ax                              ;save registers used
        push    ds
        push    cx
        push    si
        push    dx        
        
        xor     cx,cx                           ;clear CX        

        call    print_char                      ;print out command

        mov     dl,' '                          ;print a space to delineate
        call    print_char

        
        mov     ax,0f800h
        mov     ds,ax                           ;move start of RAM to DS
        
        
        call    get_hex_num                     ;get start address in AX
        mov     ah,al
        call    get_hex_num                     ;get low byte
        mov     si,ax                           ;and move it to SI
        
        mov     dl,','                          ;print ',' to separate
        call    print_char

        call    get_hex_num                     ;get number of bytes in AX
        mov     ah,al                           
        call    get_hex_num                     ;get low byte
        mov     cx,ax                           ;and move it to CX

        call    clrscr1                         ;clear the screen

        @type_loop:
                mov     ax,si                   ;print address
                mov     al,ah
                call    print_hex_num
                mov     ax,si
                call    print_hex_num
                
                mov     dl,' '                  ;print space to delineate
                call    print_char
              
                mov     al,[si]                 ;get memory
                call    print_hex_num
                
                inc     si                      ;increment pointer

                call    print_crlf

                loop    @type_loop              ;repeat BBBB times

        pop dx                                  ;restore registers
        pop si
        pop cx
        pop ds
        pop ax

        ret                                     ;return
type_mem        endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: print_hex_num                                             *
;*                                                                           *
;*      Purpose: Print a hexadecimal number to the terminal                  *
;*****************************************************************************
;*      Input: AL = number to be printed                                     *
;*                                                                           *
;*      Output: number printed to terminal                                   *
;*****************************************************************************
;*      Calls: print_char                                                    *
;*****************************************************************************
;*      Last Rev: 18 Nov 95                                                  *
;*****************************************************************************
public  print_hex_num

.code
print_hex_num   proc
        push    ax                              ;save registers used
        push    dx
        push    cx

        mov     dl,al                           ;get high nibble
        mov     cx,4
        shr     dl,cl
        and     dl,0Fh                          ;mask low byte

;if DL > 9
        cmp     dl,9                            ;dl > 9 ?
;then
        jg      @1st_alpha
;endif

        add     dl,30h
        call    print_char

        jmp     @print_lower_nibble             ;print rest of number

        @1st_alpha:
                add     dl,55                   ;convert to A-F
                call    print_char


        @print_lower_nibble:
                mov     dl,al
                and     dl,0fh                  ;mask off high nibble

        ;if DL > 9
                cmp     dl,9                            ;dl > 9 ?
        ;then
                jg      @2nd_alpha
        ;endif
        
                add     dl,30h
                call    print_char

                jmp     @end_print_hex_num

                @2nd_alpha:
                        add     dl,55
                        call    print_char


                @end_print_hex_num:
                        pop     cx              ;restore registers
                        pop     dx
                        pop     ax

                        ret

print_hex_num   endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: clrscr1                                                   *
;*                                                                           *
;*      Purpose: clear the terminal screen                                   *
;*****************************************************************************
;*      Input: none                                                          *
;*                                                                           *
;*      Output: Cleared screen                                               *
;*****************************************************************************
;*      Last Rev: 28 Nov 95                                                  *
;*****************************************************************************
public  clrscr1

.code
clrscr1 proc
        
        push    dx                              ;Save registers used
        
        mov     dx,01ah                         ;print clrscreen character
        call    print_char
        
        pop     dx
        
        ret

clrscr1 endp



;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: get_hex_num                                               *
;*                                                                           *
;*      Purpose: Gets a 2-digit hex number from the terminal                 *
;*****************************************************************************
;*      Input: none                                                          *
;*                                                                           *
;*      Output: number stored in AL                                          *
;*****************************************************************************
;*      Last Rev: 20 Nov 95                                                  *
;*****************************************************************************
public  get_hex_num

.code
get_hex_num     proc
        push    dx                              ;save registers used
        push    cx
        
        @test1:
        call    read_char                       ;get a character

        cmp     dl,'0'
        jl      @test1
        cmp     dl,'9'
        jg      @test_for_hex1

        call    print_char                      ;print the character
        sub     dl,30h                          ;convert to number

        mov     al,dl                           ;move to al
        mov     cx,4                            ;put number in upper nibble
        shl     al,cl
        
        jmp     @test2

        @test_for_hex1:
        cmp     dl,'A'
        jl      @test1
        cmp     dl,'F'
        jg      @test1

        call    print_char                      ;print the character
        sub     dl,55                           ;convert to number
        
        mov     al,dl                           ;move to al
        mov     cx,4                            ;put number in upper nibble
        shl     al,cl                           
        


        @test2:
        call    read_char                       ;get a character

        cmp     dl,'0'
        jl      @test2
        cmp     dl,'9'
        jg      @test_for_hex2

        call    print_char                      ;print the character
        sub     dl,30h                          ;convert to number
        
        add     al,dl                           ;add the 2 nums together
        
        jmp     @end_get_hex_num

        @test_for_hex2:
        cmp     dl,'A'
        jl      @test2
        cmp     dl,'F'
        jg      @test2

        call    print_char                      ;print the character
        sub     dl,55                           ;convert to number

        add     al,dl                           ;add the 2 nums together


        @end_get_hex_num:
                pop     cx
                pop     dx

                ret

get_hex_num     endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: modify_mem                                                *
;*                                                                           *
;*      Purpose: Allows user to modify sections of memory, 1 byte at a time  *
;*****************************************************************************
;*      Input: memory address from keybboard                                 *
;*                                                                           *
;*      output: current memory address & value to screen                     *
;*              modified memory                                              *
;*****************************************************************************
;*      Calls: print_char                                                    *
;*              print_crlf                                                   *
;*              get_hex_num                                                  *
;*              print_hex_num                                                *
;*              read_char                                                    *
;*              convert_to_hex                                               *
;*****************************************************************************
;*      Last Rev: 20 Nov 95                                                  *
;*****************************************************************************
public  modify_mem

.code
modify_mem      proc
        push    dx                              ;save registers used
        push    ds
        push    di
        push    si
        push    ax


        call    print_char                      ;print choice

        mov     dl,' '                          ;print space to delineate
        call    print_char

        
        mov     ax,0f800h                       ;move DS to top of RAM
        mov     ds,ax

        
        call    get_hex_num                     ;get start address in AX
        mov     ah,al
        call    get_hex_num                     ;get low byte
        mov     si,ax                           ;move it to SI

        call    print_crlf                      ;clear the screen

        @modify_loop:
                mov     ax,si
                mov     al,ah
                call    print_hex_num           ;print high byte of address
                mov     ax,si           
                call    print_hex_num           ;print low byte of address

                mov     dl,' '                  ;print a space to delineate
                call    print_char

                mov     al,[si]                 ;get memory in AX
                call    print_hex_num           ;print num

                mov     dl,' '                  ;print a space to delineate
                call    print_char

                call    print_crlf

                mov     dl,':'                  ;print input prompt
                call    print_char


        @get_mem_value1:                
                
                call    read_char               ;get new value/CR/end

        ;if char = '$'
                cmp     dl,'$'                  ;DL = '$' ?
        ;then end
                je      @end_modify_memory      ;end
        ;endif

        ;if char = <CR>
                cmp     dl,13                   ;char = <CR> ?
        ;then
                je      @inc_mem_pointer        ;goto next address
        ;endif
        
        cmp     dl,'0'
        jl      @get_mem_value1
        cmp     dl,'9'
        jg      @test_mem_hex1

        call    print_char                      ;print the character
        sub     dl,30h                          ;convert to number

        mov     al,dl                           ;move to al
        mov     cx,4                            ;put number in upper nibble
        shl     al,cl
        
        jmp     @read_2nd_mem_char

        @test_mem_hex1:
        cmp     dl,'A'
        jl      @get_mem_value1
        cmp     dl,'F'
        jg      @get_mem_value1

        call    print_char                      ;print the character
        sub     dl,55                           ;convert to number
        
        mov     al,dl                           ;move to al
        mov     cx,4                            ;put number in upper nibble
        shl     al,cl                           
        


        @read_2nd_mem_char:
        call    read_char                       ;get a character

        cmp     dl,'0'
        jl      @read_2nd_mem_char
        cmp     dl,'9'
        jg      @test_mem_hex2

        call    print_char                      ;print the character
        sub     dl,30h                          ;convert to number
        
        add     al,dl                           ;add the 2 nums together
        
        jmp     @done

        @test_mem_hex2:
        cmp     dl,'A'
        jl      @read_2nd_mem_char
        cmp     dl,'F'
        jg      @read_2nd_mem_char

        call    print_char                      ;print the character
        sub     dl,55                           ;convert to number

        add     al,dl                           ;add the 2 nums together


        @done:

                mov     [si],al                 ;send new byte to RAM

                @inc_mem_pointer:
                        inc     si              ;point to next location

                        call    print_crlf      ;print cr/lf
                        
                        jmp     @modify_loop    ;start loop over


        @end_modify_memory:
                pop     ax                      ;restore registers
                pop     si
                pop     di
                pop     ds
                pop     dx

                ret

modify_mem      endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: convert_to_hex                                            *
;*                                                                           *
;*      Purpose: Converts a single character into its corresponding HEX      *
;*                      digit -- no error checking... assumes good hex digit *
;*****************************************************************************
;*      Input: character in DL                                               *
;*                                                                           *
;*      Output: upper nibble of DL=0000h lower nibble = value                *
;*****************************************************************************
;*      Last Rev: 27 Nov 95                                                  *
;*****************************************************************************
public  convert_to_hex

.code
convert_to_hex  proc

        cmp     dl,'9'
        jg      @convert_char

        sub     dl,30h                          ;convert to number

        jmp     @end_convert

        @convert_char:

        sub     dl,55                           ;convert to number
        
        mov     al,dl                           ;move to al
        
        @end_convert:

                ret

convert_to_hex  endp


;*****************************************************************************
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: exec_prog                                                 *
;*                                                                           *
;*      Purpose: Allows user to run a program entered in the RAM             *
;*                      user's program will return to the start of the       *
;*                      monitor program                                      *
;*****************************************************************************
;*      Input: Start location from terminal                                  *
;*                                                                           *
;*      Output: none                                                         *
;*****************************************************************************
;*      Last Rev: 27 Nov 95                                                  *
;*****************************************************************************
public  exec_prog

.code
exec_prog       proc

        push    dx                              ;save registers used
        push    ax
        push    bx


        call    print_char                      ;print choice

        mov     dl,' '                          ;print space to delineate
        call    print_char

        call    get_hex_num                     ;get start address in AX
        mov     ah,al
        call    get_hex_num                     ;get low byte

        call    print_crlf                      ;clear the screen
        
        mov     bx,ax                           ;jump to start of program
        call    bx

        
        pop     bx                              ;restore registers
        pop     ax
        pop     dx
        
        ret
exec_prog       endp


;*****************************************************************************        
;*      Tom Burke                                                            *
;*      338-68-9655                                                          *
;*****************************************************************************
;*      Procedure: copy_mem                                                  *
;*                                                                           *
;*      Purpose: copy one block of memory to a different location.           *
;*****************************************************************************
;*      Input: From terminal - starting address of block to be copied        *
;*                              number of bytes to copy                      *
;*                              starting address of destination block        *
;*                                                                           *
;*      Output: none - modified memory                                       *
;*****************************************************************************
;*      Last Rev: 27 Nov 95                                                  *
;*****************************************************************************
public  copy_mem

.code
copy_mem        proc

        push    di                              ;save registers used
        push    si
        push    ds
        push    ax
        push    cx
        push    es
        push    dx
        pushf


        mov     ax,0f800h                       ;mov DS to start of physical
        mov     ds,ax                           ;RAM

        mov     es,ax                           ;mov ES to start of physical
                                                ;RAM

        call    print_char                      ;print choice

        mov     dl,' '                          ;print space to delineate
        call    print_char

        call    get_hex_num                     ;get start address in AX
        mov     ah,al
        call    get_hex_num                     ;get low byte

        mov     dl,' '                          ;print space to delineate
        call    print_char

        mov     si,ax                           ;move address to SI


        call    get_hex_num                     ;get copy to address in AX
        mov     ah,al
        call    get_hex_num                     ;get low byte

        mov     dl,' '                          ;print space to delineate
        call    print_char

        mov     di,ax                           ;move address to DI


        call    get_hex_num                     ;get number of bytes in AX
        mov     ah,al
        call    get_hex_num                     ;get low byte


        CLD                                     ;clear dirsction flag

        mov     cx,ax

        @copy_loop:

                movsb                           ;move byte from DS:SI to
                                                ;ES:DI

                loop    @copy_loop


        popf                                    ;restore registers
        pop     dx
        pop     es
        pop     cx
        pop     ax
        pop     ds
        pop     si
        pop     di

        ret

copy_mem        endp



org     01ff0h                                  ;power on reset starts here

;          db     0eah,00h,0e0h,00h,0f0h           ;CS:IP = 0f000:0e000
                                                  ;physical = 0fe000h 
                                                  ;(direct jump)
           db     0eah,00h,060h,00h,0f8h
                    ;CS:IP = 0f800:06000


end

