/***************************************************************************

	PALASM text parser functions module

****************************************************************************/

#include	libc.h
#include	paltokes.inc
#include	pals.def

	/***   global vars   ***/
extern
char	*cptr,		/**  source line ptr  **/
	src_line[82],	/**  buffer for input source line  **/
	*errors[],	/**  common error messages ptr array  **/
	cur_phase;	/**  inversion phase of the current pin symbol  **/

char	symbuf[max_pins][9];	/**  symbol pin list  **/

extern
int	npins;		/**  number of PAL pins  **/

int	getline(),
	strcmp(),
	strncmp();

#define	no_skip FALSE
#define skip TRUE
#define pre_eof	errors[2]




/***************************************************************************
	get symbol function
   This function gets the pin name from the supplied text & puts it into
 the pin list array for later searching. it also checks for '/' if complement
 logic.
	entry -	flags = boolean place to put inversion
		indx = index int dest
	exit -	-1 = EOF
		-2 = Symbol error, contains reserved symbol
****************************************************************************/
int getsym(flags, indx)   char *flags; int indx;{
   static char	*symptr;
   static int	temp;

	/***   remove leading white space   ***/
   if (is_white(*cptr))   if (incr(skip) < 0)   return -1;

	/***   if delimiter then return err   ***/
   temp = isop(FALSE);
   if (temp != 0 && temp != invert)   return -temp;

	/***   set polarity flag if inversion symbol used   ***/
   if (temp == invert){
      flags[indx] = TRUE;
      if (incr(skip) < 0)   return -1;
      }
   else flags[indx] = FALSE;

	/***   fill symbol with spaces 1st   ***/
   symptr = &symbuf[indx][0];
   blanksym(symptr);

	/***   move symbol to table   ***/
   for (temp = 0; temp < 8 && !isdelim(*cptr); temp++){
      *symptr++ = *cptr;
      *symptr = '\0';
      incr(no_skip;
      }

	/***	waste any excess symbol   ***/
   next_field();

	/***   return good symbol   ***/
   return 0;
   }


/*********************************************************************
	white space function returns TRUE if whitespace or FALSE if
 not.
	entry -	p1= char to check
**********************************************************************/
int is_white(ch)   char ch;{

   switch (ch){
      case ' ':
      case '\t':
      case '\n':
         return TRUE;
      default:
         return FALSE;
      }
   }


/*********************************************************************
	position cptr to next field function
	exit -	-1= error
**********************************************************************/
int next_field(){

   while (!isdelim(*cptr))   if (incr(no_skip) < 0)   return -1;
   if (is_white(*cptr) || *cptr == ';')
      return incr(skip);
   else return 0;
   }


/**********************************************************************
	is delimiter function returns TRUE if char is valid delimiter
otherwise returns FALSE.
	entry -	p1= char
***********************************************************************/
int isdelim(ch)   char ch;{
   static char delims[] = {'=',';','/','*','+',':','(',
                           ')'};
   register int	cnt;

   if (ch == '\0' || is_white(ch))   return TRUE;
   for (cnt = 0; cnt < 8; cnt++)   if (ch == delims[cnt])   return TRUE;
   return FALSE;
   }


/**********************************************************************
	incr function
   This function gets next char from line & sets cptr to it
Blanks & chars after ';' are ignored if p1 is TRUE else treats blanks as
chars.
	entry -	p1= TRUE for skipping white space, FALSE for not
	returns -1 if read error (EOF)   else returns *cptr
***********************************************************************/
int incr(skip_flag)   int skip_flag;{
   static int	ch_cnt, flag;

   ch_cnt = 0;			/**  set flag to skip current char  **/

   if (skip_flag){
      while (TRUE){
         switch (*cptr){
            case '\0':   return -1;	/** EOF  **/

            case '\n':		/**  get fresh line of text  **/
            case ';':		/**  scrub this line  **/
               if ( *(cptr = getline(src_line)) == '\0')   return -1;
               cptr--;		/**  compensate for cptr++ at end of loop  **/
               break;

            case ' ':
            case '\t':
               break;
				/**  else treat as any other char  **/
            default:
               if (ch_cnt > 0)   return *cptr;

            }
         cptr++;
         ch_cnt++;
         }
      }
   else{
      while (TRUE){
         switch (*cptr){
            case '\0':   return -1;	/** EOF  **/

            case '\n':		/**  get fresh line of text  **/
               if (ch_cnt > 0)   return *cptr;

            case ';':		/**  scrub this line  **/
               if ( *(cptr = getline(src_line)) == '\0')   return -1;
               cptr--;
               break;

				/**  else treat as any other char  **/
            default:
               if (ch_cnt > 0)   return *cptr;

            }
         cptr++;
         ch_cnt++;
         }
      }
   return *cptr;
   }


/************************************************************************
	token compare function returns TRUE if string1 == string2 else
 returns FALSE.
	entry-	p1= string1 (variable)
		p2= string2 (constant)
		p3= max cnt
************************************************************************/
int tokn_cmp(str1, str2, max)   char *str1, *str2; int max;{
   static int	cnt;

   for ( cnt = max; cnt > 0; cnt--){
      if (isdelim(*str1) || *str2 == '\0')   break;	/**  end of token  **/
      if (*str1 != *str2)   return FALSE;	/**  not same  **/
      str1++; str2++;				/**  next char  **/
      }

	/***   if end of token then ==   ***/
   return (isdelim(*str1) && *str2 == '\0' && cnt != max) ?  TRUE : FALSE;
   }


/************************************************************************
	match function
   This function looks up the supplied symbol in the symbol buffer (pin
 list) & returns the pin number if found.
	entry -	bptr = ptr to symbol to be looked up
	returns	0: no match
		1..npins: pal pins

*************************************************************************/
int match(bptr)   char *bptr;{
   static int	cnt;

   for (cnt = 0; cnt < npins; cnt++)   if (tokn_cmp(bptr, &symbuf[cnt][0], 8)){
      next_field();		/**  ignore any EOF this time  **/
      return  cnt + 1;
      }
   return FALSE;
   }


/************************************************************************
	is operator function checks for possible operators
	entry -	p1= increment flag : TRUE will position cptr to next char
			after operator. FALSE will leave cptr as is.
	exit  -	0= not operator
		100..109= operators
*************************************************************************/
int isop(flag)   int flag;{
   static int	value, c_cnt;

   value = 0;
   c_cnt = 1;
   switch (*cptr){
      case ';':   value = scolon;	break;
      case '/':   value = invert;	break;
      case '*':   value = prodch;	break;
      case '+':   value = sumch;	break;
      case ':':
         if (strncmp(cptr, ":+:", 3) == 0){
            value = xor;
            c_cnt = 3;
            }
         else if (strncmp(cptr, ":*:", 3) == 0){
            value = xnor;
            c_cnt = 3;
            }
         else if (*(cptr +1) == '='){
            value = replace;
            c_cnt++;
            }
         break;
      case ')':   value = closeb;	break;
      case '=':   value = equal;	break;
      case '(':   value = openb;  	break;
      case 'I':
         if (tokn_cmp(cptr, "IF", 2)){
            value = IF;
            c_cnt++;
            }
         break;
      }
   if (value == 0)   return value;
   else if (flag){
      cptr += c_cnt;
      if (is_white(*cptr) || *cptr == ';')   incr(skip);
      }
   return value;
   }


/************************************************************************
	parser function returns a token corresponding to a pin name or
a constant operator.
	exit -	0= error, not found
		1..npins= pin numbers
		99= 'carry'
		100..110= binary operators
		150= 'FUNCTION TABLE'
		151= 'DESCRIPTION'
		200..213= fixed symbols
		-10= GND
		-20= Vcc
		-1= EOF
*************************************************************************/
int parse(){
   static int cnt, value;
   static char	*const[] =	{"FUNCTION TABLE", "DESCRIPTION", "CARRY",
				"GND", "FALSE", "VCC", "TRUE"};
   static char	slen[] = {14, 11, 5, 3, 5, 3, 4};
   static int	toke[] = {func, desc, carry, GND, GND, VCC, VCC};

	/***   if null line then EOF   ***/
   if (*cptr == '\0')   return -1;

	/***   first check for pin symbol   ***/
   value = match(cptr);
   if (value > 0)   return value;

	/***   next check for key words   ***/
   for (cnt = 0; cnt < 7; cnt++){
      if (tokn_cmp(cptr, const[cnt], slen[cnt]))   break;
      }

	/***   cnt < 7 means found in tables   ***/
   if (cnt < 7){
      value = toke[cnt];		/**  return token  **/
      cptr += slen[cnt];		/**  bump ptr  **/
      }

   if (value != 0){
      if (is_white(*cptr) || *cptr == ';')
         if (incr(skip) < 0)   return -1;
      return value;
      }
   return isop(TRUE);
   }



/***********************************************************************
	fill symbol name with blanks
	entry -	p1= ptr to 8 char + '\0' array
************************************************************************/
blanksym(symptr)   char *symptr;{

   strncpy(symptr, "        ", 9);
   }



