
;********************************************************
;*							*
;*	--  COLD START LOADER FOR CP/M V2.2  --		*
;*							*
;*	Russell Smith		7-October-80		*
;*	Herbert Koehl		5-MAR-82 added signon	*
;*      Herbert Koehl	       25-MAY-83 changed rev    *
;*							*
;********************************************************
;
	PSECT	ABS
;
MSIZE	EQU	60		;MEMORY CAPACITY IN KBYTES
MONITR	EQU	0F000H		;BASE ADDRESS OF MONITOR
	
EXTRA	EQU	MSIZE-20
BASE	EQU	.RES.(EXTRA*1024)-0200H
CBIOS	EQU	.RES.4A00H+BASE	;BASE OF CUSTOM BIOS
;
INSTAL	EQU	.RES.0900H-080H
;
CONOUT	EQU	0F00CH		;CONSOLE OUTPUT
;
;
CSRCHR	EQU	0FF76H		;CURSOR CHARACTER STORAGE LOCATION

CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED

	ORG	080H
	
	

BOOT:	EQU	$
	LD	A,'_'+080H	;CHANGE CURSOR TO BLINKING UNDERSCORE
;	LD	A,080H		;CHANGE CURSOR TO A BLINKING DELETE SYMBOL

	LD	(CSRCHR),A	;NOW BOOT CPM!!
	LD	E,0		;LOAD E WITH TRACK#
	LD	HL,.RES.3400H+BASE
	LD	BC,0D02H
	CALL	RDLOOP		;READ EVEN SECTORS ON TRK 0
	LD	HL,.RES.3480H+BASE
	LD	BC,0C03H
	CALL	RDLOOP		;READ ODD SECTORS ON TRK 0
	LD	C,1		;LOAD C WITH TRACK#
	CALL	MONITR+33	;CALL MONITOR SEEK ROUTINE
	JR	NZ,ERROR-$
	LD	HL,.RES.4080H+BASE
	LD	BC,0D01H	
	CALL	RDLOOP		;READ ODD SECTORS ON TRK 1
	LD	HL,.RES.4100H+BASE
	LD	BC,0D02H
	CALL	RDLOOP		;READ EVEN SECTORS ON TRK 1
	
	LD	HL,SIGNON	;PRINT SIGNON MESSAGE
	CALL	PMSG
	JP	CBIOS		;JUMP TO CP/M COLD START ENTRY
;
;
RDLOOP:	PUSH	HL		;SAVE PARAMETERS
	PUSH	BC
	CALL	MONITR+36	;CALL MONITOR DISK READ ROUTINE
	POP	BC
	POP	HL
	JR	NZ,ERROR-$	;READ ERROR IF Z FLAG SET
	INC	H		;BUMP DATA POINTER BY 256
	INC	C
	INC	C		;BUMP SECTOR# BY 2
	DJNZ	RDLOOP-$
	RET
;
;
ERROR:	LD	HL,MSG		;POINT TO ERROR MESSAGE
	CALL	PMSG		;CALL PRINT ROUTINE
	JP	MONITR+3	;JUMP BACK TO MONITOR

PMSG:	EQU	$
	LD	A,(HL)		;GET CHARACTER
	CP	'$'		;CHECK FOR END OF MESSAGE
	INC	HL
	RET	Z		;RETURN IF WE ARE AT THE END OF MESSAGE
	CALL	POUT		;OUTPUT TO MONITOR CONSOLE IF WE ARE NOT AT END
	JR	PMSG		;PRINT ANOTHER BYTE

POUT:	EQU	$
	JP	CONOUT		;CONSOLE OUTPUT
	
MSG:	EQU	$
	DEFM	'B'	;CREATE A FLASHING BOOT FAILED MESSAGE
	DEFM	'O'
	DEFM	'O'
	DEFM	'T'
	DEFM	' '
	DEFM	'F'
	DEFM	'A'
	DEFM	'I'
	DEFM	'L'
	DEFM	'$'
;
SIGNON:	EQU	$
	DEFB	01AH
	DEFM	'60K CP/M 2.2 |V1.4|'
	DEFB	LF
	DEFM	'$'
	END
