;	*************************************************
;	*						*
;	*			'TX'			*
;	*	FILE TRANSMIT UTILITY  V# 2.0 Dec 6, 79	*
;	*						*
;	*	FOR TRS-80 MODEL I & II			*
;	*		AND ONYX C8000 SYSTEMS.		*
;	*						*
;	*************************************************
;
;	*-----------------------------------------------*
;	* TO CUSTOMIZE TO A PARTICULAR SYSTEM, CHANGE   *
;	* THE EQUATES FOR VARIABLES :-			*
;	*	STAT,DATA,DRDY,TBE			*
;	*-----------------------------------------------*
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
MOD1	EQU	FALSE
MOD2	EQU	TRUE
C8000	EQU	FALSE

	IF	MOD1
BOOT	EQU	4200H		;WARM BOOT ENTRY (MOD I)
BDOS	EQU	4205H		;BDOS ENTRY (MOD I)
TBASE	EQU	4300H		;TPA START (MOD I)
	ENDIF
	IF	NOT MOD1
BOOT	EQU	0		; WARM BOOT ENTRY
BDOS	EQU	5		; BDOS ENTRY
TBASE	EQU	100H		; TRANSIENT PROGRAM STARTS HERE
	ENDIF
;
;	STANDARD I/O EQUATES
;
CONIN	EQU	1		; INPUT CHARACTER FROM CONSOLE
PRINT	EQU	9		; PRINT BUFFER
INLINE	EQU	10		; INPUT LINE (LENGTH, ACTUAL, TEXT)
;
;
; [[[[[[[[[[[[[[  CHANGE THESE VARIABLES ]]]]]]]]]]]]]]]]]
;
	IF	MOD1
STAT	EQU	99H	;STATUS PORT
DATA	EQU	99H	;DATA PORT
DRDY	EQU	99H	;DATA READY
TBE	EQU	99H	;TRANSMITTER BUFFER EMPTY
	ENDIF
	IF	MOD2
STAT	EQU	0F7H	;STATUS PORT SIO B
DATA	EQU	0F5H	;DATA PORT SIO B
DRDY	EQU	01H	;DATA READY
TBE	EQU	04H	;TRANSMITTER BUFFER EMPTY
	ENDIF
	IF	C8000
STAT	EQU	1AH	;STATUS PORT
DATA	EQU	18H	;DATA PORT
DRDY	EQU	1	;DATA READY
TBE	EQU	4	;TRANSMITTER BUFFER EMPTY
	ENDIF
;
;
;	BDOS DISK I/O EQUATES
;
OPEN	EQU	15		; OPEN FILE
MAKE	EQU	22		; MAKE FILE
SETBUF	EQU	26		; SET DISK BUFFER
READ	EQU	20		; READ DISK RECORD
WRITE	EQU	21		; WRITE DISK RECORD
CLOSE	EQU	16		; CLOSE DISK FILE
SEARCH	EQU	17		; SEARCH FOR FILE
	IF	MOD1
SFCB	EQU	425CH		;DEFAULT FCB (MOD I)
	ENDIF
	IF	NOT MOD1
SFCB	EQU	5CH		; DEFAULT FCB AREA
	ENDIF
;
CR	EQU	0DH		; CARRIAGE RETURN CHARACTER
LF	EQU	0AH		; LINE FEED CHARACTER
;
;
;

;	*********************************
;	*				*
;	*	Main Program Entry	*
;	*				*
;	*********************************
;
;
	ORG TBASE		; STANDARD TRANSIENT PROGRAM START ADDRESS
	CALL NORM$ENTRY	 ; SET UP STACK
	CALL MAKE$LINK		; ESTABLISH COMMUNICATION LINK WITH
				; OTHER MACHINE
MAIN:
 	CALL GET$NAMES		; HAVE USER ENTER FILE NAMES 
;	CALL MOV$NAMES		; MOVE FILE NAMES FROM DEFAULT BLOCK
	CALL OPEN$FILE		; ATTEMPT TO OPEN THE SOURCE FILE,
				; IF AN ERROR OCCURS, THE Z FLAG WILL
	JZ OPEN$ER		; BE SET, IF IT IS ABORT THE PROGRAM.
;
	CALL S$NAME		; TRANSMIT THE FILE NAME.
	CALL S$DATA		; SEND THE CONTENTS OF THE FILE
	CALL S$DONE		; SEND END SEQUENCE
 	CALL AGAIN		; SEE IF ANOTHER FILE IS TO BE TRANSMITTED
 	JZ MAIN		 ; YES DO IT AGAIN
;
	JMP EXIT		; TERMINATE NORMALLY
;
;
;
;
;
;
;	*****************************************
;	*	NORM ENTRY	(initial setup)	*
;	*****************************************
;
NORM$ENTRY:
	POP D			; GET RETURN ADDRESS OFF STACK
	LXI H, 0		; LOAD OLD STACK POINTER INTO HL
	DAD SP
	SHLD OLD$STK		; AND SAVE IT
	LXI SP, STACK		; SET THE NEW STACK POINTER
	XCHG			; HL = RETURN ADDRESS
	PCHL			; RETURN
;
;	*************************************************
;	*	MAKE LINK	(establish communication)	*
;	*************************************************
;
MAKE$LINK:
	LXI D,SIGN		; PRINT SIGN-ON
	MVI C, PRINT
	CALL BDOS
;
	MVI C, CONIN		; OK TO GO?
	CALL BDOS
	CPI 'Q'
	JZ EXIT		 ; ABORT!!
;
	MVI	B,10	;TRY TEN TIMES
TRYLNK:	MVI E, 'S'		; CHARACTER TO TRANSMIT
	CALL COMND		; SEND AND CHECK RESPONSE
	JZ	LINKOK		; LINKED!!
	DCR	B	;DOWNDATE COUNT
	JNZ	TRYLNK
	JMP HRD$ERR		; UNABLE TO ESTABLISH LINK, SO GIVE ERROR
;
LINKOK:
	LXI D, LINKED		; LINKED UP!
	MVI C, PRINT
	CALL BDOS	
	RET
;
;
;	*********************************************************
;	*	Get both source and destination file names	*
;	*********************************************************
;
;
;	Ask the user to enter both the source file and the destination file
;	The file names must be separated by a delimeter (space, comma, etc.)
;
GET$NAMES:
	LXI D, PROMPT1		; ASK FOR THE SOURCE FILE FIRST
	LXI H, FCB		; ADDRESS OF FILE CONTROL BLOCK
	CALL ASKFOR		; GET THE NAME, THEN SET UP FCB
;
	LXI D, PROMPT2		; ASK FOR THE DESTINATION FILE
	LXI H, FCB2		; FCB ADDRESS
	CALL ASK$FOR		; GET IT
	RET
;
;
;
ASK$FOR:
	PUSH	H	;SAVE FCB ADDR
	MVI C, PRINT		; TYPE MESSAGE USING PRINT SYSTEM CALL
	CALL BDOS
;
;	GET THE FILE NAME FROM THE CONSOLE
;
	MVI C, INLINE		; USE INLINE TO GET RESPONSE
	LXI D, INBUFF		;	THIS IS A SCRATCH BUFFER
	CALL BDOS
;
;	INBUFF now contains the filename in ASCII.	Convert
;	file name to file control blocks.
;	HL contains the FCB pointer
;
	POP	D	;GET FCB ADDR
	LXI	H,INBUFF+2	;ADDR OF CHAR STRING
	CALL	FFNTCB
	LXI	D,CRLF
	MVI	C,PRINT
	CALL	BDOS
	RET
;
; FORMAT FILE NAME TO CONTROL BLOCK.
;       ENTRY - HL = ADDRESS OF STRING
;               DE = ADDRESS OF FCB
;       EXIT  - HL = ADDRESS OF TERMINATOR
;               DE = ADDRESS OF FCB
EMPFCB:		;EMPTY FCB IMAGE
	DB	0
	DB	'           '	;11 BLANKS
	DW	0,0,0,0,0,0,0,0,0,0,0,0
;
FFNTCB: PUSH    D            ;SAVE FCB ADDRESS
	PUSH	H
	LXI	H,EMPFCB
	MVI	B,36	;MOVE EMPTY FCB IMAGE
FFNML:	MOV	A,M
	STAX	D
	INX	H	;UPDATE POINTERS
	INX	D
	DCR	B
	JNZ	FFNML
	POP	D	;STRING ADDRESS (WAS IN HL)
	POP	H	;FCB ADDRESS
	PUSH	H	;RE-SAVE FOR LATER USE
        MOV     M,0          ;SET TO DRIVE A
; NOTE HL STILL POINT TO DISK NO  IN FCB
        PUSH    H            ;SAVE FCB ADDRESS
        INX     H            ;POINT TO NAME IN FCB
        MVI     C,11         ;COUNT OF NAME LENGTH
        MVI     A,' '        ;BLANK
FFNC:   MOV     M,A          ;CLEAR NAME
        INX     H 
        DCR     C
        JNZ     FFNC
        POP     H            ;RECOVER FCB ADDRESS
        INX     D            ;MOVE TO 2ND CHAR OF STRING
        LDAX    D     
        CPI     ':'          ;IS DISK NAME PRESENT
        JNZ     NODN         ;NO
        DCX     D            ;YES, BACKUP AND GET LETTER
        LDAX    D
        ANI     3
        MOV     M,A          ;STORE NUMBER IN FCB
        INX     D            ;MOVE BACK TO COLON
        INX     D            ;MOVE TO FIRST CHAR OF NAME
        INX     D            ;COUNTERACT FOLLOWING DCX
NODN:   DCX     D            ;BACKUP TO 1ST CHAR OF NAME
        INX     H            ;MOVE TO NAME IN FCB
        MVI     C,8          ;MAXIMUM NAME LENGTH
FFNGN:  LDAX    D            ;GET NAME BYTE
        CPI     ' '          ;BLANK
        JNZ     FFNP         ;NO, THEREFORE NAME PRESENT
        INX     D            ;BYPASS BLANK
        JMP     FFNGN
FFNP:   LDAX    D            ;GET ID BYTE
        CPI     '/'          ;CHK IF END
        JZ      FFNX         ;YES
        CPI     21H          ;OR ANY CHAR <21H
        JC      FFNX         ;YES
        CPI     '.'          ;TYPE SEPARATOR
        JZ      FFNT         ;YES
        MOV     M,A          ;STORE NAME BYTE
        INX     D            ;BUMP PTRS
        INX     H 
        DCR     C            ;DECREMENT COUNT
        JP      FFNP         ;REPEAT
        STC                  ;SET ERROR
FFNX:   XCHG                 ;SET REGISTERS FOR EXIT
        POP     D            ;RESTORE FCB ADDRESS
        RET     
FFNT:   INX     D            ;BYPASS PERIOD
        MOV     A,C          ;CHECK IF COUNT 0
        ORA     A
        JZ      FFNGT        ;YES, GO STRAIGHT TO GET TYPE
FFNS:   INX     H            ;NO, SKIP TO TYPE IN FCB
        DCR     C
        JNZ     FFNS
FFNGT:  MVI     C,3          ;TYPE LENGTH
FFNGTC: LDAX    D            ;GET ID BYTE
        CPI     '/'          ;CHK IF END
        JZ      FFNX         ;YES
        CPI     21H
        JC      FFNX
        MOV     M,A          ;STORE NAME BYTE
        INX     D 
        INX     H 
        DCR     C            ;DOWNDATE COUNT
        JNZ     FFNGTC       ;GET NEXT TYPE CHAR
        JMP     FFNX

;
	*********************************
	*				*
	*	MOVE FCB'S		*
	*				*
	*********************************

MOV$NAMES:
	LXI	H,SFCB		; GET ADDRESS OF DEFAULT FCB
	MVI	B,32		; SET COUNT
	LXI	D,FCB		; SET DESTINATION
MOVAG:	MOV	A,M		; GET BYTE
	STAX	D
	INX	H		; UPDATE
	INX	D		; POINTERS
	DCR	B		; DOWNDATE COUNT
	JNZ	MOVAG		; IF COUNT NOT ZERO, DO IT AGAIN SAM
	RET			; FINISHED

;	*********************************
;	*	Open the file		*
;	*********************************
;
OPEN$FILE:
	MVI C, OPEN		; OPEN THE FILE USING SYSTEM CALL
	LXI D, FCB
	CALL BDOS
	CPI	0FFH		; SET Z FLAG IF ERROR
	RET			; IF THE FILE IS NOT FOUND THE S FLAG WILL
				; BE SET
;
;
;
;	*********************************
;	*	Send file name		*
;	*********************************
;
S$NAME:
	MVI E, 'F'		; LET THE OTHER UNIT KNOW A FILE NAME IS COMING
	CALL COMND		; ISSUE DOWN LINE, COMPARE RESPONSE
	JNZ HRD$ERR		; IF NOT THE SAME GIVE LINK ERROR
	CALL SS$NAME		; ACTUALLY SEND IT
;
	MVI E, 'O'		; ISSUE OPEN FILE COMMAND
	CALL COMND
	RZ			; IF GOOD, RETURN
;
	CPI 'H'		 ; SEE IF ITS THE 'FILE EXISTS' ERROR
	CZ FL$EXST		; SEE WHAT WE SHOULD DO
	JMP HRD$ERR
;
;
;
SS$NAME:
	MVI D, 16		; # OF CHARACTERS IN FILE NAME
	LXI H, FCB2		; START OF ASCII FILE NAME
	CALL SEND$BUF		; SEND THAT BUFFER
	JM HRD$ERR		; IF MINUS, WE GOT A HARD ERROR
	RET
;
;
;
;	*************************
;	*	SEND DATA	*
;	*************************
;
S$DATA:
	CALL SET$DISK		; SET THE DISK BUFFER ADDRESS
R$LOOP:
	CALL	PRREC		; PRESENT RECORD NUMBER
	CALL GET$REC		; GET RECORD FROM DISK
	CPI	00H		
	RNZ			; RETURN IF END OF FILE
	CALL DATA$TO		; TRANSMIT THAT SECTOR
	JM HRD$ERR		; IF ERROR RETURNED, EXIT
	CALL DO$WRT		; SIGNAL OK TO WRITE TO DISK
	JZ R$LOOP		; CONTINUE UNTIL END OF FILE IF NO ERROR
	CPI 'G'		 ; TEST FOR WRITE ERROR
	JZ DSK$PRB		; RECEIVER HAVING PROBLEMS WITH DISK
	JMP HRD$ERR		; SOME DATA LINK PROBLEM ...
DATA$TO:
	MVI E, 'R'		; SIGNAL THAT DATA RECORD FOLLOWS
	CALL COMND		; TRANSMIT IT
	JNZ HRD$ERR		; DATA LINK ERROR
;
	LXI H, SECTOR		; ADDRESS OF BUFFER TO TRANSMIT
	MVI D, 128		; SECTOR LENGTH
	CALL SEND$BUF		; TRANSMIT THAT BUFFER
	JM HRD$ERR		; ERROR IN TRANSMISSION, GIVE MESSAGE
	RET
;
;
;
;	*********************************
;	*	TRANSMIT DONE		*
;	*********************************
;
S$DONE:
	MVI B, 10		; NUMBER OF RETRIES
D$LOOP: PUSH B			; SAVE ON STACK
	MVI E, 'X'		; SEND END OF FILE MARKER
	CALL COMND
	POP B
	RZ			; RETURN IF ACK. IS OK
	CPI 'C'		 ; SEE IF ITS A CLOSE ERROR
	JZ CNT$CLS		; GIVE ERROR MESSAGE
	DCR B			; COUNT DOWN RETRIES
	JNZ D$LOOP		; TRY AGAIN
	JMP HRD$ERR		; STILL DIDNT GET RESPONSE SO ERROR
;
;
;
;	*********************************
;	*	DO IT AGAIN ??		*
;	*********************************
;
AGAIN:
	MVI	A,0
	STA	COUNTR
	STA	COUNTR+1
	STA	COUNTR+2	; RESET RECORD COUNT
	LXI D, SUCCESS		; PRINT ALLS WELL AND ASK FOR RESPONSE TO
	MVI C, PRINT		;	QUESTION: REPEAT OR EXIT
	CALL BDOS
;
	MVI C, CONIN		; GET CHARCTER FROM CONSOLE
	CALL BDOS
	CPI 'R'		 ; SEE IF ITS THE REPEAT COMMAND
	RET
;
;
;
FL$EXST:
	LXI	D,EXSMSG	; O/P FILE EXISTS MESSAGE
	MVI	C,PRINT
	CALL	BDOS
	JMP EXIT		; THE FILE EXISTS ON DESTINATION DISK
				; SO JUST EXIT FOR NOW.	LATER EXPAND ??
;
;
;
SET$DISK:
	LXI D, SECTOR		; ADDRESS OF DISK READ BUFFER
	MVI C, SETBUF		; SYSTEM CALL TO SET DISK READ ADDRESS
	CALL BDOS		; EXECUTE
	RET
;
;
;
GET$REC:
	MVI C, READ		; DISK READ FUNCTION 
	LXI D, FCB		; FILE CONTROL BLOCK IN USE
	CALL BDOS		; DO THE READ
	RET
;
;
;
DO$WRT: MVI E, 'W'		; COMMAND TO SIGNAL WRITE
	CALL COMND
	RET
;
;
;
COMND:	CALL SEND		; TRANSMIT THE COMMAND
	CALL RECEIVE		; WAIT FOR RESPONSE
	CMP E			; COMPARE TO TRANSMITTED CHARACTER
	RET
;	*********************************************************
;	*							*
;	*	Send buffer down the link and error check it	*
;	*							*
;	*********************************************************
;
;	TRANSMIT A BUFFER DOWN THE LINE.	D HAS THE LENGTH,
;	HL THE START ADDRESS.	IF HARD ERROR OCCURS, MINUS IS SET ON
;
;	Structure:
;			SEND$BUF
;			SEND$CK 
;			LOOP$B	CK$ERR
;			SEND	RECEIVE
;
;
SEND$BUF:
	SHLD POINT	; SAVE POINTER IN CASE OF RETRYS
	LXI H, COUNT	; SAVE BYTE COUNTER ALSO
	MOV M, D
	MVI A, 4	; NUMBER OF RETRIES - 1 LEFT
	STA RETRY	; STORE AT COUNTER
TRY$TO: CALL SEND$CK	; SEND THE BUFFER AND ERROR CHECK IT
	RZ		; IF 0, DATA OK.	IF NZ, THEN ERROR IN TRANSMISSION
	LDA RETRY	; SEE IF WE HAVE ANY RETRIES LEFT
	DCR A
	RM		; IF WE'VE DONE 5 THEN RETURN WITH M SET INDICATING
			; ERROR
	STA RETRY	; MORE LEFT, SO SAVE COUNT
	JMP TRY$TO	; AND TRY AGAIN
;
;
;
SEND$CK:
	XRA A		; CLEAR A
	STA ERR$CODE	; CLEAR ERROR CHECK CHARACTER
	LHLD POINT	; GET BUFFER POINTER
	LDA COUNT	; GET BYTE COUNT BACK
	MOV D, A
	CALL LOOP$B	; DUMP THE BUFFER TO THE PUNCH DEVICE
	CALL CK$ERR	; COMPARE THE ERROR CHECK
	RET
;
;
;
;	REALLY LOOP THROUGH THE SPECIFIED BUFFER AND CALL THE SEND
;	ROUTINE TO OUTPUT TO THE PUNCH
;
LOOP$B:
	MOV E, M		; GET THE CHARACTER
	LDA ERR$CODE		; GET THE ACCUMULATED ERROR CODE
	ADD E			; ADD IN THE CURRENT CHARACTER
	STA ERR$CODE		; PUT IT BACK
	CALL SEND		; ACTUALLY OUTPUT THE CHARACTER
	INX H			; INCREMENT THE POINTER
	DCR	D		; COUNT DOWN
	JNZ LOOP$B		; CONTINUE IF MORE LEFT
	RET
;
CK$ERR:
	CALL RECEIVE		; GET CHARACTER
	LXI H, ERR$CODE	 ; POINT TO THE ERROR CHECK CHARACTER
	SUB M			; SEE IF ITS THE SAME
	MVI M, 0		; STORE A ZERO IN ERROR CHECK CHARACTER
	RET			; ALWAYS RETURN, 0 = GOOD, NZ = BAD
;

	*************************************************
	*	PRESENT RECORD NUMBER ON SCREEN		*
	*************************************************

PRREC:
	CALL	UPCUNT		; FIRST UPDATE COUNT
	CALL	PRNMB		; THEN PRESENT NUMBER
	LXI	D,RECNO		; DISPLAY FOR OPERATOR
	MVI	C,PRINT
	CALL	BDOS
	RET

UPCUNT:
	LXI	H,COUNTR	; POINT TO COUNTER FIELD
	MVI	C,3		; SET TO DO 3*2=6 DIGITS
	CALL	NEXDEC
	RET

PRNMB:
	LXI	H,COUNTF	; POINTER TO FIELD WHERE TO STORE
	LXI	D,COUNTR+2	; ACTUAL COUNTER (LAST BYTE OF 3)
	MVI	B,3		; SET TO DISPLAY 3*2=6 DECIMAL DIGITS
PRREN:
	LDAX	D		; GET NUMBER
	PUSH	B		; SAVE COUNTER
	CALL	CONASC		; CONVERT TO ASCII
	MOV	A,B
	MOV	M,A
	INX	H
	MOV	A,C
	MOV	M,A
	POP	B
	DCX	D		; POINT TO LESS SIGNIFICANT DIGIT
	INX	H		; NEXT CHARACTER FIELD
	DCR	B		; DECREMENT COUNTER
	JNZ	PRREN		; DO NEXT
	RET

NEXDEC:
	MVI	B,1		; UPDATE WITH ONE
	MOV	A,M		; GET LEAST SIGNIFICANT DIGIT
	ADD	B
	MVI	B,0		; PREPARE FOR FURTHER CARRY FLOW
CUNTUP:
	DAA			; DO DECIMAL ADJUST
	JNC	CUNT1		; IF OVERFLOW (CARRY)
	MVI	A,0		; RESET DIGIT
CUNT1:
	MOV	M,A		; STORE RESULT
	INX	H		; NEXT DIGITS
	MOV	A,M		; GET MORE SIGNIFICANT DIGIT
	ADC	B		; ADD IN CARRY
	DCR	C		; GET COUNT, SEE IF LAST
	JNZ	CUNTUP		; NO, DO ONE MORE
	RET
	
CONASC:
	CALL	CONAS1		; SMART METHOD
	MOV	B,C
CONAS1:
	RRC
	RRC
	RRC
	RRC			; SHIFT 4 BITS AROUND (DECIMAL DIGITS)
	PUSH	PSW		; SAVE A
	ANI	0FH		; LOWER 4BITS
	ADI	030H		; MAKE ASCII DIGIT
	MOV	C,A		; RESULT IN C
	POP	PSW		; RESTORE A
	RET

;
;	*****************************************
;	*	SEND CHARACTER DOWN LINE	*
;	*****************************************
;
SEND:
	IN STAT		 ; GET STATUS FROM SERIAL DEVICE
	ANI TBE		; TEST BIT 1
	JZ SEND		 ; LOOP
	MOV A, E
	OUT DATA		; OUTPUT IT
	RET
;
;
;	*****************************************
;	*	RECEIVE CHARACTER FROM LINE	*
;	*****************************************
;
;
RECEIVE:
	IN STAT		 ; READ STATUS
	ANI DRDY		 ; MASK RECEIVER READY
	JZ RECEIVE		; WAIT UNTIL CHARCTER IS THERE
	IN DATA		 ; READ CHARACTER
	RET
;
;
;
;	*********************************
;	*	Exit Routines		*
;	*********************************
;
OPEN$ER:
	LXI D, NO$FLE		; CANT OPEN FILE SO ISSUE MESSAGE
	MVI C, PRINT		; AND THEN ABORT
	CALL BDOS
	JMP EXIT
;
HRD$ERR:
	LXI D, NO$LINK		; UNABLE TO MAINTAIN OR ESTABLISH STABLE
	MVI C, PRINT		;	DATA CHANNEL, SO ABORT
	CALL BDOS
	JMP EXIT
;
DSK$PRB:
	LXI D, DSK$BAD		; RECEIVEING UNIT HAS SIGNALED BAD DISK
	MVI C, PRINT		;	WRITE
	CALL BDOS
	JMP EXIT
;
CNT$CLS:
	LXI D, CCLOSE		; RECEIVER HAS INDICATED FILE CANT BE CLOSED
	MVI C, PRINT
	CALL BDOS
	JMP EXIT
;
;
;
EXIT:
	MVI E, 'Z'		; SIGN OFF
	CALL SEND
	LHLD OLD$STK		; LOAD OLD STACK POINTER IN HL
	SPHL			; RESTORE STACK POINTER
	RET			; GO HOME TO CCP
;
;	*********************************
;	*	Variable Storage	*
;	*********************************
;
;
PARAMS: DW	FCB		; FILE CONTROL BLOCK
	DW	INBUFF + 2	; POINT TO ASCII FILE NAME
;
COUNT	DS	1		; BYTE COUNTER
POINT	DS	2		; BUFFER POINTER
RETRY	DS	1		; RETRY COUNT
ERRCODE DS	1		; ERROR DETECTION CODE
INBUFF	DB	32		; INPUT BUFFER
	DS	34
;
SECTOR	DS	256
FCB	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
FCB2	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
OLD$STK DS	2
;
COUNTR:	DB	0,0,0		; 3 BYTE COUNTER
RECNO:	DB	' REC. NO: '
COUNTF:	DB	'000000',CR,'$'
;
CRLF:	DB	CR,LF,'$'
LINKED	DB	CR,LF,' TALKING TO RX SYSTEM...',LF,CR,'$'
SIGN	DB	CR, LF,' TX UTILITY	VERS 2.0'
	IF	MOD1	
	DB	' FOR TRS-80, MODEL I'
	ENDIF
	IF	MOD2
	DB	' FOR TRS-80, MODEL II'
	ENDIF
	IF	C8000
	DB	' FOR ONYX C8000'
	ENDIF
	DB	CR, LF,' HIT CR WHEN RX SYSTEM READY OR Q TO ABORT'
	DB	'$'
EXSMSG:	DB	CR,LF,' FILE ALREADY EXISTS ON RX SYSTEM $'
NO$FLE	DB	CR, LF, ' ERROR IN ATTEMPTING TO OPEN FILE','$'
PROMPT1 DB	CR, LF, ' SOURCE FILE: ','$'
PROMPT2 DB	' DESTINATION FILE: ', '$'
NO$LINK	DB	CR,LF, ' CONVERSATION STOPPED ...',CR,LF, '$'
BD$DAT	DB	CR, LF, ' HARD DATA TX ERROR', CR, LF, '$'
DSK$BAD DB	CR, LF, ' RX SYSTEM HAS UNRECOVERABLE DISK ERROR', CR, LF, '$'
SUCCESS DB	CR, LF, ' FUNCTION COMPLETE',CR, LF
	DB	07H,' FILE TRANSFERRED ', CR, LF
	DB	' TYPE R TO REPEAT, CR TO EXIT ', '$'
CCLOSE	DB	CR, LF, ' RX SYSTEM CANNOT CLOSE FILE', CR, LF, '$'
INIT$STR DB	0, 0, 0, 40H, 0AEH, 37H
STACK	EQU	$ + 40
	END
