;*************************************************************************
;	micro resources block lettering utility for cp/m
;*************************************************************************
;
; this program prints block letter character strings on the printer
; under the cp/m environment. command format is simply:
;	A>BLOCK<cr>
; program operation is self prompting at the console
; operator selects optional overprint characters and then
; has repetitive selection of text strings to print.
;
; block letter format is 12 x 12 matrix. character set includes
; full ascii character set including lower case.
;
;***********************************************************************
;
; This program is copyrighted by Micro Resources and as such
; this source code shall not be sold nor used for commercial
; purposes without permission from Micro Resources.
;
;
;	COPYRIGHT 1980
;	Micro Resources
;	2468 Hansen Ct.
;	Simi Valley, CA 93065
;	(805) 527-7922
;
;***********************************************************************
;
;
;cp/m bdos equates 
;
rdcon	equ	1
wrcon	equ	2
print	equ	9
rdstr	equ	10		;read input string from console
const	equ	11		;console stat
prtchar	equ	05h		;cp/m print char func code
bdos	equ	0005h		;cp/m bdos entry point
wboot	equ	0000h		;cp/m warm boot entry point
cr	equ	0dh		;carrage return code
lf	equ	0ah		;line feed code
;
;start of main program executable code
;
	org	0100h
	lxi	sp,stack
;
	call	ilprt		;print a sign on message
	db	cr,lf,lf,'Micro Resources Block Lettering Utility'
	db	cr,lf,'Version 1.5  Copyright 1980'
	db	cr,lf,0
;
	call	ilprt		;have operator select overprint characters
	db	cr,lf,'Select first overprint character '
	db	cr,lf,' (enter carriage return for each block'
	db	cr,lf,'  letter printed in its own symbol)     : ',0
;
	call	keyin		;get operator selection
	push	psw
	call	crlf
	pop	psw
	cpi	cr		;check if each indicator
	jz	opsech		;go process for each type
	sta	strbuf+1	;put the 1st overprint away
;
	call	ilprt		;have operator select second overprint char
	db	cr,lf,'Select second overprint character :',0
	call	keyin
	sta	strbuf+2	;save the 2nd overprint char
	call	crlf
	jmp	selstr
;
opsech:
	xra	a		;set to indicate each prints in own
	sta	strbuf+1
	sta	strbuf+2
;
selstr:
	call	ilprt		;prompt for a text string
	db	cr,lf,lf,'Select a text string for block letter'
	db	cr,lf,'printing. Carriage return to exit.    :',0
;
	mvi	a,09h		;set maximum input string size
	sta	inbuf
	lxi	d,inbuf		;point to buffer for cp/m
	mvi	c,rdstr		;read string function
	call	bdos		;get input
	lxi	d,inbuf+1	;get pointer to input length
	ldax	d		;get length
	ora	a		;see if done
	jz	wboot		;go warm boot if he is done
;
	inx	d		;point to first char in buffer
	sta	strbuf		;put length in print pass buffer
	mov	b,a		;setup for loop to move data
	lxi	h,strbuf+3	;point into pass buffer
move:
	ldax	d		;get a char from input buffer
	mov	m,a		;put in pass buffer
	inx	h		;do pointer adjust
	inx	d
	dcr	b		;all moved?
	jnz	move		;go do more moving if byte count
				;hasn't gone to zero
	lxi	d,strbuf	;point to the string print routine
	call	string		;go output his selection
	jmp	selstr		;go input next string
;
;gets a key code in from console
;
keyin:
	push	b		;save..
	push	d		;..all..
	push	h		;..regs
	mvi	c,rdcon		;get con char function code
	call	bdos		;get character
	pop	h		;restore..
	pop	d		;..all..
	pop	b		;..regs
	ret
;
;
;types via cp/m so tabs are expanded
;
ctype:
	push	b		;save..
	push	d		;..all..
	push	h		;..regs
	mov	e,a		;char to e
	mvi	c,wrcon		;get bdos fnc
	call	bdos		;prin the chr
	pop	h		;restore..
	pop	d		;..all..
	pop	b		;..regs
	ret			;from "ctype"
;
;
;type a carrage return line feed pair at console
;
crlf:
	mvi	a,cr
	call	ctype
	mvi	a,lf
	call	ctype
	ret
;
;
;
;
;inline print of msg
;
;the call to ilprt is followed by a message,
;binary 0 as the end.  binary 1 may be used to
;pause (message 'press return to continue')
;
ilprt:
	xthl			;save hl, get hl=msg
ilplp:
	mov	a,m		;get char
	ora	a		;end of msg?
	jz	ilpret		;..yes, return
	cpi	1		;pause?
	jz	ilpause		;..yes
	call	ctype		;type the character of message
ilpnext:
	inx	h		;to next char
	jmp	ilplp		;loop
;
;
;pause while typing so info doesn't
;	scroll off of video screens
;
ilpause:
	call	ilprt		;print:
	
	db	cr,lf,'press return to continue or ^c to exit'
	db	cr,lf,0
	call	keyin		;get any char
	cpi	'c'-40h		;reboot?
	jz	wboot		;yes.
	jmp	ilpnext		;loop
;
ilpret:
	xthl			;restore hl
	ret			; & return addr past message
;
;
;
;
;place to allocate storage for block letter printing
;
strbuf	ds	20		;buffer to pass string to
				;the string print routine
inbuf	ds	20		;buffer for cp/m input string
;
	ds	30		;save some stack space
stack:
	dw	0000		;initial stack pointer
;
;
;printer output routine
;entry with character in (a).
;
output:
	mov	e,a		;set char to reg for cp/m
	mvi	c,prtchar
	call	bdos
	ret
;
;
;block letter printing subroutine
;
;	entry: (de) = string start address
;		first byte of string is length of text
;		second byte is first overprint char
;		third byte is second overprint char
;			(if both above bytes are 00h
;			 then each char prints in its
;			 symbol)
;		fourth to n bytes are string of length
;			specified as first byte
;
;
;parameteric equates
;
maxlin	equ	012		;twelve lines per string
;
;
string:
	ldax	d		;get string length
	ora	a		;check for no length
	rz
;
	sta	strlen		;save string length
	inx	d
	ldax	d		;get first overprint char
	mov	c,a		;save first byte for each check
	sbi	020h		;see if char is printable
	cpi	05fh
	mov	a,c		;restore first char
	jc	frstok		;skip space substitute if ok
	mvi	a,' '		;substitute a space if not ok
frstok:
	sta	pat1		;save the print char
	inx	d
	ldax	d		;get second overprint char
	mov	l,a		;save temporary
	sbi	020h		;see if char is printable
	cpi	05fh
	mov	a,l		;restore second char
	jc	secok		;skip space substitute if ok
	mvi	a,' '		;substitute a space if not ok
secok:
	sta	pat2		;save second print char
	xra	a		;reset each flag initial
	sta	each
	mov	a,l		;check if each flag s/b set
	ora	c		;zero if each
	jnz	notech		;skip set if not each
	cma			;set flag if each
	sta	each
	jmp	notspc		;if each skip spc-spc check
notech:
	lda	pat1		;check if both print as spaces
	cpi	' '
	jnz	notspc
	lda	pat2
	cpi	' '		;check second for space also
	rz			;bale out if all print as spaces
notspc:
	inx	d		;get to start char of string
	xchg
	shld	strpnt		;save string pointer
	shld	strpos		;set start position
;
	mvi	a,01h		;set start line number
	sta	lineno
	sta	chrcnt		;set start character count
;
nextline:
	mvi	a,0ffh		;set the first pass flag
	sta	frstflg
;
	lda	each		;see if each, is so skip space check
	ora	a		;..if so
	jnz	nextchr
;
	lda	pat1		;see if pattern 1 is space
	cpi	' '
	jz	newline		;skip print if space
;
nextchr:
	lhld	strpos		;get current character
	mov	a,m
	sui	020h		;adjust ascii to zero based index
	cpi	07fh		;check for valid character
	jc	chok		;skip fixup if ok
	mvi	a,00h		;make invalid char a space
chok:
	mvi	b,012h		;calculate the char base address
	lxi	h,0000h		;zero initial index
	mvi	d,00h
	mov	e,a		;make double index
chrbc:
	dad	d		;loop to make 18*char base index
	dcr	b
	jnz	chrbc
	lxi	d,chrtbl	;get table base address
	dad	d
	xchg			;(de) = base of char in table
;
	lda	lineno		;get current line number
	rrc			;check even / odd
	jnc	evenln		;go get even line number pattern
	rlc			;fix up line number
	dcr	a
	mov	c,a
	add	c
	add	c
	ora	a
	rar			;(a) =  odd index=[(line num -1)*3] / 2
	mvi	h,0
	mov	l,a
	dad	d		;(hl) = odd pattern pointer
	mov	d,m
	inx	h
	mov	a,m
	ani	0f0h
	mov 	e,a
	xchg			;(hl) = bit pattern
	jmp	patprt
evenln:
	rlc			;fix up line number
	mov	c,a
	add	c
	add	c
	ora	a
	rar
	dcr	a
	dcr	a		;(a) = even index=[(line num*3) / 2] - 2
	mvi	h,0
	mov	l,a
	dad	d		;(hl) = even pattern pointer
	mov	d,m
	inx	h
	mov	e,m
	xchg
	dad	h
	dad	h
	dad	h
	dad	h		;(hl) = bit pattern
patprt:
	mvi	b,014		;set print loop count
	push	h
	lhld	strpos		;get string pointer
	lda	each		;see if each print
	ora	a
	jnz	prtech		;go select each code
	lda	frstflg		;if not each see which pass
	ora	a
	jz	gpat2		;go around to get pat # 2
	lda	pat1		;get pattern for pass 1
	mov	c,a
	jmp	gotpat		;go to got pattern exit
gpat2:
	lda	pat2		;get pattern number two
	mov	c,a
	jmp	gotpat
prtech:
	mov	c,m		;get current character
gotpat:
	inx	h		;set for next char
	shld	strpos
	pop	h		;get pattern back
prtlp:
	dad	h		;get carry equal to pattern bit
	mvi	a,' '		;set print for space
	jnc	prtblk		;for zero go do a space
	mov	a,c		;get char for pattern to print
prtblk:
	push	b		;save parameters
	push	h		;save pattern
	call	output		;send the char to output
	pop	h
	pop	b
	dcr	b		;dec the print count
	jnz	prtlp		;go do more bits if not done
;
	lxi	h,strlen	;check if done with current line
	lda	chrcnt
	cmp	m		;zero if count is same as length
	jz	newline		;get setup for next line
	inr	a		;set char count up by one
	sta	chrcnt		;save away
	jmp	nextchr		;go do next char on this line
newline:
	mvi	a,cr		;restore output to new line
	call	output
	lda	each		;check if each flag
	ora	a		;if not zero then skip second scan
	jnz	nsecscn
	lda	frstflg		;check if this is second pass
	ora	a
	jz	nsecscn		;go for new line if end of second pass
	xra	a		;set flag for second if this will be second
	sta	frstflg
	mvi	a,01h		;set char cnt back to one
	sta	chrcnt
	lhld	strpnt		;reset string scan pointer
	shld	strpos
	lda	pat2		;see if pattern two is space
	cpi	' '
	jz	newline		;skip print if all spaces
	jmp	nextchr		;go rescan line for second pass
;
nsecscn:
	mvi	a,lf
	call	output
	mvi	a,01h		;set char cnt back to one
	sta	chrcnt
	lhld	strpnt		;reset string scan pointer
	shld	strpos
	lda	lineno		;see if line number is at max
	cpi	maxlin
	jz	spac3		;go to space three lines
	inr	a		;bump line number
	sta	lineno
	jmp	nextline	;go print the next line
spac3:
	mvi	b,03h		;space output three lines
spac3l:
	push	b
	mvi	a,cr
	call	output
	mvi	a,lf
	call	output
	pop	b
	dcr	b
	jnz	spac3l
;
	ret			;exit from string print
;
;
;string print routine storage allocations
;
lineno	db	00h		;current line number
strlen	db	00h		;string length
strpnt	dw	0000h		;string start pointer
strpos	dw	0000h		;current string pointer
chrcnt	db	00h		;currently outputted char pointer
each	db	00h		;each as own print flag
pat1	db	00h		;store for print pattern # 1
pat2	db	00h		;store for print pattern # 2
frstflg	db	00h		;flag for first/second scan
;
chrtbl:
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
;							!
	db	006H,000H,060H,006H,000H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,000H,006H,000H,060H
;			              			"
	db	019H,081H,098H,019H,080H,000H,000H,000H,000H
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
;			              			#
	db	030H,0C3H,00CH,0FFH,0FFH,0FFH,030H,0C3H,00CH
	db	030H,0C3H,00CH,0FFH,0FFH,0FFH,030H,0C3H,00CH
;			              			$
	db	006H,007H,0FEH,0FFH,0FCH,063H,0C6H,00FH,0FEH
	db	07FH,0F0H,063H,0C6H,03FH,0FFH,07FH,0E0H,060H
;			              			%
	db	0E0H,03AH,006H,0E0H,0C0H,018H,003H,000H,060H
	db	00CH,001H,080H,030H,006H,007H,0C0H,058H,007H
;							&
	db	03FH,0C7H,0FEH,060H,066H,006H,030H,0C1H,098H
	db	03FH,006H,033H,0C1H,0ECH,00CH,0FFH,0E7H,0F3H
;			              			'
	db	00FH,000H,0F0H,00FH,000H,030H,006H,000H,0C0H
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
;			              			(
	db	002H,000H,060H,00CH,001H,080H,018H,001H,080H
	db	018H,001H,080H,018H,000H,0C0H,006H,000H,020H
;			              			)
	db	004H,000H,060H,003H,000H,018H,001H,080H,018H
	db	001H,080H,018H,001H,080H,030H,006H,000H,040H
;			              			*
	db	000H,000H,000H,066H,063H,06CH,01FH,087H,0FEH
	db	07FH,0E1H,0F8H,036H,0C6H,066H,000H,000H,000H
;			              			+
	db	000H,000H,000H,006H,000H,060H,006H,00FH,0FFH
	db	0FFH,0F0H,060H,006H,000H,060H,000H,000H,000H
;			              			,
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
	db	00FH,000H,0F0H,00FH,000H,030H,006H,000H,0C0H
;			              			-
	db	000H,000H,000H,000H,000H,000H,000H,00FH,0FFH
	db	0FFH,0F0H,000H,000H,000H,000H,000H,000H,000H
;			              			.
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
	db	000H,000H,000H,000H,000H,0F0H,00FH,000H,0F0H
;			              			/
	db	000H,030H,006H,000H,0C0H,018H,003H,000H,060H
	db	00CH,001H,080H,030H,006H,000H,0C0H,008H,000H
;			              			0
	db	03FH,0C7H,0FEH,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,07FH,0E3H,0FCH
;			              			1
	db	006H,000H,0E0H,01EH,000H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,060H,07FH,0E7H,0FEH
;			              			2
	db	07FH,0EFH,0FFH,0C0H,030H,003H,000H,030H,006H
	db	001H,080H,060H,018H,006H,000H,0FFH,0FFH,0FFH
;			              			3
	db	07FH,0EFH,0FFH,0C0H,030H,003H,000H,030H,01EH
	db	001H,0E0H,003H,000H,03CH,003H,0FFH,0F7H,0FEH
;			              			4
	db	003H,080H,078H,00DH,081H,098H,031H,087H,0FFH
	db	0FFH,0F0H,018H,001H,080H,018H,001H,080H,018H
;			              			5
	db	0FFH,0FFH,0FFH,0C0H,00CH,000H,0C0H,00FH,0F8H
	db	0FFH,0C0H,006H,000H,030H,003H,0FFH,0FFH,0FEH
;			              			6
	db	07FH,0EFH,0FFH,0C0H,03CH,000H,0C0H,00FH,0FEH
	db	0FFH,0FCH,003H,0C0H,03CH,003H,0FFH,0F7H,0FEH
;			              			7
	db	0FFH,0FFH,0FEH,0C0H,0C0H,018H,003H,000H,060H
	db	006H,000H,060H,006H,000H,060H,006H,000H,060H
;			              			8
	db	07FH,0EFH,0FFH,0C0H,03CH,003H,060H,063H,0FCH
	db	03FH,0C6H,006H,0C0H,03CH,003H,0FFH,0F7H,0FEH
;			              			9
	db	07FH,0EFH,0FFH,0C0H,03CH,003H,0C0H,03FH,0FFH
	db	0FFH,0F0H,003H,000H,03CH,003H,0FFH,0F7H,0FEH
;			              			:
	db	000H,000H,000H,00FH,000H,0F0H,00FH,000H,000H
	db	000H,000H,0F0H,00FH,000H,0F0H,000H,000H,000H
;							;	
	db	000H,000H,000H,00FH,000H,0F0H,00FH,000H,000H
	db	00FH,000H,0F0H,00FH,000H,030H,006H,000H,0C0H
;			              			<
	db	000H,040H,00CH,001H,080H,030H,006H,000H,0C0H
	db	00CH,000H,060H,003H,000H,018H,000H,0C0H,004H
;							=
	db	000H,000H,000H,000H,00FH,0FFH,0FFH,0F0H,000H
	db	000H,00FH,0FFH,0FFH,0F0H,000H,000H,000H,000H
;			              			>
	db	020H,003H,000H,018H,000H,0C0H,006H,000H,030H
	db	003H,000H,060H,00CH,001H,080H,030H,002H,000H
;			              			?
	db	07FH,0EFH,0FFH,0C0H,030H,003H,000H,030H,03FH
	db	007H,0E0H,060H,006H,000H,000H,006H,000H,060H
;			              			@
	db	03FH,0C7H,0FEH,0C0H,03CH,003H,0C6H,03CH,063H
	db	0C7H,0ECH,03CH,0C0H,00CH,000H,07FH,0F3H,0FFH
;			              			A
	db	07FH,0EFH,0FFH,0C0H,03CH,003H,0C0H,03FH,0FFH
	db	0FFH,0FCH,003H,0C0H,03CH,003H,0C0H,03CH,003H
;			              			B
	db	0FFH,0EFH,0FFH,0C0H,03CH,003H,0C0H,06FH,0FCH
	db	0FFH,0CCH,006H,0C0H,03CH,003H,0FFH,0FFH,0FEH
;			              			C
	db	07FH,0EFH,0FFH,0C0H,03CH,000H,0C0H,00CH,000H
	db	0C0H,00CH,000H,0C0H,00CH,003H,0FFH,0F7H,0FEH
;			              			D
	db	0FFH,08FH,0FCH,0C0H,06CH,003H,0C0H,03CH,003H
	db	0C0H,03CH,003H,0C0H,03CH,006H,0FFH,0CFH,0F8H
;			              			E
	db	0FFH,0FFH,0FFH,0C0H,00CH,000H,0C0H,00FH,0F0H
	db	0FFH,00CH,000H,0C0H,00CH,000H,0FFH,0FFH,0FFH
;			              			F
	db	0FFH,0FFH,0FFH,0C0H,00CH,000H,0C0H,00FH,0F0H
	db	0FFH,00CH,000H,0C0H,00CH,000H,0C0H,00CH,000H
;			              			G
	db	07FH,0EFH,0FFH,0C0H,03CH,000H,0C0H,00CH,000H
	db	0C1H,0FCH,01FH,0C0H,03CH,003H,0FFH,0F7H,0FEH
;			              			H
	db	0C0H,03CH,003H,0C0H,03CH,003H,0C0H,03FH,0FFH
	db	0FFH,0FCH,003H,0C0H,03CH,003H,0C0H,03CH,003H
;			              			I
	db	07FH,0E7H,0FEH,006H,000H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,060H,07FH,0E7H,0FEH
;			              			J
	db	03FH,0F3H,0FFH,003H,000H,030H,003H,000H,030H
	db	003H,000H,030H,0C3H,00CH,030H,0FFH,007H,0E0H
;			              			K
	db	0C0H,03CH,006H,0C0H,0CCH,018H,0C3H,00FH,0E0H
	db	0FEH,00CH,030H,0C1H,08CH,00CH,0C0H,06CH,003H
;			              			L
	db	0C0H,00CH,000H,0C0H,00CH,000H,0C0H,00CH,000H
	db	0C0H,00CH,000H,0C0H,00CH,000H,0FFH,0FFH,0FFH
;			              			M
	db	0C0H,03EH,007H,0F0H,0FDH,09BH,0CFH,03CH,063H
	db	0C0H,03CH,003H,0C0H,03CH,003H,0C0H,03CH,003H
;			              			N
	db	0C0H,03EH,003H,0F0H,03DH,083H,0CCH,03CH,063H
	db	0C3H,03CH,01BH,0C0H,0FCH,007H,0C0H,03CH,001H
;			              			O
	db	0FFH,0FFH,0FFH,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,0FFH,0FFH,0FFH
;			              			P
	db	0FFH,0EFH,0FFH,0C0H,03CH,003H,0C0H,03FH,0FFH
	db	0FFH,0ECH,000H,0C0H,00CH,000H,0C0H,00CH,000H
;			              			Q
	db	07FH,0EFH,0FFH,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C0H,03CH,033H,0C1H,0BCH,00FH,0FFH,0E7H,0FBH
;			              			R
	db	0FFH,0EFH,0FFH,0C0H,03CH,003H,0C0H,03FH,0FFH
	db	0FFH,0ECH,030H,0C1H,08CH,00CH,0C0H,06CH,003H
;			              			S
	db	07FH,0EFH,0FFH,0C0H,03CH,000H,0E0H,007H,0FCH
	db	03FH,0E0H,007H,000H,03CH,003H,0FFH,0F7H,0FEH
;			              			T
	db	0FFH,0FFH,0FFH,006H,000H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,060H,006H,000H,060H
;			              			U
	db	0C0H,03CH,003H,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,0FFH,0F7H,0FEH
;			              			V
	db	0C0H,03CH,003H,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C0H,036H,006H,030H,0C1H,098H,00FH,000H,060H
;			              			W
	db	0C0H,03CH,003H,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C6H,03CH,0F3H,0D9H,0BFH,00FH,0E0H,07CH,003H
;			              			X
	db	0C0H,03CH,003H,060H,063H,00CH,019H,080H,0F0H
	db	00FH,001H,098H,030H,0C6H,006H,0C0H,03CH,003H
;			              			Y
	db	0C0H,03CH,003H,060H,063H,00CH,019H,080H,0F0H
	db	006H,000H,060H,006H,000H,060H,006H,000H,060H
;			              			Z
	db	0FFH,0FFH,0FFH,000H,060H,00CH,001H,080H,030H
	db	006H,000H,0C0H,018H,003H,000H,07FH,0FFH,0FFH
;			              			[
	db	007H,080H,060H,006H,000H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,060H,006H,000H,078H
;			              			\
	db	0C0H,006H,000H,030H,001H,080H,00CH,000H,060H
	db	003H,000H,018H,000H,0C0H,006H,000H,030H,001H
;							]
	db	01EH,000H,060H,006H,000H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,060H,006H,001H,0E0H
;			              			^
	db	006H,000H,0F0H,01FH,080H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,060H,006H,000H,060H
;			              			_
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
	db	000H,000H,000H,000H,000H,000H,0FFH,0FFH,0FFH
;							`
	db	00FH,000H,0F0H,00FH,000H,0C0H,006H,000H,030H
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
;							a
	db	000H,000H,000H,000H,007H,0FCH,07FH,0E0H,003H
	db	000H,033H,0FBH,0FFH,0FCH,003H,07FH,0F3H,0FBH
;						    	b
	db	0C0H,00CH,000H,0C0H,00DH,0FCH,0FFH,0ECH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,0FFH,0EDH,0FCH
;							c
	db	000H,000H,000H,000H,003H,0FCH,07FH,0ECH,003H
	db	0C0H,00CH,000H,0C0H,00CH,003H,07FH,0E3H,0FCH
;							d
	db	000H,030H,003H,000H,033H,0FBH,07FH,0FCH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,07FH,0F3H,0FBH
;							e
	db	000H,000H,000H,000H,003H,0FCH,07FH,0ECH,003H
	db	0FFH,0FFH,0FFH,0C0H,00CH,003H,07FH,0E3H,0FCH
;							f
	db	007H,0C0H,0FEH,018H,031H,080H,018H,003H,0E0H
	db	03EH,001H,080H,018H,001H,080H,018H,001H,080H
;							g
	db	03FH,0B7H,0FFH,0C0H,03CH,003H,0C0H,03CH,003H
	db	07FH,0F3H,0FBH,000H,030H,003H,03FH,0E3H,0FCH
;							h
	db	0C0H,00CH,000H,0C0H,00DH,0FCH,0FFH,0ECH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,0C0H,03CH,003H
;							i
	db	003H,000H,030H,000H,000H,070H,007H,000H,030H
	db	003H,000H,030H,003H,000H,030H,003H,000H,030H
;							j
	db	000H,030H,003H,000H,000H,007H,000H,070H,003H
	db	000H,030H,003H,000H,031H,083H,00FH,0E0H,07CH
;							k
	db	000H,000H,000H,000H,00CH,003H,0C0H,06CH,00CH
	db	0C3H,00DH,0F8H,0F8H,0CCH,006H,0C0H,03CH,003H
;							l
	db	007H,000H,070H,003H,000H,030H,003H,000H,030H
	db	003H,000H,030H,003H,000H,030H,003H,000H,030H
;							m
	db	000H,000H,000H,000H,00CH,0CCH,0DFH,0EEH,073H
	db	0C6H,03CH,063H,0C6H,03CH,063H,0C6H,03CH,063H
;							n
	db	000H,000H,000H,000H,00CH,0FCH,0DFH,0EEH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,0C0H,03CH,003H
;							o
	db	000H,000H,000H,000H,003H,0FCH,07FH,0ECH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,07FH,0E3H,0FCH
;							p
	db	0DFH,0CFH,0FEH,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C0H,03FH,0FEH,0DFH,0CCH,000H,0C0H,00CH,000H
;							q
	db	03FH,0B7H,0FFH,0C0H,03CH,003H,0C0H,03CH,003H
	db	0C0H,037H,0FFH,03FH,0B0H,003H,000H,030H,003H
;							r
	db	000H,000H,000H,000H,00CH,0FCH,0DFH,0EEH,003H
	db	0C0H,00CH,000H,0C0H,00CH,000H,0C0H,00CH,000H
;							s
	db	000H,000H,000H,000H,003H,0FCH,07FH,0ECH,003H
	db	0E0H,007H,0FEH,000H,07CH,003H,07FH,0E3H,0FCH
;							t
	db	018H,001H,080H,07FH,087H,0F8H,018H,001H,080H
	db	018H,001H,080H,018H,001H,083H,00FH,0E0H,07CH
;							u
	db	000H,000H,000H,000H,00CH,003H,0C0H,03CH,003H
	db	0C0H,03CH,003H,0C0H,03CH,003H,07FH,0F3H,0FBH
;							v
	db	000H,000H,000H,000H,006H,006H,060H,066H,006H
	db	060H,066H,006H,030H,0C1H,098H,00FH,000H,060H
;							w
	db	000H,000H,000H,000H,00CH,063H,0C6H,03CH,063H
	db	0C6H,03CH,063H,0C6H,03CH,0E7H,07FH,0B3H,033H
;							x
	db	000H,000H,000H,000H,00CH,003H,060H,063H,00CH
	db	019H,080H,0F0H,019H,083H,00CH,060H,06CH,003H
;							y
	db	000H,000H,000H,000H,00CH,003H,060H,063H,00CH
	db	019H,080H,0F0H,00EH,000H,0C0H,018H,003H,000H
;							z
	db	000H,000H,000H,000H,00FH,0FEH,0FFH,0E0H,00CH
	db	003H,000H,0C0H,030H,00CH,000H,0FFH,0EFH,0FEH
;							{
	db	003H,000H,060H,006H,000H,060H,006H,001H,080H
	db	018H,000H,060H,006H,000H,060H,006H,000H,030H
;							|
	db	006H,000H,060H,006H,000H,060H,006H,000H,060H
	db	006H,000H,060H,006H,000H,060H,006H,000H,060H
;							}
	db	00CH,000H,060H,006H,000H,060H,006H,000H,018H
	db	001H,080H,060H,006H,000H,060H,006H,000H,0C0H
;							~
	db	038H,037H,0C6H,0C7H,0C8H,038H,000H,000H,000H
	db	000H,000H,000H,000H,000H,000H,000H,000H,000H
;
;
;
	end
;
