; BIOS FOR MICRO-2 COMPUTER
;VERSION M4.1
;INTERRUPTS ARE NOT IMPLEMENTED
;
;
;THIS VERSION CONTAINS DISK DRIVERS FOR THE DIGITAL SYSTEMS
;FDC-3 CONTROLLER BOARD.  THIS BOARD CAN HANDLE DOUBLE DENSITY
;
;	NOTE :  MSIZE DETERMINES WHERE THIS CBIOS IS LOCATED
MSIZE	EQU	64	;CP/M VERSION MEMORY SIZE IN KILOBYTES
VERS	EQU	41
PATCH	EQU	MSIZE*1024-2*256	;START OF THE CBIOS PATCH
;
;	WE WILL USE A SCRATCH AREA STARTING AT 40H
SCRAT	EQU	40H		;START OF SCRATCH AREA
TRACK	EQU	SCRAT		;CURRENT TRACK ON DRIVE 0
TRAK1	EQU	TRACK+1		;CURRENT TRACK ON DRIVE 1
TRAK2	EQU	TRAK1+1
TRAK3	EQU	TRAK2+1
SECTOR	EQU	TRAK3+1		;CURRENTLY SELECTED SECTOR
DMAAD	EQU	SECTOR+1		;CURRENT DMA ADDRESS
DISKNO	EQU	DMAAD+2		;CURRENT DISK NUMBER
DUMMY	EQU	DISKNO+1	;MUST BE 0 FOR DOUBLE ADD
ERRORS	EQU	DUMMY+1
PORT	EQU	4AH
PORTOUT	EQU	PORT+1
DENSITY	EQU	PORTOUT+1
;
;
	ORG	PATCH		;ORIGIN OF THIS PROGRAM
CBASE	EQU	(MSIZE-16)*1024	;BIAS FOR SYSTEMS LARGER THAN 16K
CPMB	EQU	CBASE+2900H	;BASE OF CP/M (= BASE OF CCP)
BDOS	EQU	CBASE+3106H	;BASE OF RESIDENT PORTION OF CP/M
CPML	EQU	$-CPMB		;LENGTH OF THE CP/M SYSTEM IN BYTES
NSECTS	EQU	CPML/128	;NUMBER OF SECTORS TO LOAD ON WARM START
WARMBOOT	EQU	CPMB-80H	;START OF WARM BOOT 
;
;SET UP INPUT OUTPUT PORTS
DATA	EQU	40H
STATUS	EQU	DATA+1
DATA1	EQU	48H
STATUS1	EQU	DATA1+1
DATA2	EQU	50H
STATUS2	EQU	DATA2+1
;
;
;	JUMP VECTOR FOR INDIVIDUAL SUBROUTINES
	JMP	CPMB		;COLD START
WBOTE:
	JMP	WBOOT		;WARM START
	JMP	CONST		;CONSOLE STATUS
	JMP	CONIN		;CONSOLE CHARACTER IN
	JMP	CONOUT		;CONSOLE CHARACTER OUT
	JMP	LIST		;LIST CHARACTER OUT
	JMP	PUNCH		;PUNCH CHARACTER OUT
	JMP	READER		;READER CHARACTER OUT
	JMP	HOME		;MOVE HEAD TO HOME POSITION
	JMP	SELDSK		;SELECT DISK
	JMP	SETTRK		;SET TRACK NUMBER
	JMP	SETSEC		;SET SECTOR NUMBER
	JMP	SETDMA		;SET DMA ADDRESS
	JMP	READ		;READ DISK
	JMP	WRITE		;WRITE DISK
ERR:
	JMP	ERRTN		;ROUTINE TO HANDLE DISK ERRORS
;
;	INDIVIDUAL SUBROUTINES TO PERFORM EACH FUNCTION
;
WBOOT:
;READ IN TRACK 0 SECTOR 2 WHICH WILL DO THE REST OF THE WARM START
;
	LXI	SP,80H		;USE SPACE BELOW BUFFER FOR STACK
	MVI	C,0		;SELECT DISK 0
	CALL	SELDSK
	CALL	HOME		;GO TO TRACK 00
;
;SET SINGLE DENSITY
	LDA	PORT
	ANI	0F7H
	STA	PORT
;SET DMA ADDRESS TO 80 BELOW START OF CCP
	LXI	B,WARMBOOT
	CALL	SETDMA
	MVI	C,2
	CALL	SETSEC
;NOW READ
	CALL	READ
	ORA	A	;ANY ERRORS?
	JNZ	WBOOT	;RETRY THE ENTIRE BOOT IF AN ERROR OCCURS
;
;
	JMP	WARMBOOT+3	;GO FINISH THE WARM START
;I/O HANDLERS
;
CONST:	;CONSOLE STATUS, RETURN 0FFH IF CHARACTER READY, 00H IF NOT
	IN	STATUS
	ANI	2
	RZ
	MVI	A,0FFH
	RET
;
CONIN:	;CONSOLE CHARACTER INTO REGISTER A
	IN	STATUS
	ANI	2
	JZ	CONIN
	IN	DATA
	ANI	7FH	;STRIP PARITY BIT
	RET
;
CONOUT: ;CONSOLE CHARACTER OUTPUT FROM REGISTER C
;
	CALL	CONST	;CHECK FOR TEMP STOP
	CNZ	CTRLS	;ANY CHAR. WILL STOP/START DISPLAY
	MOV	A,C	;GET CHAR. FOR CHECKS
	CPI	09H	;IS IT A TAB
	JZ	TABOUT
	CPI	0AH	;IS IT A LINE FEED
	JNZ	CONOT	;MUST BE VALID CHAR.
	XRA	A
	STA	LPOS	;CLEAR LINE COUNT AT END OF LINE
	JMP	CONOT+7	;JUMP AROUND LPOS
;
;
CONOT:	LDA	LPOS	;GET CHAR COUNT
	INR	A	;LPOS:=LPOS+1
	STA	LPOS
;
;
	IN	STATUS
	ANI	1
	JZ	CONOUT
	MOV	A,C
	OUT	DATA
	RET
;SPECIAL ROUTINES FOR CONSOLE
;
CTRLS:	;THIS ROUTINE WILL STOP AND START THE DISPLAY
	;WHEN OUTPUTING TO THE CONSOLE
;
	IN	DATA	;CLEAR STATUS PORT
	CALL	CONST	;WAIT FOR CHAR
	JZ	CTRLS+2	;FROM KEYBOARD
	IN	DATA	;CLEAR STATUS AND DATA PORTS FOR RETURN
	RET
;
;
TABOUT:	;THIS ROUTINE EXPANDS TABS FOR THE CONSOLE
;
;
	MVI	C,20H	;GET A SPACE
	CALL	CONOT	;OUTPUT IT
	LDA	LPOS	;TABS ARE 8 SPACES
	ANI	7
	RZ
	JMP	TABOUT+2;C REG DOESN'T GET TRASHED
;
;
;
;
LIST:	;LIST CHARACTER FROM REGISTER C
	MOV	A,C
	CPI	0DH
	RZ
	CPI	09H	;TAB CHAR
	JZ	LTABOT	;DUPLICATE OF CONSOLE VERSION 
			;BUT FOR LINE PRINTER
	CPI	0AH	;LINE FEED
	JNZ	LIST1	;MUST BE VALID CHAR
	XRA	A
	STA	LPOS	;WE WILL TRY TO USE THE SAME VARIABLE
	JMP	LIST1+7
;
LIST1:
	LDA	LPOS
	INR	A	;SAME AS CONSOLE
	STA	LPOS
	IN	STATUS1
	ANI	1
	JZ	LIST1+7
	MOV	A,C	;CHARACTER TO REGISTER A
	OUT	DATA1
	RET		;NULL SUBROUTINE
;
;
LTABOT:	;TAB EXPANDER FOR LINE PRINTER (IDENTICAL TO CONSOLE)
	MVI	C,20H
	CALL	LIST1
	LDA	LPOS
	ANI	7
	RZ
	JMP	LTABOT+2
;
;
LPOS:	DB	0	;VARIABLE FOR CONSOLE AND PRINTER
			;CHAR COUNT
;
;
PUNCH:	;PUNCH CHARACTER FROM REGISTER C
	IN	STATUS2
	ANI	1
	JZ	PUNCH
	MOV	A,C	;CHARACTER TO REGISTER A
	OUT	DATA2
	RET
;
;
READER: ;READ CHARACTER INTO REGISTER A FROM READER DEVICE
;	IN	STATUS2
;	ANI	2
;	JZ	READER
;	IN	DATA2
	RET
COMAND1	EQU	80H
STAT	EQU	80H
HADDR	EQU	81H
LADDR	EQU	82H
COMAND2	EQU	83H
;
;
;	I/O DRIVERS FOR THE DISK FOLLOW
;
HOME:	;MOVE TO THE TRACK O0 POSITION OF CURRENT DRIVE
	CALL	HEADLOAD
; H,L POINT TO WORD WITH TRACK FOR SELECTED DISK
HOMEL:
	MVI	M,00	;SET CURRENT TRACK PTR BACK TO 0
	IN	STAT	;READ FDC STATUS
	ANI	4	;TEST TRACK 0 BIT
	RZ		;RETURN IF AT 0
	STC		;DIRECTION=OUT
	CALL	STEP	;STEP ONE TRACK
	JMP	HOMEL	;LOOP
;
SELDSK:	;SELECT DISK GIVEN BY REGISTER C
;MAKE SURE DUMMY IS 0 (FOR USE IN DOUBLE ADD TO H,L)
	XRA	A
	STA	DUMMY
	MOV	A,C
	ANI	07H	;GET ONLY DISK SELECT BITS
	STA	DISKNO
	MOV	C,A
;SET UP THE SECOND COMMAND PORT
	LDA	PORT
	ANI	0F0H	;CLEAR OUT OLD DISK SELECT BITS
	ORA	C	;PUT IN NEW DISK SELECT BITS
	STA	PORT
	RET
;
SETTRK:	;SET TRACK GIVEN BY REGISTER C
	CALL	HEADLOAD
;H,L REFERENCE CORRECT TRACK INDICATOR ACCORDING TO
;SELECTED DISK
	MOV	A,C	;DESIRED TRACK
	CMP	M
	RZ		;WE ARE ALREADY ON THE TRACK
SETTKX:
	CALL	STEP	;STEP TRACK-CARRY HAS DIRECTION
			;STEP WILL UPDATE TRACK INDICATOR
	MOV	A,C
	CMP	M	;ARE WE WHERE WE WANT TO BE
	JNZ	SETTKX	;NOT YET
;HAVE STEPPED ENOUGH
SEEKRT:
;DELAY 10 MSEC FOR FINAL STEP TIME AND HEAD SETTLE TIME
	MVI	A,10D
	CALL	DELAY
	RET		;END OF SETTRK ROUTINE
;
DELAY:	;ROUTINE TO DELAY C(A) MILLISECONDS
	PUSH	B
DELAY2:
	MVI	C,0AAH	;ADJUST FOR 1 MSEC LOOP DELAY
			;THIS IS THE VALUE FOR OUR IMSAI
LDXA:
	DCR	C
	JNZ	LDXA	;LOOP 1 MSEC
	DCR	A
	JNZ	DELAY2
	POP	B
	RET		;END OF DELAY ROUTINE
;
SETSEC:	;SET SECTOR GIVEN BY REGISTER C
	MOV	A,C
	STA	SECTOR
	RET
;
SETDMA:	;SET DMA ADDRESS GIVEN BY REGISTERS B AND C
	MOV	L,C	;LOW ORDER ADDRESS
	MOV	H,B	;HIGH ORDER ADDRESS
	SHLD	DMAAD	;SAVE THE ADDRESS
	RET
;
;
READ:	;PERFORM READ OPERATION.
	;THIS IS SIMILAR TO WRITE, SO SET UP READ COMMAND AND USE
	;COMMON CODE IN WRITE
	MVI	B,040H	;SET READ FLAG
	JMP	WAITIO	;TO PERFORM THE ACTUAL I/O
;
WRITE:	;PERFORM A WRITE OPERATION
	MVI	B,080H	;SET WRITE COMMAND
;
WAITIO:
;ENTER HERE FROM READ AND WRITE TO PERFORM THE ACTUAL I/O 
;OPERATION.  RETURN A 00H IN REGISTER A IF THE OPERATION COMPLETES
;PROPERLY, AND 01H IF AN ERROR OCCURS DURING THE READ OR WRITE
;
;IN THIS CASE, WE HAVE SAVED THE DISK NUMBER IN 'DISKNO' 
;			THE TRACK NUMBER IN 'TRACK' 
;			THE SECTOR NUMBER IN 'SECTOR' 
;			THE DMA ADDRESS IN 'DMAAD' 
			;B STILL HAS R/W FLAG
	MVI	A,10D	;SET ERROR COUNT
	STA	ERRORS	;RETRY SOME FAILURES 10 TIMES
			;BEFORE GIVING UP
	PUSH	B
	CALL	HEADLOAD
;H,L POINT TO TRACK BYTE FOR SELECTED DISK
	POP	B
TRYAGN:
	MOV	C,M
; DECIDE WHETHER TO ALLOW DISK WRITE PROCOMPENSTATION
	MVI	A,39D	;PRECOMP SHOULD BE INHIBITED ON TRACKS 
			;0-39
	JM	ALLOWIT
;INHIBIT PRECOMP
	MVI	A,10H
	ORA	B
	MOV	B,A	;GOES OUT ON THE SAME PORT AS READ/WRITE
ALLOWIT:
	LHLD	DMAAD	;GET BUFFER ADDRESS
	PUSH	B	;B HAS R/W CODE   C HAS TRACK
	DCX	H	;SAVE AND REPLACE 3 BYTES BELOW
			;BUF WITH TRACK,SECTOR,ADDRESS MARK
	MOV	E,M
;FIGURE CORRECT ADDRESS MARK

	MVI	A,0FBH
			;0BH IS DOUBLE DENSITY 
			;0FBH IS SINGLE DENSITY
SIN:
	MOV	M,A
;FILL IN SECTOR
	DCX	H
	MOV	D,M
	LDA	SECTOR	;NOTE THAT INVALID SECTOR NUMBER
			;WILL RESULT IN HEAD UNLOADED
			;ERROR, SO DONT CHECK
	MOV	M,A
;FILL IN TRACK
	DCX	H
	POP	B
	MOV	A,C
	MOV	C,M
	MOV	M,A
	MOV	A,H	;SET UP FDC DMA ADDRESS
	OUT	HADDR	;HIGH BYTE
	MOV	A,L
	OUT	LADDR	;LOW BYTE
	MOV	A,B	;GET R/W FLAG
	OUT	COMAND1	;START DISK READ/WRITE
RWWAIT:	IN	STAT	;READ FDC STATUS
	ANI	088H	;TEST FOR HEAD UNLOAD OR IOF
	JZ	RWWAIT
	MOV	M,C	;RESTORE 3 BYTES BELOW BUF
	INX	H
	MOV	M,D
	INX	H
	MOV	M,E
	IN	STAT	;TEST FOR ERRORS
	ANI	0F0H
	RZ		;A WILL BE 0 IF NO ERRORS
	JMP	ERR
ERRTN:
;COME HERE ON ERROR FROM DISK
	PUSH	PSW	;SAVE ERROR CONDITION
;CHECK FOR 10 ERRORS
	LXI	H,ERRORS
	DCR	M
	JNZ	REDO	;NOT TEN YET.  DO A RETRY
;WE HAVE TOO MANY ERRORS. PRINT OUT HEX NUMBER FOR LAST
;RECEIVED ERROR TYPE. CPM WILL PRINT PERM ERROR MESSAGE.
	POP	PSW	;GET CODE
	RRC
	RRC
	RRC
	RRC
;MAKE IT ASCII
	ORI	030H
;SET ERROR RETURN FOR OPERATING SYSTEM
	MVI	A,1
	RET
REDO:
;B STILL HAS READ/WRITE FLAG
	POP	PSW	;GET ERROR CODE
	ANI	0E0H	;RETRY IF NOT TRACK ERROR
	JNZ	TRYAGN	;
;WAS A TRACK ERROR SO NEED TO RESEEK
	PUSH	B	;SAVE	READ/WRITE INDICATOR
;FIGURE OUT THE DESIRED TRACK
	LXI	D,TRACK
	LHLD	DISKNO	;SELECTED DISK
	DAD	D	;POINT TO CORRECT TRACK INDICATOR
	MOV	A,M	;DESIRED TRACK
	PUSH	PSW	;SAVE IT
	CALL	HOME
	POP	PSW
	MOV	C,A
	CALL	SETTRK
	POP	B	;GET READ/WRITE INDICATOR
	JMP	TRYAGN
;
;
;
STEP:				;STEP HEAD OUT TOWARDS ZERO
				;IF CARRY IS SET; ELSE
				;STEP IN
; H,L POINT TO CORRECT TRACK INDICATOR WORD
	JC	OUTX
	INR	M	;INCREMENT CURRENT TRACK BYTE
	MVI	A,04H	;SET DIRECTION = IN
DOSTEP:
	OUT	COMAND1	;SET DIRECTION BIT IN FDC
	ORI	2
	OUT	COMAND1	;PULSE STEP BIT
	ANI	0FDH
	OUT	COMAND1	;TURN OFF PULSE
;THE FDC-2 HAD A STEPP READY LINE. THE FDC-3 RELIES ON
;SOFTWARE TIME OUT
	MVI	A,8D	;WAIT FOR STEP READY
	CALL	DELAY
	RET
;
OUTX:
	DCR	M	;UPDATE TRACK BYTE
	XRA	A
	JMP	DOSTEP
;
HEADLOAD:
;SELECT AND LOAD THE HEAD ON THE CORRECT DRIVE
	LXI	H,PORTOUT	;OLD SLECT INFO
	MOV	B,M
	DCX	H	;NEW SELECT INFO
	MOV	A,M
	INX	H
	MOV	M,A
	OUT	COMAND2	;SELECT THE DRIVE
;SET UP H.L TO POINT TO TRACK BYTE FOR SELECTED DISK
	LXI	D,TRACK
	LHLD	DISKNO
	DAD	D
;NOW CHECK FOR NEEDING A 35 MS DELAY
;IF WE HAVE CHANGED DRIVES OR IF THE HEAD IS UNLOADED
;WE NEED0TO WAIT 35 MS FOR HEAD SETTLE
	CMP	B	;ARE WE ON THE SAME DRIVE AS BEFORE
	JNZ	NEEDDLY
;WE ARE ON THE SAME DRIVE
;IS THE HEAD LOADED?
	IN	STAT
	ANI	80H
	RZ		;ALREADY LOADED
NEEDDLY:
	XRA	A
	OUT	COMAND1	;LOAD THE HEAD
	MVI	A,35D
	CALL	DELAY
	RET
;
;
	END
