;	MDS-800 I/O DRIVERS FOR CP/M 2.0

;	(Double Density A:,B: & Single Density C:, D:)
;		(w/ Kludge for MDS 230)

;	VERSION 2.2   --    10 February 80

VERS	EQU	22	;VERSION 2.2

;	COPYRIGHT (C) 1978, 1979
;	DIGITAL RESEARCH
;	BOX 579, PACIFIC GROVE
;	CALIFORNIA, 93950

;	maclib	diskdef

false	equ	0
true	equ	not false

reloc	equ	true

	if not reloc
msize	equ	62	; memory size in kilobytes
ram$top	equ	msize*1024	; Top address+1
bios	equ	ram$top-0600h	; Basic Input/Output System
bdos	equ	bios-0e00h	; base of the BDOS
ccp	equ	bdos-0800h	; The Console Command Processor
	org	bios
	endif

	if reloc
	org	0		; or 0100h for REL-1
ccp	equ	$
bdos	equ	ccp+0800h
bios	equ	bdos+0e00h
msize	equ	0		; dummy for sign-on message
	org	0800h+0e00h	;plus another 0100h for rel-1
	endif


CPML	EQU	bios-ccp
NSECTS	EQU	CPML/128	;NUMBER OF SECTORS TO LOAD

CDISK	EQU	0004H	;ADDRESS OF LAST LOGGED DISK ON WARM START
BUFF	EQU	0080H	;DEFAULT BUFFER ADDRESS

RETRY	EQU	10	;MAX RETRIES ON DISK I/O BEFORE ERROR


;	JUMP VECTOR FOR INDIVIUAL ROUTINES

	JMP	BOOT
WBOOTE:	JMP	WBOOT
	JMP	constat
	JMP	conin
	JMP	conout
	JMP	list
	JMP	punch
	JMP	reader
	JMP	HOME
	JMP	SELDSK
	JMP	SETTRK
	JMP	SETSEC
	JMP	SETDMA
	JMP	READ
	JMP	WRITE
	jmp	list$st		; List Status poll
	jmp	sect$tran	; Sector Translation


;	WE ALSO ASSUME THE MDS SYSTEM HAS FOUR DISK DRIVES

NUM$DISKS 	EQU	4	;NUMBER OF DRIVES AVAILABLE

INT$CONT$1	EQU	0FDH	; Interrupt Priority Restore Port
INT$CONT$0	EQU	0FCH	; Interrupt Mask Port
MON$INT		EQU	0F3H	;INTERRUPT CONTROL PORT
INT$MASK	EQU	0111$1110B	;ENABLE RST 0(WARM BOOT), RST 7 (MONITOR)

;	MDS MONITOR EQUATES

mon80	equ	0f800h
RMON80	EQU	0FF0FH	;RESTART MON80 (BOOT ERROR)
ci	equ	0f803h
co	equ	0f809h
csts	equ	0f812h
ri	equ	0f806h
po	equ	0f80ch
lo	equ	0f80fh


;	DISK PORTS AND COMMANDS

BASE	EQU	78H	;BASE OF DISK COMMAND IO PORTS
DSTAT	EQU	BASE	;DISK STATUS (INPUT)
RTYPE	EQU	BASE+1	;RESULT TYPE (INPUT)
RBYTE	EQU	BASE+3	;RESULT BYTE (INPUT)

ILOW	EQU	BASE+1	;IOPB LOW ADDRESS (OUTPUT)
IHIGH	EQU	BASE+2	;IOPB HIGH ADDRESS (OUTPUT)

READF	EQU	4H	;READ FUNCTION
WRITF	EQU	6H	;WRITE FUNCTION
RECAL	EQU	3H	;RECALIBRATE DRIVE
IORDY	EQU	4H	;I/O FINISHED MASK
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED

SIGNON:	;SIGNON MESSAGE: XXk CP/M Vers X.Y
	DB	CR,LF
	DB	MSIZE/10+'0',MSIZE MOD 10 + '0'
	DB	'k CP/M vers '
	DB	VERS/10+'0','.',VERS MOD 10+'0'
	DB	CR,LF,0

BOOT:
	LXI	SP,BUFF+80H	; Temporary stack pointer


; set up MDS-800 Interrupts for 0 and 7 enabled

	DI
	MVI	A,12H	; give non-existant i8259 interrupt controller
	OUT	INT$CONT$1 ; it's intialization sequence
	XRA	A
	OUT	INT$CONT$0	; this actually allows pending interrupts
				;  on the MDS-800 to happen, but intel sez
				;  do it to it for the i8259 compatibility

	MVI	A,int$mask	;RST0 AND RST7 BITS ON
	OUT	INT$CONT$0
	XRA	A
	OUT	MON$INT		; mask all monitor board interrupts

;	Plug all Unused Interrupt Vectors with RST 7
;	so unexpected interrupts will breakpoint to MDSMON


	lxi	h, 8	; point to restart 1 location
	mov d,h ! mov e,l ; keep value 8 for increment
	mvi	c, 6	; we want to initialize six restarts
fill$loop:
	mvi	m,0ffh	; plug in a restart 7 instr.
	dad	d	; point to next restart location
	dcr	c	; drop count
	jnz	fill$loop ; and iterate

	lda	5	; get MDSMON's location 5 to save
	sta	hold$5	; for compatibility with MDS230

	XRA	A	;CLEAR ACCUMULATOR
	STA	CDISK	;SET INITIALLY TO DISK A/USER 0

	lxi h,sign$on ! call prmsg

	JMP	GOCPM	;GO TO CP/M


WBOOT:
	LXI	SP,0100H ; Temp Stack Pointer
WBOOT0:
	LXI	B,ccp	;SET DMA ADDRESS TO START OF DISK SYSTEM
	CALL	SETDMA

	MVI	C,0	;BOOT FROM DRIVE 0
	CALL	SELDSK
	CALL	HOME

	MVI	C,2	;START READING SECTOR 2
	CALL	SETSEC

;	READ SECTORS, COUNT NSECTS TO ZERO

	MVI	B,NSECTS

RDSEC:	;READ NEXT SECTOR
	PUSH	B	;SAVE SECTOR COUNT
	CALL	READ
	JNZ	WBOOT	;RETRY IF ERRORS OCCUR

	LHLD	IOD	;INCREMENT DMA ADDRESS
	LXI	D,128	;SECTOR SIZE
	DAD	D	;INCREMENTED DMA ADDRESS IN HL
	SHLD	IOD	; SAME AS SETDMA CALL

	LDA	IOS	;SECTOR NUMBER JUST READ
	CPI	26	;READ LAST SECTOR?
	JC	RD1

;	MUST BE SECTOR 26, ZERO AND GO TO NEXT TRACK

	LXI	H, IOT	; GET POINTER TO TRACK NUMBER
	INR	M	; AND ADD ONE TO IT
	XRA	A	;CLEAR SECTOR NUMBER
RD1:
	INR	A	;TO NEXT SECTOR
	STA	IOS	; SAME AS SETSEC
	POP	B	;RECALL SECTOR COUNT
	DCR	B	;DONE?
	JNZ	RDSEC


;
GOCPM:	;(ENTER HERE FROM COLD START BOOT)

;	set up page zero jumps to warm boot, BDOS, and MDSMON breakpoint

	MVI	A,JMP
	STA	0
	LXI	H,WBOOTE
	SHLD	1	;JMP WBOOT AT LOCATION 00
	STA	5
	LXI	H,BDOS+6
	SHLD	6	;JMP BDOS AT LOCATION 5
	STA	7*8	;JMP TO MON80 (MAY HAVE BEEN CHANGED BY DDT)
	LXI	H,RMON80
	SHLD	7*8+1

	LDA	CDISK	;LAST LOGGED DISK NUMBER
	MOV	C,A	;SEND TO CCP TO LOG IT IN
	EI
	JMP	ccp

conin:
	call	ci1
	ani	7fh
	ret
ci1:
	call	mon
	db	0ffh and ci
conout:
	call	mon
	db	0ffh and co
constat:
	call	mon
	db	0ffh and csts
list:
	call	mon
	db	0ffh and lo
reader:
	call	mon
	db	0ffh and ri
punch:
	call	mon
	db	0ffh and po

mon:				; Kludge patcher for loc 5
	lxi h,5 ! lda hold$5 ! mov m,a  ; restore MDSMON loc. 0005h
	xthl ! mov l,m ! mvi h,0f8h	; fetch & build mon call address
	call caller			; vector to appropriate MDSMON entry
	pop h ! mvi m, 0c3h		; restore CP/M's BDOS vector op code
	ret

caller:	pchl


list$st: 	; not implemented
	xra a ! ret

SELDSK:	;SELECT DISK GIVEN BY REGISTER C
	lxi h, 0 ! mov a,c ! cpi num$disks ! rnc  ; first, insure good select
	ani 2 ! sta dbank  		; then save it
	lxi h,sel$table ! mvi b,0 ! dad b ! mov a,m ! sta iof
	mov h,b ! mov l,c		; get drive code to HL
	dad h ! dad h ! dad h ! dad h	; multiply it times 16
	lxi d,dpbase ! dad d		; and make address of drive table
	ret

HOME:	;MOVE TO HOME POSITION
;	TREAT AS TRACK 00 SEEK
	MVI	C,0
;
SETTRK:	;SET TRACK ADDRESS GIVEN BY C
	LXI	H,IOT
	MOV	M,C
	RET
;
SETSEC:	;SET SECTOR NUMBER GIVEN BY C
	MOV	A,C	;SECTOR NUMBER TO ACCUM
	STA	IOS	;STORE SECTOR NUMBER TO IOPB
	RET
;
SETDMA:	;SET DMA ADDRESS GIVEN BY REGS B,C
	MOV	L,C
	MOV	H,B
	SHLD	IOD
	RET

sect$tran:		; Translate the Sector # in <C> if needed
	mov h,b ! mov l,c ! inx h  ; In case of no translation
	mov a, d ! ora e ! rz		; (TRANTAB) = 0, we return
	xchg ! dad b		; else, offset table by logical sector
	mov l,m ! mvi h,0	; then fetch (8 bit) physical sector
	ret


READ:	;READ NEXT DISK RECORD (ASSUMING DISK/TRK/SEC/DMA SET)
	MVI	C,READF	;SET TO READ FUNCTION
	JMP	SETFUNC
;
WRITE:	;DISK WRITE FUNCTION
	MVI	C,WRITF
;
SETFUNC:
;	SET FUNCTION FOR NEXT I/O (COMMAND IN REG-C)
	LXI	H,IOF	;IO FUNCTION ADDRESS
	MOV	A,M	;GET IT TO ACCUMULATOR FOR MASKING
	ANI	1111$1000B	;REMOVE PREVIOUS COMMAND
	ORA	C	;SET TO NEW COMMAND
	MOV	M,A	;REPLACED IN IOPB
;	SINGLE DENSITY DRIVE 1 REQUIRES BIT 5 ON IN SECTOR #
;	MASK THE BIT FROM THE CURRENT I/O FUNCTION
	ANI	0010$0000B	;MASK THE DISK SELECT BIT
	LXI	H,IOS		;ADDRESS THE SECTOR SELECT BYTE
	ORA	M		;SELECT PROPER DISK BANK
	MOV	M,A		;SET DISK SELECT BIT ON/OFF
;
WAITIO:
	MVI	C,RETRY	;MAX RETRIES BEFORE PERM ERROR
REWAIT:
;	START THE I/O FUNCTION AND WAIT FOR COMPLETION
	CALL	INTYPE	;IN RTYPE
	CALL	INBYTE	;CLEARS THE CONTROLLER

	LDA	DBANK		;SET BANK FLAGS
	ORA	A		;ZERO IF DRIVE 0,1 AND NZ IF 2,3
	MVI	A,IOPB AND 0FFH	;LOW ADDRESS FOR IOPB
	MVI	B,IOPB SHR 8	;HIGH ADDRESS FOR IOPB
	JNZ	IODR1	;DRIVE BANK 1?
	OUT	ILOW		;LOW ADDRESS TO CONTROLLER
	MOV	A,B
	OUT	IHIGH	;HIGH ADDRESS
	JMP	WAIT0		;TO WAIT FOR COMPLETE

IODR1:	;DRIVE BANK 1
	OUT	ILOW+10H	;88 FOR DRIVE BANK 10
	MOV	A,B
	OUT	IHIGH+10H

WAIT0:	CALL	INSTAT		;WAIT FOR COMPLETION
	ANI	IORDY		;READY?
	JZ	WAIT0

;	CHECK IO COMPLETION OK
	CALL	INTYPE		;MUST BE IO COMPLETE (00) UNLINKED
;	00 UNLINKED I/O COMPLETE,    01 LINKED I/O COMPLETE (NOT USED)
;	10 DISK STATUS CHANGED       11 (NOT USED)
	CPI	10B		;READY STATUS CHANGE?
	JZ	WREADY

;	MUST BE 00 IN THE ACCUMULATOR
	ORA	A
	JNZ	WERROR		;SOME OTHER CONDITION, RETRY

;	CHECK I/O ERROR BITS
	CALL	INBYTE
	RAL
	JC	WREADY		;UNIT NOT READY
	RAR
	ANI	11111110B	;ANY OTHER ERRORS?  (DELETED DATA OK)
	JNZ	WERROR

;	READ OR WRITE IS OK, ACCUMULATOR CONTAINS ZERO
	RET

WREADY:	;NOT READY, TREAT AS ERROR FOR NOW
	CALL	INBYTE		;CLEAR RESULT BYTE
	JMP	TRYCOUNT

WERROR:	;RETURN HARDWARE MALFUNCTION (CRC, TRACK, SEEK, ETC.)
;	THE MDS CONTROLLER HAS RETURNED A BIT IN EACH POSITION
;	OF THE ACCUMULATOR, CORRESPONDING TO THE CONDITIONS:
;	0	- DELETED DATA (ACCEPTED AS OK ABOVE)
;	1	- CRC ERROR
;	2	- SEEK ERROR
;	3	- ADDRESS ERROR (HARDWARE MALFUNCTION)
;	4	- DATA OVER/UNDER FLOW (HARDWARE MALFUNCTION)
;	5	- WRITE PROTECT (TREATED AS NOT READY)
;	6	- WRITE ERROR (HARDWARE MALFUNCTION)
;	7	- NOT READY
;	(ACCUMULATOR BITS ARE NUMBERED 7 6 5 4 3 2 1 0)

TRYCOUNT:
;	REGISTER C CONTAINS RETRY COUNT, DECREMENT 'TIL ZERO
	DCR	C
	JNZ	REWAIT	;FOR ANOTHER TRY

;	CANNOT RECOVER FROM ERROR
	mvi	a,1	;ERROR CODE
	RET

;	INTYPE, INBYTE, INSTAT READ DRIVE BANK 00 OR 10
INTYPE:	LDA	DBANK
	ORA	A
	JNZ	INTYP1	;SKIP TO BANK 10
	IN	RTYPE
	RET
INTYP1:	IN	RTYPE+10H	;78 FOR 0,1  88 FOR 2,3
	RET

INBYTE:	LDA	DBANK
	ORA	A
	JNZ	INBYT1
	IN	RBYTE
	RET
INBYT1:	IN	RBYTE+10H
	RET

INSTAT:	LDA	DBANK
	ORA	A
	JNZ	INSTA1
	IN	DSTAT
	RET
INSTA1:	IN	DSTAT+10H
	RET


;	UTILITY SUBROUTINES

PRMSG:	;PRINT MESSAGE AT H,L TO 0
	MOV A,M ! ORA A ! RZ
	PUSH H ! MOV C,A ! CALL conout ! POP h
	INX H ! JMP PRMSG


;	DATA AREAS (MUST BE IN RAM)

DBANK:	DB	0	;DISK BANK 00 IF DRIVE 0,1
			;	   10 IF DRIVE 2,3

IOPB:			;IO PARAMETER BLOCK
	DB	80H	;NORMAL I/O OPERATION
IOF:	DB	READF	;IO FUNCTION, INITIAL READ
ION:	DB	1	;NUMBER OF SECTORS TO READ
IOT:	DB	2	;TRACK NUMBER
IOS:	DB	1	;SECTOR NUMBER
IOD:	DW	BUFF	;IO ADDRESS
;
;

sel$table:
	DB	00H, 10H, 00H, 30H	; drive select bits

;	disks	num$disks		; generate drive tables
;	diskdef	0,1,52,,2048,243,128,128,2,0
;	diskdef	1,0
;	diskdef	2,1,26,6,1024,243,64,64,2,0
;	diskdef	3,2
;	endef
dpbase:
	dw	0,0	; double density uses no translate table
	dw	0,0
	dw	dirbuf, double$tab
	dw	csv0, alv0

	dw	0,0
	dw	0,0
	dw	dirbuf, double$tab
	dw	csv1, alv1

	dw	skew6, 0
	dw	0,0
	dw	dirbuf, single$tab
	dw	csv2, alv2

	dw	skew6, 0
	dw	0,0
	dw	dirbuf, single$tab
	dw	csv3, alv3

double$tab:
	dw	52	; sectors per track
	db	4	; 2**4 sectors per cluster
	db	15	; 2**4-1 (block mask)
	db	1	; extent mask
	dw	242	; number of last cluster
	dw	127	; directory size - 1
	db	0c0h	; two clusters for directory
	db	0	; alloc 2
	dw	32	; size of directory checksum vector
	dw	2	; system track offset

single$tab:
	dw	26	; sectors per track
	db	3	; 2**3 (=8) sectors per cluster
	db	7	; 2**3-1 (blick mask)
	db	0	; extent mask
	dw	242	; number of last cluster
	dw	63	; directory size - 1
	db	0c0h	; two clusters reserved for directory
	db	0	; alloc 2
	dw	16	; 16 sector directory
	dw	2	; two system tracks

skew6:
	db	1, 7, 13, 19, 25
	db	5, 11, 17, 23
	db	3, 9, 15, 21
	db	2, 8, 14, 20, 26
	db	6, 12, 18, 24
	db	4, 10, 16, 22
;
;	Everything past this point need not be loaded at
;	bootstrap time as it is not initialized.
;	Everything previous must fit onto the seven sectors of 128
;	bytes each left of the 2.0 system diskette.

;	In other words, this point must be <= BIOS+380h



begin$data equ	$
dirbuf	ds	128	; system directory buffer
alv0	ds	31
csv0	ds	32
alv1	ds	31
csv1	ds	32
alv2	ds	31
csv2	ds	16
alv3	ds	31
csv3	ds	16
end$data equ	$


hold$5	ds	1

	if	reloc
	db	0	; force out last address for relocation
	endif

	END
