;
; TITLE		UNIVERSAL DISK TO DISK COPY
; FILE NAME	UCOPY.ASM
; AUTHOR	ROBERT A. VAN VALZAH   6/23/78
; LAST REVISOR	R. A. V.   6/11/79
; REASON	REPAIRED BUG IN PRINTING OF BUFFER SIZE > 32K
;
;
	ORG	100H
ENTRY:			;NORMAL ENTRY
	JMP	MAIN
	MVI	A,0FFH	;DEBUG ENTRY
	JMP	POWERUP
MAIN:
	XRA	A	;CLEAR DEBUG FLAG
POWERUP:
	STA	DEBUG	;SAVE DEBUG MODE FLAG
	LXI	SP,STACK
	CALL	INITIALIZE
	CALL	COPY
	CALL	EXIT
	JMP	0	;BOOT
;
INITIALIZE:
	CALL	VECTRS	;OBTAIN VECTORS TO CBIOS ROUTINES
	CALL	SIZEMEM	;DETERMINE BUFFER SIZE
	CALL	INITVARS ;INITIALIZE RAM AREAS
	CALL	SIGNON
	CALL	PRTCONFIG ;PRINT CONFIGURATION
	CALL	LOADDISKS ;PROMPT USER TO LOAD COPY & MASTER
	RET
;
; SET UP LINKAGE TO BIOS ROUTINES
;
VECTRS:	JMP	GETVEC
WBOOTE:	JMP	3
CSTS:	JMP	6
CI:	JMP	9
CO:	JMP	12
LO:	JMP	15
PO:	JMP	18
RI:	JMP	21
HOME:	JMP	24
SELDSK:	JMP	27
SETTRK:	JMP	30
SETSEC:	JMP	33
SETDMA:	JMP	36
READ:	JMP	39
WRITE:	JMP	42
GETVEC:
	LDA	2	;GET PAGE OF BIOS
	MVI	B,14	;NUMBER OF JUMPS TO LINK
	LXI	H,WBOOTE+2 ;FIRST ADDRESS TO LINK
GETVE1:
	MOV	M,A	;LINK A JUMP
	INX H ! INX H ! INX H ;ON TO NEXT JUMP
	DCR	B
	JNZ	GETVE1
	RET
;
SIZEMEM:
	LHLD	1	;ADDRESS OF WARM BOOT ENTRY
	LDA	DEBUG	;IF DEBUG MODE - - -
	ORA	A
	JZ	BIGMEM
	LHLD	6	;USE ONLY RAM UP TO BASE OF DDT
BIGMEM:
	MVI	L,0	;TRUNCATE TO NEAREST 1/4 K
	XCHG		;MEMTOP -> DE
	LXI	H,-BUFFER ;FIRST BYTE OF BUFFER
	DAD	D	;DIFFERENCE IS LENGTH OF BUFFER
	MOV	A,L	;CONVERT LENGTH OF BUFFER TO NUMBER
	RAL		;OF SECTORS IT WILL HOLD
	MOV	A,H
	RAL
	MOV	L,A
	MVI	A,0
	RAL
	MOV	H,A
	SHLD	MAXSEC
	RET
;
INITVARS:
	MVI	A,0	;DEFAULT TO DRIVE A FOR MASTER
	STA	MDRIVE
	MVI	A,1	;DEFAUT TO DRIVE B FOR COPY
	STA	CDRIVE
	LXI	H,0	;FIRST SECTOR TO READ IS 0
	SHLD	NEXTSEC
	RET
;
SIGNON:
	CALL	MESSAGE
	DB	'UCOPY VERS .01', 13, 10, 0
	RET
;
MESSAGE:
	XTHL
MESSLOOP:
	MOV	A,M
	INX	H
	ORA	A
	JZ	MESSEXIT
	MOV	C,A
	PUSH	H
	CALL	CO
	POP	H
	JMP	MESSLOOP
MESSEXIT:
	XTHL
	RET
;
PRTCONFIG:
	CALL	MESSAGE
	DB	'BUFFER SIZE IS ', 0
	LHLD	MAXSEC
	MOV	A,H	;NINTH BIT INTO CARRY
	RAR
	MOV	A,L	;LOW 8 BITS INTO REG A
	RAR ! RAR ! RAR	;DIVIDE BY 8 TO GET K BYTES
	ANI	0011$1111B
	CALL	DECA	;PRINT SIZE IN K
	LHLD	MAXSEC	;NOW PRINT FRACTIONAL PART
	MOV	A,L
	ANI	0000$0111B
	ADD	A	;MULTIPLY BY 4
	ADD	A
	MOV	E,A
	MVI	D,0	;MAKE 16 BIT VALUE
	LXI	H,KTBL	;BASE OF FRACTIONAL PART TABLE
	DAD	D	;ADD INDEX TO BASE
	MVI	B,4	;MAX DIGITS TO PRINT FROM TABLE
PC1:
	MOV	A,M	;GET A DIGIT
	ORA	A	;END OF ENTRY?
	JZ	PCEXIT	;YUP - EXIT
	MOV	C,A	;NOPE - PRINT IT
	PUSH H ! PUSH B
	CALL	CO
	POP B ! POP H
	INX	H	;ON TO NEXT DIGIT
	DCR	B	;PRINTED THE WHOLE ENTRY?
	JNZ	PC1	;NOPE - PRINT MORE
PCEXIT:
	CALL	MESSAGE	;PRINT K BYTES
	DB	' K BYTES', 13, 10, 0
	RET
;
KTBL:			;TABLE OF FRACTIONAL K PARTS
	DB	0,0,0,0, '.125', '.25',0, '.375'
	DB	'.5',0,0, '.625', '.75',0, '.875'
;
;	DECA PRINTS THE NUMBER IN THE A REG AS A DECIMAL
;	NUMBER 0 - 255.  CLOBBERS A AND E.
;
DECA:
	MVI	E,-1 AND 255	;INITIALIZE QUOTITENT
;
;	THIS LOOP DIVIDES THE A REG BY 10 THRU MULTIPLE
;	SUBTRACTION.  QUOTIENT IS LEFT IN E REG,
;	REMAINDER-10 IS LEFT IN A.
;
LOOP:
	INR	E	;ADD ONE TO QUOTIENT FOR EACH SUBTRACT
	SUI	10
	JNC	LOOP	;HAVEN'T UNDERFLOWED YET
;
	ADI	'0' + 10	;CONVERT REMAINDER TO ASCII
	PUSH	PSW	;PUT THIS DIGIT ON THE STACK
	MOV	A,E	;GET REMAINDER -> A
	ORA	A	;DONE WITH ALL DIGITS?
	CNZ	DECA	;NO - DO THIS AGAIN WITH THE REMAINDER
;
;	THE ASCII NUMBER IS NOW UP ON THE STACK, MSD FIRST
;	TO COME OFF.  BDOS WILL PROBABLY RETURN HERE.
;
	POP	PSW
	MOV	C,A
	JMP	CO
;
LOADDISKS:
	CALL	MESSAGE
	DB	'MASTER ON DRIVE ', 0
	LDA	MDRIVE
	CALL	DRIVENAME
	CALL	MESSAGE
	DB	13, 10, 'COPY ON DRIVE ', 0
	LDA	CDRIVE
	CALL	DRIVENAME
RETMESS:
	CALL	MESSAGE
	DB	13, 10, 'THEN PRESS RETURN', 0
	CALL	CI
	CPI	13
	JNZ	RETMESS
	CALL	MESSAGE
	DB	13, 10, 0
	RET
;
DRIVENAME:		;PRINT DRIVE NUMBER IN REG A AS A - D
	ADI	'A'
	MOV	C,A
	CALL	CO
	RET
;
COPY:
	CALL	READBUF
	CALL	WRITEBUF
	JNC	COPY
	RET
;
READBUF:
	CALL	SELMAST
	LXI	B,BUFFER
	LHLD	MAXSEC
	XCHG		;MAX SECTORS -> DE
	LHLD	NEXTSEC	;SECTOR NUMBER TO READ NEXT
	SHLD	FIRSTSEC ;FIRST SECTOR READ INTO BUFFER
RB1:
	CALL	DMA	;SET DMA
	CALL	READSEC
	CALL	INCRSEC	;ON TO NEXT SECTOR, OUT OF SECTORS?
	JC	RBEXIT	;YUP
	CALL	INCRDMA	;MOVE DMA ADDRESS UP IN BUFFER
	DCX	D	;IS BUFFER FULL YET?
	MOV	A,D
	ORA	E
	JNZ	RB1	;NOPE - KEEP READING
RBEXIT:
	SHLD	NEXTSEC	;FIRST SECTOR TO READ NEXT BUFFER FULL
	RET
;
SELMAST:		;SELECT MASTER DRIVE
	LDA	MDRIVE
	MOV	C,A
	CALL	SELDSK
	RET
;
DMA:			;SET DMA ADDRESS TO VALUE IN REG BC
	PUSH H ! PUSH D ! PUSH B
	CALL	SETDMA
	POP B ! POP D ! POP H
	RET
;
READSEC:
	PUSH H ! PUSH D ! PUSH B
	CALL	CONVERT	;SET SECTOR AND TRACK
	CALL	READ
	POP B ! POP D ! POP H
	RET
;
CONVERT:
	CALL	CONVTRK
	CALL	TRK
	CALL	CONVSEC
	CALL	SEC
	RET
;
CONVTRK:		;SECTOR NUMBER 0 - 2001 IN REG HL
			;TO TRACK NUMBER IN REG C ON EXIT
	PUSH	H	;SAVE SECTOR NUMBER
	MVI	C,-1 AND 255
	LXI	D,-26	;SECTORS PER TRACK
CT1:
	INR	C
	DAD	D
	JC	CT1
	POP	H
	RET
;
TRK:
	PUSH H ! PUSH D ! PUSH B
	CALL	SETTRK
	POP B ! POP D ! POP H
	RET
;
CONVSEC:		;SECTOR NUMBER 0 - 2001 IN REG HL TO
			;SECTOR NUMBER 1 - 26 IN REG C
	LXI	D,-26	;SECTORS PER TRACK
CS1:
	DAD	D
	JC	CS1
	LXI	D,26	;RESTORE FROM OVER DRAFT
	DAD	D
	LXI	D,SECTBL ;NOW INDEX INTO SECTOR TABLE
	DAD	D
	MOV	C,M
	RET
;
SECTBL:
	DB	1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25
	DB	2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26
;
SEC:
	PUSH H ! PUSH D ! PUSH B
	CALL	SETSEC
	POP B ! POP D ! POP H
	RET
;
INCRSEC:		;INCRMENT SECTOR NUMBER IN REG HL
			;SET CARRY IF OVERFLOW TO 2002
	INX	H
	MVI	A,2002/256-1
	CMP	H
	RNC
	MVI	A,2002 MOD 256-1
	CMP	L
	RET
;
INCRDMA:		;ADD 80H (ONE SECTOR LENGTH) TO THE
			;DMA ADDRESS IN REG BC
	PUSH	H
	LXI	H,80H
	DAD	B
	MOV	B,H
	MOV	C,L
	POP	H
	RET
;
WRITEBUF:
	CALL	SELCOPY
	LXI	B,BUFFER
	LHLD	MAXSEC
	XCHG
	LHLD	FIRSTSEC
WR1:
	CALL	DMA
	CALL	WRITESEC
	CALL	INCRSEC
	JC	WREXIT
	CALL	INCRDMA
	DCX	D	; BUFFER FULL YET?
	MOV	A,D
	ORA	E
	JNZ	WR1
WREXIT:
	RET
;
SELCOPY:		;SELECT DRIVE CONTAINING COPY
	LDA	CDRIVE
	MOV	C,A
	CALL	SELDSK
	RET
;
WRITESEC:
	PUSH H ! PUSH D ! PUSH B
	CALL	CONVERT
	CALL	WRITE
	POP B ! POP D ! POP H
	RET
;
EXIT:
	CALL	MESSAGE
	DB	'FUNCTION COMPLETE', 13, 10
	DB	'MOUNT SYSTEM DISK AND PRESS RETURN TO BOOT'
	DB	13, 10, 0
	CALL	CI
	RET
;
;			RAM AREAS
;
MDRIVE	DS	1	;MASTER DRIVE NUMBER
CDRIVE	DS	1	;COPY DRIVE NUMBER
MAXSEC	DS	2	;NUMBER OF SECTORS IN BUFFER
FIRSTSEC DS	2	;FIRST SECTOR IN BUFFER
NEXTSEC	DS	2	;NEXT SECTOR TO READ
DEBUG	DS	1	;DEBUG MODE FLAG
	DS	100	;STACK ROOM
STACK:
BUFFER:
;
	END	ENTRY
