	title	'CP/M 2.2 cbios for DMS-2, ver. 4.1, 03 apr 82'
;
;
;	cbios for micro-2 computer
;
;	version 1.0  double density for CP/M 1.4
;	version 2.0  rewritten for CP/M 2.2
;	version 3.0  modified for auto density select (A:-->F:)
;			drives A: & B: --> 542k d/d
;			drives C: & D: --> 512k d/d (std. DMS)
;			drives e: & F: --> 243k s/d (std. 3740)
;	version 4.0  modified to enable interrupts and add type-ahead buffer
;
;	NOTE:  front panel and console in, interrupts
;	are enabled in this version.
;
		page 58
;
$*Macro
		maclib	z80
;
true		equ	0ffffh
false		equ	not true
;
hytype		equ	true
teletype	equ	false
;
;
;	base page equates
;
iobyte		equ	0003h
cdisk		equ	0004h
rstrt1		equ	0008h		;restart 1 location
rstrt7		equ	0038h		;restart 7 location
;
;
;	this version contains disk drivers for the digital systems
;	fdc-3 controller board.  this board can handle double density
;
;	note:  msize determines where this cbios is located
;
msize		equ	64		;cp/m version memory size in kilobytes
ndrive		equ	2		;number of drives in system.
ndens		equ	3		;number of different densities
vers		equ	22		;CP/M version
rev		equ	41		;cbios revision
cbios		equ	(msize*1024)-(6*256)	;start of the cbios patch
;
;
		org	0040h
;
;	local disk variable storage
;
track		ds	1		;current track on drive 0
trak1		ds	1		;current track on drive 1
trak2		ds	1		;drive 2
trak3		ds	1		;drive 3
sector		ds	1		;currently selected sector
dmaad		ds	2		;current dma address
diskno		ds	1		;current disk number
dummy		ds	1		;must be 0 for double add
errors		ds	1		;disk error counter, 10 max.
port		ds	1		;last command save
portout		ds	1		;current command
density		ds	1		;disk density bit map
					;lsb=drive 0, density select
					;  1=double, 0=single
;
;
		org	cbios		;origin of this program
;
cbase		equ	(msize-20)*1024	;bias for systems larger than 20k
cpmb		equ	cbase+3400h	;base of cp/m (= base of ccp)
bdos		equ	cpmb+806h	;base of resident portion of cp/m
cpml		equ	$-cpmb		;length of the cp/m system in bytes
nsects		equ	cpml/128	;number of sectors to load on warm start
;
;	serial I/O and interrupts equates
;
data		equ	40h		;console port
status		equ	data+1
data1		equ	48h		;punch and reader port
status1		equ	data1+1
data2		equ	50h		;list port
status2		equ	data2+1
;
rxrdy		equ	0000$0010b	;8251 receiver ready bit
txrdy		equ	0000$0001b	;8251 transmitter buffer empty bit
dtr		equ	1000$0000b	;8251 dtr bit (htif handshake bit)
;
;
;	jump vector for individual subroutines
;
		jmp	cboot		;cold start
;
wmboot:		jmp	wboot		;warm start
		jmp	const		;console status
		jmp	conin		;console character in
		jmp	conout		;console character out
		jmp	list		;list character out
		jmp	punch		;punch character out
		jmp	reader		;reader character out
		jmp	home		;move head to home position
		jmp	seldsk		;select disk
		jmp	settrk		;set track number
		jmp	setsec		;set sector number
		jmp	setdma		;set dma address
		jmp	read		;read disk
		jmp	write		;write disk
		jmp	prstat		;routine to handle list status (for despool)
		jmp	sectran		;sector translation routine
;
;
;	individual subroutines to perform each function
;
wboot:		;simplest case is to read the disk until all sectors loaded
		lxi	sp,0080h	;reset stack
		mvi	c,00
		call	seldsk
		call	home
		lda	port
		ani	0f7h
		sta	port
;
		mvi	b,nsects	;<b> counts the number of sectors to load
		mvi	c,0		;<c> has the current track number
		mvi	d,2		;<d> has the next sector to read
;
;	note that we begin by reading track 0, sector 2 since sector 1
;	contains the cold start loader, which is skipped in a warm start
;
		lxi	h,cpmb		;base of cp/m (initial load point)
;
load1:		;load one more sector
		push	b		;save sector count, current track
		push	d		;save next sector to read
		push	h		;save dma address
		mov	c,d		;get sector address to register <c>
		call	setsec		;set sector address from register <c>
		pop	b		;recall dma address to <bc>
		push	b		;replace on stack for later recall
		call	setdma		;set dma address from <bc>
;
;	drive set to 0, track set, sector set, dma address set
;
		call	read
		ora	a		;any errors?
		jrnz	wboot		;retry the entire boot if an error occurs
;
;	no error, move to next sector
;
		pop	h		;recall dma address
		lxi	d,128		;dma=dma+128
		dad	d		;new dma address is in <hl>
		pop	d		;recall sector address
		pop	b		;recall number of sectors remaining
					; and current trk
		dcr	b		;sectors=sectors-1
		jrz	gocpm		;transfer to cp/m if all have been loaded
;
;	more sectors remain to load, check for track change
;
		inr	d
		mov	a,d		;sector=26?, if so, change tracks
		cpi	27
		jrc	load1		;carry generated if sector<27
;
;	end of current track, go to next track
;	check for density change
;	the density to be used is the density of drive A:
;
		lda	density
		rrc
		jrnc	load2
;
;	change to double density
;
		mvi	a,8
		sta	port
;
load2:		mvi	d,1		;begin with first sector of next track
		inr	c		;track=track+1
;
;	save register state, and change tracks
;
		push	b
		push	d
		push	h
		call	settrk		;track address set from register <c>
		pop	h
		pop	d
		pop	b
		jr	load1		;for another sector
;
;
gocpm:		;come here on either warm or cold boot
		;initialize pointers in low memory
		mvi	a,0c3h		;c3 is a jmp instruction
		sta	0000		;for jmp to wmboot
		sta	0005		;for jmp to bdos
		sta	rstrt1		;interrupts
		sta	rstrt7		;in case not in DDT
		lxi	h,wmboot	;wmboot entry point
		shld	0001		;set address field for jmp at 0
		shld	rstrt7+1	;warm boot on f/p irq
;
		lxi	h,bdos		;bdos entry point
		shld	0006		;address field of jump at 5 to bdos
;
		lxi	h,intack	;address of irq handler
		shld	rstrt1+1
;
		lxi	b,0080h		;default dma address is 0080h
		call	setdma
;
		mvi	a,irqebl	;start interrupts
		out	irqport
;
;	put active disk number (stored in location 4) in <c>
;
		lda	0004h
		mov	c,a
		ei			;enable interrupts
		jmp	cpmb		;go to cpm for further processing
;
;
;	i/o and interrupt handlers
;
const:		;console status, return 0ffh if character ready, 00h if not
		;check type ahead buffer count
		lda	typbufc
		ora	a
		rz
		ori	0ffh
		ret
;
conin:		; this routine replaces the old "conin".  so that we
		;can implement a type ahead buffer
		call	const		;wait for char ready
		jrz	conin		;loop till somebody types something
		lxi	h,typbufc	;point to count
		dcr	m		;now one less
		mov	c,m		;get count for move down
		inx	h		;point to buffer
		mov	a,m		;and get char
		rz			;if count is zero, then we have nothing
					;to move.
		mov	d,h		;make a poor mans software fifo
		mov	e,l
		inx	h		;move contents down one char
		mvi	b,00		;setup <bc> for "ldir"
		ldir			;move it
		ret			;return character
;
conout:	 	;console character output from register <c>
		in	status
		rar
		jrnc	conout
		mov	a,c
		out	data
		ret
;
;
prstat:		;check printer status, return 0ff if ready, 00 if not
;
		if hytype
;
		in	status2
		ani	dtr or txrdy	;check dtr and txrdy
		xri	dtr or txrdy
		mvi	a,0ffh
		rz
		cma
		ret
		endif
;
		if teletype
;
		xra	a
		ret
		endif
;
;
list:		;output character in <c> to printer device
;
		if hytype
;
		call	prstat
		ora	a
		jrz	list
		mov	a,c
		out	data2
		ret
		endif
;
		if teletype
;
		mvi	a,27h
		out	status2
;
list1:		in	status2
		ral
		jnc	list1
		mov	a,c
		out	data2
		push	psw
;
list2:		in	status2
		ral
		jc	list2
;
list3:		in	status2
		ral
		jnc	list3
		pop	psw
		cpi	0ah
		rnz
		mvi	a,25h
		out	status2
		ret
		endif
;
;
punch:		;punch character from register <c>
		in	status1
		rar
		jrnc	punch
		mov	a,c		;character to register <a>
		out	data1
		ret
;
;
reader:		;read character into register <a> from reader device
		in	status1
		ani	rxrdy
		jrz	reader
		in	data1
		ret
;
;
;	interrupt handler and local equates
;
;	the type-ahead buffer is the last 30 bytes of ram.
;
;	NOTE:  if you overflow the buffer you will cause
;	all sorts of damage, since no check is made to
;	limit the number of char's in the buffer.
;
;	MODIFICATION:  the buffer is forced to remain in the
;	range of 0ffe1 to 0ffff, so the only dammage is to the
;	leading characters in the buffer.
;
irqport		equ	60h		;interrupt mask and status port
irqebl		equ	0011$0000b	;irq enable for (D5=f/p),(D4=conin)
;
clkirq		equ	0100$0000b	;60hz clock interrupt mask/enable
fpirq		equ	0010$0000b	;front panel interrupt bit mask/enable
ciirq		equ	0001$0000b	;console interrupt enable bit
moirq		equ	0000$1000b	;modem port interrupt enable bit
;
typbuf		equ	0ffffh-30	;start of type-ahead buffer
typbufc		equ	typbuf-1	;character count in buffer
;
;
intack:		;interrupt (restart 1) routine
		push	psw		;save user psw
		in	irqport		;figure out which device interrupted
		ani	fpirq		;check for front panel interrupt
		jrz	conirq		;if not console, then front panel
		xri	irqebl
		out	irqport
		ori	irqebl
		out	irqport
		ei
		jmp	rstrt7		;go do restart 7
;
;
conirq:		;must be console interrupt, so take care of type ahead buffer
		push	h
		lxi	h,typbufc	;buffer counter
		mov	a,m		;get count
		inr	m		;now one more
		inx	h		;point to buffer proper
		add	l		;figure out where to put char
		ori	0e0h		;force buffer > 0ffe0h
		mov	l,a
;
;	go get the char from the usart
;
getchr:		;get console character into register <a>
		in	data
		ani	7fh		;strip parity bit
		mov	m,a		;put it in the buffer
;
irqret:		pop	h
		pop	psw		;restore registers
		ei
		ret
;
;
;	i/o drivers for the disk follow
;
comand1		equ	80h		;first disk command port
stat		equ	80h		;disk status port
haddr		equ	81h		;high dma address port
laddr		equ	82h		;low dma address port
comand2		equ	83h		;second command port
;
;
home:		;move to the track 00 position of current drive
		call	headload
;
;	 <hl> points to word with track for selected disk
;
homel:		mvi	m,00		;set current track ptr back to 0
		in	stat		;read fdc status
		ani	4		;test track 0 bit
		rz			;return if at 0
		stc			;direction=out
		call	step		;step one track
		jr	homel		;loop
;
;
seldsk:		;select disk given by register <c>
		;make sure dummy is 0 (for use in double add to <hl>)
		;set up the second command port
		call	chgdens
		mov	a,h
		ora	l
		rz
		mov	a,c		;get disk number
		sta	diskno		;update
		xra	a
		sta	dummy
		lda	density
		mov	b,c
;
ckdens:		dcr	b
		rrc
		jp	ckdens		;get density in [cy],(1=dd,0=sd)
		jrnc	setsgl
		mov	a,c
		ori	08h		;set double density
		mov	c,a
;
setsgl:		lda	port
		ani	0f0h		;clear out old disk select bits
		ora	c		;new disk select bits
		sta	port
		ret
;
;
settrk:		;set track given by register <c>
		call	headload
		mov	a,m
		ora	a
		cm	homel
;
;	<hl> reference correct track indicator according to
;	selected disk
;
		mov	a,c		;desired track
		cmp	m
		rz			;we are already on the track
;
settkx:		call	step		;step track-carry has direction
					;step will update track indicator
		mov	a,c
		cmp	m		;are we where we want to be
		jrnz	settkx		;not yet
;
;	have stepped enough
;	delay 10 msec for final step time and head settle time
;
		mvi	a,10d
;
;
delay:		;routine to delay <c(a)> milliseconds
		push	b
;
delay2:		mvi	c,88		;adjust for 1 msec loop delay
;
ldxa:		xthl
		xthl
		dcr	c
		jnz	ldxa		;loop 1 msec
		dcr	a
		jnz	delay2
		pop	b
		ret			;end of delay routine
;
;
setsec:		;set sector given by register <c>
		mov	a,c
		sta	sector
		ret
;
;
setdma:		;set dma address given by register <bc>
		mov	l,c		;low order address
		mov	h,b		;high order address
		shld	dmaad		;save the address
		ret
;
;
read:		;perform read operation.
		;this is similar to write, so set up read command and use
		;common code in write
		mvi	b,040h		;set read flag
		jr	waitio		;to perform the actual i/o
;
;
write:		;perform a write operation
		mvi	b,080h		;set write command
;
waitio:		;enter here from read and write to perform the actual i/o 
		;operation.  return a 00h in register a if the operation completes
		;properly, and 01h if an error occurs during the read or write
		;
		;in this case, we have saved the disk number in 'diskno' 
		;			the track number in 'track' 
		;			the sector number in 'sector' 
		;			the dma address in 'dmaad' 
		;			<b> still has r/w flag
		;
		mvi	a,10		;set error count
		sta	errors		;retry some failures 10 times
					;before giving up
		push	b
		call	headload
;
;	<hl> point to track byte for selected disk
;
		pop	b
;
tryagn:		mov	c,m
;
;	decide whether to allow disk write precompenstation
;
allowit:	lhld	dmaad		;get buffer address
		push	b		;<b> has r/w code, <c> has track
		dcx	h		;save and replace 3 bytes below
					;buf with track,sector,address mark
		mov	e,m
;
;	figure correct address mark
;

		lda	port
		ani	08h
		mvi	a,0fbh
		jrz	sin
		ani	0fh		;was double 
					;0bh is double density 
					;0fbh is single density
;
sin:		mov	m,a
;
;	fill in sector
;
		dcx	h
		mov	d,m
		lda	sector		;note that invalid sector number
					;will result in head unloaded
					;error, so dont check
		mov	m,a
;
;	fill in track
;
		dcx	h
		pop	b
		mov	a,c
		mov	c,m
		mov	m,a
		mov	a,h		;set up fdc dma address
		out	haddr		;high byte
		mov	a,l
		out	laddr		;low byte
		mov	a,b		;get r/w flag
		out	comand1		;start disk read/write
;
rwwait:		in	stat		;read fdc status
		ani	088h		;test for head unload or iof
		jrz	rwwait
		mov	m,c		;restore 3 bytes below buf
		inx	h
		mov	m,d
		inx	h
		mov	m,e
		in	stat		;test for errors
		ani	0f0h
		rz			;<a> will be 0 if no errors
;
errtn:		;come here on error from disk
		;check for 10 errors
		lxi	h,errors
		dcr	m
		jrnz	redo		;not ten yet, do a retry
;
;	set error return for operating system
;
		mvi	a,1
		ret
;
redo:		;<b> still has read/write flag
		ani	0e0h		;retry if not track error
		jrnz	tryagn
;
;	was a track error so need to reseek
;
		push	b		;save	read/write indicator
;
;	figure out the desired track
;
		lxi	d,track
		lhld	diskno		;selected disk
		dad	d		;point to correct track indicator
		mov	a,m		;desired track
		push	psw		;save it
		call	home
		pop	psw
		mov	c,a
		call	settrk
		pop	b		;get read/write indicator
		jr	tryagn
;
;
step:		;step head out towards zero
		;if [cy] is set, else step in
;
;	 <hl> point to correct track indicator word
;
		jrc	outx
		inr	m		;increment current track byte
		mvi	a,04h		;set direction = in
;
dostep:		out	comand1		;set direction bit in fdc
		ori	2
		out	comand1		;pulse step bit
		ani	0fdh
		out	comand1		;turn off pulse
;
;	the fdc-2 had a step ready line. the fdc-3 relies on
;	software time out
;
		mvi	a,6		;wait for step ready
		jmp	delay
;
outx:		dcr	m		;update track byte
		xra	a
		jr	dostep
;
;
headload:	;select and load the head on the correct drive
		lxi	h,portout	;old slect info
		mov	b,m
		dcx	h		;new select info
		mov	a,m
		inx	h
		mov	m,a
		out	comand2		;select the drive
;
;	set up <hl> to point to track byte for selected disk
;
		lxi	d,track
		lhld	diskno
		dad	d
;
;	now check for needing a 35 ms delay
;	if we have changed drives or if the head is unloaded
;	we need to wait 35 ms for head settle
;
		cmp	b		;are we on the same drive as before
		jrnz	needdly
;
;	we are on the same drive
;	is the head loaded?
;
		in	stat
		ani	80h
		rz			;already loaded
;
needdly:	xra	a
		out	comand1		;load the head
		mvi	a,35
		jmp	delay
;
;
sectran:	mov	l,c
		mov	h,b
		inx	h
		mov	a,d
		ora	e
		rz			;no xlat table, (double density)
		xchg
		dad	b
		mov	l,m
		mvi	h,00
		ret
;
;
chgdens:	;get pointer the dph
		lxi	h,0000
		mov	a,c
		cpi	ndrive * ndens
		rnc			;check for max drive error
		mvi	b,03		;set up <b> for dpb test
		cpi	4		;check for single
		jrnc	sddriv
		cpi	2		;check for doubles
		jrnc	dd14driv
		jr	denslp		;2.2 density
;
sddriv:		dcr	b
;
dd14driv:	dcr	b
;
denslp:		mov	a,c		;mask drive bits for 0 or 1
		ani	01
		mov	c,a
		mov	e,a		;set up for selection
		mvi	d,00
		lda	density
		ora	a
;
denslp1:	rar
		inr	d
		dcr	e
		jp	denslp1
		push	psw
		mvi	a,1		;check for single
		cmp	b
		jrz	singdens
		pop	psw
		stc
		jr	rolbyte
;
singdens:	pop	psw
		stc
		cmc
;
rolbyte:	ral
		dcr	d
		jrnz	rolbyte
		sta	density
		mov	l,c		;get drive
		dad	h		;times 16
		dad	h
		dad	h
		dad	h		;<hl> now has pointer to correct dph.
		lxi	d,dpbase
		dad	d
;
		xra	a		;clear out table address in case of dd
		mov	m,a
		inx	h
		mov	m,a
		dcx	h		;restore <hl>
		push	b		;save drive number
;
;	now let's find out which density we want.
;
		mov	a,b		;get density specifier
		dcr	a		;test for single density
		jrz	sinden		;single density routine
		dcr	a		;check for dd(1.4) density
		jrz	douden		;double (1.4) density, fall through for (2.2)
;
;	here for 2.2 density
;
		lxi	b,dpb0
;
putdph:		push	h
		lxi	d,0010		;ofset into dph
		dad	d		;add it in
		mov	m,c		;<bc> now has proper dpb
		inx	h
		mov	m,b
		pop	h
		pop	b		;restore drive number
		ret			;return back seldsk
;
douden:		lxi	b,dpb2
		jr	putdph		;finish (2.2) density
;
sinden:		lxi	b,xlt3		;single density sector 
					;tranlation table
		mov	m,c
		inx	h
		mov	m,b
		dcx	h		;point back to start of dph
		lxi	b,dpb3		;single density dpb
		jr	putdph
;
;
dpbase		equ	$		;Base of Disk Parameter Blocks
;
dpe0		dw	xlt0,0000h	;Translate Table
		dw	0000h,0000h	;Scratch Area
		dw	dirbuf,dpb0	;Dir Buff, Parm Block
		dw	csv0,alv0	;Check, Alloc Vectors
;
dpe1		dw	xlt1,0000h	;Translate Table
		dw	0000h,0000h	;Scratch Area
		dw	dirbuf,dpb1	;Dir Buff, Parm Block
		dw	csv1,alv1	;Check, Alloc Vectors
;
;
;	 4336:	128 Byte Record Capacity
;	  542:	Kilobyte Drive  Capacity
;	  128:	32 Byte Directory Entries
;	   64:	Checked Directory Entries
;	  128:	Records / Extent
;	   16:	Records / Block
;	   58:	Sectors / Track
;	    2:	Reserved  Tracks
;
dpb0		equ	$		;Disk Parameter Block
		dw	58		;Sectors Per Track
		db	4		;Block Shift
		db	15		;Block Mask
		db	0		;Extnt Mask
		dw	270		;Disk Size - 1
		dw	127		;Directory Max
		db	192		;Alloc0
		db	0		;Alloc1
		dw	16		;Check Size
		dw	2		;Offset
;
xlt0		equ	0		;No Translate Table
als0		equ	34		;Allocation Vector Size
css0		equ	16		;Check Vector Size
;
;	Disk 1 is the same as Disk 0
;
dpb1		equ	dpb0		;Equivalent Parameters
als1		equ	als0		;Same Allocation Vector Size
css1		equ	css0		;Same Checksum Vector Size
xlt1		equ	xlt0		;Same Translate Table
;
;
;	 4096:	128 Byte Record Capacity
;	  512:	Kilobyte Drive  Capacity
;	  128:	32 Byte Directory Entries
;	   64:	Checked Directory Entries
;	  128:	Records / Extent
;	   16:	Records / Block
;	   58:	Sectors / Track
;	    2:	Reserved  Tracks
;
dpb2		equ	$		;Disk Parameter Block
		dw	58		;Sectors Per Track
		db	4		;Block Shift
		db	15		;Block Mask
		db	0		;1.4 Compatible
		dw	255		;Disk Size - 1
		dw	127		;Directory Max
		db	192		;Alloc0
		db	0		;Alloc1
		dw	16		;Check Size
		dw	2		;Offset
;
xlt2		equ	0		;No Translate Table
als2		equ	32		;Allocation Vector Size
css2		equ	16		;Check Vector Size
;
;
;	 1944:	128 Byte Record Capacity
;	  243:	Kilobyte Drive  Capacity
;	   64:	32 Byte Directory Entries
;	   64:	Checked Directory Entries
;	  128:	Records / Extent
;	    8:	Records / Block
;	   26:	Sectors / Track
;	    2:	Reserved  Tracks
;	    6:	Sector Skew Factor
;
dpb3		equ	$		;Disk Parameter Block
		dw	26		;Sectors Per Track
		db	3		;Block Shift
		db	7		;Block Mask
		db	0		;1.4 Compatible
		dw	242		;Disk Size - 1
		dw	63		;Directory Max
		db	192		;Alloc0
		db	0		;Alloc1
		dw	16		;Check Size
		dw	2		;Offset
;
xlt3		equ	$		;Translate Table
		db	1,7,13,19
		db	25,5,11,17
		db	23,3,9,15
		db	21,2,8,14
		db	20,26,6,12
		db	18,24,4,10
		db	16,22
;
als3		equ	31		;Allocation Vector Size
css3		equ	16		;Check Vector Size
;
;
cboot:		;give log-on message on cold start only
		lxi	sp,0080h
		lxi	h,signon
;
prtmess:	mov	a,m
		ora	a		;zero?
		jrz	clriob
		mov	c,a
		call	conout
		inx	h
		jr	prtmess
;
clriob:		sta	cdisk		;clear current disk and iobyte
		sta	iobyte
		sta	typbufc		;also char count, of type-ahead buffer
		lxi	h,0ffffh
		shld	track
		jmp	gocpm
;
;
signon		db	0dh,0ah		;cr,lf
		db	msize/10+'0',msize mod 10+'0'
		db	'k CP/M vers ',vers/10+'0','.',vers mod 10+'0'
		db	'-',rev/10+'0','.',rev mod 10+'0'
;
		if teletype
		db	' **teletype**'
		endif
;
		db	00	;end of signon message
;
;
		org	cboot
;
;	Uninitialized Scratch Memory Follows:
;
begdat		equ	$		;Start of Scratch Area
dirbuf		ds	128		;Directory Buffer

alv0		ds	als0		;Alloc Vector
csv0		ds	css0		;Check Vector

alv1		ds	als1		;Alloc Vector
csv1		ds	css1		;Check Vector

enddat		equ	$		;End of Scratch Area
datsiz		equ	$-begdat	;Size of Scratch Area
;
;
		end	cbios
