	title	'SOL & MORROW 2.2 Cbios,  10 apr 82'
;
;
;	this is the bios for MORROWs discus 1 system.
;
rev		equ	10
;
true		equ	0ffffh
false		equ	not true
;
test		equ	true
;
msize		equ	56		; number of kilobytes of memory
syssize		equ	(6*256)+0e00h+800h
cpmbase		equ	(msize*1024)-syssize	; base of cpm
ccp		equ	cpmbase
bdos		equ	ccp+806h
bios		equ	ccp+800h+0e00h	;where bios starts
;
ndrives		equ	1		;number of drives in system
nsec		equ	(syssize-(6*256))/128	;sectors to load on warm boot
;
cdisk		equ	4
;
;	controller prom entry points
;
origin		equ	0e000h		;base of prom
input		equ	origin+3	;console input (not used)
output		equ	origin+6	;console output (not used)
tkzero		equ	origin+9h	;seek to track zero (home)
tseek		equ	origin+0ch	;seek command entry point
sector		equ	origin+0fh	;set sector
dma		equ	origin+12h	;set dma address
diskr		equ	origin+15h	;read sector
diskw		equ	origin+18h	;write sector
;
;	controller variables
;
stack		equ	origin+26eh	;local stack
drive		equ	origin+273h	;current drive
dmaadr		equ	origin+274h	;current dma address
track		equ	origin+277h	;current track
status		equ	origin+302h	;status port
delay		equ	origin+1f3h
;
	if not test
solmon		equ	0f000h		;sol monitor
csts		equ	solmon+3	;console status
ci		equ	solmon+6	;console input
ri		equ	solmon+9	;reader input
co		equ	solmon+0ch	;console output
lo		equ	solmon+0fh	;list output
po		equ	solmon+12h	;punch output
	endif
;
	if test
ccsmon		equ	0f800h		;CCS monitor (for debug)
csts		equ	ccsmon+3
ci		equ	ccsmon+6
ri		equ	ccsmon+6
co		equ	ccsmon+9
lo		equ	ccsmon+9
po		equ	ccsmon+9
	endif
;
kbdata		equ	0fch		;keyboard data port
kbstat		equ	0fah		;keyboard status
kbrdy		equ	01h		;keyboard ready bit
;
lprstat		equ	0f8h
lprdata		equ	0f9h
lrxrdy		equ	0100$0000b
ltxrdy		equ	1000$0000b
;
;
		org	bios
;
;
start:		jmp	cboot		;cold entry point
		jmp	wboot		;warm boot entry point
		jmp	const		;console status routine
		jmp	conin		;console input
		jmp	conout		;console output
		jmp	list		;list device out
		jmp	punch		;aux device output
		jmp	reader		;aux device input
		jmp	home		;home the disk (seek to trk 0)
		jmp	seldsk		;select disk
		jmp	settrk		;set track
		jmp	setsec		;set sector
		jmp	setdma		;set dma address
		jmp	read		;read sector
		jmp	write		;write sector
		jmp	lstst		;list device status
		jmp	secttran	;sector translation routine
;
;
cboot:		lxi	sp,stack	;put stack somewhere safe
		lxi	h,prompt	;signon message
		call	messg		;print it
		xra	a		;tell cpm disk A:
		sta	cdisk
		jmp	gocpm		;finish initialization
;
;
wboot:		lxi	sp,stack
		mvi	a,88h		;select drive A:
		sta	drive
		sta	status
		call	tkzero		;home disk
		lxi	b,(nsec shl 8) or 6	;# sectors to load, start at 6
		lxi	h,cpmbase+200h	;start of ccp
		shld	dmaadr
;
wloop:		push	b		;save sector number and count
		call	sector
		call	read		;read disk
		ana	a		;any errors
		jnz	wboot		;retry
;
		pop	b
		dcr	b		;one less
		jz	gocpm
;
advnce:		mvi	a,5		;sector offset
		add	c		;next sector
		mov	c,a
		sbi	27		;test for overflow
		jm	ok		;no overflow
;
		inr	a		;new sector
		mov	c,a
		lxi	d,0f580h	;dma address adjustment
		cpi	1		;test for track done
		jnz	ok+3		;nope
;
		push	b
		call	tseek		;seek to track 1
		pop	b
;
ok:		lxi	d,280h		;dma address adjustment
		lhld	dmaadr		;get old dma address
		dad	d		;calculate new dma address
		shld	dmaadr
		mvi	a,(cpmbase+1600h)/100h
		sub	h		;test for overflow
		jm	advnce
;
		jmp	wloop		;read next sector
;
;
gocpm:		lxi	h,80h		;default dma address
		shld	dmaadr
		mvi	a,jmp		;init page zero jump locations
		sta	0000h
		lxi	h,start+3	;warm boot entry point
		shld	0001h
		sta	0005h
		lxi	h,bdos		;entry point to bdos
		shld	0006h
		lda	cdisk
		mov	c,a		;default drive 0
		jmp	ccp		;enter ccp
;
;
const:		;return console input status
		;0ffh=if ready, 00=if not ready
		jmp	csts		;use monitor i/o routines
		ret
;
conin:		;console character input
		;return character in <a>
		call	ci
		ani	7fh
		ret
;
conout:		;console character output
		;output character in <c>
		jmp	co
		ret
;
lstst:		;return list status
		;0ffh=ready, 00=not ready
		xra	a
		ret
;
list:		;output character in <c> to list device
		jmp	lo
		ret
;
punch:		;output character in <c> to aux device
		jmp	po
		ret
;
reader:		;input character to <a> from aux device
		jmp	ri
		ret
;
;
home:		jmp	tkzero		;seek to track zero
;
;
seldsk:		lxi	h,0000h		;setup <hl> for error return
		mov	a,c		;get drive
		cpi	ndrives		;check if over max.
		rnc
		lda	drive		;calculate the current drive
		push	psw
		ani	0f7h
		lxi	h,dtable
		push	h
;
sloop:		cmp	m
		jz	found
;
		inx	h
		inx	h
		jmp	sloop
;
found:		inx	h		;store track of current drive
		lda	track
		mov	m,a
		pop	h		;calculate the bit pattern of new drive
		mov	a,c
		add	a
		add	l
		mov	l,a
		jnc	hisok
;
		inr	h
;
hisok:		pop	psw
		ani	8		;preserve head load bit
		ora	m		;activate new drive
		sta	status
		sta	drive
		inx	h		;get current track of new drive
		mov	a,m		;and initialize
		sta	track
		mvi	h,00		;calculate DPB address
		mov	l,c
		dad	h
		dad	h
		dad	h
		dad	h
		lxi	d,dpbase
		dad	d
		ret
;
;
dtable		db	80h		;drive A:
		db	0
		db	1		;drive B:
		db	0
		db	20h		;drive C:
		db	0
		db	2		;drive D:
		db	0
;
;
settrk:		;move head to cylinder in <c>
		jmp	tseek
;
;
setsec:		;set sector to <c>
		jmp	sector
;
;
setdma:		;set dma address to <bc>
		jmp	dma
;
;
read:		mvi	c,10		;number of retrys before perm. error
		push	b
		call	diskr		;read current sector
		pop	b
		ana	a		;test for return error
		rz			;none so return to cp/m
		dcr	c		;ERROR, dec. retrys
;
		jnz	read+2
		ori	0ffh		;return non-zero for perm. error
		ana	a		;set flags
		ret
;
;
write:		;write current buffer to disk
		jmp	diskw
;
;
secttran:	;translate sector in <c> from table
		;addressed by <de>
		xchg
		dad	b
		mov	l,m		;get sector # from memory
		mvi	h,00
		ret
;
;
messg:		;print message utility routine
		mov	a,m
		ana	a
		rz
		push	h
		mov	c,a
		call	conout
		pop	h
		inx	h
		jmp	messg
;
;
dpb0	equ	$		;Disk Parameter Block
	dw	26		;Sectors Per Track
	db	3		;Block Shift
	db	7		;Block Mask
	db	0		;1.4 Compatible
	dw	242		;Disk Size - 1
	dw	63		;Directory Max
	db	192		;Alloc0
	db	0		;Alloc1
	dw	16		;Check Size
	dw	2		;Offset
;
xlt0	equ	$		;Translate Table
	db	1,7,13,19
	db	25,5,11,17
	db	23,3,9,15
	db	21,2,8,14
	db	20,26,6,12
	db	18,24,4,10
	db	16,22
;
als0	equ	31		;Allocation Vector Size
css0	equ	16		;Check Vector Size
;
dpb1	equ	dpb0		;Equivalent Parameters
als1	equ	als0		;Same Allocation Vector Size
css1	equ	css0		;Same Checksum Vector Size
xlt1	equ	xlt0		;Same Translate Table
;
;
prompt		db	0dh,0ah,0dh,0ah
		db	msize/10+'0',msize mod 10 + '0'
		db	'k CP/M '
		db	'vers '
		db	'2.2','-',rev/10+'0','.',rev mod 10+'0'
		db	9,'SOL & MORROW discus 1'
		db	0dh,0ah,00
;
;
dpbase	equ	$		;Base of Disk Parameter Blocks
;
dpe0	dw	xlt0,0000h	;Translate Table
	dw	0000h,0000h	;Scratch Area
	dw	dirbuf,dpb0	;Dir Buff, Parm Block
	dw	csv0,alv0	;Check, Alloc Vectors
;
dpe1	dw	xlt1,0000h	;Translate Table
	dw	0000h,0000h	;Scratch Area
	dw	dirbuf,dpb1	;Dir Buff, Parm Block
	dw	csv1,alv1	;Check, Alloc Vectors
;
;
;	Uninitialized Scratch Memory Follows:
;
dirbuf	ds	128		;Directory Buffer
;
alv0	ds	als0		;Alloc Vector
csv0	ds	css0		;Check Vector
;
alv1	ds	als1		;Alloc Vector
csv1	ds	css1		;Check Vector
;
;
		END

