	TITLE	'Bdos interface,  Bdos Version 2.2'
;*******************************************************************
;*******************************************************************
;***								 ***
;***	B A S I C   D I S K   O P E R A T I N G   S Y S T E M	 ***
;***		  I N T E R F A C E   M O D U L E		 ***
;***								 ***
;*******************************************************************
;*******************************************************************
;
;
;
ON	equ	0ffffh
OFF	equ	00000h
TEST	equ	OFF
DEBLOCK	equ	on
;
	if	TEST
	org	3C00h
	else
	org	0800h
	endif
;	bios value defined at end of module
;
SSIZE	equ	24		;24 level stack
;
;	low memory locations
REBOOT	equ	0000h		;cold boot function
IOLOC	equ	0003h		;i/o byte location
BDOSA	equ	0006h		;address field of jmp bdos
;
;
BOOTF	set	BIOS+3*0	;cold boot function
WBOOTF	set	BIOS+3*1	;warm boot function
CONSTF	set	BIOS+3*2	;console status function
CONINF	set	BIOS+3*3	;console input function
CONOUTF	set	BIOS+3*4	;console output function
LISTF	set	BIOS+3*5	;list output function
PUNCHF	set	BIOS+3*6	;punch output function
READERF	set	BIOS+3*7	;reader input function
HOMEF	set	BIOS+3*8	;disk home function
SELDSKF	set	BIOS+3*9	;select disk function
SETTRKF	set	BIOS+3*10	;set track function
SETSECF	set	BIOS+3*11	;set sector function
SETDMAF	set	BIOS+3*12	;set dma function
READF	set	BIOS+3*13	;read disk function
WRITEF	set	BIOS+3*14	;write disk function
LISTSTF	set	BIOS+3*15	;list status function
SECTRAN	set	BIOS+3*16	;sector translate
;
;	equates for non-graphic characters
CTLC	equ	03h		;control C
CTLE	equ	05h		;physical eol
CTLH	equ	08h		;backspace
CTLP	equ	10h		;print toggle
CTLR	equ	12h		;repeat line
CTLS	equ	13h		;stop/start screen
CTLU	equ	15h		;line delete
CTLX	equ	18h		;=ctl U
CTLZ	equ	1ah		;end of file
RUBOUT	equ	7fh		;char delete
TAB	equ	09h		;tab char
CR	equ	0dh		;carriage return
LF	equ	0ah		;line feed
CTL5E	equ	5eh		;control up arrow
;
	db	0,0,0,0,0,0
;
;	enter here from the user's program with function number
;	and information address in <de>
;
	jmp	BDOSE		;past parameter block
;
;********************************************
;***	relative locations 0009 - 000e	  ***
;********************************************
;
PERERR:	dw	PERSUB		;permanent error subroutine
SELERR:	dw	SELSUB		;select error subroutine
RODERR:	dw	RODSUB		;ro disk error subroutine
ROFERR:	dw	ROFSUB		;ro file error subroutine
;
;
BDOSE:		;arrive here from user programs
	xchg
	shld	INFO
	xchg			;info=<de>, <de>=info
	mov	a,e
	sta	LINFO		;linfo = low(info) - don't equ
	lxi	h,0000
	shld	ARET		;return value defaults to 0000
;
;	save user's stack pointer.  set to local stack
;
	dad	sp
	shld	ENTSP		;entsp = stackptr
	lxi	sp,LSTACK	;local stack setup
	xra	a
	sta	FCBDSK
	sta	RESEL		;fcbdsk, resel = false
	lxi	h,GOBACK	;return here after all functions
	push	h		;jmp goback equivalents to ret
	mov	a,c
	cpi	NFUNCS
	rnc			;skip if invalid number
	mov	c,e		;possible output character to <c>
	lxi	h,FUNCTAB
	mov	e,a
	mvi	d,00		;<de>=func, <hl>=.ciotab
	dad	d
	dad	d
	mov	e,m
	inx	h
	mov	d,m		;<de>=functab(func)
	lhld	INFO
	xchg
	pchl			;dispatched
;
;	dispatch table for functions
;
FUNCTAB:
	dw	WBOOTF,FUNC1,TABOUT,FUNC3
	dw	PUNCHF,LISTF,FUNC6,FUNC7
	dw	FUNC8,FUNC9,READ,FUNC11
DISKF	equ	($-FUNCTAB)/2			;disk functions
	dw	FUNC12,FUNC13,CURSELECT,FUNC15
	dw	FUNC16,FUNC17,FUNC18,FUNC19
	dw	FUNC20,FUNC21,FUNC22,FUNC23
	dw	FUNC24,FUNC25,FUNC26,FUNC27
	dw	SET$RO,FUNC29,FUNC30,FUNC31
	dw	FUNC32,FUNC33,FUNC34,FUNC35
	dw	SETRANDOM,FUNC37,NO$FUNC,NO$FUNC
	dw	FUNC40
NFUNCS	equ	($-FUNCTAB)/2
;
PERSUB:		;report permanent error
	lxi	h,PERMSG
	call	ERRFLG		;to report the error
	cpi	CTLC
	jz	REBOOT		;reboot if response is ctrlc
	ret			;and ignore the error
;
SELSUB:		;report select error
	lxi	h,SELMSG
	jmp	WAIT$ERR	;wait console before boot
;
RODSUB:		;report write to read/only disk
	lxi	h,RODMSG
	jmp	WAIT$ERR	;wait console
;
ROFSUB:		;report read/only file
	lxi	h,ROFMSG	;drop through to wait for console
;
WAIT$ERR:	;wait for response before boot
	call	ERRFLG
	jmp	REBOOT
;
;	error messages
DSKMSG:	db	'Bdos Err on '
DSKERR:	db	' : $'		;filled in by errflg
PERMSG:	db	'Bad Sector$'
SELMSG:	db	'Select$'
ROFMSG:	db	'file '
RODMSG:	db	'R/O$'
;
;
;	error subroutines
;
ERRFLG:		;report error to console, message address in <hl>
	push	h
	call	CRLF		;stack mssg address, new line
	lda	CURDSK
	adi	'A'
	sta	DSKERR		;current disk name
	lxi	b,DSKMSG
	call	PRINT		;the error message
	pop	b
	call	PRINT		;error message tail
;
;
;	console handlers
CONIN:		;read console`character into <a>
	lxi	h,KBCHAR
	mov	a,m
	mvi	m,00
	ora	a
	rnz
	jmp	CONINF
;
CONECH:		;read character with echo
	call	CONIN
	call	ECHOC
	rc			;echo character?
	;
	;	character must be echoed before return
	;
	push	psw
	mov	c,a
	call	TABOUT
	pop	psw
	ret			;with character in <a>
;
ECHOC:		;echo character if graphic
		;cr, lf, tab or backspace
	cpi	CR		;carriage return?
	rz
	cpi	LF		;line feed?
	rz
	cpi	TAB		;tab?
	rz
	cpi	CTLH		;backspace?
	rz
	cpi	' '		;carry set if not graphic
	ret
;
CONBRK:		;check for character ready
	lda	KBCHAR
	ora	a
	jnz	CONB1		;skip if active kbchar
	;
	;	no active kbchar, check external break
	;
	call	CONSTF
	ani	01
	rz			;return if no char ready
	;
	;	character ready, read it
	;
	call	CONINF		;into <a>
	cpi	CTLS
	jnz	CONB0		;check stop screen function
	;
	;	found ctls, read next character
	;
	call	CONINF		;into <a>
	cpi	CTLC
	jz	REBOOT		;ctlc implies re-boot
	;
	;	not a reboot, act as if nothing has happened
	;
	xra	a
	ret			;with zero in accumulator
CONB0:		;character in accum.  save it
	sta	KBCHAR
CONB1:		;return with true set in accumulator
	mvi	a,01
	ret
;
CONOUT:		;compute character position/write console char from <c>
		;compcol = true if computing column position
	lda	COMPCOL
	ora	a
	jnz	COMPOUT
	;
	;	write the character, then compute the column
	;	write console character from <c>
	;
	push	b
	call	CONBRK		;check for screen stop function
	pop	b
	push	b		;recall/save character
	call	CONOUTF		;externally, to console
	pop	b
	push	b		;recall/save character
	;
	;	may be copying to the list device
	;
	lda	LISTCP
	ora	a
	cnz	LISTF		;to printer, if so
	pop	b		;recall the character
COMPOUT:
	mov	a,c		;recall the character
	;
	;	and compute column position
	;
	lxi	h,COLUMN	;<a> = char, <hl> = .column
	cpi	7fh
	rz
	inr	m
	cpi	20h
	rnc
	dcr	m		;column = column - 1
	mov	a,m
	ora	a
	rz			;return if at zero
	;
	;	not at zero.  may be backspace or end of line
	;
	mov	a,c		;character back to <a>
	cpi	CTLH
	jnz	NOTBACKSP
	;
	;	backspace character
	;
	dcr	m		;column = column -1
	ret
NOTBACKSP:	;not a backspace character, eol?
	cpi	LF
	rnz			;return if not
	;
	;end of line, column = 00
	mvi	m,00		;column = 00
	ret
;
CTLOUT:		;send <c> character with possible preceding up-arrow
	mov	a,c
	call	ECHOC		;[cy] if not graphic (or special case)
	jnc	TABOUT		;skip if graphic, tab, cr, lf or ctlh
	;
	;	send preceding up arrow
	;
	push	psw
	mvi	c,CTL5E
	call	CONOUT		;up arrow
	pop	psw
	ori	40h		;becomes graphic letter
	mov	c,a		;ready to print
	;
	;	(drop through to tabout)
	;
;
TABOUT:		;expand tabs to console
	mov	a,c
	cpi	TAB
	jnz	CONOUT		;direct to conout if not
	;
	;	tab encountered.  move to next tab position
	;
TAB0:
	mvi	c,' '
	call	CONOUT		;another black
	lda	COLUMN
	ani	0000$0111b	;(column mod 8) = 00?
	jnz	TAB0		;back for another if not
	ret
;
BACKUP:		;back-up one screen position
	call	PCTLH
	mvi	c,' '
	call	CONOUTF
;
PCTLH:		;send ctlh to console without affecting column count
	mvi	c,CTLH
	jmp	CONOUTF
;
CRLFP:		;print (#, cr, lf) for ctlx, ctlu, ctlr functions
		;then move to strtcol (starting column)
	mvi	c,'#'
	call	CONOUT
	call	CRLF
	;
	;	column = 00, move to position strtcol
	;
CRLFP0:
	lda	COLUMN
	lxi	h,STRTCOL
	cmp	m
	rnc			;stop when column reaches strtcol
	mvi	c,' '
	call	CONOUT		;print blank
	jmp	CRLFP0
;
CRLF:		;carriage return, line feed sequence
	mvi	c,CR
	call	CONOUT
	mvi	c,LF
	jmp	CONOUT		;ret
;
PRINT:		;print message until m(<bc>) = "$"
	ldax	b
	cpi	'$'
	rz			;stop on "$"
	;
	;	more to print
	;
	inx	b
	push	b
	mov	c,a		;char to <c>
	call	TABOUT		;another character printed
	pop	b
	jmp	PRINT
;
READ:		;read to info address (max length,
		;current length, buffer)
	lda	COLUMN
	sta	STRTCOL		;save start for ctlx, ctlh
	lhld	INFO
	mov	c,m
	inx	h
	push	h
	mvi	b,00
	;
	;	<b> = current buffer length.
	;	<c> = maximum buffer length.
	;	<hl> = next to fill - 1
READNX:		;read next character, <bc>, <hl> active
	push	b
	push	h		;<b>-len, <c>-max, <hl> saved
READN0:
	call	CONIN		;next char in <a>
	ani	7fh		;mask parity bit
	pop	h
	pop	b		;reactivate counters
	cpi	CR
	jz	READEN		;end of line?
	cpi	LF
	jz	READEN		;also end of line
	cpi	CTLH
	jnz	NOTH		;backspace?
	;
	;	do ws have any characters to back over?
	;
	mov	a,b
	ora	a
	jz	READNX
	;
	;	characters remain in buffer, backup one
	;
	dcr	b		;remove one character
	lda	COLUMN
	sta	COMPCOL		;col >00
	;
	;	compcol >0 marks repeat as length comp
	;
	jmp	LINELEN		;uses same code as repeat
NOTH:		;not a backspace
	cpi	RUBOUT
	jnz	NOTRUB		;rubout char?
	;
	;	rubout encountered, rubout if possible
	;
	mov	a,b
	ora	a
	jz	READNX		;skip if len = 00
	;
	;	buffer has characters, resend last char
	;
	mov	a,m
	dcr	b
	dcx	h		;<a>= last char
	;
	;	<b>len = <b>len -1, next to fill -1, decrement
	;
	jmp	RDECH1		;act like this is an echo
NOTRUB:		;not a rubout character, check end line
	cpi	CTLE
	jnz	NOTE		;physical end of line?
	;
	;	yes, save active counters and force EOL
	;
	push	b
	push	h
	call	CRLF
	xra	a
	sta	STRTCOL		;start position = 00
	jmp	READN0		;for another character
NOTE:		;not end of line, list toggle?
	cpi	CTLP
	jnz	NOTP		;skip if not ctlp
	;
	;	list toggle - change parity
	;
	push	h		;save next to fill -1
	lxi	h,LISTCP		;<hl> = .listcp flag
	mvi	a,01
	sub	m		;true = listcp
	mov	m,a		;listcp = not listcp
	pop	h
	jmp	readnx		;for another char
NOTP:		;not a ctlp, line delete?
	cpi	CTLX
	jnz	NOTX
	pop	h		;discard start position
	;
	;	loop while column <> strtcol
	;
BACKX:
	lda	STRTCOL
	lxi	h,COLUMN
	cmp	m
	jnc	READ		;start again
	dcr	m		;column = column -1
	call	BACKUP		;one position
	jmp	BACKX
NOTX:		;not a control x, control u ?
		;not control-x, control-u?
	cpi	CTLU
	jnz	NOTU		;skip if not
	;
	;	delete line (ctlu)
	;
	call	CRLFP		;physical eol
	pop	h		;discard starting position
	jmp	READ		;to start all over
NOTU:		;not line delete, repeat line?
	cpi	CTLR
	jnz	NOTR
LINELEN:	;repeat line, or compute line len(ctlh)
		;if compcol > 00
	push	b
	call	CRLFP		;save line length
	pop	b
	pop	h
	push	h
	push	b
	;
	;	<b>cur, <c>max, active beginning buff at <hl>
	;
REP0:
	mov	a,b
	ora	a
	jz	REP1		;count len to 00
	inx	h
	mov	c,m		;next to print
	dcr	b
	push	b
	push	h		;count length down
	call	CTLOUT		;character echoed
	pop	h
	pop	b		;recall remaining count
	jmp	REP0		;for the next character
REP1:		;end of repeat, recall lengths
		;original <bc> still remains pushed
	push	h		;save next to fill
	lda	COMPCOL
	ora	a		;0 if computing length
	jz	READN0		;for another char if so
	;
	;	column position computed for ctlh
	;
	lxi	h,COLUMN
	sub	m		;diff > 00
	sta	COMPCOL		;count down below
	;
	;	move back compcol - column spaces
	;
BACKSP:		;move back one more space
	call	BACKUP		;one space
	lxi	h,COMPCOL
	dcr	m
	jnz	BACKSP
	jmp	READN0		;for next character
NOTR:		;not a ctlr, place into buffer
RDECHO:
	inx	h
	mov	m,a		;character filled to memory
	inr	b		;<b>-len = <b>-len + 1
RDECH1:		;look for a random control character
	push	b
	push	h		;active values saved
	mov	c,a		;ready to print
	call	CTLOUT		;may be up-arrow in <c>
	pop	h
	pop	b
	mov	a,m		;recall char
	cpi	CTLC		;set flags for reboot test
	mov	a,b		;move length to <a>
	jnz	NOTC		;skip if not a control c
	cpi	01		;control-c, must be length 1
	jz	REBOOT		;reboot if <b>len = 1
	;
	;	length not one, so skip reboot
	;
NOTC:		;not reboot, are we at end of buffer?
	cmp	c
	jc	READNX		;go for another if not
READEN:		;end of read operation, store <b>len
	pop	h
	mov	m,b		;m(current len) = <b>
	mvi	c,CR
	jmp	CONOUT		;return carriage return
		;ret
;
FUNC1:		;return console character with echo
	call	CONECH
	jmp	STA$RET
;
FUNC3:		;return reader character
	call	READERF
	jmp	STA$RET
;
FUNC6:		;direct console i/o - read if 0ffh
	mov	a,c
	inr	a
	jz	DIRINP		;0ffh => 00h, means input mode
	;
	;	direct output function
	;
	inr	a
	jz	CONSTF
	jmp	CONOUTF
;
DIRINP:
	call	CONSTF		;status check
	ora	a
	jz	RETMON		;skip, return 00 if not ready
	;
	;	character is ready, get it
	;
	call	CONINF		;into <a>
	jmp	STA$RET
;
FUNC7:		;return i/o byte
	lda	IOLOC
	jmp	STA$RET
;
FUNC8:		;set i/o byte
	lxi	h,IOLOC
	mov	m,c
	ret			;jmp goback
;
FUNC9:		;write line until $ encountered
	xchg
	mov	c,l
	mov	b,h		;<bc>=string address
	jmp	PRINT		;out to console
;
FUNC11:		;check console status
	call	CONBRK
		;(drop through to sta$ret)
;
STA$RET:	;store the <a> register to aret
	sta	ARET
NO$FUNC:	;return, no function inplemented
	ret			;jmp goback
;
SET$LRET1:
	mvi	a,01
	jmp	STA$RET
;
;
;	data areas
;
COMPCOL:db	00		;true if computing column position
STRTCOL:db	00		;starting column position after read
COLUMN:	db	00		;column position
LISTCP:	db	00		;listing toggle
KBCHAR:	db	00		;initial key char = 00
ENTSP:	dw	0000		;entry stack pointer
	ds	SSIZE*2		;stack size
LSTACK	equ	$		;stack starts here
;
;	end of basic i/o system
;
;
	page
;*******************************************************************
;*******************************************************************
;
;	common values shared between bdosi and bdos
;
USRCODE:db	00		;current user number
CURDSK:	db	00		;current disk number
INFO:	dw	0000		;information address
ARET:	dw	0000		;address value to return
LRET	equ	ARET		;low(aret)
;
;*******************************************************************
;*******************************************************************
;***								 ***
;***	B A S I C   D I S K   O P E R A T I N G   S Y S T E M	 ***
;***								 ***
;*******************************************************************
;*******************************************************************
;
DVERS	equ	20h		;version 2.0
;	module addresses
;
;	literal constants
TRUE	equ	0ffh		;constant true
FALSE	equ	000h		;constant false
ENDDIR	equ	0ffffh		;end of directory
BYTE	equ	01		;number of bytes for "byte" type
WORD	equ	02		;number of bytes for "word" type
;
;	fixed addresses in low memory
TFCB	equ	005ch		;default fcb location
TBUFF	equ	0080h		;default buffer loaction
;
;	fixed addresses referenced in bios module are
;	pererr (0009), selerr (000c), roderr (000f)
;
;	error messages handlers
;
SEL$ERROR:	;report select error
	lxi	h,SELERR
;
GOERR:		;<hl> = .errorhandler, call subroutine
	mov	e,m
	inx	h
	mov	d,m		;address of routine in <de>
	xchg
	pchl			;to subroutine
;
;
;	local subroutines for bios interface
;
MOVE:		;move data length, of length <c>, from source <de>,
		;to destination given by <hl>
	inr	c		;in case it is zero
MOVE0:
	dcr	c
	rz			;more to move
	ldax	d
	mov	m,a		;one byte moved
	inx	d
	inx	h		;to next byte
	jmp	MOVE0
;
SELECT$DISK:	;select the disk drive given by curdsk, and fill
		;the base addresses curtrka - alloca, then fill
		;the values of the disk parameter block
	lda	CURDSK
	mov	c,a		;current disk # to <c>
	;
	;	lsb of of <e> = 0, if not yet logged-in
	;
	call	SELDSKF		;<hl> filled by call
	;
	;	<hl> = 0000 if error.  otherwise disk headers
	;
	mov	a,h
	ora	l
	rz			;return with 0000 in <hl> and [z] flag
	;
	;	disk header block address in <hl>
	;
	mov	e,m
	inx	h
	mov	d,m
	inx	h		;<de> = .tran
	shld	CDRMAXA
	inx	h
	inx	h		;.cdrmax
	shld	CURTRKA
	inx	h
	inx	h		;<hl> = .currec
	shld	CURRECA
	inx	h
	inx	h		;<hl> = .buffa
	;
	;	<de> still contains .tran
	;
	xchg
	shld	TRANV		;.tran vector
	lxi	h,BUFFA		;<de> = source for move, <hl> = dest
	mvi	c,ADDLIST
	call	MOVE		;addlist filled
	;
	;	now fill the disk parameter block
	;
	lhld	DPBADDR
	xchg			;<de> is source
	lxi	h,SECTPT	;<hl> is destination
	mvi	c,DPBLIST
	call	MOVE		;data filled
	;
	;	now set single-double map mode
	;
	lhld	MAXALL		;largest allocation number
	mov	a,h		;00 indicates < 255
	lxi	h,SINGLE
	mvi	m,TRUE		;assume <a> = 00
	ora	a
	jz	RET$SELECT
	;
	;	high order of maxall not zero, use double dm
	;
	mvi	m,FALSE
RET$SELECT:
	mvi	a,TRUE
	ora	a
	ret			;select disk function ok
;
HOME:		;move to home position, then offset to start of dir
	call	HOMEF		;move to track 00, sector 00 reference
	;
	;	first directory position selected
	;
	xra	a		;constant zero to accumulator
	lhld	CURTRKA
	mov	m,a
	inx	h
	mov	m,a		;curtrk = 0000
	lhld	CURRECA
	mov	m,a
	inx	h
	mov	m,a		;currec = 0000
	;
	;	curtrk, currec both set to 0000
	;
	ret
;
RDBUFF:		;read buffer and check condition
	call	READF		;current drive, track, sector, dma
	jmp	PER$ERROR
;
WRBUFF:		;write buffer and check condition
		;write type (wrtype) is in register <c>
		;wrtype = 0 => normal write operation
		;wrtype = 1 => directory write operation
		;wrtype = 2 => start of new block
	call	WRITEF		;current drive, track, sector, dma
;
PER$ERROR:	;report permanent error to user
	ora	a
	rz
	lxi	h,PERERR
	jmp	GOERR
;
SEEKDIR:	;seek the record containing the current dir entry
	lhld	DCNT		;directory counter to <hl>
	mvi	c,DSKSHF
	call	HLROTR		;value to <hl>
	shld	ARECORD
	shld	DREC		;ready for seek
;
SEEK:		;seek the track given by arecord (actual record)
		;local equates for registers
ARECH	equ	b
ARECL	equ	c		;arecord = <bc>
CRECH	equ	d
CRECL	equ	e		;currec = <de>
CTRKH	equ	h
CTRKL	equ	l		;curtrk = <hl>
TCRECH	equ	h
TCRECL	equ	l		;tcurrec = <hl>
	;
	;	load the registers from menory
	;
	lxi	h,ARECORD
	mov	ARECL,m
	inx	h
	mov	ARECH,m
	lhld	CURRECA
	mov	CRECL,m
	inx	h
	mov	CRECH,m
	lhld	CURTRKA
	mov	a,m
	inx	h
	mov	CTRKH,m
	mov	CTRKL,a
	;
	;	loop while arecord < currec
	;
SEEK0:
	mov	a,ARECL
	sub	CRECL
	mov	a,ARECH
	sbb	CRECH
	jnc	SEEK1		;skip if arecord >= currec
	;
	;	currec = currec - sectpt
	;
	push	CTRKH
	lhld	SECTPT
	mov	a,CRECL
	sub	l
	mov	CRECL,a
	mov	a,CRECH
	sbb	h
	mov	CRECH,a
	pop	CTRKH
	;
	;	curtrk = curtrk -1
	;
	dcx	CTRKH
	jmp	SEEK0		;for another try
SEEK1:		;look while arecord >= (t:=currec + sectpt)
	push	CTRKH
	lhld	SECTPT
	dad	CRECH		;<hl> = currec + sectpt
	jc	SEEK2
	mov	a,ARECL
	sub	TCRECL
	mov	a,ARECH
	sbb	TCRECH
	jc	SEEK2		;skip if t > arecord
	;
	;	currec = t
	;
	xchg
	;
	;	curtrk = curtrk - 1
	;
	pop	CTRKH
	inx	CTRKH
	jmp	SEEK1		;for another try
SEEK2:
	pop	CTRKH
	;
	;	arrive here with updated values in each register
	;
	push	ARECH
	push	CRECH
	push	CTRKH		;to stack for later
	;
	;stack contains (lowest)<bc>=arecord, <de>=currec, <hl>=curtrk
	;
	xchg
	lhld	OFFSET
	dad	d		;<hl> = curtrk + offset
	mov	b,h
	mov	c,l
	call	SETTRKF		;track set up
	;
	;note than <bc> - curtrk is difference to move in bios
	;
	pop	d		;recall curtrk
	lhld	CURTRKA
	mov	m,e
	inx	h
	mov	m,d		;curtrk updated
	;
	;	now compute sector as arecord - currec
	;
	pop	CRECH		;recall currec
	lhld	CURRECA
	mov	m,CRECL
	inx	h
	mov	m,CRECH
	pop	ARECH		;<bc> = arecord, <de> = currec
	mov	a,ARECL
	sub	CRECL
	mov	ARECL,a
	mov	a,ARECH
	sbb	CRECH
	mov	ARECH,a
	lhld	TRANV
	xchg			;<bc> = sector#, <de> = .tran
	call	SECTRAN		;<hl> = tran(sector)
	mov	c,l
	mov	b,h		;<bc> = tran(sector)
	jmp	SETSECF		;selected sector
		;ret
;
;	file control block (fcb) constants
;
EMPTY	equ	0e5h		;empty directory entry
LSTREC	equ	127		;last record# in extent
RECSIZ	equ	128		;record size
FCBLEN	equ	32		;file control block size
DIRREC	equ	RECSIZ/FCBLEN	;directory blocks per record
DSKSHF	equ	2		;log2 (dirrec)
DSKMSK	equ	DIRREC-1
FCBSHF	equ	5		;log2 (fcblen)
;
EXTNUM	equ	12		;extent number field
MAXEXT	equ	31		;largest extent number
UBYTES	equ	13		;unfilled bytes field
MODNUM	equ	14		;data module number
MAXMOD	equ	15		;largest module number
FWFMSK	equ	80h		;file write flag is high order modnum
NAMLEN	equ	15		;name length
RECCNT	equ	15		;record count field
DSKMAP	equ	16		;disk map field
LSTFCB	equ	FCBLEN-1
NXTREC	equ	FCBLEN
RANREC	equ	NXTREC+1	;random record field (2 bytes)
;
;	reserved file indicators
ROFILE	equ	9		;high order of first type char
INVIS	equ	10		;invisible file in dir command
;	equ	11		;reserved
;
;	utility functions for file access
;
DM$POSITION:	;compute disk map position for vrecord to <hl>
	lxi	h,BLKSHF
	mov	c,m		;shift count to <c>
	lda	VRECORD		;current virtual record to <a>
DMPOS0:
	ora	a
	rar
	dcr	c
	jnz	DMPOS0
	;
	;	<a> = shr(vrecord,blkshf) = vrecord/2**(sect/block)
	;
	mov	b,a		;save it for later addition
	mvi	a,08
	sub	m		;8-blkshf to accumulator
	mov	c,a		;extent shift count in register <c>
	lda	EXTVAL		;extent value and extmsk
DMPOS1:		;blkshf = 3,4,5,6,7, <c> = 5,4,3,2,1
		;shift is 4,3,2,1,0
	dcr	c
	jz	DMPOS2
	ora	a
	ral
	jmp	DMPOS1
DMPOS2:		;arrive here with <a> = shl(ext and extmsk,7-blkshf)
	add	b		;add the previous shr(vrecord,blkshf) value
	;
	;<a> is one if the following values, depending upon allocation
	;
	;bks  blkshf
	;1k	3	v/8 + extval * 16
	;2k	4	v/16 + extval * 8
	;4k	5	v/32 + extval * 4
	;8k	6	v/64 + extval * 2
	;16k	7	v/128 + extval * 1
	;
	ret			;with dm$position in <a>
;
GETDM:		;return disk map value from position given by <bc>
	lhld	INFO		;base address of file control block
	lxi	d,DSKMAP
	dad	d		;<hl> = .diskmap
	dad	b		;index by a single byte value
	lda	SINGLE		;single byte/map entry?
	ora	a
	jz	GETDMD		;get disk map single byte
	mov	l,m
	mvi	h,00
	ret			;with <hl> = 00bb
GETDMD:
	dad	b		;<hl> = .fcb(dm+i*2)
	;
	;	double precision value returned
	;
	mov	e,m
	inx	h
	mov	d,m
	xchg
	ret
;
INDEX:		;compute disk block number from current fcb
	call	DM$POSITION	;0...15 in register <a>
	mov	c,a
	mvi	b,00
	call	GETDM		;value to <hl>
	shld	ARECORD
	ret
;
ALLOCATED:	;called following index to see if block allocated
	lhld	ARECORD
	mov	a,l
	ora	h
	ret
;
ATRAN:
	lda	BLKSHF		;shift count to reg <a>
	lhld	ARECORD
ATRAN0:
	dad	h
	dcr	a
	jnz	ATRAN0		;shl(arecord.blkshf)
	shld	t15e7
	lda	BLKMSK
	mov	c,a		;mask value to <c>
	lda	VRECORD
	ana	c		;masked value in <a>
	ora	l
	mov	l,a		;to <hl>
	shld	ARECORD		;arecord = <hl> or (vrecord and blkmsk)
	ret
;
GETEXTA:	;get current extent field address to <a>
	lhld	INFO
	lxi	d,EXTNUM
	dad	d		;<hl> = .fcb(extnum)
	ret
;
GETFCBA:	;compute reccnt and nxtrec addresses for get/setfcb
	lhld	INFO
	lxi	d,RECCNT
	dad	d
	xchg			;<de> = .fcb(reccnt)
	lxi	h,(NXTREC-RECCNT)
	dad	d		;<hl> = .fcb(nxtrec)
	ret
;
GETFCB:		;set variables from currently addressed fcb
	call	GETFCBA		;addresses in <de>, <hl>
	mov	a,m
	sta	VRECORD		;vrecord = fcb(nxtrec)
	xchg
	mov	a,m
	sta	RCOUNT		;rcount = fcb(reccnt)
	call	GETEXTA		;<hl> = .fcb(extnum)
	lda	EXTMSK		;extent mask to <a>
	ana	m		;fcb(extnum) and extmsk
	sta	EXTVAL
	ret
;
SETFCB:		;place values back into current fcb
	call	GETFCBA		;addresses to <de>, <hl>
	lda	SEQIO
	cpi	02
	jnz	SETFCB0
	xra	a
SETFCB0:
	mov	c,a		;=1 if sequential i/o
	lda	VRECORD
	add	c
	mov	m,a		;fcb(nxtrec) = vrecord+seqio
	xchg
	lda	RCOUNT
	mov	m,a		;fcb(reccnt) = rcount
	ret
;
HLROTR:		;<hl> rotate right by amount in <c>
	inr	c		;in case zero
HLROTR0:
	dcr	c
	rz			;return when zero
	mov	a,h
	ora	a
	rar
	mov	h,a		;high byte
	mov	a,l
	rar
	mov	l,a		;low byte
	jmp	HLROTR0
;
COMPUTE$CS:	;compute checksum for current directory buffer
	mvi	c,RECSIZ	;size of directory buffer
	lhld	BUFFA		;current directory buffer
	xra	a		;clear checksum value
COMPUTE$CS0:
	add	m
	inx	h
	dcr	c		;cs=cs+buff(recsiz-<c>)
	jnz	COMPUTE$CS0
	ret			;with checksum in <a>
;
HLROTL:		;rotate the mask in <hl> by amount in <c>
	inr	c		;may be zero
HLROTL0:
	dcr	c
	rz			;return if zero
	dad	h		;shl(<hl>,1)
	jmp	HLROTL0
;
SET$CDISK:	;set a "1" value in curdsk position of <bc>
	push	b		;save input parameter
	lda	CURDSK
	mov	c,a		;ready parameter for shift
	lxi	h,0001		;number to shift
	call	HLROTL		;<hl> = mask to integrate
	pop	b		;original mask
	mov	a,c
	ora	l
	mov	l,a
	mov	a,b
	ora	h
	mov	h,a		;<hl> = mask or rol(1,curdsk)
	ret
;
NOWRITE:	;return true if dir checksum defference occurred
	lhld	RODSK
	lda	CURDSK
	mov	c,a
	call	HLROTR
	mov	a,l
	ani	0000$0001b
	ret			;non-zero if nowrite
;
SET$RO:		;set current disk to read only
	lxi	h,RODSK
	mov	c,m
	inx	h
	mov	b,m
	call	SET$CDISK	;sets bit to "1"
	shld	RODSK
	;
	;	high water mark in directory goes to max.
	;
	lhld	DIRMAX
	inx	h
	xchg			;<de> = directory max
	lhld	CDRMAXA		;<hl> = .cdrmax
	mov	m,e
	inx	h
	mov	m,d		;cdrmax = dirmax
	ret
;
CHECK$ROFILE:	;check current buff(dptr) or fcb(0) for r/o status
	call	GETDPTRA
CK$RO$FILE:
	lxi	d,ROFILE
	dad	d		;offset to ro bit
	mov	a,m
	ral
	rnc			;return if not set
;
ROF$ERROR:	;report read/only file error
	lxi	h,ROFERR
	jmp	GOERR
;
CHECK$WRITE:	;check for write protected disk
	call	NOWRITE
	rz			;ok to write if not rodsk
;
ROD$ERROR:	;report read/only disk error
	lxi	h,RODERR
	jmp	GOERR
;
GETDPTRA:	;compute the address of a directory element at
		;position dptr in the buffer
	lhld	BUFFA
	lda	DPTR
;
ADDH:		;<hl> = <hl> + <a>
	add	l
	mov	l,a
	rnc			;overflow to <h>
	inr	h
	ret
;
GETMODNUM:	;compute the address of the module number
		;bring module number to accumulator
		;(high order byte is fwf(file write flag))
	lhld	INFO
	lxi	d,MODNUM
	dad	d		;<hl> = .fcb(modnum)
	mov	a,m
	ret			;<a> = fcb(modnum)
;
CLRMODNUM:	;clear the module number field for user open make
	call	GETMODNUM
	mvi	m,00		;fcb(modnum) = 00
	ret
;
SETFWF:
	call	GETMODNUM	;<hl> = .fcb(modnum), <a> = fcb(modnum)
	;
	;	set fwf (file write flag) to "1"
	;
	ori	FWFMSK
	mov	m,a		;fcb(modnum) = fcb(modnum) or 80h
	;
	;	also returns non-zero in accumulator
	;
	ret
;
COMPCDR:	;return [cy] if dcrmax > dcnt
	lhld	DCNT
	xchg			;<de> = directory counter
	lhld	CDRMAXA		;<hl> = .cdrmax
	mov	a,e
	sub	m		;low(dcnt) - low(cdrmax)
	inx	h		;<hl> = .cdrmax + 1
	mov	a,d
	sbb	m		;high(dcnt) - high(cdrmax)
	;
	;	condition dcnt-cdrmax, produces [cy] if cdrmax > dcnt
	;
	ret
;
SETCDR:		;if not(cdrmax > dcnt) then cdrmax = dcnt+1
	call	COMPCDR
	rc			;return if cdrmax > dcnt
	;
	;	otherwise <hl> = .dcrmax+1, <de> = dcnt
	;
	inx	d
	mov	m,d
	dcx	h
	mov	m,e
	ret
;
SUBDH:		;compute <hl> = <de>-<hl>
	mov	a,e
	sub	l
	mov	l,a
	mov	a,d
	sbb	h
	mov	h,a
	ret
;
NEWCHECKSUM:
	mvi	c,TRUE		;drop through to compute new checksum
CHECKSUM:	;compute current checksum record and update the
		;directory element if [c]=true, or check for = if not
		;drec < chksiz ?
	lhld	DREC
	xchg
	lhld	CHKSIZ
	call	SUBDH		;<de>-<hl>
	rnc		;skip checksum if past checksum vector size
	;
	;	drec < chksiz, so continue
	;
	push	b		;save init flag
	call	COMPUTE$CS	;check sum value to <a>
	lhld	CHECKA		;address of check sum vector
	xchg
	lhld	DREC		;value of drec
	dad	d		;<hl> = .check(drec)
	pop	b		;recall true = 0ffh or false = 00 to <c>
	inr	c		;0ffh produces zero flag
	jz	INITIAL$CS
	;
	;	not initializing, compare
	;
	cmp	m		;compute$cs = check(drec)?
	rz			;no message if ok
	;
	;	checksum error, are we beyond
	;	the end of the disk?
	;
	call	COMPCDR
	rnc			;no message if so
	call	SET$RO		;read/only disk set
	ret
INITIAL$CS:	;initializing the checksum
	mov	m,a
	ret
;
WRDIR:		;write the current directory entry, set checksum
	call	NEWCHECKSUM	;initialize entry
	call	SETDIR		;directory dma
	mvi	c,01		;indicates a write directory operation
	call	WRBUFF		;write the buffer
	jmp	SETDATA		;to data dma address
		;ret
;
RD$DIR:		;read a directory entry into the directory buffer
	call	SETDIR		;directory dma
	call	RDBUFF		;directory record loader
;
SETDATA:	;set data dma address
	lxi	h,DMAAD
	jmp	SETDMA		;to complete the call
;
SETDIR:		;set directory dma address
	lxi	h,BUFFA
;
SETDMA:		;<hl> = .dma address to set (i.e., buffa or dmaad)
	mov	c,m
	inx	h
	mov	b,m		;parameter ready
	jmp	SETDMAF
;
DIR$TO$USER:	;copy the directory entry to the user buffer
		;after call to search or searchn by user code
	lhld	BUFFA
	xchg			;source is directory buffer
	lhld	DMAAD		;destination is user dma address
	mvi	c,RECSIZ	;copy entire record
	jmp	MOVE
		;ret
;
END$OF$DIR:	;return zero flag if at end of directory, non-zero
		;if not at end (end if dir if dcnt = 0ffffh)
	lxi	h,DCNT
	mov	a,m		;may be 0ffh
	inx	h
	cmp	m		;low(dcnt) = high(dcnt) ?
	rnz			;non-zero returned if different
	;
	;	high and low the same = 0ffh ?
	;
	inr	a		;0ffh becomes 00 if so
	ret
;
SET$END$DIR:	;set dcnt to the end of the directory
	lxi	h,ENDDIR
	shld	DCNT
	ret
;
READ$DIR:	;read next directory entry
		; with <c> = true if initializing
	lhld	DIRMAX
	xchg			;in preparation for subtract
	lhld	DCNT
	inx	h
	shld	DCNT		;dcnt = dcnt + 1
	;
	;	continue while dirmax >= dcnt (dirmac-dcnt no [cy])
	;
	call	SUBDH		;<de>-<hl>
	jnc	READ$DIR0
	;
	;	yes, set dcnt to end of directory
	;
	jmp	SET$END$DIR
;
READ$DIR0	;not at end of directory, seek next element
		;initialization flag is in <c>
	lda	DCNT
	ani	DSKMSK		;low(dcnt) and dskmak
	mvi	b,FCBSHF	;to multiply by fcb size
READ$DIR1:
	add	a
	dcr	b
	jnz	READ$DIR1
	;
	;	<a> = (low(dcnt and dskmsk) shl fcbshf)
	;
	sta	DPTR		;ready for next dir operation
	ora	a
	rnz			;return if not a new record
	push	b		;save initalization flag in <c>
	call	SEEK$DIR	;seek proper record
	call	RD$DIR		;read the directory record
	pop	b		;recall initialization flag
	jmp	CHECKSUM	;checksum the directory element
		;ret
;
GETALLOCBIT:	;given allocation vector position <bc>.
		;return with byte containing <bc> shifted so
		;that the least significant bit is in the low
		;order accumulator position.  <hl> is
		;the address of the byte for possible replacement in
		;memory upon return, and <d> contains the
		;number of shifts required to place the
		;returned value back into position.
	mov	a,c
	ani	0000$0111b
	inr	a
	mov	e,a
	mov	d,a
	;
	;	<d> & <e> both contain the number of bit
	;	positions to shift
	;
	mov	a,c

;	rept 3
;	rrc
;	endm
	rrc
	rrc
	rrc

	ani	0001$1111b
	mov	c,a		;<c> shr 3
	mov	a,b

;	rept 5
;	add	a
;	endm			;<b> shl 5
	add	a
	add	a
	add	a
	add	a
	add	a

	ora	c
	mov	c,a		;<bbb><ccccc> to <c>
	mov	a,b

;	rept 3
;	rrc
;	endm
	rrc
	rrc
	rrc

	ani	0001$1111b
	mov	b,a		;<bc> shr 3
	lhld	ALLOCA		;address of allocation vector
	dad	b
	mov	a,m
	;
	;	now move the bit to the low order position of <a>
	;
;
ROTL:
	rlc
	dcr	e
	jnz	ROTL
	ret
;
SETALLOCBIT:	;<bc> is the bit position fo alloc to set or
		;reset.  the value of the bit is is register <e>
	push	d
	call	GETALLOCBIT	;shifted val <a>, count in <d>
	ani	1111$1110b	;mask low bit to zero, (may be set)
	pop	b
	ora	c		;low bit of <c> is masked into <a>
;
ROTR:		;byte value from alloc is in register <a>,
		;with shift count in register <c> (to place
		;byte back into position).  and target alloc
		;position in registers <hl>.  rotate and replace
	rrc
	dcr	d
	jnz	ROTR		;back into position
	mov	m,a		;back to alloc
	ret
;
SCANDM:		;scan the disk map addressed by dptr for
		;non-zero entries, the allocation vector entry
		;corresponding to a non-zero entry is set
		;to the value of <c> (0,1)
	call	GETDPTRA	;<hl> = buffa + dptr
	;
	;	<hl> addresses the beginning of the directory entry
	;
	lxi	d,DSKMAP
	dad	d		;<hl> now addresses the disk map
	push	b		;save the 0/1 bit to set
	mvi	c,FCBLEN-DSKMAP+1	;size of single byte
					;disk map + 1
SCANDM0:	;loop once for each disk map entry
	pop	d		;recall bit parity
	dcr	c
	rz			;all done scanning ?
	;
	;	no, get next entry for scan
	;
	push	d		;replace bit parity
	lda	SINGLE
	ora	a
	jz	SCANDM1
	;
	;	single byte scan operation
	;
	push	b		;save counter
	push	h		;save map address
	mov	c,m
	mvi	b,00		;<bc> = block #
	jmp	SCANDM2
SCANDM1:	;double byte scan operation
	dcr	c		;count for double byte
	push	b		;save counter
	mov	c,m
	inx	h
	mov	b,m		;<bc> = block #
	push	h		;save map address
SCANDM2:	;arrive here with <bc> = block #, <e> = 0/1
	mov	a,c
	ora	b		;skip if = 0000
	jz	SCANDM3
	lhld	MAXALL
	mov	a,l
	sub	c
	mov	a,h
	sbb	b
	cnc	SET$ALLOC$BIT	;bit set to 0/1
SCANDM3:
	pop	h
	inx	h		;to next bit position
	pop	b		;recall counter
	jmp	SCANDM0
;
INITIALIZE:	;initialize the current disk
		;lret = false
		;set to true if $$$ file exists
		;compute the length of the allocation vector
	lhld	MAXALL
	mvi	c,03		;perform maxall/8
	;
	;	number of bytes in alloc vector is (maxall/8)+1
	;
	call	HLROTR
	inx	h		;<hl> = maxall/8+1
	mov	b,h
	mov	c,l		;count down <bc> till zero
	lhld	ALLOCA		;base of allocation vectors
	;
	;	fill the allocation vector with zeros
	;
;
INITIAL0:
	mvi	m,00
	inx	h		;alloc(i) = 00
	dcx	b		;count length down
	mov	a,b
	ora	c
	jnz	INITIAL0
	;
	;	set the reserved space for the directory
	;
	lhld	DIRBLK
	xchg
	lhld	ALLOCA		;<hl> = alloc()
	mov	m,e
	inx	h
	mov	m,d		;sets reserved directory blks
	;
	;	allocation vector initialized, home disk
	call	HOME
	;
	;	cdrmax = 3 (scans at least one directory record
	;
	lhld	CDRMAXA
	mvi	m,03
	inx	h
	mvi	m,00
	;
	;	cdrmax = 000
	;
	call	SET$END$DIR	;dcnt = enddir
	;
	;	read directory entries and check for
	;	allocated storage
	;
INITIAL2:
	mvi	c,TRUE
	call	READ$DIR
	call	END$OF$DIR
	rz			;return if end of directory
	;
	;	not end of directory, valid entry?
	;
	call	GETDPTRA	;<hl> = buffa + dptr
	mvi	a,EMPTY
	cmp	m
	jz	INITIAL2	;to get another item
	;
	;	not empty, user code the same ?
	;
	lda	USRCODE
	cmp	m
	jnz	PDOLLAR
	;
	;	same user code, check for "$$$" submit
	;
	inx	h
	mov	a,m		;first character
	sui	'$'		;dollar file ?
	jnz	PDOLLAR
	;
	;	dollar file found, mark in lret
	;
	dcr	a
	sta	LRET		;lret = 255
PDOLLAR:	;now scan the disk map for allocated blocks
	mvi	c,01		;set to allocated
	call	SCANDM
	call	SETCDR		;set cdrmax to dcnt
	jmp	INITIAL2	;for another entry
;
COPY$DIRLOC:	;copy directory location to lret following
		;delete,rename,....ops
	lda	DIRLOC
	jmp	STA$RET
;
COMPEXT:	;compare extent# in <a> with that in <c>
		;return non-zero if they do not match
	push	b		;save <c>'s original value
	push	psw
	lda	EXTMSK
	cma
	mov	b,a
	;
	;	<b> has negated form of extent mask
	;
	mov	a,c
	ana	b
	mov	c,a		;low bits removed from <c>
	pop	psw
	ana	b		;low bits removed from <a>
	sub	c
	ani	MAXEXT		;set flags
	pop	b		;restore original values
	ret
;
SEARCH:		;search for directory element length <c> at info
	mvi	a,0ffh
	sta	DIRLOC		;changed if actually found
	lxi	h,SEARCHL
	mov	m,c		;searchl = <c>
	lhld	INFO
	shld	SEARCHA		;searcha = info
	call	SET$END$DIR	;dcnt = enddir
	call	HOME		;to start at the beginning
;
SEARCHN:	;search for the next directory element, assuming
		;a pervious call on search which sets
		;searcha and searchl
	mvi	c,FALSE
	call	READ$DIR	;read next dir element
	call	END$OF$DIR
	jz	SEARCH$FIN	;skip to end if so
	;
	;	not end of directory, scan for match
	;
	lhld	SEARCHA
	xchg			;<de> = beginning of user fcb
	ldax	d		;first character
	cpi	EMPTY		;keep scanning if empty
	jz	SEARCHNEXT
	;
	;	not empty, may be end of logical directory
	;
	push	d		;save search address
	call	COMPCDR		;past logical end?
	pop	d		;recall address
	jnc	SEARCH$FIN	;artificial stop
;
SEARCHNEXT:
	call	GETDPTRA	;<hl> = buffa + dptr
	lda	SEARCHL
	mov	c,a		;length of search to <c>
	mvi	b,00		;<b> counts up, <c> counts down
;
SEARCHLOOP:
	mov	a,c
	ora	a
	jz	ENDSEARCH
	ldax	d
	cpi	'?'
	jz	SEARCHOK	;"?" matches anything
	;
	;	scan next character if not ubytes
	;
	mov	a,b
	cpi	UBYTES
	jz	SEARCHOK
	;
	;	not the ubytes field, extent field
	;
	cpi	EXTNUM		;may be extent field
	ldax	d		;fcb character
	jz	SEARCHEXT	;skip to search extent
	sub	m
	ani	07fh		;mask-out flags
	jnz	SEARCHN		;skip if not matched
	jmp	SEARCHOK	;matched character
;
SEARCHEXT:	;<a> has fcb character
		;attempt and extent # match
	push	b		;save counters
	mov	c,m		;directory character to <c>
	call	COMPEXT		;compare user/dir character
	pop	b		;recall counters
	jnz	SEARCHN		;skip if no match
;
SEARCHOK:	;current character matches
	inx	d
	inx	h
	inr	b
	dcr	c
	jmp	SEARCHLOOP
;
ENDSEARCH:	;entire name matches, return dir position
	lda	DCNT
	ani	DSKMSK
	sta	LRET
	;
	;	lret = low(dcnt) and 0000$0011b
	;
	lxi	h,DIRLOC
	mov	a,m
	ral
	rnc
	;
	;	yes, change it to 0 to mark as found
	;
	xra	a
	mov	m,a		;dirloc = 00
	ret
SEARCH$FIN:	;end of directory, or empty name
	call	SET$END$DIR	;may be artifical end
	mvi	a,255
	jmp	STA$RET
;
DELETE:		;delete the currently addressed file
	call	CHECK$WRITE	;write protected ?
	mvi	c,EXTNUM
	call	SEARCH		;search through file type
;
DELETE0:	;loop while directory matches
	call	END$OF$DIR
	rz			;stop if end
	;
	;set eacn non-zero disk map entry to 0
	;in the allocation vector
	;may be r/o file
	;
	call	CK$RO$FILE	;ro disk error if found
	call	GETDPTRA	;<hl> = .buff(dptr)
	mvi	c,EMPTY
	mvi	c,00
	call	SCANDM		;alloc elements set to 0
	call	WRDIR		;write the directory
	call	SEARCHN		;to next element
	jmp	DELETE0		;for another record
;
GET$BLOCK:	;given allocation vector position <bc>, find
		;the zero bit closest to this position by
		;searching left and right.
		;if found, set the bit to one and return
		;the bit position in <hl>.  if not found
		;(i.e. we pass 0 on the left or maxall on
		;the right), return 0000 in <hl>
	mov	d,b
	mov	e,c		;copy of starting position to <de>
;
LEFTTST:
	mov	a,c
	ora	b
	jz	RIGHTTST	;skip if left=0000
	;
	;	left not at position zero, bit zero ?
	;
	dcx	b
	push	d
	push	b		;left, right pushed
	call	GETALLOCBIT
	rar
	jnc	RETBLOCK	;return block number if zero
	;
	;	bit is one, so try the right
	;
	pop	b
	pop	d		;left, right restored
;
RIGHTTST:
	lhld	MAXALL		;value of maximum allocation #
	mov	a,e
	sub	l
	mov	a,e
	sbb	h		;right = maxall ?
	jnc	RETBLOCK0	;return block 0000 if so
	inx	d
	push	b
	push	d		;left, right pushed
	mov	b,d
	mov	c,e		;ready right for call
	call	GETALLOCBIT
	rar
	jnc	RETBLOCK	;return block number if zero
	pop	d
	pop	b		;restore left and right pointers
	jmp	LEFTTST		;for another attempt
;
RETBLOCK:
	ral
	inr	a		;bit back into position and
				;set to "1"
	;
	;<d> contains the number of shifts required to repeat
	;
	call	ROTR		;mov bit back to position and store
	pop	h
	pop	d		;<hl> teturned value, <de> discarded
	ret
;
RETBLOCK0:	;cannot find an available bit, return 0000
	mov	a,c
	ora	b
	jnz	LEFTTST
	lxi	h,0000
	ret
;
COPY$FCB:	;copy the entire file control block
	mvi	c,00
	mvi	e,FCBLEN	;start at 0, to fcblen-1
;
COPY$DIR:	;copy fcb information starting at <c> for <e> bytes
		;into the currently addressed directory entry
	push	d		;save length for later
	mvi 	b,00		;double index to <bc>
	lhld	INFO		;<hl> = source for data
	dad	b
	xchg			;<de> = .fcb(c), source for copy
	call	GETDPTRA	;<hl> = .buff(dptr).destination
	pop	b		;<de> = source,<hl> = dest,<c> = length
	call	MOVE		;data moved
;
SEEK$COPY:	;enter from close to seek and copy current element
	call	SEEK$DIR	;to the directory element
	jmp	WRDIR		;write the directory element
		;ret
;
RENAME:		;rename the file described by the first half of
		;the currently addressed file control block.
		;the new name is contained in the last half of
		;the currently addressed file control block.
		;the file name and type are changed.  but the
		;reel number is ignored.  the user number is
		;identical
	call	CHECK$WRITE	;may be write protected
	;
	;	search pu to the extent field
	mvi	c,EXTNUM
	call	SEARCH
	;
	;	copy position 0
	;
	lhld	INFO
	mov	a,m		;<hl> = .fcb(0), <a> = fcb(0)
	lxi	d,DSKMAP
	dad	d		;<hl> = .fcb(dskmap)
	mov	m,a		;fcb(dskmap) = fcb(0)
	;
	;	assume the same disk drive for new named file
	;
;
RENAME0:
	call	END$OF$DIR
	rz			;stop at end of dir
	;
	;	not end of directory, rename next element
	;
	call	CK$RO$FILE	;may be read-only file
	mvi	c,dskmap
	mvi	e,EXTNUM
	call	COPY$DIR
	;
	;	element renamed, move to next
	;
	call	SEARCHN
	jmp	RENAME0
;
INDICATORS:	;set file indicators for current fcb
	mvi	c,EXTNUM
	call	SEARCH		;through file type
;
INDIC0:
	call	END$OF$DIR
	rz			;stop at end of dir
	;
	;	not end of directory, continue to change
	;
	mvi	c,00
	mvi	e,EXTNUM	;copy name
	call	COPY$DIR
	call	SEARCHN
	jmp	INDIC0
;
OPEN:		;search for the directory entry, copy to fcb
	mvi	c,NAMLEN
	call	SEARCH
	call	END$OF$DIR
	rz			;return with lret=255 if end
	;
	;	not end of directory, copy fcb information
	;
;
OPEN$COPY:	;(referenced below to copy fcb info)
	call	GETEXTA
	mov	a,m
	push	psw
	push	h		;save extent #
	call	GETDPTRA
	xchg			;<de> = .buff(dptr)
	lhld	INFO		;<hl> = fcb(0)
	mvi	c,NXTREC	;length of move operation
	push	d		;save .buff(dptr)
	call	MOVE		;from .buff(dptr) to .fcb(0)
	;
	;	note that entire fcb is copied, including indicators
	;
	call	SETFWF		;sets file write flag
	pop	d
	lxi	h,EXTNUM
	dad	d		;<hl> .buf(dptr+extnum)
	mov	c,m		;<c> = directory extent number
	lxi	h,RECCNT
	dad	d		;<hl> = .buff(dptr+reccnt)
	mov	b,m		;<b> holds directory record count
	pop	h
	pop	psw
	mov	m,a		;restore extent number
	;
	;<hl> = .user extent #, <b> = dir rec cnt, <c> = dir extent #
	;if user ext < dir ext then user := 128 records
	;if user ext = dir ext then user := dir records
	;if user ext > dir ext then user := 0 records
	;
	mov	a,c
	cmp	m
	mov	a,b		;ready dir ceccnt
	jz	OPEN$RCNT	;if save, user gets dir reccnt
	mvi	a,00
	jc	OPEN$RCNT	;user is larger
	mvi	a,128		;directory is larger
;
OPEN$RCNT:	;<a> has record count to fill
	lhld	INFO
	lxi	d,RECCNT
	dad	d
	mov	m,a
	ret
;
MERGEZERO:	;<hl> = .fcb1(i), <de> = fcb2(i)
		;if fcb1(i) = 0 then fcb1(i) := fcb2(i)
	mov	a,m
	inx	h
	ora	m
	dcx	h
	rnz			;return if = 0000
	ldax	d
	mov	m,a
	inx	d
	inx	h		;low byte copied
	ldax	d
	mov	m,a
	dcx	d
	dcx	h		;back to input for more
	ret
;
CLOSE:		;locate the directory element and re-write it
	xra	a
	sta	LRET
	sta	DCNT
	sta	t15eb
	call	NOWRITE
	rnz			;skip close if r/o disk
	;
	;	check file write flag - 0 indicates written
	;
	call	GETMODNUM	;fcb(modnum) in <a>
	ani	FWFMSK
	rnz			;return if bit remains set
	mvi	c,NAMLEN
	call	SEARCH		;locate file
	call	END$OF$DIR
	rz			;return if not found
	;
	;	merge the disk map at info with that at buff(dptr)
	;
	lxi	b,DSKMAP
	call	GETDPTRA
	dad	b
	xchg			;<de> is .buff(dptr+16)
	lhld	INFO
	dad	b		;<de> = .buff(dptr+16),<hl> = .fcb(16)
	mvi	c,(FCBLEN-DSKMAP)	;length of single byte dm
;
MERGE0:
	lda	SINGLE
	ora	a
	jz	MERGED		;skip to double
	;
	;	this is a single byte map
	;	if fcb(i) = 0 then fcb(i) =buff(i)
	;	if buff(i) = 0 then buff(i) = fcb(i)
	;	if fcb(i) <> buff(i) then error
	;
	mov	a,m
	ora	a
	ldax	d
	jnz	FCBNZERO
	;
	;	fcb(i) = 0
	;
	mov	m,a		;fcb(i) = buff(i)
;
FCBNZERO:
	ora	a
	jnz	BUFFNZERO
	;
	;	buff(i) = fcb(i)
	;
	mov	a,m
	stax	d		;buff(i) = fcb(i)
;	
BUFFNZERO:
	cmp	m
	jnz	MERGERR		;fcb(i) = buff(i) ?
	jmp	DMSET		;if merge ok
;
MERGED:		;this is a double byte merge operation
	call	MERGEZERO	;buff = fcb if buff 0000
	xchg
	call	MERGEZERO
	xchg			;fcb = buff if fcb = 0000
	;
	;	they should be identical at this point
	;
	ldax	d
	cmp	m
	jnz	MERGERR		;low same ?
	inx	d
	inx	h		;to high byte
	ldax	d
	cmp	m
	jnz	MERGERR		;high same ?
	;
	;	merge operation is for this pair
	;
	dcr	c		;extra count for double byte
;
DMSET:
	inx	d
	inx	h		;to next byte position
	dcr	c
	jnz	MERGE0		;for more
	;
	;	end of disk map merge, check record count
	;	<de> = .buff(dptr)+32, <hl> = .fcb(32)
	;
	lxi	b,-(FCBLEN-EXTNUM)
	dad	b
	xchg
	dad	b
	;
	;	<de> = .fcb(extnum), <hl> = .buff(dptr+extnum)
	;
	ldax	d		;current user extent number
	;
	;	if fcb(ext) >= buff(fcb) then
	;	buff(ext) := fcb(ext), buff(rec) := fcb(rec)
	;
	cmp	m
	jc	ENDMERGE
	;
	;	fcb extent funber <= dir extent number
	;
	mov	m,a		;buff(ext) = fcb(ext)
	;
	;	update directory record count field
	lxi	b,(RECCNT-EXTNUM)
	dad	b
	xchg
	dad	b
	;
	;	<de> = .buff(reccnt), <hl> .fcb(reccnt)
	;
	mov	a,m
	stax	d		;buff(reccnt = fcb(reccnt)
;
ENDMERGE:
	mvi	a,TRUE
	sta	FCB$COPIED	;mark as copied
	jmp	SEEK$COPY	;ok to "wrdir" here - 1.4 compatible
;
MERGERR:	;elements did not merge correctly
	lxi	h,LRET
	dcr	m		;=255 non-zero flag set
	ret
;
MAKE:		;create a new file by creating a directory entry
		;then opening the file
	call	CHECK$WRITE	;may be write protected
	lhld	INFO
	push	h		;save fcb address, look for 0e5H
	lxi	h,EFCB
	shld	INFO		;info = .empty
	mvi	c,02
	call	SEARCH		;length 1 match on empty entry
	call	END$OF$DIR	;zero flag set if no space
	pop	h		;recall info address
	shld	INFO		;in case we return here
	rz		;return with error condition 255 if not found
	xchg			;<de> = info address
	;
	;	clear the remainder of the fcb
	lxi	h,NAMLEN
	dad	d		;<hl> = .fcb(namlen)
	mvi	c,FCBLEN-NAMLEN	;number of bytes to fill
	xra	a		;clear accumulator to 00 for fill
;
MAKE0:
	mov	m,a
	inx	h
	dcr	c
	jnz	make0
	lxi	h,UBYTES
	dad	d		;<hl> = .fcb(ubytes)
	mov	m,a		;fcb(ubytes) = 0
	call	SETCDR		;may have extended the directory
	;
	;	now copy entry to the directory
	;
	call	copy$fcb
	;
	;	and set the file write flag to "1"
	;
	jmp	SETFWF
		;ret
;
OPEN$REEL:	;close the couurnt extent, and open the next one
		;if possible.  rmf is true if in read mode
	xra	a
	sta	FCB$COPIED	;set true if actually copied
	call	CLOSE		;close current extent
	;
	;	lret remains at enddir if we cannot open the
	;	next extent
	;
	call	END$OF$DIR
	rz			;return if end
	;
	;	increment extent number
	lhld	INFO
	lxi	b,EXTNUM
	dad	b		;<hl> = .fcb(extnum
	mov	a,m
	inr	a
	ani	MAXEXT
	mov	m,a		;fcb(extnum = ++1
	jnz	OPEN$MOD	;move to next module if zero
	;
	;	may be in the same extent group
	;
	mov	b,a
	lda	EXTMSK
	ana	b
	;
	;	if result is zero, then not in the same group
	lxi	h,FCB$COPIED	;true if the fcb was copied to directory
	ana	m		;produces a 00 in accumulator if not written
	jz	OPEN$REEL0	;go to next physical extent
	;
	;result is non-zero, so we must be in same logical extent
	;
	jmp	OPEN$REEL1	;to copy fcb information
;
OPEN$MOD:	;extent number overflow, go to next module
	lxi	b,(MODNUM-EXTNUM)
	dad	b		;<hl> = .fcb(modnum)
	inr	m		;fcb(modnum) = ++1
	;
	;	module number incremented, check for overflow
	;
	mov	a,m
	ani	MAXMOD		;mask high order bits
	jz	OPEN$R$ERR	;cannot overflow to zero
	;
	;	otherwise, ok to continue with new module
;
OPEN$REEL0:
	mvi	c,NAMLEN
	call	SEARCH		;next extent found ?
	call	END$OF$DIR
	jnz	OPEN$REEL1
	;
	;	end of file encounteded
	;
	lda	RMF
	inr	a		;0ffh becomes 00 if read
	jz	OPEN$R$ERR	;sets lret = 1
	;
	;	try to extend the current file
	;
	call	MAKE
	;
	;	cannot be end of directory
	;
	call	END$OF$DIR
	jz	OPEN$R$ERR	;with lret = 1
	jmp	OPEN$REEL2
;
OPEN$REEL1:	;not end of file, open
	call	OPEN$COPY
;
OPEN$REEL2:
	call	GETFCB		;set parameters
	xra	a
	jmp	STA$RET		;return with lret = 0
;
OPEN$R$ERR:	;cannot move to next extent of this file
	call	SETLRET1	;lret = 1
	jmp	SETFWF		;ensure that it will not be closed
		;ret
;
SEQDISKREAD:	;sequential disk read operation
	mvi	a,01
	sta	SEQIO
	;
	;	drop through to diskread
	;
DISKREAD:	;(may enter from seqdiskread)
	mvi	a,TRUE
	sta	RMF		;read mode flag = true (open$reel)
	;
	;	read the next record from the current fcb
	;
	call	GETFCB		;sets parameters for the read
	lda	VRECORD
	lxi	h,RCOUNT
	cmp	m		;vrecord-rcount
	;
	;	skip if rcount > vrecord
	;
	jc	RECORDOK
	;
	;	not enough records in the extent
	;	record count must be 128 to continue
	;
	cpi	128		;vrecord = 128 ?
	jnz	DISKEOF		;skip if vrecord <> 128
	call	OPEN$REEL	;go to next extent if so
	xra	a
	sta	VRECORD		;vrecord = 00
	;
	;	now check for open ok
	;
	lda	LRET
	ora	a
	jnz	DISKEOF		;stop at eof
;
RECORDOK:	;arrive with fcb addressing a record to read
	call	INDEX
	;
	;	error 2 if reading unwritten data
	;	(returns 1 to be compatible with 1.4)
	;
	call	ALLOCATED	;arecord = 0000 ?
	jz	DISKEOF
	;
	;	record has been allocated, read it
	;
	call	ATRAN		;arecord now a disk address
	call	SEEK		;to proper track, sector
	call	RDBUFF		;to dma address
	jmp	SETFCB		;replace parameters
		;ret
;
DISKEOF:
	jmp	SETLRET1	;lret = 1
		;ret
;
SEQDISKWRITE:	;sequential disk write
	mvi	a,01
	sta	SEQIO
	;
	;	drop through to diskwrite
	;
;
DISKWRITE:	;(may enter here from seqdiskwrite above)
	mvi	a,FALSE
	sta	RMF		;read mode flag
	;
	;	write record to currently selected file
	;
	call	CHECK$WRITE	;in case write protected
	lhld	INFO		;<hl> = .fcb(0)
	call	CHECK$ROFILE	;may be a read-only file
	call	GETFCB		;to set local parameters
	lda	VRECORD
	cpi	LSTREC+1	;vrecord -128
	;
	;	skip if vrecord > lstrec
	;	vrecord = 128, cannot poen next extent
	;
	jnc	SETLRET1	;lret = 1
;
DISKWR0:	;can write the next record, so continue
	call	INDEX
	call	ALLOCATED
	mvi	c,00		;marked as normal write
				;operation for wrbuff
	jnz	DISKWR1
	;
	;	not allocated
	;	the argument to getblock is the starting
	;	position for the disk search, and should be
	;	the last allocated block for this file.  or
	;	the value 0 if no space has been allocated
	call	DM$POSITION
	sta	DMINX		;save for later
	lxi	b,0000h		;may use block zero
	ora	a
	jz	NOPBLOCK	;skip if no previous block
	;
	;	previous block exists at <a>
	;
	mov	c,a
	dcx	b		;previous block # in <bc>
	call	GETDM		;previous block # to <hl>
	mov	b,h
	mov	c,l		;<bc> = previous block #
;
NOPBLOCK:	;<bc> = 0000, or previous block #
	call	GET$BLOCK	;block # in <hl>
	;
	;	arrive here with block # or zero
	;
	mov	a,l
	ora	h
	jnz	BLOCKOK
	;
	;	cannot find a block to allocate
	;
	mvi	a,02
	jmp	STA$RET
;
BLOCKOK:	;allocated block number is in <hl>
	shld	ARECORD
	xchg			;block number to <de>
	lhld	INFO
	lxi	b,DSKMAP
	dad	b		;<hl> = .fcb(dskmap)
	lda	SINGLE
	ora	a		;set flags for single byte dm
	lda	DMINX		;recall dm index
	jz	ALLOCWD		;skip if allocating word
	;
	;	allocating a byte value
	;
	call	ADDH
	mov	m,e		;single byte alloc
	jmp	DISKWRU		;to continue
;
ALLOCWD:	;allocate a word value
	mov	c,a
	mvi	b,00		;double(dminx)
	dad	b
	dad	b		;<hl> = .fcb(dminx*2)
	mov	m,e
	inx	h
	mov	m,d		;double word
;
DISKWRU:	;disk write to perviously unallocated block
	mvi	c,02		;marked as unallocated write
;
DISKWR1:	;continue the write operation if no allocation error
		;<c> = 0 if normat write, 2 if to prev unalloc block
	lda	LRET
	ora	a
	rnz			;stop if non-zero returned value
	push	b		;save write flag
	call	ATRAN		;arecord set
	lda	SEQIO
	dcr	a
	dcr	a
	jnz	DISKWR1C
	pop	b
	push	b
	mov	a,c
	dcr	a
	dcr	a
	jnz	DISKWR1C
	push	h
	lhld	BUFFA
	mov	d,a
;
DISKWR1A:
	mov	m,a
	inx	h
	inr	d
	jp	DISKWR1A
	call	SET$DIR
	lhld	t15e7
	mvi	c,02
;
DISKWR1B:
	shld	ARECORD
	push	b
	call	SEEK
	pop	b
	call	WRBUFF
	lhld	ARECORD
	mvi	c,00
	lda	BLKMSK
	mov	b,a
	ana	l
	cmp	b
	inx	h
	jnz	DISKWR1B
	pop	h
	shld	ARECORD
	call	SET$DATA
;
DISKWR1C:
	call	SEEK		;to proper file position
	pop	b
	push	b		;restore/save write flag 
				;(<c> = 2 if new block)
	call	WRBUFF		;written to disk
	pop	b		;<c> = 2 if a new block was
				;allocated, 0 if not
	;
	;	increment record count if rcount <= vrecord
	;
	lda	VRECORD
	lxi	h,RCOUNT
	cmp	m		;vrecord-rcount
	jc	DISKWR2		;rcount <= vrecord
	mov	m,a
	inr	m		;rcount = vrecord+1
	mvi	c,02		;mark as record count incremented
;
DISKWR2:	;<a> has vrecord, <c> = 2 if now block or new record #

	if DEBLOCK
	nop
	nop
	lxi	h,0000h
	endif

	if not DEBLOCK
	dcr	c
	dcr	c
	jnz	NOUPDATE
	endif

	push	psw		;save vrecord value
	call	GETMODNUM	;<hl> = .fcb(modnum),<a> = fcb(modnum)
	;
	;	reset the file write flag to mark as written 
	;
	ani (not FWFMSK) and 0ffh	;bit reset
	mov	m,a		;fcb(modnum) = fcb(modnum) and 7fh
	pop	psw		;restore vrecord
;
NOUPDATE:	;check for end of extent, if found attempt to open
		;next extent in preparation for next write
	cpi	LSTREC		;vrecord lstrec ?
	jnz	DISKWR3		;skip if not
	;
	;	may be random access write, if so we are done
	;
	lda	SEQIO
	cpi	01
	jnz	DISKWR3		;skip next extent open op
	;
	;	update current fcb before going to next extent
	;
	call	SETFCB
	call	OPEN$REEL	;rmf = false
	;
	;	vrecord remains at lstrec cousing eof if
	;	no more directory space is avaliable
	;
	lxi	h,LRET
	mov	a,m
	ora	a
	jnz	NOSPACE
	;
	;	space available, set vrecord = 255
	;
	dcr	a
	sta	VRECORD		;goes to 00 next time
;
NOSPACE:
	mvi	m,00		;lret = 0 for returned value
;
DISKWR3:
	jmp	SETFCB		;replace parameters
		;ret
;
RSEEK:		;random access seek operation, <c> 0 0ffh if read mode
		;fcb is assumed to address an active file control block
		;(modnum has bood set to 1100$0000b if previous bad seek
	xra	a
	sta	SEQIO		;marked as random access operation
;
RSEEK0:
	push	b		;save r/w flag
	lhld	INFO
	xchg			;<de> will hold base of fcb
	lxi	h,RANREC
	dad	d		;<hl> = .fcb(ranrec)
	mov	a,m
	ani	7fh
	push	psw		;record number
	mov	a,m
	ral			;[cy] = lsb of extent #
	inx	h
	mov	a,m
	ral
	ani	0001$1111b	;<a> ext #
	mov	c,a		;<c> holds extent number, record stacked
	mov	a,m

;	rept 4
;	rar
;	endm
	rar
	rar
	rar
	rar

	ani	0000$1111b	;mod #
	mov	b,a		;<b> holds module #, <c> holds ext #
	pop	psw		;recall sought record #
	;
	;	check to insure that high byte of ran rec = 0
	;
	inx	h
	mov	l,m		;<l> = high byte (must be 0)
	inr	l
	dcr	l
	mvi	l,06		;zero flag , <l> = 6
	;
	;	produces error 6, (seek past physical eod)
	;
	jnz	SEEKERR
	;
	;	otherwise, high byte = 0, <a> = sought record
	;
	lxi	h,NXTREC
	dad	d		;<hl> = .fcb(nxtrec
	mov	m,a		;sought rec # stored away
	;
	;	arrive here with <b> = mod#, <c> = ext#
	;	<de> = .fcb, record stored
	;	the r/w flag is still stacked. compare fcb values
	;
	lxi	h,EXTNUM
	dad	d
	mov	a,c		;<a> = seek ext#
	sub	m
	jnz	RANCLOSE	;tests for = extents
	;
	;	extents match, check mod#
	;
	lxi	h,MODNUM
	dad	d
	mov	a,b		;<b> = seek mod#
	;
	;	could be overflow at eof, producing module #
	;	0f 90h or 10h, so compare all but fwf
	;
	sub m
	ani	7fh
	jz	SEEKOK		;same ?
;
RANCLOSE:
	push	b
	push	d		;save seek mod#, ext#, .fcb
	call	CLOSE		;current extent closed
	pop	d
	pop	b		;recall parameters and fill
	mvi	l,03		;cannot close error #3
	lda	LRET
	inr	a
	jz	BADSEEK
	lxi	h,EXTNUM
	dad	d
	mov	m,c		;fcb(extnum) = ext#
	lxi	h,MODNUM
	dad	d
	mov	m,b		;fcb(modnum) = mod#
	call	OPEN		;is the file present?
	lda	LRET
	inr	a
	jnz	SEEKOK		;open sucessful ?
	;
	;	cannot open the file, read mole?
	;
	pop	b		;r/w flag to <c> (=0ffh if read)
	push	b		;everyone expects this item stacked
	mvi	l,04		;seek to unwritten extent #4
	inr	c		;becomes 00 if read operation
	jz	BADSEEK		;skip to error if read operation
	;
	;	write operation, make new extent
	;
	call	MAKE
	mvi	l,05		;cannot create new extent #5
	lda	LRET
	inr	a
	jz	BADSEEK		;no dir space
	;
	;	file make operation successful
;
SEEKOK:
	pop	b		;discard r/w flag
	xra	a
	jmp	STA$RET		;with zero set
;
BADSEEK:	;fcb no longer contains a valid fcb, mark
		;with 1100$0000b in modnum field so that it
		;appears as overflow with file write flag set
	push	h		;save error flag
	call	GETMODNUM	;<hl> = .modnum
	mvi	m,1100$0000b
	pop	h		;and drop through
;
SEEKERR:
	pop	h		;discard r/w flag
	mov	a,l
	sta	LRET		;lret = #, non-zero
	;
	;	setfwf returns non-zero accumulator for error
	;
	jmp	SETFWF		;flag set, so subsequent close ok
		;ret
;
RANDISKREAD:	;random disk read operation
	mvi	c,TRUE		;marked as read operation
	call	RSEEK
	cz	DISKREAD	;if seek successful
	ret
;
RANDISKWRITE:	;random disk write operation
	mvi	c,FALSE		;marked as write operation
	call	RSEEK
	cz	DISKWRITE	;if seek successful
	ret
;
COMPUTE$RR:	;compute random record position for 
		;get$file$size / set$random$record
	xchg
	dad	d
	;
	;<de> = .buff(dptr) or .fcb(0), <hl> = .f(nxtrec/reccnt)
	;
	mov	c,m
	mvi	b,00		;<bc> =0000$0000$?rrr$rrrr
	lxi	h,EXTNUM
	dad	d
	mov	a,c
	rrc
	ani	80h		;<a> = e000$0000
	add	c
	mov	c,a
	mvi	a,00
	adc	b
	mov	b,a
	;
	;	<bc> = 0000$0000$errr$rrrr
	;
	mov	a,m
	rrc
	ani	0fh
	add	b
	mov	b,a
	;
	;	<bc> = 000?$eeee$errr$rrrr
	;
	lxi	h,MODNUM
	dad	d
	mov	a,m		;<a> = xxx?$mmm

;	rept 4
;	add	a
;	endm			;[cy] = ?, <a> = mmmm$0000
	add	a
	add	a
	add	a
	add	a

	push	psw
	add	b
	mov	b,a
	;
	;	[cy] = ?, <bc> = mmmm$eeee$errr$rrrr
	;
	push	psw		;possible second carry
	pop	h		;[cy] = lsb of <l>
	mov	a,l		;[cy] = lsb of <a>
	pop	h		;[cy] = lsb of <l>
	ora	l		;[cy]/[cy] = lsb of <a>
	ani	0000$0001b	;<a> = 0000$000? possible carry-out
	ret
;
GETFILESIZE:	;compute logical file size for current fcb
	mvi	c,EXTNUM
	call	SEARCH
	;
	;	zero the receiving ranrec field
	;
	lhld	INFO
	lxi	d,RANREC
	dad	d
	push	h		;save position
	mov	m,d
	inx	h
	mov	m,d
	inx	h
	mov	m,d		;= 00 00 00
;
GETSIZE:
	call	END$OF$DIR
	jz	SETSIZE
	;
	;	current fcb addressed byt dptr
	;
	call	GETDPTRA
	lxi	d,RECCNT	;ready for compute size
	call	COMPUTE$RR
	;
	;	<a> = 0000$000?, <bc> = mmmm$eeee$errr$rrrr
	;	compare with memory, larger ?
	;
	pop	h
	push	h		;recall,replace .fcb(ranrec)
	mov	e,a		;save [cy]
	mov	a,c
	sub	m
	inx	h		;ls byte
	mov	a,b
	sbb	m
	inx	h		;middle byte
	mov	a,e
	sbb	m		;carry if .fcb(ranrec) > directory
	jc	GETNEXTSIZE	;for another try
	;
	;	fcb is less or equal, fill from directory
	;
	mov	m,e
	dcx	h
	mov	m,b
	dcx	h
	mov	m,c
;
GETNEXTSIZE:
	call	SEARCHN
	jmp	GETSIZE
;
SETSIZE:
	pop	h		;discard .fcb(ranrec)
	ret
;
SETRANDOM:	;set random record from the current file control block
	lhld	INFO
	lxi	d,NXTREC	;ready prams for computesize
	call	COMPUTE$RR	;<de> = info, <a> = [cy]
				;<bc> = mmmm$eeee$errr$rrrr
	lxi	h,RANREC
	dad	d		;<hl> = .fcb(ranrec)
	mov	m,c
	inx	h
	mov	m,b
	inx	h
	mov	m,a		;to ranrec
	ret
;
SELECT:		;select disk info for subsequent input or output ops
	lhld	DLOG
	lda	CURDSK
	mov	c,a
	call	HLROTR
	push	h
	xchg			;save it for test below, send to seldsk
	call	SELECTDISK
	pop	h		;return dlog vector
	cz	SEL$ERROR	;returns true if select ok
	;
	;	is the disk logged in ?
	;
	mov	a,l
	rar
	rc			;return if bit is set
	;
	;	disk not logged in, set bit and initialize
	;
	lhld	DLOG
	mov	c,l
	mov	b,h		;call ready
	call	SET$CDISK
	shld	DLOG		;dlog = set$cdisk(dlog)
	jmp	INITIALIZE
		;ret
;
CURSELECT:
	lda	LINFO
	lxi	h,CURDSK
	cmp	m
	rz			;skip if linfo=curdsk
	mov	m,a
	jmp	SELECT
		;ret
;
RESELECT:	;check current fcb to see if reselection necessary
	mvi	a,TRUE
	sta	RESEL		;mark possible relelection
	lhld	INFO
	mov	a,m		;drive select code
	ani	0001$1111b	;non-zero is auto drive select
	dcr	a		;drive code normalized to 0..30, or 255
	sta	LINFO		;save drive code
	cpi	30
	jnc	NOSELECT
	;
	;	auto select function, save curdsk
	;
	lda	CURDSK
	sta	OLDDSK		;olddsk = curdsk
	mov	a,m
	sta	FCBDSK		;save drive code
	ani	1110$0000b
	mov	m,a		;preserve hi bits
	call	CURSELECT
;
NOSELECT:	;set user code
	lda	USRCODE		;0..31
	lhld	INFO
	ora	m
	mov	m,a
	ret

;
;	individual function handlers
;

;
FUNC12:		;return version number
	mvi	a,DVERS
	jmp	STA$RET		;lret = dvers (high = 0)
		;ret
		;jmp goback
;
FUNC13:		;reset disk system - initialize to disk 0
	lxi	h,0000h
	shld	RODSK
	shld	DLOG
	xra	a
	sta	CURDSK		;note that usrcode remains unchanged
	lxi	h,TBUFF
	shld	DMAAD		;dmaad = tbuff
	call	SETDATA		;to data dma address
	jmp	SELECT
		;ret
		;jmp goback
;
FUNC15:		;open file
	call	CLRMODNUM	;clear the module number
	call	RESELECT
	jmp	OPEN
		;ret
		;jmp goback
;
FUNC16:		;close file
	call	RESELECT
	jmp	CLOSE
		;ret
		;jmp goback
;
FUNC17:		;search for first occurrence of a file
	mvi	c,00		;length assuming "?" true
	xchg
	mov	a,m
	cpi	'?'		;no reselect if "?"
	jz	QSELECT		;skip reselect if so
	;
	;	normal search
	;
	call	GETEXTA
	mov	a,m
	cpi	'?'
	cnz	CLRMODNUM	;module number zeroed
	call	RESELECT
	mvi	c,NAMLEN
;
QSELECT:
	call	SEARCH
	jmp	DIR$TO$USER	;copy directory entry to user
		;ret
		;jmp goback
;
FUNC18:		;search for next occurrence of a file name
	lhld	SEARCHA
	shld	INFO
	call	RESELECT
	call	SEARCHN
	jmp	DIR$TO$USER	;copy directory entry to user
		;ret
		;jmp goback
;
FUNC19:		;delete a file
	call	RESELECT
	call	DELETE
	jmp	COPY$DIRLOC
		;ret
		;jmp goback
;
FUNC20:		;read a file
	call	RESELECT
	jmp	SEQDISKREAD
		;ret
		;jmp goback
;
FUNC21:		;write a file
	call	RESELECT
	jmp	SEQDISKWRITE
		;ret
		;jmp goback
;
FUNC22:		;make a file
	call	CLRMODNUM
	call	RESELECT
	jmp	MAKE
		;ret
		;jmp goback
;
FUNC23:		;rename a file
	call	RESELECT
	call	RENAME
	jmp	COPY$DIRLOC
		;ret
		;jmp goback
;
FUNC24:		;return the login vector
	lhld	DLOG
	jmp	STO$ARET
;
FUNC25:		;return selected disk number
	lda	CURDSK
	jmp	STA$RET
;
FUNC26:		;set the subsequent dma address to info
	xchg			;get dam address
	shld	DMAAD		;dmaad = info
	jmp	SETDATA		;to data dma address
		;ret
		;jmp goback
;
FUNC27:		;return the login vector address
	lhld	ALLOCA
	jmp	STO$ARET
;
FUNC29:		;return r/o bit vector
	lhld	RODSK
	jmp	STO$ARET
;
FUNC30:		;set file indicators
	call	RESELECT
	call	INDICATORS
	jmp	COPY$DIRLOC	;lret = dirloc
		;ret
		;jmp goback
;
FUNC31:		;return address of disk parameter block
	lhld	DPBADDR
;
STO$ARET:
	shld	ARET
	ret
		;jmp goback
;
FUNC32:		;set user code
	lda	LINFO
	cpi	0ffh
	jnz	SETUSRCODE
	;
	;	interrogate user code instead
	;
	lda	USRCODE
	jmp	STA$RET		;lret = usercode
;
SETUSRCODE:
	ani	1fh
	sta	USRCODE
	ret
		;jmp goback
;
FUNC33:		;random disk read operation
	call	RESELECT
	jmp	RANDISKREAD	;to perform the disk read
		;ret
		;jmp goback
;
FUNC34:		;random disk write operation
	call	RESELECT
	jmp	RANDISKWRITE	;to perform the disk write
		;ret
		;jmp goback
;
FUNC35:		;return file size (0-65536)
	call	RESELECT
	jmp	GETFILESIZE
		;ret
		;jmp goback
;
FUNC37:		;
	lhld	INFO
	mov	a,l
	cma
	mov	e,a
	mov	a,h
	cma
	lhld	DLOG
	ana	h
	mov	d,a
	mov	a,l
	ana	e
	mov	e,a
	lhld	RODSK
	xchg
	shld	DLOG
	mov	a,l
	ana	e
	mov	l,a
	mov	a,h
	ana	d
	mov	h,a
	shld	RODSK
	ret
;
GOBACK:		;arrive here at end of processing to return to user
	lda	RESEL
	ora	a
	jz	RETMON
	;
	;	reselection may have taken place
	;
	lhld	INFO
	mvi	m,00		;fcb(0) = 0
	lda	FCBDSK
	ora	a
	jz	RETMON
	;
	;	restore disk number
	;
	mov	m,a		;fcb(0) = fcbdsk
	lda	OLDDSK
	sta	LINFO
	call	CURSELECT
	;
	;	return from the disk monitor
	;
;
RETMON:
	lhld	ENTSP
	sphl			;user stack restored
	lhld	ARET
	mov	a,l
	mov	b,h		;<b><a> = <hl> = aret
	ret
;
FUNC40:		;
	call	RESELECT
	mvi	a,02
	sta	SEQIO
	mvi	c,00
	call	RSEEK0
	cz	DISKWRITE
	RET
;
;
;	DATA AREAS
;
EFCB	db	EMPTY		;0e5h available dir entry
RODSK	dw	0000		;read only disk vector
DLOG	dw	0000		;logged-in disks
DMAAD	dw	TBUFF		;initial dma address
;
;
;	curtrka - alloca are set upon disk select
;	(data must be adjacent, do not insert variables)
;	(address of translate vector, no used)
;
CDRMAXA	ds	WORD		;pointer to cur dir max value
CURTRKA	ds	WORD		;current track address
CURRECA	ds	WORD		;current record address
BUFFA	ds	WORD		;pointer to directory dma address
DPBADDR	ds	WORD		;current disk parameter block address
CHECKA	ds	WORD		;current checksum vector address
ALLOCA	ds	WORD		;current allocation vector address
ADDLIST	equ	$-BUFFA		;address list size
;
;	sectpt - offset obtained from disk parm block at dpbaddr
;	(data must be adjacent, do not insert variables)
;
SECTPT	ds	WORD		;sectors per track
BLKSHF	ds	BYTE		;block shift factor
BLKMSK	ds	BYTE		;block mask
EXTMSK	ds	BYTE		;extent mask
MAXALL	ds	WORD		;maximum allocation number
DIRMAX	ds	WORD		;largest directory number
DIRBLK	ds	WORD		;reserved allocation bits for directory
CHKSIZ	ds	WORD		;size of checksum vector
OFFSET	ds	WORD		;offset tracks at beginning
DPBLIST	equ	$-SECTPT	;size of area
;
;
;	local variables
;
TRANV	ds	WORD		;address of translate vector
FCB$COPIED
	ds	BYTE		;set true if copy$fcb called
RMF	ds	BYTE		;read mode flag for open$reel
DIRLOC	ds	BYTE		;directory flag in rename, etc.
SEQIO	ds	BYTE		;1 if sequential i/o
LINFO	ds	BYTE		;low(info)
DMINX	ds	BYTE		;local for diskwrite
SEARCHL	ds	BYTE		;search length
SEARCHA	ds	WORD		;search address
TINFO	ds	WORD		;temp for info in "make"(not used)
SINGLE	ds	BYTE		;set true if single byte allocation map
RESEL	ds	BYTE		;reselection flag
OLDDSK	ds	BYTE		;disk on entry to bdos
FCBDSK	ds	BYTE		;disk named in fcb
RCOUNT	ds	BYTE		;record count if current fcb
EXTVAL	ds	BYTE		;extent number and extmsk
VRECORD	ds	WORD		;current virtual record
ARECORD	ds	WORD		;current actual record
T15e7	ds	WORD		;unknown variable
;
;	local variables for directory access
;
DPTR	ds	BYTE		;directory pointer 0,1,2,3
DCNT	ds	BYTE		;directory counter 0,1,...,dirmax
T15EB	ds	BYTE		;unknown variable
DREC	ds	WORD		;directory record 0,1,...,dirmax/4
;
;
BIOS	equ	($ and 0ff00h) + 100h	;next module
;

			END
