;
;CP/M 2.2 BOOT FOR CCS 2442 MULTIMODE DISK CONTROLLER
;
	TITLE	'CCS 2422 MULTIMODE DISK CONTROLLER BOOT FOR CP/M 2.2'
	PAGE	56
	MACLIB	Z80
;
; THIS BOOT LOADER WILL LOAD THE CP/M SYSTEM IN FROM THE SYSTEM TRACKS
;	OF AN 8" DISK.  IT IS INDEPENDENT OF SECTOR SIZE OR DENSITY.
;
	ORG	80H
;
MSIZE:	EQU	64	;MEMORY SIZE IN KILOBYTES
BIAS:	EQU	(MSIZE-20)*1024
CCP:	EQU	2C00H+BIAS
BIOS:	EQU	CCP+1600H	;BASE OF BIOS
;
SPT:	EQU	44H
CUNIT:	EQU	4AH
IDSV	EQU	4EH
;
;
DCMD:	EQU	30H
DSTAT:	EQU	DCMD
DSCTR:	EQU	DCMD+2
DDATA:	EQU	DCMD+3
DCTRL:	EQU	DCMD+4
;
BANK:	EQU	40H
;
;
RSTOR:	EQU	0DH
RDSEC:	EQU	88H
STEPI:	EQU	5DH
;
START:	MVI	A,1	;TURN OFF THE SHADOW ROM
	OUT	BANK
	LDA	CUNIT	;GET THE SELECT BITS
	MOV	B,A
	ANI	10H	;SEE IF IT IS A MINI
	LXI	H,MTBL	;ADDRESS OF MINI SECTORS PER TRACK
	JRZ	LOAD2	;JUMP IF MINI DRIVE
	LXI	H,TBL	;ADDRESS OF 8" SECTORS PER TRACK
LOAD2:	MOV	C,M	;GET THE TRACK 00 SPT
	MOV	A,B	;REGET THE SELBITS
	ANI	40H	;SEE IF DOUBLE DENSITY
	JRZ	LOAD3	;JUMP IF NOT
	DCX	H	; ELSE, ADJUST POINTER FOR DDEN SPT
LOAD3:	XRA	B	;BUILD TRACK 00 SELBITS
	MOV	B,A	;SAVE IN (B)
	LDA	IDSV+3	;GET SECTOR SIZE
	ADD	L	;OFFSET THE POINTER
	MOV	L,A
	MOV	A,M	;GET THE CORRECT SECTORS PER TRACK
	STA	SPT	;SAVE IT
	LXI	H,CCP-1	;GET THE CP/M LOAD ADDRESS
	LXI	D,(BIOS+800H)+2  ;STOP PAGE ADDRESS, START SECTOR
	MOV	A,B	;REGET THE SELBITS
	OUT	DCTRL
	MVI	A,RSTOR	;HOME THE DISK
LOAD0:	OUT	DCMD
LOAD1:	IN	DCTRL	;WAIT TIL DONE
	RAR
	JRNC	LOAD1
	IN	DSTAT	;GET THE STATUS
	ANI	98H	;MASK FOR ERRORS
	JRNZ	START	;TRY AGAIN IF ERRORS
LOAD4:	MOV	A,E	;GET THE START SECTOR
	OUT	DSCTR
	IN	DDATA	;CLEAR ANY BOGUS STATUS BITS
	MOV	A,B	;GET THE SELECT BITS
	ORI	80H	;SET THE AUTO-WAIT BIT
	OUT	DCTRL
	MVI	A,RDSEC	;START THE TRACK READ GOING
	OUT	DCMD
LOAD5:	INX	H	;INCREMENT THE POINTER
	IN	DDATA	;GET THE DATA
	MOV	M,A	;STORE IT
	IN	DCTRL	;SEE IF INTRQ RELEASED THE WAIT
	RAR		;CHECK FOR INTRQ
	JRNC	LOAD5	;JUMP IF VALID DATA
	DCX	H	;ADJUST THE MEMORY POINTER
	IN	DSTAT	;CHECK THE STATUS
	ANI	9CH	;MASK FOR READ ERRORS
	JRNZ	START	;TRY AGAIN IF ERROR
	MOV	A,H	;SEE IF ALL IN
	CMP	D
	JNC	BIOS	;JUMP IF SO
	MOV	A,E	;NO, CHECK FOR TRACK OVERFLOW
	INR	E	;INCREMENT SECTOR POINTER
	CMP	C
	JRNZ	LOAD4	;JUMP IF NO OVERFLOW
	LDA	SPT	;ELSE, GO TO NEXT TRACK
	MOV	C,A	;SET THE CORRECT SPT
	LDA	CUNIT
	MOV	B,A	;RESET THE SELBIT
	OUT	DCTRL
	MVI	A,STEPI	;GET A STEP IN COMMAND
	MVI	E,1	;RESET SECTOR COUNTER
	JR	LOAD0	;GO DO THE STEP IN
;
TBL:	DB	26,15,8,4  ;8" SECTORS PER TRACK TABLE
MTBL:	DB	18,10,5,2  ;5" SECTORS PER TRACK TABLE
