;-----------------------------------------------------------
;			D B U G
;-----------------------------------------------------------
;			AN 8080 DEBUGGER
;
;
;		ASSEMBLY PARAMETERS
;	THESE PARAMETERS MAY BE CHANGED TO
;	MODIFY THE CONFIGURATION OF THE SYSTEM
;-----------------------------------------------------------
;
;	ASCII CHARACTER DEFINITIONS
;
CR	EQU	0DH
ASCR	EQU	CR
LF	EQU	0AH
TAB	EQU	9	;TAB CHARACTER
CANCL	EQU	18H
RUBOUT	EQU	7FH	;DELETE CHARACTER
;
;	ASSEMBLY PARAMETERS
;
RSTN	EQU	5	;RST NO. TO USE FOR BKPTS
RSTLOC	EQU	RSTN*8	;RESTART ADDRESS (FOR BREAKPOINT)
NBK	EQU	7	;MAX NO. OF BREAKPOINTS
IRST	EQU	0EFH	;RST INSTRUCTON (FOR BKPT)
;
;
		ORG	1000H
;
DEBUG:	JMP	IOIN	;JUMP AROUND BREAKPOINT VECTOR
			;AND VARIABLE STORAGE
BKJMP:	JMP	BKPT	;BREAKPOINT VECTOR
;
;
;	DBUG LOCAL RAM DEFINITIONS
;
;
INPUT:	STA	INP+1	;THIS WILL BE INITIALIZED
INP:	IN	0	;ELSEWHERE
	RET
;
OUTPUT:	MOV	A,B
	STA	OT+1
	MOV	A,C
OT:	OUT	0	;THIS WILL ALSO BE INITIALIZED
	RET
;
;		VARIABLE STORAGE
;
SAVSP:	DW	0	;USER STACK POINTER
SAVPC:	DW	0	;USER REGISTERS
SAVPS:	DW	0	;	"
SAVBC:	DW	0	;	"
SAVDE:	DW	0	;	"
SAVHL:	DW	0	;	"
	;
LAST:	DW	0	;LAST NO. TYPED
LADD:	DW	0	;LAST ADDR DISPLAYED
ARG1:	DW	0	;FIRST ARGUMENT OF COMMAND
ARG1C:	DB	0	;SIZE OF FIRST ARGUMENT
ARG2:	DW	0	;SECOND ARGUMENT OF COMMAND
ARG2C:	DB	0	;SIZE OF SECOND ARG
ARG3:	DW	0	;THIRD (FINAL) ARGUMENT
ARG3C:	DB	0	;SIZE OF THIRD ARGUMENT
ASCFG:	DB	0	;NON-ZERO IF PRINTING IN ASCII
JINS:	DB	0	;NON-ZERO IF LAST INSTRUCTION WAS JUMP
NCNT:	DB	0	;COUNT OF INSTRUCTIONS WHILE STEPPING
NBRK:	DS	3	;NBRK FOR STEPPTING
BKTB:	DS	3*NBK	;BREAKPOINT TABLE
OURSP:	DW	DBSTK	;OUR STACK SO WE CAN DO 'RET'
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DBSTK:	EQU	$
	DW	0,0,0,0,0,0,0,0
HISSTK:	EQU	$
;
;
;
;
;			DBUG MAIN LOOP
;
;
;
IOIN:	LXI	SP,DBSTK	;INIT STACK
	CALL	BKOUT	;CLEAR BKPTS IF THIS IS A RESTART
	LHLD	NBRK	;REMOVE 'NXT' BKPT
	MOV	A,M
	CPI	IRST
	JNZ	MAIN
	LDA	NBRK+2
	MOV	M,A
	LXI	H,DBMS	;TYPE HDR MSG
	CALL	OUTST
;
MAIN:	MVI	A,0	;HERE TO GET A USER CMD
	STA	ASCFG	;SET HEX MODE
	CALL	CRLF
	MVI	A,'%'	;PROMPT
	CALL	OUTCH
	MVI	A,' '	;AND A SPACE
	CALL	OUTCH
	CALL	GTNUM	;GET NUMERIC PARAM'S (IF ANY)
	LXI	H,CMDTB	;NOW A HAS COMMND CHAR
	MOV	D,A	;SAVE IN D
;
;
;	SUBROUTINE 'SRCH'
;
;	THIS IS NOT TRULY A SUBROUTINE, SINCE
;	IT IS ENTERED WITH A JUMP AND EXITED WITH
;	A PCHL.  ITS PURPOSE IS TO SEARCH A TABLE
;	FOR A PARTICULAR CHARACTER AND THEN JUMP
;	TO A ROUTINE POINTED TO BY THE TABLE.  IF
;	THE CHARACTER IS NOT FOUND, THE STANDARD
;	ERROR MESSAGE ('?') IS PRINTED AND SRCH
;	JUMPS TO MAIN.  THUS, SRCH SHOULD NOT BE
;	CALLED FROM PLACES THAT ARE USING THE
;	STACK.
;
;	ON ENTRY, D CONTAINS THE CHARACTER BEING
;	SEARCHED FOR, AND HL POINTS THE THE SEARCH
;	TABLE.  THE FORMAT OF THE SEARCH TABLE IS:
;
;		VARIABLE LENGTH TABLE
;		THREE BYTES PER ENTRY
;		TERMINATED BY A ZERO BYTE
;
;	EACH THREE-BYTE ENTRY CONSISTS OF A
;	ONE-BYTE CHARACTER AND A TWO-BYTE ADDRESS.
;	THE EASIEST WAY TO CREATE MOST OF THESE
;	TABLES IS WITH THE CMD MACRO.
;
;
SRCH:			;SEARCH FOR COMMAND MATCH
	MOV	A,M	;GET PROTOTYPE CMD CHAR
	ORA	A	;TEST FOR END OF TABLE
	JZ	ERROR	;OOPS!
	CMP	D	;IS IT A COMMAND WE CAN USE
	JZ	HIT
	INX	H	;TRY AGAIN
	INX	H
	INX	H
	JMP	SRCH
;
HIT:			;HERE ON COMMAND MATCH
	INX	H	;POINT AT ROUTINE ADDRESS
	MOV	D,M	;LOAD THE ADDRESS INTO HL
	INX	H
	MOV	H,M
	MOV	L,D
	PCHL		;JUMP TO THE ROUTINE
;
ERROR:			;GET HERE ON A BAD COMMAND
	CALL	CRLF
	MVI	A,'?'	;ERROR MESSAGE
	CALL	OUTCH	;PRINT IT
	CALL	CRLF
	JMP	MAIN	;TRY AGAIN
;
;		COMMAND TABLE
;
;	EACH ENTRY IS THREE BYTES:
;
;	ONE BYTE WHICH IS THE PROTOTYPE CHARACTER, AND
;	TWO WHICH POINT TO THE ASSOCIATED PROCESSING
;	ROUTINE.  THE TABLE IS TERMINATED BY A ZERO
;	PROTOTYPE CHARACTER.
;
;	GENERATE ENTRIES WITH THE CMD MACRO, AS BELOW.
;
CMD	MACRO	COMD,R
	DB	COMD
	DW	R
	ENDM
;
;
CMDTB:	CMD	'S',STOP	;SET BREAKPOINTS
	CMD	';',HEX		;DISPLAY, ENTER IN HEX
	CMD	'/',ASCII	;DISPLAY, ENTER IN ASCII
	CMD	'G',GO		;RUN PROGRAM
	CMD	'N',NXT		;STEP ONE INSTRUCTION
	CMD	'X',REMVE	;REMOVE BREAKPOINTS
	CMD	'R',RCMD	;DISPLAY, ENTER REGISTERS
	CMD	'I',INPT	;INPUT FROM PORT
	CMD	'Z',ZOOM	;ZOOM TO INSTRUCTION
	CMD	'J',JUMPT	;JUMP TRACE
	CMD	'Q',QUIT	;EXIT DBUG
	CMD	',',PAR2	;TWO-PARAMETER COMMAND
;
	DB	0	;TERMINATOR
;
CMDT2:			;TWO-ARGUMENT COMMANDS
	CMD	'N',NXT2	;STEP, GIVING NEW PC
	CMD	'Z',ZOOM2	;ZOOM, GIVING NEW PC
	CMD	'J',JUMP2	;JUMP TRACE, NEW PC
	CMD	'O',OUTPT	;OUTPUT TO PORT
	CMD	';',HEXD	;HEX DUMP OF MEMORY
	CMD	'/',ASCD	;ASCII DUMP OF MEMORY
	CMD	'+',ADDIT	;ADD TWO HEX NUMBERS
	CMD	'-',SUBIT	;SUBTRACT TWO HEX NUMBERS
	CMD	',',PAR3	;THREE-PARAM COMMAND
;
	DB	0	;TERMINATOR
;
CMDT3:			;THREE-ARGUMENT COMMANDS
	CMD	'M',MOVE	;MOVE MEMORY
	CMD	'=',FILL	;FILL MEMORY WITH CONSTANT
	CMD	':',COMP	;COMPARE MEMORY WITH MEMORY
	CMD	'?',MSK3	;3-ARGUMENT MASKED SEARCH
	CMD	',',PAR4	;FOUR-PARAMETER COMMAND
;
	DB	0
;
CMDT4:			;FOUR-ARGUMENT COMMAND
	CMD	'?',MSKSR	;MASKED SEARCH
;
	DB	0
;
;		COMMAND PROCESSING ROUTINES
;
;	THESE ROUTINES ARE ALL ENTERED VIA A
;	JUMP INSTRUCTION FROM THE MAIN LOOP,
;	AND EXIT VIA A 'JUMP MAIN'.  NOTE THAT THE
;	NEXT AND GO ROUTINE EXECUTE THROUGH
;	THE USER PROGRAM BEFORE THE 'JUMP MAIN'.
;
;		','= SAVE AN ARGUMENT
;
PAR2:			;SAVE FIRST ARGUMENT
	MOV	H,B	;SAVE THE ARGUMENT
	MOV	L,C
	SHLD	ARG1
	MOV	A,E	;SAVE ITS SIZE
	STA	ARG1C
	CALL	GTNUM	;GET A NEW ARGUMENT
	MOV	D,A	;SAVE THE COMMAND CHAR
	LXI	H,CMDT2	;SHIFT TO NEW TABLE
	JMP	SRCH
;
PAR3:			;SAVE SECOND ARGUMENT
	MOV	H,B
	MOV	L,C
	SHLD	ARG2
	MOV	A,E
	STA	ARG2C
	CALL	GTNUM
	MOV	D,A
	LXI	H,CMDT3	;THIRD COMMAND
	JMP	SRCH
;
PAR4:			;SAVE THE THIRD ARGUMENT
	MOV	H,B
	MOV	L,C
	SHLD	ARG3
	MOV	A,E
	STA	ARG3C
	CALL	GTNUM
	MOV	D,A
	LXI	H,CMDT4	;SHIFT TO LAST TABLE
	JMP	SRCH
;
;
;		"S" (SET BREAKPOINT) COMMAND
;
;	THE PARAMETER GIVEN IS THE ADDRESS OF
;	THE INSTRUCTION TO SET THE BREAKPOINT
;	AT.  IF THE BREAKPOINT IS ALREADY IN
;	THE TABLE, AN ERROR IS GIVEN.  IF NO
;	PARAMETER IS GIVEN, IT IS AN ERROR.
;
;
STOP:			;SET BREAKPOINTS
	DCR	E	;WAS THERE A PARAMETER?
	JM	PRNT	;JUMP IF NO PARAMETER GIVEN
	MOV	A,B	;ENSURE PARAMETER .NE.0
	ORA	C
	JZ	ERROR
	CALL	SBKTB	;SEARCH FOR BKPT IN TABLE
	JMP	STOK	;JUMP IF NOT FOUND
	JMP	ERROR	;ERROR IF ALREADY THERE
;
STOK:			;GET HERE TO SET BREAKPOINT
	LXI	H,BKTB	;POINT TO TABLE
	MVI	D,NBK	;TABLE SIZE TO D
;
EMPSR:			;SEARCH FOR EMPTY SLOT
	MOV	A,M	;IS ADDRESS FIELD ZERO?
	INX	H
	ORA	M
	JZ	STSET	;IF SO, USE THIS SLOT
	INX	H	;TRY NEXT SLOT
	INX	H
	DCR	D
	JNZ	EMPSR
	JMP	ERROR	;IF NO SLOTS, THEN ERROR
;
STSET:			;GET HERE TO FILL A SLOT
	DCX	H	;POINT AT FIRST BYTE OF ADDRESS
	MOV	M,C	;PUT IN TABLE
	INX	H
	MOV	M,B
	LXI	H,RSTLOC	;GET BREAKPOINT TRAP ADDRESS
	MVI	M,0C3H	;PLUG IN A JUMP
	LXI	H,BKPT	;GET ADDRESS OF SERVICE ROUTINE
	SHLD	RSTLOC+1	;PLUG IT IN
	JMP	MAIN	;EXIT
;
PRNT:			;GET HERE TO PRINT BREAKPOINTS
	LXI	H,BKTB	;POINT TO TABLE
	MVI	B,NBK	;COUNTER
	CALL	CRLF
PRLP:			;PRINT EXISTING BKPOINTS
	MOV	E,M	;GET OUT OF TABLE
	INX	H
	MOV	D,M
	MOV	A,D	;TEST FOR ZERO
	ORA	E
	JZ	PRINC
	CALL	SPACE
	XCHG		;PRINT ADDRESS
;
PRINC:	INX	H
	INX	H
	DCR	B
	JNZ	PRLP
	JMP	MAIN	;EXIT
;
;
;		"/" (DISPLAY, ENTER MEMORY IN ASCII)
;		";" (DISPLAY, ENTER MEMORY IN HEX)
;
;	THE PARAMETER GIVEN IS THE ADDRESS OF
;	THE LOCATION TO BE DISPLAYED.  AFTER
;	THE LOCATION IS DISPLAYED, WE WAIT
;	FOR INPUT.  WHEN WE GET IT, IF A HEX
;	VALUE IS GIVEN ALSO, WE ENTER THAT
;	VALUE IN THE LOCATION.  IF A SINGLE
;	QUOTE AND AN ASCII CHARACTER ARE GIVEN,
;	WE ENTER THAT ASCII CHARACTER.  IF
;	THE VALUE IS TERMINATED BY <CR> (OR
;	IF JUST <CR> IS GIVEN) WE RETURN TO
;	THE MAIN LOOP.  IF THE TERMINATION
;	CHARACTER IS A <LF>, WE MOVE TO THE NEXT
;	LOCATION AND REPEAT;  IF IT IS <^> WE
;	MOVE TH THE PREVIOUS LOCATION AND REPEAT.
;
;
ASCII:			;
	MVI	D,0	;FLAG ASCII MODE
	JMP	DMEM1	;ENTER COMMON CODE
;
HEX:			;
	MVI	D,1	;FLAG HEX MODE
DMEM1:			;
	MOV	H,B	;PUT ADDRESS IS HL
	MOV	L,C
	DCR	E	;WAS AN ADDRESS REALLY GIVEN?
	JP	DMEM	;JUMP IF SO
	LHLD	LADD	;USE LAST ADDRESS DISPLAYED
DMEM:			;DISPLAY, ENTER MEMORY
	SHLD	LAST	;SAVE ADDRESS AS LAST VALUE
	SHLD	LADD	;ALSO AS LAST ADDRESS
	CALL	SPACE	;OUTPUT A BLANK
	MOV	A,M	;GET THE LOCATION
	DCR	D	;TEST D
	INR	D
	JZ	ASC	;JUMP IF ASCII WANTED
HX:			;
	CALL	OUT2	;DISPLAY IN HEX
	JMP	NLOC	;GO GET RESPONSE
ASC:			;
	CPI	' '	;TEST FOR CONTROL CHARACTERS
	JM	HX	;PRINT IN HEX
	CPI	7FH+1	
	JP	HX
	CALL	OUTCH	;AND PRINT CHARACTER
;
NLOC:			;GET HERE TO GET A RESPONSE
	CALL	SPACE	;PUT A BLANK BEFORE HIS ENTRY
	CALL	GTNUM	;NOW GET IT
	PUSH	PSW	;SAVE CHAR TYPED
	MOV	A,E	;WAS A NUMBER TYPED
	ORA	A
	JZ	NOSTO	;IF NOT, DON'T STORE
	MOV	A,C	;PUT VALUE IN A
	MOV	M,A	;PUT VALUE IN MEMORY
	CMP	M	;ENSURE IS GOT THERE
	JNZ	ERRO	;OOPS!!
	MOV	A,E	;HOW LONG WAS NUMBER
	CPI	3
	JM	NOSTO	;JUMP IF .LE. 8 BITS
	MOV	A,B	;GET HIGH 8 BITS IN A
	INX	H	;MOVE TO NEXT LOCATION
	MOV	M,A	;STORE DATA
	CMP	M
	JNZ	ERRO
NOSTO:			;
	POP	PSW	;GET CHARACTER TYPED
	CPI	LF	;IF LINE FEED, THEN NEXT LOCATION
	JZ	INCR
	CPI	','	;IF COMA, THEN NEXT LOCATION
	JZ	INC1
	CPI	'@'	;IF AT SIGN, THE DO INDIRECT
	JZ	INDR
	CPI	CR	;IF CR, THEN QUIT
	JZ	MAIN
	CPI	'^'	;IF CARROT, THE PREVIOUS LOCATION
	JNZ	ERROR
	CALL	CRLF
	DCX	H
	JMP	DADD
INCR:			;
	INX	H
	CALL	CRRUB	;FINISH CR/LF
DADD:			;
	CALL	OUT4	;PRINT THE ADDRESS
	JMP	DMEM	;AND DISPLAY THE DATA
INC1:			;
	INX	H	;TO NEXT LOCATION
	JMP	DMEM
INDR:			;
	MOV	A,M	;GET NEW ADDRESS IN HL
	INX	H
	MOV	H,M
	MOV	L,A
	CALL	CRLF	;NEW LINE
	JMP	DADD	;GO DISPLAY IT
ERRO:			;
	POP	PSW	;FIX STACK
	JMP	ERROR
;
;
;		"Q" (QUIT) COMMAND
;
;	THIS COMMAND CAUSES CONTROL TO RETURN TO
;	THE EXECUTIVE.  ANY ARGUMENTS ARE IGNORED.
;
MNTR	EQU	0000H
;
QUIT:			;
	LXI	H,MNTR
	JMP	FAKIT
;
;
;		"G" (GO) COMMAND
;
;	IF A NUMERIC PARAMETER IS GIVEN, THE
;	PC IS SET TO THIS VALUE.  THE INSTRUCTION
;	POINTED TO BY THE PC IS THEN STEPPED
;	THROUGH (BY CALL NEXT) AND THEN THE USER
;	PROGRAM IS ENTERED.  THE REASON FOR CALLING
;	NEXT IS TO STEP PAST A BREAKPOINT.
;
;
GO:			;
	MOV	A,E	;WAS A PARAMETER GIVEN
	ORA	A
	JZ	NONUM
	MOV	H,B	;IF SO, RESET PC
	MOV	L,C
FAKIT:			;
	SHLD	SAVPC
NONUM:			;
	CALL	NEXT	;STEP PAST ANY BREAKPOINTS
	CALL	BKIN	;INSERT BREAKPOINTS
	CALL	ENTER	;GO ENTER DEBUGGED CODE
	CALL	BKOUT	;REMOVE BREAKPOINTS
	CALL	DISPL	;DISPLAY REGISTERS
	JMP	MAIN	;GO GET ANOTHER COMMAND
;
;
;		"N" (NEXT) COMMAND
;
;	THIS COMMAND CALLS THE NEXT SUBROUTINE
;	TO EXECUTE ONE INSTRUCTION.  IF A PARAMETER
;	IS GIVEN, IT IS TAKEN AS A COUNT OF NEXT
;	CALLS TO DO BEFORE REQUESTING ANOTHER
;	COMMAND.  AFTER EACH NEXT CALL, THE
;	REGISTERS ARE DISPLAYED.  THIS PROVIDES A
;	TRACE CAPABILITY.
;	IF TWO ARGUMENTS ARE GIVEN, THE SECOND IS THE
;	TRACE COUNT, AND THE FIRST IS A NEW VALUE OF THE
;	PC TO EXECUTE FROM.
;
;
NXT2:			;SET PC THEN DO NEXT
	LHLD	ARG1	;GET NEW PC VALUE
	SHLD	SAVPC	;SET IT
NXT:			;EXECUTE NEXT INSTRUCTION(S)
	MVI	A,1	;ASSUME COUNT WILL BE 1
	DCR	E	;WAS A NUMBER GIVEN
	JM	NOCNT
	MOV	A,C	;PUT COUNT IN A
NOCNT:			;
	STA	NCNT	;SAVE COUNT
NXTLP:			;NEXT LOOP
	CALL	NEXT	;EXECUTE ONE INSTRUCTION
	CALL	DISPL	;DISPLAY REGISTERS
	LDA	NCNT	;COUNT THIS INSTRUCTION
	DCR	A
	STA	NCNT
	JNZ	NXTLP	;LOOP IF MORE WANTED
	JMP	MAIN
;
;
;	"X" (REMOVE BREAKPOINTS) COMMAND
;
;	THIS COMMAND REMOVES THE BREAKPOINT AT
;	THE LOCATION GIVEN BY THE NUMERIC PARAMETER.
;	IF NO PARAMETER IS GIVEN, ALL BREAKPOINTS
;	ARE REMOVED.  IF THERE IS NO BREAKPOINT
;	AT THE SPECIFIED LOCATION, AN ERROR
;	MESSAGE IS GIVEN.
;
;
REMVE:			;
	DCR	E	;ANY PARAMETERS?
	JM	REMALL	;JUMP IF NOT
	CALL	SBKTB	;SEARCH FOR THIS BKPT
	JMP	ERROR	;ERROR IF NOT FOUND
	DCX	H	;POINT AT FIRST BYTE OF ENTRY
	MVI	M,0
	INX	H
	MVI	M,0
	INX	H
	MVI	M,0
	JMP	MAIN
REMALL:			;REMOVE ALL BREAKPOINTS
	LXI	H,BKTB	;POINT AT TABLE
	MVI	B,3*NBK	;TABLE SIZE
REMEM:	MVI	M,0	;CLEAR A BYTE
	INX	H	;MOVE TO NEXT ONE
	DCR	B	;COUNT IT
	JNZ	REMEM
	JMP	MAIN
;
;
;	"R..." (DISPLAY, MODIFY REGISTERS) COMMAND
;
;	THE GROUP OF COMMANDS BEGINNING WITH "R"
;	IS A LONG ONE, AND THEY SOMETIMES ECHO MORE
;	THAN IS TYPED (FOR EXAMPLE, TYPING "RP" WILL
;	ECHO AS "RPC;").  BASICALLY, THE
;	LETTER "R" IS OPTIONALLY FOLLOWED BY A
;	REGISTER IDENTIFIER (A, B, C, BC, D, E,
;	DE, F, H, L, HL, M [=HL], P ["C;" APPENDED
;	BY THE DBUG], OR S ["P;" APPENDED]) AND THEN
;	FOLLOWED BY EITHER ";" OR "/" TO DISPLAY IN
;	HEX OR ASCII.  IF NO REGISTER IDENTIFIER IS
;	TYPED, ALL REGISTERS ARE DISPLAYED, AND NO
;	REGISTERS MAY BE MODIFIED.  AFTER A REGISTER
;	HAS BEEN MODIFIED, A COMMAND CHARACTER OF [CR],
;	[LF], [,], [^] MAY BE TYPED.  CR MEANS
;	TERMINATE MODIFICATION, LF AND "," MEAN MOVE
;	TO THE NEXT REGISTER, AND [^] MEANS
;	MOVE TO THE PREVIOUS REGISTER.  NEXT AND
;	PREVIOUS ARE DETERMINED AS FOLLOWS:
;
;		CURRENT		NEXT		PREVIOUS
;		PC		SP		---
;		SP		A		PC
;		A		B		SP
;		B		C		A
;		C		D		B
;		D		E		C
;		E		H		D
;		H		L		E
;		L		F		H
;		F		---		HL
;		BC		DE		A
;		DE		HL		BC
;		HL		F		DE
;
;
RCMD:			;REGISTER COMMANDS
	CALL	GETCH	;GET ANOTHER CHAR (AFTER R)
	MOV	D,A	;SET UP FOR SRCH
	LXI	H,RTAB
	JMP	SRCH	;LOOK FOR SECOND COMMAND
;
;	SECOND-CHARACTER TABLE FOR "R" COMMAND
;
RTAB:			;
	CMD	';',RDMPH	;R; - DUMP ALL IN HEX
	CMD	'/',RDMPA	;R/ - DUMP ALL IN ASCII
	CMD	'A',RMODA	;RA - MORE TO COME
	CMD	'B',RMODB	;RB...
	CMD	'C',RMODC	;RC...
	CMD	'D',RMODD	;RD...
	CMD	'E',RMODE	;RE...
	CMD	'F',RMODF	;RF...
	CMD	'H',RMODH	;RH...
	CMD	'L',RMODL	;RL...
	CMD	'M',RMODM	;RM...
	CMD	'P',RMODP	;RP...
	CMD	'S',RMODS	;RS...
	DB	0		;TERMINATE TABLE
;
;
RDMPH:			;DUMP REGISTERS IN HEX
	CALL	DISPL
	JMP	MAIN
;
RDMPA:			;DUMP REGISTERS IN ASCII
	MVI	A,0FFH	;SET ASCII FLAG
	STA	ASCFG
	CALL	DISPL	;DUMP REGS IN ASCII
	JMP	MAIN
;
;	RMOD"X" ROUTINES
;
RMODA:			;RA...
	LXI	H,TYPA	;ADDR OF TYPE OUT ROUTINE
RMOD:			;GET HERE TO PROCESS SINGLE REGS
	SHLD	ARG1	;SAVE ADDR OF TYPEOUT ROUTINE
	CALL	GETCH	;GET THIRD CHAR OF COMMAND (; OR /)
	MOV	D,A	;FIND IT IN TABLE
	LXI	H,RMTAB
	JMP	SRCH
;
RMODB:			;RB...
	CALL	GETCH	;GET THIRD CHAR (;, /, OR C)
	LXI	H,TYPB	;SET UP IF ITS ; OR /
	SHLD	ARG1
	MOV	D,A	;SET UP FOR SRCH
	LXI	H,RBTAB
	JMP	SRCH
RMODC:			;RC...
	LXI	H,TYPC	;ADDR OF TYPEOUT ROUTINE
	JMP	RMOD
RMODD:			;RD...
	CALL	GETCH	;GET 3RD CHAR (SAME AS RMODB)
	LXI	H,TYPD
	SHLD	ARG1
	MOV	D,A
	LXI	H,RDTAB
	JMP	SRCH
RMODE:			;RE...
	LXI	H,TYPE
	JMP	RMOD
RMODF:			;RF...
	MVI	A,';'	;FOLLOW IT WITH A ";"COMMAND
	CALL	OUTCH
	CALL	SPACE
TYPF:
	CALL	FDSP	;DISPLAY FLAGS
	CALL	SPACE
FLGRS:
	MVI	B,0	;NON-ZERO IF SOMETHING TYPED
	MVI	C,0	;BUDDING YOUNG FLAGS
FLOOP:
	CALL	GETCH	;GET INPUT FOR A FLAG
	MOV	D,A
	LXI	H,FTAB
	JMP	SRCH
;
;
;		FLAGS TABLE
;
;
FTAB:
	CMD	'S',FLGS	;SIGN FLAG
	CMD	'Z',FLGZ	;ZERO FLAG
	CMD	'A',FLGA	;AUX. CARRY FLAG
	CMD	'P',FLGP	;PARITY FLAG
	CMD	'C',FLGC	;CARRY FLAG
	CMD	'.',FLGO	;CLEAR ALL FLAGS
	CMD	RUBOUT,FLGX	;START OVER
	CMD	CANCL,FLGX	;	"
	CMD	CR,FLGE		;TERMINATE
	CMD	LF,FLGE		;LIKEWISE
	CMD	',',FLGE	;DITTO
	CMD	'^',FLGU	;TO PREVIOUS REG (HL)
;
		DB	0
;
;
FLGS:
	MVI	A,80H	;LOAD SIGN FLAG
FLGOR:
	ORA	C	;ADD TO BUDDING FLAGS
	MOV	C,A
	INR	B	;MARK SOMETHING TYPED
	JMP	FLOOP	;PROCEED
FLGZ:
	MVI	A,40H	;LOAD PROPER VALUE
	JMP	FLGOR
FLGA:
	MVI	A,10H	;HALF CARRY
	JMP	FLGOR
FLGP:
	MVI	A,4	;PARITY
	JMP	FLGOR
FLGC:
	MVI	A,1	;CARRY
	JMP	FLGOR
FLGX:
	LXI	H,CANMS
	CALL	OUTST
	JMP	FLGRS	;AND CLEAR TYPED DATA
FLGE:
	DCR	B	;WERE FLAGS TYPED?
	JM	MAIN	;IF NOT, QUIT
FLGO:
	MOV	A,C	;SET FINAL FLAGS
	STA	SAVPS
	JMP	MAIN
FLGU:
	DCR	B	;WERE FLAGS TYPED
	JM	TOML	;IF NOT, TO HL
	MOV	A,C	;SET NEW FLAGS
	STA	SAVPS
	JMP	TOM
;
;		BACK TO THE RMOD ROUTINES
;
RMODH:			;RM...
	CALL	GETCH	;GET 3RD CHAR (;, /, OR L)
	LXI	H,TYPH	;SET UP IF IT IS ; OR /
	SHLD	ARG1
	MOV	D,A	;FIND OUT WHAT IT IS
	LXI	H,RHTAB
	JMP	SRCH
RMODL:			;RL...
	LXI	H,TYPL	;ADDR OF TYPEOUT ROUTINE
	JMP	RMOD
RMODM:			;RM...
	LXI	H,TYPM
	JMP	RMOD
RMODP:			;RP...
	MVI	A,'C'	;TYPE FOLLOWING 'C'
	CALL	OUTCH
	LXI	H,TYPP	;ADDRESS OF TYPEOUT ROUTINE
HONLY:			;GET HERE IF ONLY HEX IS ALLOWED
	MVI	A,';'	;TYPE THE SEMICOLON FOR THE USER
	CALL	OUTCH
	CALL	SPACE	;FOLLOW WITH A BLANK
	MVI	A,0	;FORCE HEX MODE
	STA	ASCFG
	PCHL		;ENTER TYPEOUT ROUTINE
RMODS:			;RS...
	LXI	H,TYPS	;ADDRS OF WHAT ELSE
	MVI	A,'P'	;TYPE A 'P' FOR THE USER
	CALL	OUTCH
	JMP	HONLY
;
;		THIRD CHARACTER TABLES
;
RMTAB:			;CHARS AFTER RA, RC, RE, RL, RM
	CMD	';',RMHEX	;DISPLAY IN HEX
	CMD	'/',RMASC	;DISPLAY IN ASCII
;
		DB	0
;
RBTAB:			;CHARS AFTER RB
	CMD	'C',RMBC	;DISPLAY BC
	CMD	';',RMHEX	;DISPLAY B IN HEX
	CMD	'/',RMASC	;DISPLAY B IN ASCII
;
		DB	0
;
RDTAB:			;CHARS AFTER RD
	CMD	'E',RMDE	;DISPLAY DE
	CMD	';',RMHEX	;DISPLAY IN HEX
	CMD	'/',RMASC	;DISPLAY IN ASCII
;
		DB	0
;
RHTAB:			;CHARS AFTER RH
	CMD	'L',RMHL	;DISPLAY HL
	CMD	';',RMHEX
	CMD	'/',RMASC
;
		DB	0
;
RMBC:			;RBC...
	LXI	H,TYPBC	;HANDLE LIKE SINGLE REGS
	JMP	RMOD
RMDE:			;RDE...
	LXI	H,TYPDE
	JMP	RM
OD
RMHL:			;RHL...
	LXI	H,TYPM
	JMP	RMOD
RMASC:			;HERE TO DO ASCII
	MVI	A,0FFH	;SET ASCII MODE
	STA	ASCFG
	JMP	RMTYP
RMHEX:			;HERE TO DO IN HEX
	MVI	A,0	;SET HEX MODE
	STA	ASCFG
RMTYP:			;HERE TO ENTER TYPEOUT ROUTINE
	CALL	SPACE	;SEPARATE WITH A SPACE
	LHLD	ARG1	;GET ADDR OF TYPEOUT ROUTINE
	PCHL		;ENTER IT
TYPA:			;TYPE A REG
	LDA	SAVPS+1	;LOAD VALUE TO TYPE
	LXI	H,FIXA	;LOAD ADDR OF MOD ROUTINE
T2FIX:			;TYPE 8 BITS, ENTER MOD ROUTINE
	CALL	OUT2A	;TYPE THE REGISTER
FIXEM:			;HERE TO GET VALUE, ENTER MOD ROUTINE
	CALL	SPACE
	CALL	GTNUM	;GET NEW VALUE & COMMAND
	MOV	D,A	;SAVE COMMAND CHAR
	DCR	E	;TEST WHETHER NO. WAS TYPED
			;*(SET MINUS FLAG IF NOT)
	PCHL		;ENTER MODIFICATION ROUTINE
TYPB:
	LDA	SAVBC+1	;TYPE B
	LXI	H,FIXB
	JMP	T2FIX
TYPC:
	LDA	SAVBC	;TYPE C
	LXI	H,FIXC
	JMP	T2FIX
TYPBC:
	LXI	D,FIXBC	;LOAD ADDR OF MOD ROUTINE
	LHLD	SAVBC	;GET VALUE
T4FIX:
	CALL	OUT4A	;TYPE 16 BITS, ENTER FIX RTN
	XCHG		;TYPE NO.
	JMP	FIXEM	;PUT MOD ADDR IN HL
TYPD:			;TYPE D
	LDA	SAVDE+1
	LXI	H,FIXD
	JMP	T2FIX
TYPE:			;TYPE E
	LDA	SAVDE
	LXI	H,FIXE
	JMP	T2FIX
TYPDE:
	LHLD	SAVDE
	LXI	D,FIXDE
	JMP	T4FIX
TYPH:
	LDA	SAVHL+1
	LXI	H,FIXH
	JMP	T2FIX
TYPL:
	LDA	SAVHL
	LXI	H,FIXL
	JMP	T2FIX
TYPM:
	LHLD	SAVHL
	LXI	D,FIXM
	JMP	T4FIX
TYPP:
	LHLD	SAVPC	;GET VALUE
	CALL	OUT4	;TYPE IN FORCED HEX
	LXI	H,FIXP	;PROCEED WITH FIX
	JMP	FIXEM
TYPS:
	LHLD	SAVSP	;GET VALUE
	CALL	OUT4	;FORCE TYPING IN HEX
	LXI	H,FIXS
	JMP	FIXM
;
;	REGISTER-MODIFICATION ROUTINES
;
FIXA:	JM	NOA	;JUMP IF NO DATA
	MOV	A,C	;RESET A
	STA	SAVPS+1
NOA:
	LXI	H,NXTA	;PROPER CMD CHAR TBL
	JMP	SRCH	;CHECK OUT CMD CHAR
FIXB:
	JM	NOB
	MOV	A,C
	STA	SAVBC+1
NOB:
	LXI	H,NXTB
	JMP	SRCH
FIXC:
	JM	NOC
	MOV	A,C
	STA	SAVBC
NOC:
	LXI	H,NXTC
	JMP	SRCH
FIXBC:
	JM	NOBC	;JUMP IF NO DATA
	MOV	H,B	;COPY DATA TO HL
	MOV	L,C
	SHLD	SAVBC	;RESET BC
NOBC:
	LXI	H,NXTBC	;CHARS THAT FOLLOW REG BC
	JMP	SRCH
FIXD:
	JM	NOD
	MOV	A,C
	STA	SAVDE+1
NOD:
	LXI	H,NXTD
	JMP	SRCH
FIXE:
	JM	NOE
	MOV	A,C
	STA	SAVDE
NOE:
	LXI	H,NXTE
	JMP	SRCH
FIXDE:
	JM	NODE
	MOV	H,B
	MOV	L,C
	SHLD	SAVDE
NODE:
	LXI	H,NXTDE
	JMP	SRCH
FIXH:
	JM	NOL
	MOV	A,C
	STA	SAVHL+1
NOH:
	LXI	H,NXTH
	JMP	SRCH
FIXL:
	JM	NOL
	MOV	A,C
	STA	SAVHL
NOL:
	LXI	H,NXTL
	JMP	SRCH
FIXM:
	JM	NOM
	MOV	H,B
	MOV	L,C
	SHLD	SAVHL
NOM:
	LXI	H,NXTM
	JMP	SRCH
FIXP:
	JM	NOPC
	MOV	H,B
	MOV	L,C
	SHLD	SAVPC
NOPC:
	LXI	H,NXTP
	JMP	SRCH
FIXS:
	JM	NOS
	MOV	H,B
	MOV	L,C
	SHLD	SAVSP
NOS:
	LXI	H,NXTS
	JMP	SRCH
;
;
;
;		TERMS MACRO
;
;	THIS MACRO GENERATES "CMD"-TYPE
;	TABLES FOR "SRCH".  IT ACCEPTS THREE
;	ARGUMENTS WHICH ARE THE ROUTINE ADDRESSES,
;	BUT THE CHARACTERS ARE CONSTANT AT
;	CR, LF, ",", AND "^".  ONE CALL TO
;	"TERMS" GENERATES AN ENTIRE TABLE.
;
;
TERMS	MACRO	TLF,TCM,TUA
	DB	CR
	DW	MAIN
	DB	LF
	DW	TLF
	DB	'^'
	DW	TUA
	DB	'.'
	DW	TCM
	DB	0
	ENDM
;
;	TERMINATOR CHARACTER ACTION TABLES
;
NXTA:	TERMS	TOB,TOB1,TOSL
	;
NXTB:	TERMS	TOC,TOC1,TOAL
	;
NXTC:	TERMS	TOD,TOD1,TOBL
	;
NXTBC:	TERMS	TODE,TOE1,TOCL
	;
NXTD:	TERMS	TOE,TOE1,TOCL
	;
NXTE:	TERMS	TOH,TOH1,TODL
	;
NXTDE:	TERMS	TOM,TOM1,TOBCL
	;
NXTH:	TERMS	TOL,TOL1,TOEL
	;
NXTL:	TERMS	TOF,TOF1,TOHL
	;
NXTM:	TERMS	TOF,TOF1,TODEL
	;
NXTP:	TERMS	TOS,TOS1,MAIN
	;
NXTS:	TERMS	TOA,TOA1,TOPL
;
;	SWITCH-TO-NEW-REGISTER ROUTINES
;
