#asm
CCGO:	MVI	C,QUERY
	CALL	BDOS
	INR	A
	STA	DFLTDSK
	RET
CCGCHAR: MOV	A,M
CCSXT:	MOV	L,A
	RLC
	SBB	A
	MOV	H,A
	RET
CCGINT:	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	RET
CCPCHAR: MOV	A,L
	STAX	D
	RET
CCPINT:	MOV	A,L
	STAX	D
	INX	D
	MOV	A,H
	STAX	D
	RET
CCOR:	MOV	A,L
	ORA	E
	MOV	L,A
	MOV	A,H
	ORA	D
	MOV	H,A
	RET
CCXOR:	MOV	A,L
	XRA	E
	MOV	L,A
	MOV	A,H
	XRA	D
	MOV	H,A
	RET
CCAND:	MOV	A,L
	ANA	E
	MOV	L,A
	MOV	A,H
	ANA	D
	MOV	H,A
	RET
CCEQ:	CALL	CCCMP
	RZ
	DCX	H
	RET
CCNE:	CALL	CCCMP
	RNZ
	DCX	H
	RET
CCGT:	XCHG
	CALL	CCCMP
	RC
	DCX	H
	RET
CCLE:	CALL	CCCMP
	RZ
	RC
	DCX	H
	RET
CCGE:	CALL	CCCMP
	RNC
	DCX	H
	RET
CCLT:	CALL	CCCMP
	RC
	DCX	H
	RET
CCCMP:	MOV	A,E
	SUB	L
	MOV	E,A
	MOV	A,D
	SBB	H
	LXI	H,1
	JM	CCCMP1
	ORA	E
	RET
CCCMP1:	ORA	E
	STC
	RET
CCUGE:	CALL	CCUCMP
	RNC
	DCX	H
	RET
CCULT:	CALL	CCUCMP
	RC
	DCX	H
	RET
CCUGT:	XCHG
	CALL	CCUCMP
	RC
	DCX	H
	RET
CCULE:	CALL	CCUCMP
	RZ
	RC
	DCX	H
	RET
CCUCMP:	MOV	A,D
	CMP	H
	JNZ	$+5
	MOV	A,E
	CMP	L
	LXI	H,1
	RET
CCASR:	XCHG
	MOV	A,H
	RAL
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	DCR	E
	JNZ	CCASR+1
	RET
CCASL:	XCHG
	DAD	H
	DCR	E
	JNZ	CCASL+1
	RET
CCSUB:	MOV	A,E
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
	RET
CCNEG:	CALL	CCCOM
	INX	H
	RET
CCCOM:	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	RET
CCMULT:	MOV	B,H
	MOV	C,L
	LXI	H,0
CCMULT1: MOV	A,C
	RRC
	JNC	$+4
	DAD	D
	XRA	A
	MOV	A,B
	RAR
	MOV	B,A
	MOV	A,C
	RAR
	MOV	C,A
	ORA	B
	RZ
	XRA	A
	MOV	A,E
	RAL
	MOV	E,A
	MOV	A,D
	RAL
	MOV	D,A
	ORA	E
	RZ
	JMP	CCMULT1
CCDIV:	MOV	B,H
	MOV	C,L
	MOV	A,D
	XRA	B
	PUSH	PSW
	MOV	A,D
	ORA	A
	CM	CCDENEG
	MOV	A,B
	ORA	A
	CM	CCBCNEG
	MVI	A,16
	PUSH	PSW
	XCHG
	LXI	D,0
CCDIV1:	DAD	H
	CALL	CCRDEL
	JZ	CCDIV2
	CALL	CCCMPBCDE
	JM	CCDIV2
	MOV	A,L
	ORI	1
	MOV	L,A
	MOV	A,E
	SUB	C
	MOV	E,A
	MOV	A,D
	SBB	B
	MOV	D,A
CCDIV2:	POP	PSW
	DCR	A
	JZ	CCDIV3
	PUSH	PSW
	JMP	CCDIV1
CCDIV3:	POP	PSW
	RP
	CALL	CCDENEG
	XCHG
	CALL	CCDENEG
	XCHG
	RET
CCDENEG: MOV	A,D
	CMA
	MOV	D,A
	MOV	A,E
	CMA
	MOV	E,A
	INX	D
	RET
CCBCNEG: MOV	A,B
	CMA
	MOV	B,A
	MOV	A,C
	CMA
	MOV	C,A
	INX	B
	RET
CCRDEL:	MOV	A,E
	RAL
	MOV	E,A
	MOV	A,D
	RAL
	MOV	D,A
	ORA	E
	RET
CCCMPBCDE: MOV	A,E
	SUB	C
	MOV	A,D
	SBB	B
	RET
NULL	EQU	0
FCBSIZE	EQU	36
NEXTP	EQU	0
UNUSED	EQU	2
BUFFER	EQU	4
FLAG	EQU	33
FREEFLG	EQU	128
EOFFLG	EQU	2
WRTFLG	EQU	1
BUFSIZ	EQU	128
NBUFS	EQU	4
CLOSE	EQU	16
CREATE	EQU	22
DMA	EQU	26
DELETE	EQU	19
GETCH	EQU	1
GETSTR	EQU	10
OPEN	EQU	15
PUTCH	EQU	2
QUERY	EQU	25
READ	EQU	20
SELECT	EQU	14
WRITE	EQU	21
LF	EQU	10
EOL	EQU	13
CTRLZ	EQU	26
TBUFF	EQU	80H
DFLTDSK	DS	1
UNIT	DS	2
IP	DS	2
CHP	DS	2
DP	DS	2
FILE	DS	2
MODE	DS	2
ZCH	DS	2
ZT	DS	2
FN	DS	2
QZEXIT:
	LDA	DFLTDSK
	MOV	E,A
	DCR	E
	MVI	C,SELECT
	CALL	BDOS
	JMP	0
BDOS	EQU	5
QZCPM:
	POP	H
	POP	D
	POP	B
	PUSH	B
	PUSH	D
	PUSH	H
	CALL	BDOS
	JMP	CCSXT
GRABIO:
	MVI	B,NBUFS
	LXI	H,IOBUFS+FLAG
	LXI	D,FCBSIZE+BUFFER+BUFSIZ
	MVI	A,FREEFLG
GRAB2:	CMP	M
	JZ	GRAB3
	DAD	D
	DCR	B
	JNZ	GRAB2
	LXI	H,NULL
	RET
GRAB3:	MVI	M,0
	LXI	D,-FLAG
	DAD	D
	RET
FREEIO:
	POP	B
	POP	H
	PUSH	H
	PUSH	B
	LXI	D,FLAG
	DAD	D
	MVI	M,FREEFLG
	LXI	H,NULL
	RET
IOBUFS:
	DS	FCBSIZE-3
	DB	FREEFLG,0,0
	DS	BUFFER+BUFSIZ
	DS	FCBSIZE-3
	DB	FREEFLG,0,0
	DS	BUFFER+BUFSIZ
	DS	FCBSIZE-3
	DB	FREEFLG,0,0
	DS	BUFFER+BUFSIZ
	DS	FCBSIZE-3
	DB	FREEFLG,0,0
	DS	BUFFER+BUFSIZ
QZFOPEN:
	POP	B
	POP	H
	SHLD	MODE
	POP	D
	XCHG
	SHLD	FILE
	PUSH	H
	PUSH	D
	PUSH	B
	CALL	GRABIO
	SHLD	UNIT
	MOV	A,H
	ORA	L
	RZ
	LXI	D,FCBSIZE
	DAD	D
	SHLD	IP
	LHLD	IP
	LXI	D,BUFFER
	DAD	D
	XCHG
	LHLD	IP
	LXI	B,NEXTP
	DAD	B
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	UNIT
	PUSH	H
	LHLD	FILE
	PUSH	H
	CALL	FCB
	POP	H
	POP	H
	LHLD	UNIT
	MOV	L,M
	MVI	H,0
	PUSH	H
	CALL	CPMDISK
	POP	H
	LHLD	MODE
	MOV	A,M
	CPI	72H
	JZ	FOPIF0
	CPI	52H
	JNZ	FOPIF1
FOPIF0:
	MVI	C,OPEN
	LHLD	UNIT
	XCHG
	CALL	BDOS
	ORA	A
	JP	FOPIF2
	LHLD	UNIT
	PUSH	H
	CALL	FREEIO
	POP	H
	LXI	H,NULL
	RET
FOPIF2:
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	LXI	D,0
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	FOPIF4
FOPIF1:
	LHLD	MODE
	MOV	A,M
	CPI	77H
	JZ	FOPIF1A
	CPI	57H
	JNZ	FOPIF5
FOPIF1A:
	MVI	C,DELETE
	LHLD	UNIT
	XCHG
	CALL	BDOS
	MVI	C,CREATE
	LHLD	UNIT
	XCHG
	CALL	BDOS
	ORA	A
	JP	FOPIF3
	LHLD	UNIT
	PUSH	H
	CALL	FREEIO
	POP	H
	LXI	H,NULL
	RET
FOPIF3:
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	LXI	D,BUFSIZ
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	UNIT
	LXI	D,FLAG
	DAD	D
	MVI	A,WRTFLG
	ORA	M
	MOV	M,A
	JMP	FOPIF4
FOPIF5:
	LHLD	UNIT
	PUSH	H
	CALL	FREEIO
	POP	H
	LXI	H,NULL
	RET
FOPIF4:
	LHLD	UNIT
	RET
QZFCLOSE:
	POP	B
	POP	H
	SHLD	UNIT
	PUSH	H
	PUSH	B
	LXI	H,1
	SHLD	ZT
	LHLD	UNIT
	LXI	D,FLAG
	DAD	D
	MOV	A,M
	ANI	WRTFLG
	JZ	FCLIF1
	LXI	H,CTRLZ
	PUSH	H
	LHLD	UNIT
	PUSH	H
	CALL	QZPUTC
	POP	H
	POP	H
	LHLD	UNIT
	LXI	D,FCBSIZE
	DAD	D
	SHLD	IP
	LHLD	IP
	LXI	D,NEXTP
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	CHP
	LHLD	IP
	LXI	D,BUFFER+BUFSIZ
	DAD	D
	SHLD	DP
FCLWH1:
	LHLD	CHP
	XCHG
	LHLD	DP
	MOV	A,D
	CMP	H
	JC	FCLWH2
	JNZ	FCLWH3
	MOV	A,E
	CMP	L
	JNC	FCLWH3
FCLWH2:
	LHLD	CHP
	MVI	M,CTRLZ
	INX	H
	SHLD	CHP
	JMP	FCLWH1
FCLWH3:
	LXI	H,WRITE
	PUSH	H
	LHLD	UNIT
	PUSH	H
	CALL	CPMIO
	POP	D
	POP	D
	MOV	A,H
	ORA	A
	JP	FCLIF4
	LXI	H,0
	SHLD	ZT
FCLIF4:
FCLIF3:
FCLIF1:
	MVI	C,CLOSE
	LHLD	UNIT
	XCHG
	CALL	BDOS
	ORA	A
	JP	FCLIF5
	LXI	H,0
	SHLD	ZT
FCLIF5:
	LHLD	UNIT
	PUSH	H
	CALL	FREEIO
	POP	H
	LHLD	ZT
	RET
FCB:
	POP	H
	POP	D
	POP	B
	PUSH	B
	PUSH	D
	PUSH	H
	INX	D
	LDAX	D
	DCX	D
	CPI	':'
	JNZ	FCBIF1
	LDAX	D
	SUI	40H
	INX	D
	INX	D
  	CPI	61H-41H
   	JC 	FCBIF2
  	SUI	61H-41H
	JMP	FCBIF2
FCBIF1:
	LDA	DFLTDSK
FCBIF2:
	STAX	B
	INX	B
	MVI	H,' '
	MVI	L,8
	CALL	FCBFILL
	MVI	L,3
	CALL	FCBFILL
	MVI	H,0
	MVI	L,4
	CALL	FCBPAD
	LXI	H,16
	DAD	B
	MVI	M,0
	RET
FCBFILL:
	MOV	A,L
	ORA	A
	JZ	FILL2
	LDAX	D
	CPI	'.'
	JZ	FILL2
	CPI	0
	JZ	FILL2
	CPI	61H
 	JC	FILL1
	CPI	7AH+1
	JNC	FILL1
	SUI	61H-41H
FILL1:
	STAX	B
	INX	B
	INX	D
	DCR	L
	JMP	FCBFILL
FILL2:
	LDAX	D
	CPI	'.'
	JZ	FILL3
	CPI	0
	JZ	FILL3
	INX	D
	JMP	FILL2
FILL3:
	CPI	'.'
	JNZ	FILL4
	INX	D
FILL4:
FCBPAD:
	MOV	A,L
	ORA	A
	JZ	PAD2
	MOV	A,H
	STAX	B
	INX	B
	DCR	L
	JMP	FCBPAD
PAD2:
	RET
QZGETC:
	POP	B
	POP	H
	PUSH	H
	PUSH	B
	PUSH	H
	CALL	CGET
	POP	D
	MOV	A,L
	CPI	EOL
	JNZ	GETCRET
	PUSH	H
	PUSH	D
	CALL	CGET
	POP	H
	POP	H
GETCRET:
	RET
CGET:
	POP	D
	POP	H
	SHLD	UNIT
	PUSH	H
	PUSH	D
	LXI	D,FLAG
	DAD	D
	MOV	A,M
	ANI	EOFFLG
	JZ	GETCIF1
	LXI	H,-1
	RET
GETCIF1:
	LHLD	UNIT
	LXI	D,FCBSIZE
	DAD	D
	SHLD	IP
	LXI	D,NEXTP
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	CHP
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	MOV	A,M
	INX	H
	ORA	M
	JNZ	GETCIF2
	LXI	H,READ
 	PUSH	H
	LHLD	UNIT
	PUSH	H
	CALL	CPMIO
	POP	D
	POP	D
	MOV	A,H
	ORA	L
	JZ	GETCIF3
	LXI	H,-1
	RET
GETCIF3:
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	LXI	D,BUFSIZ
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	IP
	LXI	D,BUFFER
	DAD	D
	SHLD	CHP
GETCIF2:
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	D
	MOV	M,D
	DCX	H
	MOV	M,E
	LHLD	CHP
	INX	H
	XCHG
	LHLD	IP
	LXI	B,NEXTP
	DAD	B
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	CHP
	MOV	A,M
	CPI	CTRLZ
	JNZ	GETCIF4
	LHLD	UNIT
	LXI	D,FLAG
	DAD	D
	MOV	A,M
	ORI	EOFFLG
	MOV	M,A
	LXI	H,-1
	RET
GETCIF4:
	MOV	L,A
	MVI	H,0
	RET
QZPUTC:
	POP	B
	POP	D
	POP	H
	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	H
	PUSH	D
	CALL	CPUT
	POP	D
	MOV	A,H
	ORA	A
	JM	PUTCERR
	MOV	A,L
	CPI	EOL
	JNZ	PUTCRET
	LXI	H,LF
	PUSH	H
	PUSH	D
	CALL	CPUT
	POP	D
	POP	D
	MOV	A,H
	ORA	A
	JM	PUTCERR
PUTCRET:
	POP	H
	RET
PUTCERR:
	POP	B
	LXI	H,-1
	RET
CPUT:
	POP	B
	POP	D
	POP	H
	SHLD	ZCH
	XCHG
	SHLD	UNIT
	PUSH	D
	PUSH	H
	PUSH	B
	LXI	D,FCBSIZE
	DAD	D
	SHLD	IP
	LXI	D,NEXTP
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	CHP
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	MOV	A,M
	INX	H
	ORA	M
	JNZ	PUTCIF1
	LXI	H,WRITE
	PUSH	H
	LHLD	UNIT
	PUSH	H
	CALL	CPMIO
	POP	D
	POP	D
	MOV	A,H
	ORA	L
	JZ	PUTCIF2
	LXI	H,-1
	RET
PUTCIF2:
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	LXI	D,BUFSIZ
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	IP
	LXI	D,BUFFER
	DAD	D
	SHLD	CHP
PUTCIF1:
	LHLD	IP
	LXI	D,UNUSED
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	D
	MOV	M,D
	DCX	H
	MOV	M,E
	LHLD	CHP
	INX	H
	XCHG
	LHLD	IP
	LXI	B,NEXTP
	DAD	B
	MOV	M,E
	INX	H
	MOV	M,D
	LDA	ZCH
	LHLD	CHP
	MOV	M,A
	MVI	H,0
	MOV	L,A
	RET
QZGETS:
	POP	B
	POP	H
	SHLD	CHP
	PUSH	H
	PUSH	B
	DCX	H
	MOV	D,M
	MVI	M,0
	DCX	H
	MOV	E,M
	MVI	M,79
	PUSH	H
	PUSH	D
	XCHG
	MVI	C,GETSTR
	CALL	BDOS
	LHLD	CHP
	DCX	H
	MOV	E,M
	INX	H
	MVI	D,0
	DAD	D
	MVI	M,0
	POP	D
	POP	H
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	MVI	C,PUTCH
	MVI	E,LF
	CALL	BDOS
	LHLD	CHP
	RET
QZGETCHAR:
	MVI	C,GETCH
	CALL	BDOS
	MOV	L,A
	MVI	H,0
	CPI	CTRLZ
	JNZ	GETCHAR1
	LXI	H,-1
GETCHAR1:
	CPI	EOL
	JNZ	GETCHAR2
	PUSH	H
	MVI	C,PUTCH
	MVI	E,LF
	CALL	BDOS
	POP	H
GETCHAR2:
	RET
QZPUTS:
	POP	B
	POP	H
	PUSH	H
	PUSH	B
PUTS1:
	MOV	A,M
	ORA	A
	JZ	PUTSRET
	MOV	E,M
	INX	H
	PUSH	H
	MVI	C,PUTCH
	CALL	BDOS
	POP	H
	JMP	PUTS1
PUTSRET:
	RET
QZPUTCHAR:
	POP	B
	POP	H
	SHLD	ZCH
	PUSH	H
	PUSH	B
	XCHG
	MVI	C,PUTCH
	CALL	BDOS
	LDA	ZCH
	CPI	EOL
	JNZ	PUTCHIF1
	MVI	E,LF
	MVI	C,PUTCH
	CALL	BDOS
PUTCHIF1:
	LHLD	ZCH
	MVI	H,0
	RET
CPMIO:
	POP	B
	POP	D
	POP	H
	SHLD	FN
	XCHG
	SHLD	UNIT
	PUSH	D
	PUSH	H
	PUSH	B
	LHLD	UNIT
	MOV	L,M
	MVI	H,0
	PUSH	H
	CALL	CPMDISK
	POP	H
	LHLD	UNIT
	LXI	D,FCBSIZE
	DAD	D
	LXI	D,BUFFER
	DAD	D
	XCHG
	MVI	C,DMA
	CALL	BDOS
	LHLD	FN
	MOV	C,L
	LHLD	UNIT
	XCHG
	CALL	BDOS
	CALL	CCSXT
	SHLD	ZT
	MVI	C,DMA
	LXI	D,TBUFF
	CALL	BDOS
	LHLD	ZT
	MOV	A,H
	ORA	L
	JNZ	CPMIF1
	LXI	H,0
	JMP	CPMIF2
CPMIF1:
	LXI	H,-1
CPMIF2:
	RET
CPMDISK:
	POP	D
	POP	H
	PUSH	H
	PUSH	D
	MOV	A,L
	ORA	H
	JZ	DISKIF1
	XCHG
	DCX	D
	MVI	C,SELECT
	CALL	BDOS
DISKIF1:
	RET
#endasm
