/***************************************************************\
*								*
*			MAKE RESERVATION			*
*								*
\***************************************************************/
#define FALSE 0
#define TRUE  1
#define BYEAR  1981      /* base year */
#define BDAY      4      /* base day  */

struct s0 {
   int room_index[10];
   int msg_num;
   int mdays[12];
   int bit_start;
   int bit_week;
   int bit_year;
   char free0[76];
}  var;
struct s1  {
   int num;
   char text[126];
}  rcomm;
struct s2  {
   char name[20];
   int room;
   int mm,dd,yy;
   int rate;
   int persons;
   int lstay;
   int atime;
   int aphone,pphone,cphone;
   char mname[20];
   char addr[40];
   int msgnum;
   int dmmm,dmdd,dmyy;
   int mtime;
   char inital[2];
   char free2[14];
}  res;

char room_def[96][4];    /* room number by type */
char room_des[10][12];   /*description of each room type */
int date,year,month,day;
int week,nyear,julean;
int cyear,cweek,ctime,cmonth,cday;
char bmap[80][104];
int bdisp;
char comment[126];

main()
{
  int fid,fid1;
  int field,i,j,temp;
  char trec[128];
  char fname[6];
  char change;

   fid = open("bmap",2);
   read(fid,&bmap[0][0],65);
   read(fid,var,1);
   read(fid,room_def,3);
   read(fid,trec,1);
   for(i=0; i<10; i++)
      for(j=0; j<12; room_des[i][j] = trec[i*12+j++]);
   seek(fid,0,0);

   time();
   do  {
      printf("Date of reservation (MM,DD,YY) ? ");
      scanf("%d,%d,%d",&month,&day,&year);
      year += 1900;
      if(month > 12  ||  day > var.mdays[month - 1])  {
         printf("Invalid date\n");
         month = 0;
      }
      else
         if(year < cyear)  {
            printf("Invalid year\n");
            month = 0;
         }
         else
            if(year == cyear)  {
               if(month < cmonth)  {
                  printf("Invalid month\n");
                  month = 0;
               }
               else
                  if(month == cmonth)
                     if(day < cday)  {
                        printf("Invalid day\n");
                        month = 0;
                     }
            }
            else
               if(year != cyear + 1)
                  if(year > cyear+2)  {
                     printf("Invalid year\n");
                     month = 0;
                  }
                  else
                     if(month == cmonth)  {
                        if(day > cday)  {
                           printf("Invalid Reservation date\n");
                           month = 0;
                        }
                     }
                     else
                        if(month > cmonth)  {
                           printf("Invalid Reservation date\n");
                           month = 0;
                        }
   }
   while(month == 0);
   printf("Length of stay in days ? ");
   scanf("%d",&res.lstay);
   printf("Number in party ? ");
   scanf("%d",&res.persons);
   do {
      for(i=0; i < 10  &&  room_des[i][0] != '\0'; i++)  {
         for(j=0; j<12; putchar(room_des[i][j++]));
         printf(" %d\n",i);
      }
      printf("Type of room ? ");
      scanf("%d",&res.room);
      fdate();
      dsply();
   }
   while(res.room == 99);
   for(temp=date,i=0; i<res.lstay; temp++,i++)  {
      if(temp > 6)  {
         temp = 0;
         bdisp = (bdisp + 1) % 104;
      }
      bmap[res.room][bdisp] = bmap[res.room][bdisp] | (0x40 >> temp);
   }
   res.mm = month;
   res.dd = day;
   res.yy = year;
   res.dmmm = cmonth;
   res.dmdd = cday;
   res.dmyy = cyear;
   res.mtime = ctime;
   change = FALSE;
   field = 0;
   do  {
      switch (field)  {

      case 0:
         printf("Reservation name ? ");
         def(&res.name,20);
         if(change == TRUE)
            break;

   
      case 1:
         printf("Address ? ");
         def(&res.addr,40);
         if(change == TRUE)
            break;

      case 2:
         printf("Phone number XXX,XXX,XXXX ? ");
         scanf("%d,%d,%d",&res.aphone,&res.pphone,&res.cphone);
         if(change == TRUE)
            break;

      case 3:
         printf("Arival time ? ");
         scanf("%d",&res.atime);
         if(change == TRUE)
            break;
   
      case 4:
         printf("Name of person making reservation ? ");
         def(&res.mname,20);
         if(change == TRUE)
            break;
      
      case 5:
         printf("Rate (in whole dollars) ? ");
         scanf("%d",&res.rate);
         if(change == TRUE)
            break;
   
      case 6:
         printf("Operators initials ? ");
         scanf("%c%c",&res.inital[0],&res.inital[1]);
         if(change == TRUE)
            break;
   
      case 7:
         printf("Enter comments (carriage return in none) ? ");
         def(comment,126);
         break;
   
      default:
         printf("/nInvalid choice\n");
   
      }
      prec();
      printf("Any changes (Y/N) ? ");
      if(toupper(getchar()) == 'Y')  {
         putchar('\n');
         printf("Reservation name 0\nAddress          1\nPhone number     2\n");
         printf("Arival time      3\nMakers name     4\nRate             5\n");
         printf("Initials         6\nComment          7\n\n");
         printf("Which field ?");
         scanf("%d",&field);
         change = TRUE;
      }
      else
         field = 99;
   }
   while(field != 99);
   if(comment[0] == ' ')
      res.msgnum = 0;
   else
      res.msgnum = (var.msg_num +=1);
   if(var.msg_num == 0x7fff)
      res.msgnum = var.msg_num = 1;
   sprintf(fname,"w%dy%d",week,nyear-1900);
   if((fid1 = open(fname,2)) == -1)  {
      if((fid1 = creat(fname)) == -1)
         printf("error in file creation\n");
   }
   else  {
      while((temp=read(fid1,trec,1)) == 1);
      if(temp == -1)
         printf("***Error in read***\n");
   }
   if(write(fid1,res,1) != 1)
      printf("***error in write***\n");
   close(fid1);
   write(fid,&bmap[0][0],65);
   write(fid,var,1);
   close(fid);
   if(res.msgnum != 0)  {
      fid = open("msg",2);
      do {
         temp = read(fid,rcomm,1);
      }
      while(temp != 0 && rcomm.num != 0);
      if(rcomm.num == 0)
         seek(fid,-1,1);
      for(i=0; i<126; rcomm.text[i] = comment[i++]);
      rcomm.num = res.msgnum;
      write(fid,rcomm,1);
      close(fid);
   }
   exec("EXEC");
}

/*******************************************************\
*							*
*			date routine			*
*							*
*    enter with						*
*							*
*	month:	month of year				*
*	day:	day of month				*
*	year:	the year				*
*							*
*     return with the above values and			*
*							*
*	julean:	julean date				*
*	date:	day of week				*
*	week:	adjusted week				*
*	nyear	adjusted year				*
*							*
\*******************************************************/
fdate()
{
int i,ydiff,fday;
   for(julean=i=0; i<month-1; i++)
      julean += var.mdays[i];
   julean += day;
   if( month > 2)
      julean += leap(year);
   ydiff = year - BYEAR;
   for(fday = BDAY; ydiff != 0; fday +=1+leap(BYEAR+(--ydiff)));
   date = (julean + fday -1) % 7;
   week = (julean + fday -1)/7;
   if(week == 0)  {
      nyear = year - 1;
      week = 52;
   }
   else
      nyear = year;
}

leap(year)
int year;
{
   if(year %4 == 0  &&  year %100 != 0  ||  year %400 == 0)
      return(1);
   else
      return(0);
}

dsply()
{
  int tday,tyear,k,i,j,tmon,disp,temp,eweek,eday;
  int high,low;
  char cr[4];
  char ctemp;
   printf("\n\n");
   for(i=0; i<12; putchar(room_des[res.room][i++]));
   for(j=0; j<2; j++)  {
      printf("\n        ");
      tday = day - date - 7;  /*  drop back to previous sunday  */
      tyear = nyear;
      if (tday < 1)  {
         tmon = (month + 10) % 12;   /*  back one month  */
         if(month == 11)
            tyear = year - 1;               /*  back a year  */
         tday += var.mdays[tmon];
         if(tmon == 1)
            tday += leap(tyear);
      }
      else
         tmon = month - 1;    /* month should start at 0 */
      disp = (week - var.bit_week + var.bit_start + 52*(var.bit_year - nyear) + 103) % 104;
      bdisp = (disp + 1) % 104;    /* save location of week in bmap  */
      eweek = (res.lstay + date) / 7 + 1;   /* last week of res. */
      eday = (res.lstay + date) % 7;        /*  day after res.  */
      for(i=week; i<week+6; i++)  {
         if(j == 0)
            temp = tday/10;
         else
            temp = tday % 10;
         if((week+1 == i && date == 0)  ||  (week+eweek == i && eday == 0))
            printf("|",temp);
         if(temp == 0  &&  j == 0)
            printf(" ");
         else
            printf("%d",temp);
         for(k=1; k<7; k++)  {
            if((week+1 == i && date == k)  ||  (week+eweek == i && eday == k))
               printf("|");
            putchar(' ');
         }
         if((tday += 7) > ((var.mdays[tmon] != 28) ? var.mdays[tmon]:leap(tyear)+28)) {
            tday = tday - ((var.mdays[tmon] != 28) ? var.mdays[tmon]:leap(tyear)+28);
            tmon = (tmon + 13) % 12;    /*  bump month  */
         }
      }
   }
   putchar('\n');
   if(res.room == 0)
      low = 0;
   else
      low = var.room_index[res.room-1] + 1;
   high = var.room_index[res.room];
   for(i=low; i<=high; i++)  {
      temp = disp;
      printf("    ",i);
      for(k=0; k<4; putchar(room_def[i][k++]));
      for(j = 0; j < 6; j++)  {
         ctemp = bmap[i][temp];
         for (k=0; k<7; k++)  {
            if((j == 1 && k == date)  ||  (j == eweek  &&  k == eday))
               putchar('|');
            if((ctemp << k & 0x40) != 0x00)
               putchar('*');
            else
               putchar(' ');
         }
      temp = (temp + 1) % 104;
      }
      printf("\n");
   }
   do  {
      printf("\nWhich room number (99 if another type) ? ");
      def(cr,4);
      for(i=0; i<4; cr[i]=toupper(cr[i++]));
      if(cr[0]=='9' && cr[1]=='9')
         res.room = 99;
      else  {
         res.room = 100;
         for(i=low; i<=high  &&  res.room ==100; i++)
            if(cr[0]==room_def[i][0]&&cr[1]==room_def[i][1]&&cr[2]==room_def[i][2]&&cr[3]==room_def[i][3])   
               res.room = i;
         if(res.room == 100)
            printf("Invalid room number\n");
      }
   }
   while(res.room == 100);
}
/*******************************************************\
*							*
*		Define the current values for:		*
*							*
*		ctime,cday,cweek,cmonth,cyear		*
*							*
\*******************************************************/
time()
{
 int i,ydiff,fday,tjulean;
/*   ctime = 800;
   cday = 1;
   cweek = 26;
   cmonth = 7;
   cyear = 1981;   */

   ctime = peek(0x43) * 100 + peek(0x42);
   cday = peek(0x45);
   cmonth = peek(0x44);
   cyear = peek(0x46) + 1900;
   for(tjulean=i=0; i<cmonth-1; i++)
      tjulean += var.mdays[i];
   tjulean += cday;
   if( cmonth > 2)
      tjulean += leap(cyear);
   ydiff = cyear - BYEAR;
   for(fday = BDAY; ydiff != 0; fday +=1+leap(BYEAR+(--ydiff)));
   cweek = (tjulean + fday -1)/7;
   if(cweek == 0)  {
      cyear = cyear - 1;
      cweek = 52;
   }
   else
      nyear = year;
}

def(pt,len)
char pt[];
int len;
{
 char buf[128];
 int i;

   buf[0] = '\0';
   scanf("%s",buf);
   for(i=0; i<len  &&  buf[i] != '\0'; pt[i] = toupper(buf[i++]));
   for(; i<len; pt[i++] = ' ');
}

prec()
{
 int i;

   printf("\n\n\n\n\n\n");
   printf("                                                   ");
   printf("No. IN  LENGTH   ARIVAL\n");
   printf("          NAME           ROOM      DATE      RATE   PARTY");
   printf("  OF STAY   TIME\n");
   printf("          ----           ----      ----      ----  ------  ");
   printf("------   ------\n");
   for(i=0; i<20; putchar(res.name[i++]));
   printf("     ");
   for(i=0; i<4;putchar(room_def[res.room][i++]));
   printf("    %2d-%2d-%2d    %4d   %3d",res.mm,res.dd,res.yy-1900,res.rate,res.persons);
   printf("     %3d       %4d\n\n",res.lstay,res.atime);
   printf(" PHONE No.        ADDRESS                                 MAKERS NAME\n");
   printf(" ---------        -------                                 -----------\n");
   printf("%3d-%3d-%4d   ",res.aphone,res.pphone,res.cphone);
   printf("   ");
   for(i=0; i<40; putchar(res.addr[i++]));
   for(i=0; i<20; putchar(res.mname[i++]));
   printf("\n\n    DATE      TIME     OPERATORS\n");
   printf("    MADE      MADE      INITIALS\n");
   printf("    ----      ----     ---------\n");
   printf("  %2d-%2d-%2d    %4d",res.dmmm,res.dmdd,res.dmyy-1900,res.mtime);
   printf("        %c%c\n\n\n",res.inital[0],res.inital[1]);
   if(comment[0] != ' ')  {
      printf("   MESSAGE\n   -------\n");
      for(i=0; i<126; putchar(comment[i++]));
      putchar('\n');
   }
}
