$NOLIST
;
;	I/O PORTS & DEFINITIONS
;
;	MC1460 CLOCK/CALENDAR DEFINITIONS
;
CLK_BASE	EQU	10H		;CLOCK BASE ADDRESS
CLK_SEC		EQU	CLK_BASE	;CLOCK SECONDS R/W REGISTER
CLK_MIN		EQU	CLK_BASE + 1	;CLOCK MINUTES R/W REGISTER
CLK_HRS		EQU	CLK_BASE + 2	;CLOCK HOURS R/W REGISTER
CLK_DAY		EQU	CLK_BASE + 3	;CLOCK DAY OF MONTH R/W REGISTER
CLK_MON		EQU	CLK_BASE + 4	;CLOCK MONTH R/W REGISTER
CLK_STAT1	EQU	CLK_BASE + 5	;CLOCK HARDWARE STATUS READ REGISTER
					;  BIT 0= ON BOARD INIT
CLK_STAT	EQU	CLK_BASE + 7	;CLOCK STATUS READ REGISTER
CLK_60HZ	EQU	00000001B	;60 HZ TIMING BIT MASK
CLK_10HZ	EQU	00000010B	;10HZ TIMING BIT MASK
CLK_PER_INT_EN	EQU	00000100B	;PERIODIC INTERRUPT ENABLED BIT MASK
CLK_PER_INT_PEN	EQU	00001000B	;PERIODIC INTERRUPT PENDING BIT MASK
CLK_PWR_FAIL	EQU	00010000B	;POWER FAIL INTERRUPT PENDING BIT MASK
CLK_INT_PEND	EQU	00100000B	;CLOCK INT PENDING (PF OR PER) BIT MASK

RESET_PF_INT	EQU	CLK_BASE + 5	;RESET POWER FAIL INT WRITE PORT
RESET_PER_INT	EQU	CLK_BASE + 6	;RESET PERIODIC INT WRITE PORT

CLK_CTRLS	EQU	CLK_BASE + 7	;CLOCK CONTROL WRITE PORT
CLK_INIT	EQU	00000001B	;INIT CLK TO 1/1 0:0:0 BIT MASK
CLK_HOLD	EQU	00000010B	;HOLD CLOCK BIT
ENBL_PER_INT	EQU	00010000B	;ENABLE PERIODIC INTERRUPT BIT
PER_10MS	EQU	0		;10MS PERIODIC INT.
PER_LINE	EQU	00100000B	;LINE FREQ (16.6/20MS) PER INT
PER_50MS	EQU	01000000B	;50MS PER INT
PER_100MS	EQU	01100000B	;100MS PER INT
PER_1SEC	EQU	10000000B	;1 SECOND PER INT
PER_60SEC	EQU	10100000B	;60 SECOND PER INT
PER_60MIN	EQU	11000000B	;60 MINUTE PER INT
PER_24HOUR	EQU	11100000B	;24 HOUR PER INT

CLK_MODE	EQU	PER_1SEC OR ENBL_PER_INT	;SET UP WORD
;
;	SBC 517 I/O BOARD DEFINITIONS

P1_BASE		EQU	50H		;BOARD BASE ADDR
P1_INT_STAT	EQU	P1_BASE		;INTERRUPT STATUS READ
P1_INT_MASK	EQU	P1_BASE + 1	;INTERRUPT MASK R/W
P1_RES_TINT	EQU	P1_BASE + 2	;RESET TIMER INTERRUPT WRITE
P1_MASK_RES	EQU	P1_BASE + 3	;SET INT MASK & RESET TIMER WRITE
PORT_10		EQU	P1_BASE + 4	;8255 PORT A R/W
PORT_11		EQU	P1_BASE + 5	;8255 PORT B R/W
PORT_12		EQU	P1_BASE + 6	;8255 PORT C R/W
PORT1_C		EQU	P1_BASE + 7	;8255 CONTROL WRITE
PORT_20		EQU	P1_BASE + 8	;8255 PORT A R/W
PORT_21		EQU	P1_BASE + 9	;8255 PORT B R/W
PORT_22		EQU	P1_BASE + 0AH	;8255 PORT C R/W
PORT2_C		EQU	P1_BASE + 0BH	;8255 CONTROL WRITE
USART2D		EQU	P1_BASE + 0CH	;8251 DATA R/W
USART2C		EQU	P1_BASE + 0DH	;8251 COMMAND WRITE
USART2_STAT	EQU	P1_BASE + 0EH	;8251 STATUS READ
;
;	SBX D/A CONVERTER DEFINITIONS
;
DA_DATA		EQU	60H		;D/A DATA OUTPUT PORT
DA_RESET	EQU	62H		;D/A RESET OUTPUT PORT
DA_STAT		EQU	DA_RESET	;D/A STATUS INPUT PORT
;
;	SBX SERIAL MODULE DEFINITIONS
;
USARTD		EQU	0A0H		;8251 DATA REGISTER
USARTC		EQU	0A2H		;8251 CONTROL REGISTER

TMR2		EQU	0BCH		;8253 TIMER #2 REGISTER
TMRCTL		EQU	0BEH		;8253 CONTROL REGISTER
;
;	INTERRUPT CONTROLLER DEFINITIONS
;
PIC1		EQU	0C0H		;8259 REGISTER 1
PIC2		EQU	0C2H		;8259 REGISTER 2
;
;	KEYBOARD-DISPLAY 8255 PORT DEFINITIONS
;
KEYBRD		EQU	0C8H		;KEYBOARD DATA IN
KEY_USR1	EQU	10000000B	;KEYBOARD USER SWITCH 1 INPUT MASK
KEY_STAT	EQU	0CCH		;KEYBOARD STATUS PORT
KEY_IRQ		EQU	00001000B	;KEYBOARD INT REQ BIT MASK
KEY_RDY		EQU	00100000B	;KEYBOARD CHAR READY BIT MASK

DISP_OUTP	EQU	0CAH		;BURROUGHS DISPLAY OUTPUT DATA
CHAR_BLINK	EQU	10000000B	;CHAR BLINK BIT

DISP_STAT	EQU	0CCH		;DISPLAY STATUS PORT
DISP_IRQ	EQU	00000001B	;DISPLAY INT REQ BIT MASK
DISP_OBF	EQU	00000010B	;DISPLAY OUTPUT BUFFER FULL* BIT MASK
DISP_READY	EQU	01000000B	;DISPLAY READY FOR NEXT CHAR BIT MASK
DISP_ERROR	EQU	10000000B	;DISPLAY ERROR* BIT MASK

KEY_DISP_CTRL	EQU	0CEH		;8255 MODE PORT
KEY_DISP_MODE	EQU	10111100B	;8255 MODE WORD
KEY_INT_ENABL	EQU	00001001B	;8255 GROUP A INTR ENABLE
;
;	MAIN 8253 TIMER DEFINITIONS (NOT USED YET)
;
T2TMR0		EQU	0D0H		;MAIN BOARD 8253 TIMER #0 PORT
T2TMR1		EQU	0D2H		;MAIN BOARD 8253 TIMER #1 PORT
T2TMR2		EQU	0D4H		;MAIN BOARD 8253 TIMER #2 PORT
T2CTRL		EQU	0D6H		;MAIN BOARD 8253 TIMER CONTROL PORT
;
;	SBX A/D CONVERTER MODULE DEFINITIONS
;
AD_CMD		EQU	0D8H		;SBX A/D COMMAND / LO BYTE PORT
AD_LOW		EQU	AD_CMD
AD_HIGH		EQU	0D9H		;SBX A/D HIGH BYTE
$LIST
