
/*
 *  This program emulates the CP/M built-in command TYPE
 *
 *  Written by:  B. Livingston		April 29, 1983
 *
 *
 *	compile as follows:
 *
 *	B>cc vu.c libr.olb
 */

#include <stdio.h>
#include <bdos.h>

/******************************/

main (argc, argv)

int argc ;
char **argv ;
{
    void fail(), flush() ;
    FILE *fpin ;
    int c ;

    /*  make sure there is just one command-line argument  */
    if (argc != 2)
	fail("usage: VU [drive:]filename.type") ;

    /*  try to open the file given as the command-line argument  */
    if ((fpin = freopen(argv[1], "rb", stdin)) == NULL)
	fail("can't open file") ;

    /*  transfer file to console character-by-character until a "stop"
     *  condition is detected:
     *	    physical end-of-file, or
     *	    a Control-Z character in the file, or
     *	    a keystroke from the user.  */
    while (!( (c = getc(fpin)) == EOF || c == CTLZ || biosb(BCONST) ))
	bios(BCONOUT, c) ;

    /*  get rid of any pending additional keystrokes, then exit  */
    flush() ;
    exit(0) ;
}

/******************************/

void
fail (msg)			/*  display error message, then exit  */

char *msg ;
{
    void flush() ;

    fprintf(stderr, "VU -- %s\r\n", msg) ;
    flush() ;
    exit(1) ;
}

/******************************/

void
flush () {			/*  get rid of any pending keyboard input  */

    while (bdosb(DIRCON, 0xFE))	/*  console status  */
	bdosb(DIRCON, 0xFF) ;	/*  console input  */
}
                     