
"
    SIMLST  -  SIMULATED COMPILER LISTING PROGRAM   


    INVOCATION:

    *SIMLST(SOURCE.PAS,SOURCE.LST)

"



"###########
#  PREFIX  #
###########"

CONST NL = '(:10:)';   FF = '(:12:)';   CR = '(:13:)';   EM = '(:25:)';

CONST PAGELENGTH = 512;
TYPE PAGE = ARRAY (.1..PAGELENGTH.) OF CHAR;

CONST LINELENGTH = 132;
TYPE LINE = ARRAY (.1..LINELENGTH.) OF CHAR;

CONST IDLENGTH = 16;
TYPE IDENTIFIER = ARRAY (.1..IDLENGTH.) OF CHAR;

TYPE FILE = 1..4;

TYPE ARGTAG =
  (NILTYPE, BOOLTYPE, INTTYPE, IDTYPE, PTRTYPE);

TYPE POINTER = @BOOLEAN;

TYPE ARGTYPE = RECORD
                 CASE TAG: ARGTAG OF
                   NILTYPE, BOOLTYPE: (BOOL: BOOLEAN);
                   INTTYPE: (INT: INTEGER);
                   IDTYPE: (ID: IDENTIFIER);
                   PTRTYPE: (PTR: POINTER)
               END;

CONST MAXARG = 10;
TYPE ARGLIST = ARRAY (.1..MAXARG.) OF ARGTYPE;

TYPE ARGSEQ = (INP, OUT);

TYPE PROGRESULT =
  (TERMINATED, OVERFLOW, POINTERERROR, RANGEERROR, VARIANTERROR,
   HEAPLIMIT, STACKLIMIT, CODELIMIT, TIMELIMIT, CALLERROR);

PROCEDURE READ(VAR C: CHAR);
PROCEDURE WRITE(C: CHAR);
PROCEDURE OPEN(F: FILE; ID: IDENTIFIER; VAR FOUND: BOOLEAN);
PROCEDURE CLOSE(F: FILE);
PROCEDURE GET(F: FILE; P: INTEGER; VAR BLOCK: UNIV PAGE);
PROCEDURE PUT(F: FILE; P: INTEGER; VAR BLOCK: UNIV PAGE);
PROCEDURE NOTUSED1;
PROCEDURE MARK(VAR TOP: INTEGER);
PROCEDURE RELEASE(TOP: INTEGER);
PROCEDURE IDENTIFY(HEADER: LINE);
PROCEDURE ACCEPT(VAR C: CHAR);
PROCEDURE DISPLAY(C: CHAR);
PROCEDURE NOTUSED2;
PROCEDURE NOTUSED3;
PROCEDURE NOTUSED4;
PROCEDURE NOTUSED5;
PROCEDURE READARG(S: ARGSEQ; VAR ARG: ARGTYPE);
PROCEDURE WRITEARG(S: ARGSEQ; ARG: ARGTYPE);
PROCEDURE NOTUSED6;
PROCEDURE NOTUSED7;
PROCEDURE NOTUSED8;
PROCEDURE NOTUSED9;
PROCEDURE RUN(ID: IDENTIFIER; VAR PARAM: ARGLIST;
              VAR LINE: INTEGER; VAR RESULT: PROGRESULT);

PROGRAM SIMLST(VAR PARAM: ARGLIST);

VAR
    CL1, CL2, CL3, CL4: CHAR;
    CH: CHAR;
    LINE: INTEGER;
    ARG: ARGTYPE;

PROCEDURE PRINT_LINE;
BEGIN
  IF CL4<'9' THEN CL4:=CHR(ORD(CL4)+1) ELSE BEGIN
    CL4:='0';
    IF CL3<'9' THEN CL3:=CHR(ORD(CL3)+1) ELSE BEGIN
      CL3:='0';
      IF CL2<'9' THEN CL2:=CHR(ORD(CL2)+1) ELSE BEGIN
        CL2:='0';
        IF CL1<'9' THEN CL1:=CHR(ORD(CL1)+1) ELSE CL1:='0'
      END
    END
  END;
  WRITE(CL1); WRITE(CL2); WRITE(CL3); WRITE(CL4); WRITE(' ');
END;


BEGIN

  WRITEARG(INP,PARAM(.2.));
  WRITEARG(OUT,PARAM(.3.));

  CL1:='0'; CL2:='0'; CL3:='0'; CL4:='0';
  LINE:=1;
  WRITE(FF);
  READ(CH);

  WHILE CH <> EM DO
  BEGIN
    PRINT_LINE;
    WHILE CH <> NL DO
    BEGIN
      WRITE(CH);
      READ(CH);
    END;
    WRITE(CH);
    LINE:=LINE+1;
    READ(CH);
  END;

  READARG(INP,ARG);
  READARG(OUT,ARG);

END.
