

;		BOOTSTRAP PROGRAM FOR MICROMATION
;
;	*****************************************************************
;
	ORG	0000H
;
;	EQUATES FOR CP/M LOCATIONS
;       MSIZE DETERMINES THE LOCATION IN MEMORY WHERE THE BOOTSTRAP LOADS
;       THE CP/M OPERATING SYSTEM.
;
MSIZE		EQU	48	;SET FOR A 48K SYSTEM, CHANGE WHEN SYSTEM
				;SIZE CHANGES.


CONTROLLER	EQU	0F800H
BUFF		EQU	CONTROLLER+400H
UARTDATA	EQU	CONTROLLER+602H
UARTSTAT	EQU	CONTROLLER+60AH
;
;	==>>> DO NOT SUBSTITUTE BOTH 20 (TWENTY) ON NEXT LINE !!!
CBASE		EQU	(MSIZE-20)*1024	;BIAS FOR SYSTEMS LARGER THAN 20K
BDOS		EQU	CBASE+3C06H
CCP		EQU	CBASE+3400H	;BASE OF CONSOLE COMMAND PROCESSOR, 16K
CCPM		EQU	CCP-128		;START OF LOAD TO SKIP BOOT
COLDBOOT	EQU	CBASE+4A00H	;COLD START BOOT
;
;	EQUATES FOR RESERVED ROM LOCATIONS
HOME		EQU	CONTROLLER+3
SETTRK		EQU	CONTROLLER+9	;SET TRACK
SETSEC		EQU	CONTROLLER+0CH	;SET SECTOR NUMBER
SETDMA		EQU	CONTROLLER+0FH	;SET DMA FUNCTION
READ		EQU	CONTROLLER+12H	;DISK READ
CONTROLBYTE	EQU	BUFF+3
TRACK		EQU	BUFF+4
SECTOR		EQU	BUFF+0AH
DMA		EQU	BUFF+0BH
TWOSIDE		EQU	BUFF+0FH
STEPTIME	EQU	BUFF+10H
CR		EQU	0DH
LF		EQU	0AH
;
;
BOOT		LXI	SP,CCPM
		CALL	HOME
		LXI	H,CCPM-80H
		SHLD	DMA
RDTRK:		MVI	C,0
RDSEC:		MOV	A,C
		CPI	26
		JZ	NXTTRK
		LXI	D,128
		LHLD	DMA
		DAD	D
		INR	C
		CALL	SETSEC
		PUSH	B
		SHLD	DMA
RELP		DI
		CALL	READ
	;	EI		;COMENTED OUT
		JNZ	BOOT
		POP	B
		JMP	RDSEC
NXTTRK		LDA	TRACK
		ORA	A
		JNZ	INIT
		MVI	C,1
		CALL	SETTRK
		JMP	RDTRK
INIT		LXI	H,UARTSTAT	;HARDWARE UART INITIALIZATION ROUTINES
		MVI	M,0EH		;  USED FOR THE 8251 UART
		NOP
		NOP
		MVI	M,40H		;  THE NOP INSTRUCTIONS ARE NEEDED
		NOP
		NOP
		MVI	M,0EEH		;  ONLY IF USING A 4 MHZ CPU THAT PUTS
		NOP
		NOP
		MVI	M,5		;  A 2MHZ CLOCK ON PIN 49 ON THE BUS
		MVI	A,8
		STA	STEPTIME	;STEPTIME FOR SHUGART DRIVES
		MVI	C,9
		LXI	D,SIGNON
		CALL	BDOS
		JMP	COLDBOOT

SIGNON		DB CR,LF
		DB MSIZE/10+30H
		DB MSIZE MOD 10 + 30H
		DB 'K CP/M - MICROMATION VER 2.1$'
