;
;
;
;			THIS FILE IS NAMED	PROM 46 I ASM/PRN

*-----------------------------------------------------------------------

;				LAST TIME UPDATED	Sept 12 1980
	*****************************************************************
	*								*
	*			   REVISION - 4				*
	*								*
	*     THIS ADAPTATION TO MICROMATION UNTRANSCENDABLE PAIR OF 	*
	*	 'DOUBLER' AND 'HARD' DISK CONTROLLERS IS DONE BY	*
	*								*
	*						ANANDA VEEREN	*
	*								*
	*   			COPYRIGHT (C) 1980	MICROMATION	*
	*								*
	*****************************************************************

CR		EQU	0DH	;ASCII <CR>
LF		EQU	0AH	;ASCII <LF>
BELL		EQU	07	;ASCII <BELL>

*---------------------------------------------------------------------------
HEADS		EQU	8		;# of HARD disk heads
					;(for 20 meg SHUGART SA-4008)
FIRSHEAD	EQU	4		;heads 0-3 are floppies

FLOPCONT	EQU	0F800H		;Floppy CONTROLLER
FBUFF		EQU	FLOPCONT+400H	;floppy SCRATCH RAM

HBASE		EQU	0F000H		;HARD DISK CONTROLLER BASE ADDRESS
HARDVECTOR	EQU	HBASE		;location of this programm
*---------------------------------------------------------------------------

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*		HARDWARE PORT DEFINITIONS		*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

FWRCONT		EQU	FLOPCONT+600H
FRDSTAT		EQU	FWRCONT
FWRCLK		EQU	FWRCONT+1
FUARTDATA	EQU	FWRCONT+2
FRDMARK		EQU	FWRCONT+5	;LOADS THE HEAD
FUARTSTAT	EQU	FWRCONT+0AH

	* * * * * * * * * * * * * * * * * * * * * * * * *
	*						*
	*	JUMP VECTORS TO ROUTINES IN FLOPPY	*
	*		CONTROLLER PROM			*
	*						*
	* * * * * * * * * * * * * * * * * * * * * * * * *

FHOME		EQU	FLOPCONT+3	;HOMES THE DISK
FSELDSK		EQU	FLOPCONT+6	;SELECTS DRIVE POINTED TO BY C REG
					;AND LOADS HEAD
FSETTRK		EQU	FLOPCONT+9	;STEPS DRIVE TO TRACK (C)
FSETSEC		EQU	FLOPCONT+0CH	;SET SECTOR NUMBER
FSETDMA		EQU	FLOPCONT+0FH	;SET DMA ADDRESS
DISKWRITE	EQU	FLOPCONT+15H	;WRITE SECTOR
DISKREAD	EQU	FLOPCONT+12H	;SECTOR READ
SETDEN		EQU	FLOPCONT+1BH	;TEST DENSITY OF CURRENT DRIVE
WRITEPROTECT	EQU	FLOPCONT+1EH	;CHECK FOR WRITE PROTECT


	*****************************************************************
	*								*
	*	FOLLOWING DECLARATIONS CORRESPOND TO HARD DISKS ONLY	*
	*								*
	*****************************************************************

TRAKMAX		EQU	202		;NUMBER OF TRACKS PER CILINDER
LASTHEAD	EQU	FIRSHEAD+HEADS-1;last hard disk head # (head = 4-11) 

SECTSIZE	EQU	128		;128 DATA BYTES
SECMASK		EQU	0F0H-((SECTSIZE/128-1)*10H)	;sector size mask
DEBFAC		EQU	SECTSIZE/128	;Deblock Factor

BYTESPTR	EQU	18000		;BYTES PER TRACK
SERVBYTS	EQU	36		; 36 SERVICE BYTES
SPAREBYTS	EQU	8		;8 SPARE BYTES AT THE END OF SECTOR
NUMBSECS	EQU	BYTESPTR/(SECTSIZE+SERVBYTS+SPAREBYTS)
					;NO. OF SECTORS PER TRACK

STARTSECT	EQU	00		;FIRST SECTOR FOR DISK OPERATION
LSTSECT		EQU	STARTSECT+NUMBSECS-1	;ONE LESS THEN # OF SECS.

HSTEPTIME	EQU	01	;MSECS * 2 (FOR 4 MHZ CLK AND SOFTWARE DELAY
HSTPSETL	EQU	30	;Step settle time (msec)
HHEADSETL	EQU	20	;Head settle time (msec)

RETRYMAX	EQU	30	;Retry count for Read/Write

BADSECTS	EQU	24		;# of PERMANENTLY demaged sectors
					;per LOGICAL drive
BADMAPLEN	EQU	(BADSECTS*3)+4	;Length of map for ONE LOGICAL drive
HBACKTRK	EQU	0001		;Track # that is used as a replacement
					;one in BAD MEDIA HANDLING

	*****************************************************************
	*								*
	*		HARD DISK CONTROLLER BASE ALLOCATIONS		*
	*								*
	*****************************************************************

HIO		EQU	80h		;I/O ports AREA

BUFFA		EQU	HBASE+400H	;SCRATCHPAD RAM (PART OF MAIN BUFF)
BUFFB		EQU	BUFFA+1024-SECTSIZE	;MAIN DATA BUFFER
				 	;(LOCATED AT THE END OF BUFFER)
					;starting addr. depends on sector size

TBUFF		EQU	BUFFA+40H	;SCRATCH FOR HARD DISK
PARBUFF		EQU	BUFFA+80H	;BIOS JUMP VECTORS will be located here


	*****************************************************************
	*								*
	*		HARDWARE PORT DEFINITIONS			*
	*								*
	*****************************************************************

STATPORT	EQU	HIO		;READ  - DRIVE STATUS
OPPORT		EQU	HIO+1		;READ  - MACHINE LAST STATE

SECPORT		EQU	HIO		;WRITE - SECTOR # TO PROCESS
CONTROLPORT	EQU	HIO+1		;WRITE - DRIVE CONTROL PORT
CODEPORT	EQU	HIO+2		;WRITE - FUNCTION (READ/WRITE,
					;FORMAT, SET SECTOR SIZE.

	*****************************************************************
	*								*
	*	START OF HARD DISK CONTROLLER RAM VARIABLE DEFINITIONS	*
	*								*
	*****************************************************************

DTRACK		EQU	BUFFA+2DH	;TRACK BYTE TO DISK (AFTER STEPPING)
DHEAD		EQU	BUFFA+2EH	;HEAD BYTE TO DISK
DSECTOR		EQU	BUFFA+2FH	;SECTOR TO DISK
IDEND		EQU	002FH		;te END OF ID field low order address

SYNAFLD		EQU	BUFFA+38H	;START ADDRESS OF SYNC <A> FIELD
SYNBFLD		EQU	BUFFA+18H	;SAME, FOR SYNC <B>

		*-----------------------*
		*	RAM BUFFER	*
		*-----------------------*

HTRACK		EQU	TBUFF		;TRACK
CURRHEAD	EQU	TBUFF+1		;LOGICAL CURRENT HEAD
HDMA		EQU	TBUFF+2		;DMA ADDRESS
NXTHEAD		EQU	TBUFF+4		;input LOGICAL HEAD NO.
OPERBYT		EQU	TBUFF+5		;STATE, PRIOR TO FINISH BYTE

HCONTROL	EQU	TBUFF+6		;RAM IMAGE OF DIRVE CONTROL
STATBYTE	EQU	TBUFF+7		;DRIVE STATUS
RETRYNUM	EQU	TBUFF+8		;# of Retries
HTESTMAX	EQU	TBUFF+0CH	;NO. RETRIES (CURRENTLY NOT USED)

BADINDEX	EQU	TBUFF+0DH	;# of bad sectors per LOGICAL drive
DRMAPSIZE	EQU	TBUFF+0EH	;# of bytes in bad map for 1 LOG. drive
RESEKTRK	EQU	TBUFF+0FH	;Track # to reseek to in BAD MEDIA
					;HANDLING
HCOLDSTAT	EQU	TBUFF+11H	;Coldboot status, =0 if no HARD disk
					;INITIALIZATION has NOT been done yet,
					;= 0FFh if INITIALIZATION WAS DONE

*----------------------------------------
*	BIOS SCRATCH FOR BOTH		*
*	FLOPPY & HARD DISK DRIVES	*
*----------------------------------------
BSCRATCH	EQU	40H

SEEKDSK		EQU	BSCRATCH	;DISK # SELECTED
RWFUNC		EQU	BSCRATCH+1	;READ-WRITE FUNCTION
SEEKTRK		EQU	BSCRATCH+2	;requested track # to seek
SEEKSEC		EQU	BSCRATCH+4	;sector #
SEEKDMA		EQU	BSCRATCH+6	;DMA ADDRESS will be stored here

RWRESULT	EQU	BSCRATCH+8	;result of last READ-WRITE operation
					;=00 if ok, 01 if permanent error.
FDENSIDE	EQU	BSCRATCH+9	;FLOPPY density - side information

HSWITCH		EQU	BSCRATCH+0AH	;HARD - FLOPPY DISK SWITCH
SECSIZSW	EQU	BSCRATCH+0BH	;Sector Size switch (=01 for 128 bytes
					;=02 for 256, 04 for 512)
HFLTSTAT	EQU	BSCRATCH+0CH	;HARD DISK WRITE FAULT STATUS
					;DURING WRITE SECTOR
SIDE		EQU	BSCRATCH+0DH	;Bios Floppy SIDE info.
HCONBADR	EQU	BSCRATCH+0EH	;Hard disk controller Base address,
					;Initialized by BIOS

*	*	*	*	*	*	*	*	*	*


	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*	RESERVED SCRATCH AREA FOR JUMP VECTORS TO	*
	*	   INDIVIDUAL SUBROUTINES FOR FLOPPIES		*
	*			(IN BIOS)			*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *


HDPBASE ORG	PARBUFF		;disk related parameter buffer address

*------------------------------------------
BJUMPERS:	;BIOS JUMP VECTORS WILL BE
		;MOVED TO THIS AREA ON HARD
		;DISK INITIALIZATION
*------------------------------------------
JBOOT		DS	3
JWBOOT		DS	3
JSTAT		DS	3
JCONIN		DS	3
JCONOUT		DS	3
JLIST		DS	3
JPUNCH		DS	3
JREADER		DS	3
JHOME		DS	3
JSELDSK		DS	3
JSETTRK		DS	3
JSETSEC		DS	3
JSETDMA		DS	3
JREAD		DS	3
JWRITE		DS	3
JLISTST		DS	3
JSECTRAN	DS	3

*---------------------------------------
BMAPOINTR	EQU	$		;BAD MAP pointer table. Contains poin-
					;ters to tables for each drive
MAPSTADDR	EQU	BMAPOINTR+10H	;Actuall tables of bad sectors & tracks
					;for each drive START here
*---------------------------------------

	
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*		END OF FIXED TABLES			*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*	JUMP VECTORS TO INDIVIDUAL SUBROUTINES		*
	*		USED BY ENTIRE SYSTEM			*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	*--------------------------------------------------------
		ORG	HARDVECTOR	;ORIGIN OF THIS PROGRAM
	*--------------------------------------------------------

JMPSTART	EQU	$	;start address of jump table

	jmp	upswitch	;update disk switch
	jmp	HINIT		;initialize hard disk
HBEGIN	jmp	Bhome		;BIOS move head to home position
	jmp	Bseldsk		;BIOS select disk (DOESN'T ACTUALLY SELECTS)
	jmp	Bsettrk		;BIOS set track
	jmp	Bsetsec		;BIOS set sector
	jmp	Bsetdma		;BIOS set dma address
	jmp	Bread		;BIOS read disk
	jmp	Bwrite		;BIOS write disk
	jmp	sectran		;sector translate

	jmp	FORMAT		;Format 1 sector
	jmp	DIRECTRD	;Direct SECTOR READ w NO BAD MAP SCAN
	jmp	DIRECTWR	;Direct SECTOR WRITE

JMPEND		EQU	$	;end of jump vector table
JUMPCNT		EQU	(JMPEND-JMPSTART)/3	;# of jump vectors for INIT.


*-----------------------------------------------------------------------------

;		THIS FILE IS NAMED DSKSW.ASM/PRN

;					LAST TIME UPDATED ---> OCT-15-1979
	*****************************************************************
	*								*
	*	      THIS PART TAKES CARE OF SWITCHING FROM		*
	*		  HARD TO FLOPPY TYPES OF DRIVES		*
	*								*
	*				BY ANANDA VEEREN - MICROMATION	*
	*								*
	*****************************************************************

*----------------------------------
UPSWITCH:	;update disk switch
*----------------------------------
	STA	HSWITCH		;update disk switch location
	CALL	READYTEST	;Test wether drive is ready, return <A>=0 if
				;it is ready, FF hex otherwise
	RET			;done


*----------------------------------
BSELDSK:	;select disk given by <C> register
		;comes here from regular bios with HSWITCH set to 01
HEADSEL:	;HARD DISK disk select, which is in fact HEAD SELECT
*----------------------------------
	STA	HCOLDSTAT	;Coldboot status, =0 if no HARD disk INITIALIZ.
				;was done yet, =0FFh if INITIALIZATION WAS DONE
;---> 2 new instructions
	MVI	A,DEBFAC	;Deblock Factor
	STA	SECSIZSW	;Sector Size switch BIOS var (=01 for 128 bytes
				;=02 for 256, 04 for 512)
	MOV	A,C		;get DISK no. selected
	STA	SEEKDSK		;SAVE IT TO SYSTEM
	SUI	FIRSHEAD	;First head offset
	ORA	A		;Clear carry
	RAL			;Multiply it by 2 to give 0,2,4,6 for sel. head

	STA	NXTHEAD		;Save it in HARD disk SCRATCH
	PUSH	D		;save DRIVE "ON LINE" status
	CALL	SELHEAD		;RETURNS FF hex if drive is not ready
	ORA	A		;READY ?
	POP	D		;recall status
	JNZ	NREADY		;Drive is not READY

	LDA	HCOLDSTAT	;Coldboot status
	ORA	A		;Initialized ? (If not = 0 then TRUE)
	PUSH	D		;Remember "ON LINE" status of selected drive
	CZ	HINIT		;If COLDSTAT is true, then initialize.
	POP	D
	MOV	A,E		;GET "ON LINE" status
	RAR			;get on line status BIT

	MVI	A,0		;return status in case NO READ will be done
	RC

	CALL	READMAP		;Read bad map for requested drive
	ORA	A		;<A>=00 if success
	RZ

	MVI	A,01		;Could not read bad map Return Status
	RET			;Return to caller

*	*	*	*	*	*	*	*	*	*

*---------------------------------
NREADY:		;Drive is not READY
*---------------------------------
	LXI	D,NRDMES	;not ready mesage
	CALL	PRINT
	MVI	A,0FFH		;Not ready status
	RET			;to BIOS

NRDMES	DB	CR,LF,BELL,'NOT READY$'

*	*	*	*	*	*	*	*	*	*

*------------------------------------------------
READMAP:	;Read bad map for requested drive
*------------------------------------------------
	CALL	HAHOME		;hard disk  HOME
	MVI	C,STARTSECT	;1 sector # on track
	CALL	HSETSEC		;hard disk SET SECTOR

	LXI	B,BUFFB		;MAIN DATA BUFFER
	CALL	BSETDMA		;to READ MAP first to default DMA to prevent
				;overlaying of next drives MAP
	MVI	A,30
	STA	RETRYNUM	;# of Retries

	CALL	DIRECTRD	;HARD DISK READ 1 sector
	CALL	TRANSBMAP	;Transfer BAD Map DATA
	LDA	RWRESULT	;get R/W result
	RET			;BACK TO MAIN

*	*	*	*	*	*	*	*	*	*

*- - - - - - - - - - - - - - - - - - - -
TRANSBMAP:	;Transfer BAD Map From Controllers buffer
		;to proper location.
*- - - - - - - - - - - - - - - - - - - -
	CALL	GETBADADR	;Get address of BAD MAP for selected drive

	LDA	DRMAPSIZE	;# of bytes in bad map for 1 LOG. drive
	MOV	C,A
	LXI	D,BUFFB		;MAIN DATA BUFFER
	CALL	TRANSFER	;Move <C> bytes from BUFF to BAD MAP
	RET

*---------------------------------------
GETBADADR:	;Get address of BAD MAP
		;for corresponding drive
*---------------------------------------
	PUSH	D		;In NO case alter <D,E>, it is used in COMPTRK
	LDA	NXTHEAD		;Latest HARD disk head selected (0,2,4
	ANI	0FEH		;---> Reset bit 0 - make head EVEN
	MOV	C,A
	MVI	B,0		;for DAD
	LXI	H,BMAPOINTR	;BAD MAP pointer table. Contains pointers to
				;tables for each drive
	DAD	B		;<H,L> now contains pointer to BAD MAP
	MOV	E,M		;GET BAD MAP address LOW
	INX	H
	MOV	D,M		;MAP address HIGH
	XCHG			;<H,L> now contains BAD MAP START address
				;for REQUESTED drive
	POP	D		;Recall ORIGINAL <D,E>, please
	RET

*	*	*	*	*	*	*	*	*	*

	*****************************************
	*	FOR HOME THE HEAD		*
	*****************************************

*---------------------------------------------
BHOME:	;Bios HOME the head of selected drive
HAHOME:	;step to track 0
*------------------------
	LXI	B,00		;HOME is interpreted as set track 0 (no actuall
				;set track occures though).

	*********************************
	*	FOR BIOS SETTRACK	*
	*********************************

*-------------------------------
BSETTRK:	;BIOS SET TRACK
		;comes here with track no. in <B,C> reg.
*-------------------------------
	MOV	H,B		;track # HIGH
	MOV	L,C		;LOW
	SHLD	SEEKTRK		;just store away parameter, no actuall stepping
	RET


	*****************************************
	*	FOR BIOS SECTOR TRANSLATE	*
	*****************************************

*------------------------------------------------------------
SECTRAN:	;TRANSLATE THE SECTOR GIVEN BY BC USING THE
		;TRANSLATE TABLE GIVEN BY <D,E> registers
		;RETURN THE RESULT IN <H,L> FOR CP/M 2.0
		;H=0 IF SECT < 256
*------------------------------------------------------------
	LDA	HSWITCH
	ORA	A		;SET Z FLAG FOR FLOPPY
	JZ	JSECTRAN	;go to FLOPPY

	MOV	H,B
	MOV	L,C
	RET			;HARD DISK RETURN


	*********************************
	*	FOR BIOS SET SECTOR	*
	*********************************

*---------
BSETSEC:
*---------
	LDA	HSWITCH
	ORA	A
	JNZ	HSETSEC		;hard disk sector
	JMP	JSETSEC		;floppy set sector

*--------------------------
HSETSEC:	;HARD DISK
*--------------------------
	CALL	SETDISABLE	;Reset START bit, set READ bit true
	MOV	A,C
	STA	SEEKSEC		;save to SEEK SECTOR too
	STA	DSECTOR		;sector no. which gets actually written on disk
	RET



	*****************************************
	*	FOR BIOS SETDMA			*
	*****************************************

*-------------------------------------------------------------
BSETDMA:	;set DMA address given by <B,C> register pair
*-------------------------------------------------------------
	MOV	L,C		;LOW order address
	MOV	H,B		;HIGH DMA address
	SHLD	SEEKDMA		;to seek dma too
	JMP	JSETDMA		;set floppy DMA address too


	*****************************************
	*	FOR BIOS READ SECTOR		*
	*****************************************

*--------------------------
BREAD:	;BIOS SECTOR READ
*--------------------------
	LDA	HSWITCH		;on what disk, FLOPPY or HARD disk controllers?
	ORA	A		;set Z flag for FLOPPY
	JZ	JREAD		;FREAD is bios FLOPPY sector read,
				;<Z> FLAG IS SET, FLOPPY READ

*- - - - - - - - - - - - - - - - - - - - - - -
; --->	HARD DISK READ with error check.
;	Returns 0 in <A> reg from HARD DISK
;	SETREAD. Also returns 0 to CP/M
;	after transferring to DMA address.
*- - - - - - - - - - - - - - - - - - - - - - -
	CALL	CHKBADSEC	;Check for current SEEK parameters to be
				;equall to one of PERMANENTLY demaged areas on
				;disk, Reseek to RESERVE track if so.
	MVI	A,RETRYMAX	;Retry count for Read/Write
*-------------------------------
DIRECTRD:	;HARD DISK DIRECT READ 1 sector
		;with NO BAD SECTOR MAP scan.
		;<A> = # of Retries
*-------------------------------
	STA	RETRYNUM	;# of Retries

	CALL	HSETTRK		;Actually seek track on hard disk
	MVI	A,SECMASK	;get sector size mask
	ORI	05		;read function
	STA	RWFUNC		;SAVE IT TO HARD DISK R/W FLAG LOCATION

	CALL	SETREAD		;hard disk READ sector
	LDA	RWRESULT	;RESULT of hard disk R/W operation
	ORA	A		;if <A> = 00, then success
	JZ	READOK		;ok, transfer data
	RET			;SETREAD returns 01 for permanent error


READOK:				;read ok, transfer data
	LHLD	SEEKDMA		;<--- Lets try to use system scratch instead
	LXI	D,BUFFB		;hard disk controller internal DATA buffer

	MVI	C,SECTSIZE	;get SECTOR SIZE (no bigger, then 256 bytes now
	CALL	TRANSFER	;TRANSFER data if raad OK.
	MVI	A,00		;show CP/M that we are ok.
	STA	RWRESULT	;RESULT of hard disk R/W operation
	RET			;return to CP/M


	*****************************************
	*	FOR BIOS WRITE  SECTOR		*
	*****************************************

*----------------------------------
BWRITE:		;BIOS SECTOR WRITE
*----------------------------------
	LDA	HSWITCH		;on what disk, FLOPPY or HARD disk controllers?
	ORA	A		;set Z flag for FLOPPY
	JZ	JWRITE		;FWRITE is bios FLOPPY write sector
				;<Z> FLAG IS SET, FLOPPY READ

	CALL	CHKBADSEC	;Check for current SEEK parameters to be
				;equall to one of PERMANENTLY demaged areas on
				;disk, Reseek to RESERVE track if so.

	MVI	A,RETRYMAX	;Retry count for Read/Write
*- - - - - - - - - - - - - - - -
DIRECTWR:	;HARD disk DIRECT WRITE 1 sector
		;with NO BAD SECTOR MAP scan.
		;<A> = # of Retries
*- - - - - - - - - - - - - - - -
	STA	RETRYNUM	;# of Retries

	CALL	HSETTRK		;Actually seek track on hard disk
	LHLD	SEEKDMA		;<--- Lets try to use system scratch instead
	XCHG			;GET DMA ADDRESS TO <D,E> REGISTER
	LXI	H,BUFFB		;hard disk controller internal DATA buffer
	MVI	C,SECTSIZE	;get SECTOR SIZE (no bigger, then 256 bytes now
	CALL	TRANSFER	;TRANSFER data BEFORE doing any writes to disk.

*- - - - - - - - - - - - - - - - - - - - - - -
; --->	HARD DISK WRITE with error check.
;	Returns 0 in <A> reg from HARD DISK
;	SETREAD. Also returns 0 to CP/M
;	after transferring to DMA address.
*- - - - - - - - - - - - - - - - - - - - - - -
	MVI	A,SECMASK	;get sector size mask
	ORI	04		;WRITE function
* - - - - - - - - - - - - - - - -
WRITECON:	;Continue for both
		;WRITE & FORMAT from here
* - - - - - - - - - - - - - - - -
	STA	RWFUNC		;SAVE IT TO HARD DISK R/W FLAG LOCATION

	CALL	CLEARFLT	;CLEAR software write protect
	CALL	SETWRITE	;hard disk WRITE sector, set PROTECT when done

	LDA	RWRESULT	;GET R/W result
	RET			;we return here in any case - failure or
				;success, doesnt matter.
				;SETWRITE does 30 retries before coming here.

*	*	*	*	*	*	*	*	*	*

*-------------------------------
FORMAT:		;Format 1 sector
*-------------------------------
	CALL	HSETTRK		;Actually seek track on hard disk
	MVI	A,SECMASK	;get sector size mask
	ORI	06		;FORMAT function
	JMP	WRITECON	;Continue for both WRITE & FORMAT from here

*	*	*	*	*	*	*	*	*	*

*----------------------------------------------------------------
TRANSFER:  ;This part TRANSFERS DATA <FROM> ADDRESS, pointed by	*
*	<D,E> register pair <TO> address pointed by <H,L> pair	*
*	<C> is # of bytes to transfer				*
*----------------------------------------------------------------
TRANS1:
	LDAX	D		;get one byte starting from end address
	MOV	M,A		;SAVE it
	INX	H		;increment address
	INX	D		;this one too.
	DCR	C		;decrement COUNT
	JNZ	TRANS1		;continue if count is not exhausted
	RET			;done, return to CP/M.

; ---> <H,L> points to NEXT DMA TRANSFER ADDRESS, NOT LAST TRANSFER ONE !!!

	*****************************************
	*	THE END OF FILE DSKSW. ASM/PRN	*
	*****************************************

*	*	*	*	*	*	*	*	*

		*-------------------------------*
		* * * * * * * * * * * * * * * * *
		*	RECOVERY CODE START	*
		* * * * * * * * * * * * * * * * *
		*-------------------------------*

*-----------------------------------------------------------------
CHKBADSEC:	;Check for current SEEK parameters to be
		;equall to PERMANENTLY demaged areas of disk
		;Reseek to RESERVE track # if CURRENT SEEK=BAD MAP
*-----------------------------------------------------------------
	LHLD	SEEKTRK		;Get SEEK TRACK
	XCHG			;Put it in <D,E>
	CALL	GETBADADR	;Get address of BAD MAP for sel. drive to <H,L>
	LDA	BADINDEX	;# of bad sectors per LOGICAL drive
	MOV	C,A		;BAD MAP scan index
*- - - - - - - - - - - - - - - - - - - - - - - -
SCANLOOP:	;Scan for SEEK sector = MAP sect
		;If true, then scan for TRACK match
*- - - - - - - - - - - - - - - - - - - - - - - -
	CALL	COMPSECT	;<C> will be used as index & filnaly as SECT. #
	JNZ	SECNOTEQU	;IF no match was found

	PUSH	H		;Save current <H,L>, it will be incremented
	CALL	COMPTRK		;Compare SEEK & MAP TRACKS if sector matches
	POP	H
	JZ	BTRKMATCH	;TRACK & SECTOR BOTH match, RESEEK

SECNOTEQU:	;no match was found
	CALL	INCRSECT	;point to next map entry
	RZ			;Map is finished, this is a good sector

	JMP	SCANLOOP	;just keep scanning

*	*	*	*	*	*	*	*	*	*

*- - - - - - - - - - - - - - - - - - - - - - - - -
BTRKMATCH:	;TRACK & SECTOR BOTH match, RESEEK
		;<C> is index will be used as a SECTOR #
		;to reseek to on backup track
*- - - - - - - - - - - - - - - - - - - - - - - - -
	LHLD	RESEKTRK	;Track # to reseek to
	SHLD	SEEKTRK		;To perform I/O on GOOD BACKUP track
	CALL	HSETSEC		;set sector
	RET			;Ready to do I/O

*- - - - - - - - - - - - - - - - - - - - - - - - -
COMPSECT:	;Compare SEEK sector with MAP sector
		;<C> will be used as MAP index
*- - - - - - - - - - - - - - - - - - - - - - - - -
	MOV	B,M		;<H,L> points to SECTOR location on BAD MAP
	LDA	SEEKSEC		;save to SEEK SECTOR too
	CMP	B
	RET			;<Z> flag will be tested

*- - - - - - - - - - - - - - - - - - - - - - - - -
INCRSECT:	;point to next map entry, test for
		;END of MAP or INDEX EXHAUST,
		;SET <Z> flag if MAP IS OVER because
		;of ANY OF ABOVE CONDITIONS
*- - - - - - - - - - - - - - - - - - - - - - - - -
	INX	H
	INX	H
	INX	H		;Now <H,L> points to SECTOR byte of next entry
	DCR	C		;Decrement index
	RZ			;If all entries have been scanned, then <C>=00

	MOV	A,M		;Get 1st byte of next entry
	CPI	0FFH		;NO MORE ENTRIES ?
	RET			;<Z> flag is set if END OF MAP.

*- - - - - - - - - - - - - - - - - - - - - - - - -
COMPTRK:	;Compare SEEK & MAP TRACKS if sector matches
*- - - - - - - - - - - - - - - - - - - - - - - - -
	INX	H		;Point to MAP track HIGH byte
	MOV	A,M		;get track HIGH byte
	CMP	D		;<D> is SEEK track HIGH
	RNZ			;Will be no match

	INX	H		;Point to MAP track LOW
	MOV	A,M
	CMP	E		;<E> is SEEK track LOW
	RET

	*-------------------------------*
	* * * * * * * * * * * * * * * * *
	*	RECOVERY CODE END	*
	* * * * * * * * * * * * * * * * *
	*-------------------------------*

*	*	*	*	*	*	*	*	*

*-------------------------------------------
SETDISABLE:	;Reset START bit, set READ bit true
*-------------------------------------------
	MVI	A,SECMASK	;INITIALIZE SECTOR SIZE SWITCH
	ORI	01		;just read, no interrutps
	OUT	CODEPORT	;NO FORMAT, NO WRITE, NO INTERRUPT ENABLE
	RET			;thats all

*	*	*	*	*	*	*	*	*

*----------------------------------------------------
SETREAD:	;READ - WRITE SECTOR, RETRY IF ERROR
SETWRITE:	;30 retries is allowed now
*----------------------------------------------------
HADOIT:
	LDA	RETRYNUM	;# of Retries
	MOV	E,A		;Retry Count before Hard Error
DOAGAIN:			;FOR RETRY SITUATION
	CALL	SECCHK		;GET SECTOR # FROM (D)SECTOR, STORE IT TO
				;SECTOR PORT FOR SECTOR SEEK
	LDA	RWFUNC		;GET R/W FUNCTION
	OUT	CODEPORT	;EXECUTE, PLEASE !


;		DISK OPERATION FINISHED TEST
;	Waits till disk operation first starts (finish bit goes low - inactive)
;	Then waits for finish bit to go high - active (finished).

FINCHEK:			;check for <DISK OPERATION FINISHED>
FINREP1	IN	OPPORT		;Get OPPORT
	ANI	20H		;finish bit only
	JNZ	FINREP1		;FINISH IS HIGH, I/O HAS NOT STARTED YET.
				;FINISH BIT JUST WENT LOW, SOMETHIG STARTED !
FINREP2	IN	OPPORT		;Get opport
	STA	OPERBYT		;save it for last state analisys
	ANI	20H		;leave finish bit only
	JZ	FINREP2		;REPEAT TILL <FINISH BIT IS TRUE> (HIGH)

*- - - - - - - - - - - - - - - -
;	Disk operation finished now,
;	check for any ERRORS.
*- - - - - - - - - - - - - - - -
	CALL	CHEKFAULT	;CHECK FOR WRITE FAULT, set FAULT STATUS LOC

	LDA	OPERBYT		;get last state again
	ANI	1FH		;leave 5 low order bits only
	STA	OPERBYT		;save it
ANYERRS:
	CPI	14H		;ID field error ?
	CZ	RESEEK		;reseek if so

	LDA	RWFUNC		;GET R/W FUNCTION
	RAR			;Get WRITE bit (for both - WRITE & FORMAT)
	JNC	WASWRITE	;WRITE bit LOW, go & check last state

*--------------------------------
WASREAD:	;IT WAS READ, WHAT ELSE ?
*--------------------------------
	LDA	OPERBYT		;GET LAST STATE
	CPI	16H		;NO READ ERRORS
RWOCON	MVI	A,00		;TO INDICATE SUCCESS
	STA	RWRESULT	;SAVE IT FOR SYSTEM LOCAL BIOS ANALISYS
	JZ	RWEXIT		;EXIT RESTORE ALL REGISTERS

*------------------------------------------------------------------------
RETCHEK:	;TAKES CARE OF SECTOR R/W RETRIES
		;RETURNS TO CALLER WITH <A> REG <> 0 IF RETRY COUNT < 30
		;RETURNS WITH <A> = 00 IF NOT
*------------------------------------------------------------------------
	DCR	E		;DECREMENT RETRY COUNT
	JNZ	DOAGAIN		;RETRY

	MVI	A,01		;CP/M CONVENTION FOR PERMANENT ERROR
	STA	RWRESULT	;Save it for SYSTEM use
	JMP	RWEXIT		;EXIT RESTORE ALL REGISTERS

*	*	*	*	*	*	*	*	*

* - - - - - - - - - - - - - - - - - - - - - - - -
WASWRITE:	;It was WRITE or FORMAT operation
* - - - - - - - - - - - - - - - - - - - - - - - -
	LDA	HFLTSTAT	;WRITE FAULT STATUS DURING WRITE SECTOR
	CPI	0FFH		;FAULT ?
	JNZ	NOFAULT		;OK, continue

	CALL	UNPROTECT	;UNPROTECT DISK (set FAULT bit low, then high
	JMP	RETCHEK		;RETRY COUNT EXHAUST CHECK, set R/W result

NOFAULT	LDA	OPERBYT		;GET LAST STATE
	CPI	11H		;NO WRITE ERRORS
	JMP	RWOCON		;Continue for all - READ, WRITE & FORMAT

*- - - - - - - - - - - - - - - -
RWEXIT:		;EXIT
*- - - - - - - - - - - - - - - -
	CALL	SETPROTECT	;SET write protect
	RET			;just return

*	*	*	*	*	*	*	*	*

*------------------------------------------------------------
CHEKFAULT:	;CHECK FOR WRITE FAULT, CLEAR IT IF ITS TRUE
*------------------------------------------------------------
	IN	STATPORT	;CHECK DRIVE STATUS (FOR WRITE FAULT)
	ANI	10H		;FAULT CLEAR BIT (ACTIVE LOW)
	MVI	A,0		;if NO WRITE FAULT detected
	STA	HFLTSTAT	;WRITE FAULT STATUS DURING WRITE SECTOR
	RNZ			;just exit with 0 in <A>

	MVI	A,0FFH		;write fault was found, return FF hex in <A>
	STA	HFLTSTAT	;WRITE FAULT STATUS DURING WRITE SECTOR
	RET

*	*	*	*	*	*	*	*	*	*

*-------------------------------------------------
SECCHK:		;SET SECTOR FIRST, BEFORE R/W OR ELSE...
*-------------------------------------------------
	LDA	DSECTOR		;GET DESIRED SECTOR #
	OUT	SECPORT		;FOR REVISHION 2 HCONTHBASE JUST STORE IT
	RET

*	*	*	*	*	*	*	*	*	*

*-------------------------------------------------
RESEEK:		;ON ID ERROR, recalibrate the head and step
		;back on present track
*-------------------------------------------------
	PUSH	D		;save retry count before setting track
	CALL	HDOHOME		;CALIBRATE HARD DISK HEADS
	CALL	HSETTRK		;ACTUALLY SET ORIGINAL TRACK

	POP	D		;restore retry count
	RET			;continue

*	*	*	*	*	*	*	*	*	*

*----------------------------------------------------------------------
UNPROTECT:	;UNPROTECT DISK (set FAUL low, then high
*----------------------------------------------------------------------
	CALL	SETPROTECT	;FAULT LOW  - write protect disk
	CALL	CLEARFLT	;FAULT HIGH - clear write fault
	RET

*----------------------------------------------------------------------
SETPROTECT:	;write protect disk
*----------------------------------------------------------------------
	LDA	HCONTROL
	ANI	0FBH		;RESET FAULT CLEAR BIT
	OUT	CONTROLPORT	;TELL IT TO THE DRIVE, BUT DONT UPDATE
	RET			;H CONTROL, IT MAY SCREW IT UP
				;writing is inhibited now
*	*	*	*	*	*	*	*	*	*

*---------------------------------------------
CLEARFLT:	;clear write fault
*---------------------------------------------
	LDA	HCONTROL	;JUST TO DELAY
	ORI	4		;RESET FAULT CLEAR
	OUT	CONTROLPORT	;TELL IT TO THE DRIVE, BUT DONT UPDATE
	RET			;HCONTROL, IT MAY SCREW IT UP

*	*	*	*	*	*	*	*	*	*

*-------------------------------------
HINIT:		;INITIALIZE HARD DISK.
		;1) - ORGANIZE Scratch
		;2) - MOVE BIOS Jump vector table to scratch
		;3) - Replace DISK I/O BIOS jump vectors with corresponding
		;     vectors, located in this program.
		;4) - HOME HEAD
		;5) - Create BAD MAP pointers
*-------------------------------------
	XRA	A
	STA	DSECTOR

	MVI	A,0FFH		;Set fault clear LOW
	STA	HCONTROL	;For SET PROTECT
	CALL	SETPROTECT	;write protect disk

	CALL	ORGAN		;ORGANIZE SCRATCH

	CALL	MOVEJUMP	;move bios jump vector table to local scratch
	CALL	HDOHOME		;CALIBRATE HARD DISK HEADS

*- - - - - - - - - - - - - - - - - - - - - - - - -
BADINIT:	;Initialize variables for BAD MEDIA
		;RECOVERY software
*- - - - - - - - - - - - - - - - - - - - - - - - -
	MVI	A,BADSECTS		;# of demaged sectors per LOGICAL drive
	STA	BADINDEX		;# of bad sectors per LOGICAL drive

	LXI	B,BADMAPLEN		;Length of map for ONE LOGICAL drive
	MOV	A,C
	STA	DRMAPSIZE		;# of bytes in bad map for 1 LOG. drive
	LXI	H,HBACKTRK		;Track # that is used as a replacement
	SHLD	RESEKTRK
	CALL	MAKEMAPOINT	;Make BAD MAP pointers
	MVI	A,0		;TO indicate success
	RET

*	*	*	*	*	*	*	*	*	*

*- - - - - - - - - - - - - - - - - - -
MAKEMAPOINT:	;Make BAD MAP pointers
		;<B,C> = map length
*- - - - - - - - - - - - - - - - - - -
	LXI	D,BMAPOINTR		;BAD MAP pointer table. Contains poin-
					;ters to tables for each drive
	LXI	H,MAPSTADDR		;Actuall tables of bad sectors & tracks
					;for each drive START here
	MVI	A,HEADS/2		;# of LOGICAL hard disk drives
MAKELOP	PUSH	PSW			;save # of drives
	MOV	A,L			;Map address LOW
	STAX	D			;Pointer LOW
	INX	D
	MOV	A,H			;map addr HIGH
	STAX	D			;Pointer HIGH
	DAD	B			;Add MAP LENGTH to make next pointer
	POP	PSW			;Recall # of drives left to make point
	INX	D			;Point to next pointer LOW
	DCR	A			;keep counting drives left
	JNZ	MAKELOP			;Till pointers are made for all drives
	RET

*	*	*	*	*	*	*	*	*

*------------------------------
ORGAN:	;ORGANIZE DISK SCRATCH
*------------------------------
	XRA	A
	LXI	B,BUFFA+40H	;POINT TO THE END OF BUFFER
CLEAR1:
	DCR	C
	CALL	IDSKIPT		;do not alter an ID field
	STAX	B
	JNZ	CLEAR1

	LXI	H,SYNAFLD	;POINT H,L TO START ADDRESS OF SYNC <A> FIELD
	MVI	A,0FH		;SYNC A PATTERN
	CALL	FILL8
	MVI	A,0DH		;SYNC <B> PATTERN
	LXI	H,SYNBFLD	;SAME AS ABOVE, FOR SYNC <B> FIELD
	JMP	FILL8		;FILL8 RETURNS TO CALLER

*-----------------------
FILL8:	;FILL 8 LOCATIONS WITH DATA FROM INDEX FIELD
	;<A> REG. CONTAINS DATA TO FILL WITH
	;COMES HERE WITH SYNC. <A> FIELD ADDRESS IN <H,L> REG.
*-----------------------
	PUSH	B
	MVI	C,08		;COUNT
FILL81	MOV	M,A		;STORE DATA
	INR	L		;INCREM SCRATCH ADDR.
	DCR	C
	JNZ	FILL81
	POP	B
	RET


*- - - - - - - - - - - - - - - -
IDSKIPT:	;DECREMENT CURRENT ADDRESS <B,C> reg in case if
		;it points to ID field in order not to alter it.
*- - - - - - - - - - - - - - - -
	PUSH	PSW
	MOV	A,C		;get current address
	CPI	IDEND		;last ID field address ?
	JNZ	SKIPDONE	;no, just exit

	DCX	B		;decrem <B,C> registers
	DCX	B
	DCX	B

SKIPDONE
	POP	PSW
	RET

*	*	*	*	*	*	*	*	*	*

*------------------------------------------------------------
MOVEJUMP:	;move bios jump vectro table to local scratch
*------------------------------------------------------------
	LHLD	1		;get bios high order jump vectro table address
	MVI	L,0		;reset low order byte <H,L> points not to start
				;address of bios jump vector table
	XCHG			;point <D,E> to bios
	LXI	H,BJUMPERS	;point <H,L> to scratch jumpers start address
	MVI	C,33H		;move 33 hex bytes (table
	CALL	TRANSFER	;move 33 hex bytes from <D,E> address to <H,L>
				;address.

MVHJUMP:			;move hard disk jumpers to bios to reflect new
	LXI	D,HBEGIN	;hard disk home jump vector
	LHLD	1		;get bios high order jump vectro table address
	MVI	L,18H		;low address pointer to BIOS HOME

	MVI	C,3		;3 bytes to move (home jump vector)
	CALL	TRANSFER	;transfer the content THIS programm jump

	INX	D		;To skip moving SELECT DISK
	INX	D
	INX	D
	INX	H
	INX	H
	INX	H

	MVI	C,15		;15 bytes to move (5 jump vectors)
	CALL	TRANSFER	;transfer the content THIS programm jump
				;vectors to BIOS jump vector table
				;on return from transfer <H,L> & <D,E> both
				;point to NEXT LOCATION.
				;we need to skip one jump vector
	INX	H
	INX	H		;same to <H,L>
	INX	H
	MVI	C,3		;just one jump vector to move
	CALL	TRANSFER	;move LAST BIOS JUMP VECTOR (sector translate)
	RET			;OK, DONE

*	*	*	*	*	*	*	*	*	*

*---------------------------------------
READYTEST:	;drive ready test
*---------------------------------------
	CALL	SETDISABLE	;Reset START bit, set READ bit true

	IN	STATPORT	;GET DRIVE STATUS
	ANI	080H		;DRIVE READY bit only
	MVI	A,0
	RZ			;READY

	MVI	A,0FFH
	RET			;NOT READY

*	*	*	*	*	*	*	*	*

*---------------------------------------------
HDOHOME:	;Actually step head to track 0
*---------------------------------------------
	MVI	C,8		;to go to track 10
STPLH	PUSH	B
	CALL	GOIN		;1 step <IN> and Track 0 - inactive
	POP	B
	DCR	C
	JNZ	STPLH


GOOUT	LXI	H,DTRACK	;FOR STEPIN AND STEPOUT
	CALL	STEPOUT		;THEN STEP TOWARD 0
	CALL	WSEKDON		;Wait for Seek Done from Drive
	IN	STATPORT	;get status for track 0 flag test
	ANI	20H		;UNTIL -TRK0 IS ACTIVE
	JNZ	GOOUT

HOMEDONE:
	XRA	A
	STA	DTRACK		;SAVE IT TO SYSTEM SCRATCH
	MVI	B,HSTPSETL	;Step settle delay 
	CALL	DELAY
	RET


GOIN	LXI	H,DTRACK	;FOR STEPIN AND STEPOUT
	CALL	STEPIN		;STEP TOWARD 202
	CALL	WSEKDON		;Wait for Seek Done from Drive
	IN	STATPORT	;get status for track 0 flag test
	ANI	20H		;UNTIL -TRK0 IS INACTIVE
	JZ	GOIN
	RET

*	*	*	*	*	*	*	*	*

*---------------------------------------------
WSEKDON:	;Wait for Seek Done from Drive
*---------------------------------------------
	IN	STATPORT	;get status for track 0 flag test
	ANI	40H		;Seek Done active LOW
	JNZ	WSEKDON
	RET

*	*	*	*	*	*	*	*	*

*----------------------------------------
HSETTRK: 	;STEPS HEAD TO "SEEK" TRACK 
		;sets track, reselects head if track is odd
		;during set track <D,E> is not used,
*----------------------------------------
	LHLD	SEEKTRK		;SYSTEM TRACK #
	ORA	A
	MOV	A,H		;get REQUESTED TRACK, HIGH byte to divide by 2
	RAR			;divide by 2 with carry
	MOV	A,L		;get REQUESTED TRACK, LOW byte
	RAR			;divide by two with CARRY from HIGH byte divide
	STA	HTRACK		;Hard disk scratch track #

	LDA	CURRHEAD	;get head
	JNC	TRKEVEN		;no carry after rotate, go to even track

TRKODD				;carry is set - track is ODD
	ORI	01		;Set next head
	JMP	RANGEOK

TRKEVEN:		;<A> contains head #	
	ANI	0FEH		;Set the same head

RANGEOK	STA	NXTHEAD		;HARD disk SCRATCH for LOGICAL head #
	CALL	SELHEAD		;reselect head

	LDA	HTRACK		;Hard disk scratch track #
	MOV	C,A		;get back to <C> reg to set track
	LDA	DTRACK		;get present track #
	CMP	C		;the same track ?
	RZ			;track is the same, we have been on this trip
				;at least once before, just return

*-------------------------------
STEPLOOP:	;This part ACTUALLY SETS the TRACK if pres trk. <> next trk.
*-------------------------------
	CALL	SETDISABLE	;Reset START bit, set READ bit true

	LXI	H,DTRACK
	MOV	A,M		;GET (TRACK)
	CMP	C		;DONE?
	JZ	DONESTEP

	CALL	STEPHEAD	;NO, STEP HEAD
	JMP	STEPLOOP	;REPEAT

STEPHEAD JC	STEPIN		;IF TRACK < (C) THEN STEP IN
STEPOUT	LDA	HCONTROL	;GET CONTROLBYTE
	DCR	M		;<H,L> POINTS TO DTRACK. (TRACK)=(TRACK)-1
	ORI	02H		;DIR=OUT
	JMP	DOSTEP

STEPIN	LDA	HCONTROL	;CONTROLBYTE
	INR	M		;(TRACK)=(TRACK)+1
	ANI	0FDH		;DIR=IN

DOSTEP:
	OUT	CONTROLPORT	;SET Direction
	ANI	0FEH		;BIT 0 ACTIVE - LOW
	OUT	CONTROLPORT	;Actually step

	ORI	01		;DIACTIVATE STEP BIT
	OUT	CONTROLPORT	;STOP STEPPING
	RET

DONESTEP:
	CALL	WSEKDON		;Wait for Seek Done from Drive
	MVI	B,HSTPSETL	;Step settle time
	JMP	DELAY		;Software delay

*	*	*	*	*	*	*	*	*	*

*----------------------------------------------------
SELHEAD: ;SELECTS HEAD GIVEN BY "NEXT HEAD" location
	;comes here with head # = 4-7
*----------------------------------------------------
	LDA	NXTHEAD		;HARD disk SCRATCH for latest LOGICAL head #
DOSEL	STA	CURRHEAD	;THE SAME AS NEXT HEAD
	MOV	C,A		;FOR DAD
	LXI	H,HEADTABLE	;HEAD MASK TABLE FOR CORRESPONDING DISK
	MVI	B,0
	DAD	B		;<C> CONTAINS HEAD NUMBER
	MOV	A,M		;GET MASKTABLE
	STA	HCONTROL	;STORE IT TO CONTROLBYTE ONLY, NOT TO DHEAD !!!

SELHEAD1 OUT	CONTROLPORT
	ANI	0F0H		;<<<-=-=-=  LEAVE HEAD RELATED BITS ONLY !!!
	STA	DHEAD		;DHEAD IS PHISICAL HEAD # (=F0 FOR HEAD 0)
	CALL	DEL20MK		;delay for 20 microseconds

	CALL	READYTEST	;drive ready test
	ORA	A
	RNZ			;drive not ready, return to CP/M with FF in ACC

	MVI	A,01		;to indicate HARD DISK
	STA	HSWITCH		;disk switch = 0 for FLOPPY, 01 for HARD disks

	XRA	A		;indicate success
	RET

*------------------------
HEADTABLE:
*------------------------
	DB	0F3H,0E3H		;Drive <E>
	DB	0D3H,0C3H		;Drive <F>
	DB	0B3H,0A3H		;Drive <G>
	DB	093H,083H		;Drive <H>

*	*	*	*	*	*	*	*	*

*------------------------
DEL20MK:	;delay for 20 microseconds
*------------------------
	PUSH	B
	MVI	C,10		;for 4 MHZ
DEL20R	DCR	C
	JNZ	DEL20R		;loop
	POP	B
	RET

*	*	*	*	*	*	*	*	*	*

*------------------------------------------------
DELAY:	;Delays <B> register Msecs (Presently set for 4 Mhz clock)
	;<C> register is loaded with 0D9 hex for 1 msec loop
	;and NO Wait states, or 0AC hex for 1 wait state.
*------------------------------------------------
	PUSH	B

LLOOP	MVI	C,0ACH		;For 1 Msec loop, 1 WAIT state
SLOOP	DCR	C
	NOP
	JNZ	SLOOP		;1 msec delay loop

	DCR	B
	JNZ	LLOOP		;Main loop

	POP	B
	RET

*	*	*	*	*	*	*	*	*	*

*------------------------
PRINT:	;Print mesage by <D,E> using BIOS Conout
*------------------------
	LDAX	D	;GET MESAGE ADDRESS
	CPI	'$'	;END ?
	RZ

	MOV	C,A
	PUSH	D
	CALL	DOCONOUT	;TYPE CHARACTER
	POP	D
	INX	D		;POINT TO NEXT CHAR
	JMP	PRINT

DOCONOUT	;TYPE CHARACTER
	LHLD	1
	MVI	L,0CH		;BIOS offset for conout
	PCHL

	*************************************************
				END
	*************************************************
