	.page
	.sbttl	'adjust attributes for changed bit map'
;
;	last modified 6-Jan-83
;
;	adjust display attribute chars for changed
;	bit setting at current position
;
adjlinedisplay:
	lda	tagfollows
	cpi	true
	jz	..newlyset
;
;	handle case of newly reset bit
;	first look at bit after and then
;	at bit before to insert or remove
;	display characters
;
	lda	lcurx
	cpi	charsperline - 1
	jrz	..rbefore
	cpi	0
	jrz	..rasameline
;
;	if bit before is not set and bit after
;	is set then can move attribute
;	char from being before current char
;	to being after current char
;
	lhld	lcurxy
	inr	l	;look at bit after
	call	bmbtest
	jrz	..rasameline
	lhld	lcurxy
	dcr	l	;look at bit before
	call	bmbtest
	jrnz	..rasameline
;
;	make sure attribute chars are as we expect them
;
	lhld	nextchar
	inx	h
	bit	7,m
	jrnz	..rasameline
	dcx	h
	dcx	h
	bit	7,m
	jrz	..rasameline
	call	blinesetalterattribute
	inx	h
	mov	b,m
	dcx	h
	mov	a,m
	mov	m,b
	shld	nextchar
	inx	h
	mov	m,a
	jmp	blineresetalterattribute  ;return from
				;there
	.page
;
;	if bit following is same as current bit
;	remove display char if present, otherwise
;	insert display character
;
..rasameline:
	lhld	lcurxy
	inr	l	;hl to point to next bit
	call	bmbtest
	jrz	..raremove
	lhld	nextchar	;advance nextchar
	push	h	;since store control puts
	inx	h	;before nextchar
	call	skipattribute	
	lda	tagattribute
	call	storecontrol
	pop	h
	shld	nextchar
	jmpr	..rbefore
..raremove:
	call	removaftercursorcontrol
	jmpr	..rbefore

;
;	now adjust before current char if needed
;
..rbefore:
	lda	lcurx	;see if at beginning of line
	cpi	0
	jrnz	..rnotatbeginning
;
;	at beginning of line, insert display character
;
	lda	notagattribute
	call	storecontrol
	ret
;
;	not at begining of line, if previous bit
;	is different from current bit, insert control
;	character, otherwise remove character
;
..rnotatbeginning:
	lhld	lcurxy
	dcr	l	;get hl to point to previous
	call	bmbtest	;bit
	jrz	..rremove
	lda	notagattribute
	call	storecontrol
	ret
..rremove:
	call	removbeforecursorcontrol
	ret
	.page
;
;	handle case of newly set bit
;	first look at bit after and then
;	at bit before to insert or remove
;	display characters
;
..newlyset:
	lda	lcurx
	cpi	charsperline - 1
	jrz	..sbefore
	cpi	0
	jrz	..sasameline
;
;	if bit before is set and bit after
;	is not set then can move attribute
;	char from being before current char
;	to being after current char
;
	lhld	lcurxy
	inr	l	;look at bit after
	call	bmbtest
	jrnz	..sasameline
	lhld	lcurxy
	dcr	l	;look at bit before
	call	bmbtest
	jrz	..sasameline
;
;	make sure attribute chars are as we expect them
;
	lhld	nextchar
	inx	h
	bit	7,m
	jrnz	..sasameline
	dcx	h
	dcx	h
	bit	7,m
	jrz	..sasameline
	call	blinesetalterattribute
	inx	h
	mov	b,m
	dcx	h
	mov	a,m
	mov	m,b
	shld	nextchar
	inx	h
	mov	m,a
	jmp	blineresetalterattribute  ;return from
				;there
	.page
;
;	if bit following is same as current bit
;	remove display char if present, otherwise
;	insert display character
;
..sasameline:
	lhld	lcurxy
	inr	l	;hl to point to next bit
	call	bmbtest
	jrnz	..saremove
	lhld	nextchar	;advance nextchar
	push	h	;since store control puts
	inx	h	;before nextchar
	call	skipattribute	
	lda	notagattribute
	call	storecontrol
	pop	h
	shld	nextchar
	jmpr	..sbefore
..saremove:
	call	removaftercursorcontrol
;
;	now adjust after current char if needed
;
..sbefore:
	lda	lcurx	;see if at beginning of line
	cpi	0
	jrnz	..snotatbeginning
;
;	at beginning of line, insert display character
;
	lda	tagattribute
	call	storecontrol
	ret
;
;	not at begining of line, if previous bit
;	is different from current bit, insert control
;	character, otherwise remove character
;
..snotatbeginning:
	lhld	lcurxy
	dcr	l	;get hl to point to previous
	call	bmbtest	;bit
	jrnz	..sremove
	lda	tagattribute
	call	storecontrol
	ret
..sremove:
	call	removbeforecursorcontrol
	ret
	.page
;
;	remove a control character if present
;	from before the current character
;
removbeforecursorcontrol:
	call	blinesetalterattribute
	lhld	nextchar
	dcx	h	
	bit	7,m	;see if attribute char
	jrz	..notattribute
;
;	remove attribute char
;
	call	hltobeginingcurrentline
	xchg
	inx	h
	dcr	m	;count of attribute chars on 
			;line
	lded	nextchar
	dcx	d	;place to copy to
	push	d
	pop	h
	mvi	m,' '	;repace attribute char
	inx	h	;place to copy from
	lda	maxchar	;chars remaining on line
	inr	a	;include cursor char
	mov	b,a
..movloop:
	mov	a,m
	stax	d
	inx	h
	inx	d
	bit	7,a	;if attribute char
	jrnz	..movloop ;does not count for maxchar
	djnz	..movloop
	lhld	nextchar
	dcx	h
	shld	nextchar
..notattribute:
	call	blineresetalterattribute
	ret
	.page
;
;	remove a control character if present
;	from after the current character
;
removaftercursorcontrol:
	call	blineresetalterattribute
	lhld	nextchar
	inx	h	
	bit	7,m	;see if attribute char
	jrz	..notattribute
;
;	remove attribute char
;
	call	hltobeginingcurrentline
	xchg
	inx	h
	dcr	m	;count of attribute chars on 
			;line
	lded	nextchar
	inx	d	;place to copy to
	push	d
	pop	h
	mvi	m,' '	;repace attribute char
	inx	h	;place to copy from
	lda	maxchar	;chars remaining on line
	mov	b,a
..movloop:
	mov	a,m
	stax	d
	inx	h
	inx	d
	bit	7,a	;if attribute char
	jrnz	..movloop ;does not count for maxchar
	djnz	..movloop
..notattribute:
	call	blineresetalterattribute
	ret

