.title	"Copy Floppy Disks"
        .sbttl  "FDCOPY"
version	==	2
revision==	3
;
; LAST REVISED 28JUN82MdG
;
MINIopt	=\ '
Enter 0 for 5 inch disks
      1 for 8 inch disks '
;
	.pabs
	.phex
	.loc	100h		; beginning of TPA
;
; DMS DSC 3/4 Floppy Copy Utility.     D. Stein 8/80
; User selects single or double density.
; System(0-1), Data(2-76), or All tracks can be copied.
; Algorithm :
; 5 tracks are copied to destination disk.  Each track
; is read back to memory one at a time to be verified.
; The buffer can store 6 tracks.  The first 5 tracks
; are copied and the 6th is used to store the track
; read back from the destination disk.
;
; A separate sector table is maintained for single and
 doubl density.
;
; Program loops indefinitely until aborted by a ^C.
;
; What follows is a series of sequential routines.
; The subroutines used by these routines are:
;	getsect	   Get next R/W sector from single
;                  or double density sector table.
;	setdisk	   Set disk for next read or write
;                  increments sector and Dma address.
;	prtmsg	   String output to crt
;	conin	   Chr input from crt
;	stoMAPbyt  Save original MAPbyte
;	chaMAPbyt  Change MAPbyte
;	resMAPbyt  Restore original MAPbyt
;	getcomp    # of compares for SD or DD
;	settrk0	   set track 0 ready to be read
;       readtrk    read a track on the floppy
;	compare	   compare track copied to track read
;	prttrk	   print track number we just copied
;
; revision 6:      eliminate jumps from all of the 
;                  subroutines so the program is 
;                  more reliable. DB 12/11/81
; Version  1.07	Changes made to agree with the modified
;		cpmMAP routine in the BIOS. -11MAY82MdG
;
; Version  1.08 Attempted fix for "first-9-tracks"
;		problem.
;		Found that above problem because bufend
;		was computed from bufbegin, not bufbase.
;		NOTE! All derivatives of this code before
;		19MAY82 should be checked for this.
;				-19MAY82MdG
;
; Ver 1.09	Conditional assembly added for 5 inch
;		drives.	-02JUN82MdG
;
; Ver 2.01	Corrected number of tracks for minis.
;		-08JUN82MdG
;
; Ver 2.02	Corrections for 8 inch version.
;
; Ver 2.03	Minor adjustments to console
;		messages. Final testing.
;		-28JUN82MdG
.page
;------------------
MAIN:
;
;  Set up addresses for BIOS primitives

	lxi	sp,stack    ;Fresh stack
;
	lhld	base + 1    ;get the WBOOT address
	mov	D,H
	mov	E,L	    ;DE = HL
	lxi	H,15h	    ;get the home address
	dad	D	    ;add Wboot address
	shld	home +1	    ;jump loc for home
	lxi	H,18h	    ;get the seldsk addr
	dad	D	    ;add Wboot address
	shld	seldsk + 1  ;jump loc for seldsk
	lxi	H,1Bh	    ;get the settrk addr
	dad	D	    ;add Wboot address
	shld	settrk + 1  ;jump loc for settrk
	lxi	H,1Eh	    ;get the setsect addr
	dad	D	    ;add Wboot address
	shld	setsect + 1 ;jump loc for setsect
	lxi	H,21h	    ;get the setdma addr
	dad	D	    ;add Wboot address
	shld	setdma + 1  ;jump loc for setdma
	lxi	H,24h	    ;get the read addr
	dad	D	    ;add Wboot address
	shld	read + 1    ;jump loc for read
	lxi	H,27h	    ;get the write addr
	dad	D	    ;add Wboot address
	shld	write + 1   ;jump loc for write
	lxi	H,60h	    ;get the CPMmap addr
	dad	D	    ;add Wboot address
	shld	CPMmap + 1  ;jump loc for CPMmap
	lxi	H,66h	    ;get the setbyt addr
	dad	D	    ;add Wboot address
	shld	setbyt + 1  ;jump loc for setbyt
;--------------
;print initial messages 
;
	lxi	D,instr1; greeting
	call	prtmsg	; print
	call	stoMAPbyt ;save users current map byte	
asksrc:			  ;ask for source disk
	lxi	D,query1  ;load source query
	call	prtmsg	  ;print to crt
	call	conin	  ;get char from crt
			  ;returned in reg A
.page
	cpi	cntrlC		
	jz	abort	  ;abort if ^C
	cpi	cntrlB		
	jrz	main
	sui	'0'       ;Make ascii chr numerical
	cpi	08	  ;Out of range?
	jrc	..0	  ;no, store the source disk
	lxi	D,error2  ;yes, so
	call	prtmsg	  ;print err message and
	jmpr	asksrc    ;start this over
..0:	sta	srcedsk	  ;and save it.
askdest:		  ;ask for destination disk
	lxi	D,query2  ;load destin message
	call	prtmsg	  ;print message
	call	conin	  ;get char. from accum
	cpi	cntrlB
	jrz	asksrc	  ;backstep if ^B
	cpi	cntrlC
	jz	abort     ;abort if ^C
	sui	'0'	  ;Make ascii numeric
	cpi	08	  ;Out of range?
	jrc	..1	  ;no, so store dest disk 
	lxi	D,error2  ;yes, so print error msg
	call	prtmsg	  ;print err mess.
	jmpr	askdest   ;and try again.
..1:	sta	destdsk   ;and save it.
densfind:		  ;ask for density
;
	.ifn	MINIopt, [
	lxi	D,instr3  ;load dens question
	call	prtmsg	  ;and print it.
	call	conin     ;Get chr from console
	cpi	cntrlC
	jz	abort     ;abort if ^C
	cpi	cntrlB
	jrz	askdest   ;backstep if ^B
	ani	0DFh	  ;Make it UPPER CASE
	cpi	'S'	  ;S is single density
	mvi	C,SDbyt	  ;load sing dens code
	mvi	B,26 	  ;SD bytes per sector
	lxi	H,SDscttbl ;load SD table address
	jrz	..1	  ;return if S
	cpi	'D'	  ;D is double density
	mvi	C,DDbyt	  ;load doub dens code
	mvi	B,52 	  ;DD bytes per sector
	lxi	H,DDscttbl ;load DD table address
	jrz	..1	  ;if neither,
        lxi	D,error3  ;Load dens err msg
	call	prtmsg
	jmpr	densfind  ;and ask again.
..1:	mov	A,C       ;get dens code in A
	sta	DENSbyt	  ;Save dens code.
	mov	A,B
	]
;
	.ife	MINIopt, [
	mvi	A,MINI2
	sta	DENSbyt
	mvi	A,sect5
	lxi	H,DDscttbl
	]
;
	sta	numsect   ;Save num of sectors
	shld	tablstrt  ;Save sect tabl addr
.page
asktrk:			  ;ask user how many tracks
	lxi	D,query4  ;get copy message
	call	prtmsg	  ;print message
	call	conin	  ;get char from CRT
	ani	0DFh	  ;Make it UPPER CASE
	cpi	'S'
	jrz	..sys
	cpi	'D'
	jrz	..data
	cpi	'A'
	jrz	..all
        cpi	cntrlB
	jrz	densfind  ;backstep if ^B
	cpi	cntrlC
	jz	abort     ;abort if ^C
	lxi	D,error5  ;all tests failed so load
	call	prtmsg	  ;and print err message
	jmpr	asktrk	  ;and start this over
;
;Program used for copying the operating system.
..sys:	mvi	A,0
	sta	fsttrk
	.ifn	MINIopt,[
	mvi	A,1
	]
	.ife	MINIopt,[
	mvi	A,2
	]
	sta	lasttrk
	jmpr    ..2        ;ready to copy floppy
;
;Program used for copying the disk data.
..data:
	.ifn	MINIopt,[
	mvi	A,2
	]
	.ife	MINIopt,[
	mvi	A,3
	]
	sta	fsttrk
	.ifn	MINIopt,[
	mvi	A,76
	]
	.ife	MINIopt,[
	mvi	A,159
	]
	sta	lasttrk
	jmpr    ..2        ;ready to copy floppy
;
;Program used for copying all tracks.
..all:	mvi	A,0
	sta	fsttrk
	.ifn	MINIopt,[
	mvi	A,76
	]
	.ife	MINIopt,[
	mvi	A,159
	]
	sta	lasttrk
..2:	lxi	D,instr4  ;ready message
	call	prtmsg	  ;print it
        call	conin
	cpi	cntrlB     
	jrz	asktrk    ;backstep if ^B
	cpi	cntrlC    ;if request is ^C,
	jz	abort	  ;abort the program
	lda	srcedsk   ;source disk
	lxi	H,destdsk ;are source and destination
	cmp	M	  ;disks the same?
	jrnz	..start	  ;No. Start copying
	lxi	D,error4  ;Yes. Print error msg
	call	prtmsg
	jmp	asksrc    ;and start over.
.page
..start:
	call	HOMEboth  ;Home both drives
	lxi	D,instr2  
	call	prtmsg	  ;skip a line
	lda	fsttrk    ;first track to read
	sta	trknum    ;store it 
	sta	crnttrk	  ;transcient track number
	call	getcomp
READ5:
	lda	srcedsk  ; get source disk
	call	chaMAPbyt ;and select it.
	lhld	bufbegin
	shld	bufloc   ;for dma addressing
	lda	crnttrk	 ;current track
	sta	trknum	 ;keep for check
	cpi	0	 ;trk0? if not, then go
	jrnz	..1      ;read sect. by sect.
	call	setrk0	 ;set trk0 ready to
	call	read	 ;be read
	lxi	b,sectbyt ;reset # of bytes to
	call	setbyt	 ;128 for next i/o
	lded	bufloc   ;increment buffer addr
	lxi	h,trk0bytes ;by the # of bytes in
	dad	d	 ;track 0
	shld	bufloc   ;track 0 read
	jmpr	..2	 ;next track
..1:	call	readtrk  ;read one track
	lda	crnttrk	 ;if current track = last
	lxi	H,lasttrk ;track, 
	cmp	M	 
	jrz	..3	 ;write last tracks
..2:	lda	crnttrk
	inr	A	 ;increment track # after read
	sta	crnttrk	 
	sta     lsttrkrd ;highest track # read
	lxi	H,trknum ;minus track we started on
	sub	M	 ;have we read 5 tracks
	cpi	5        
	jrnz	..1	 ;if yes, write and verify
.page
.sbttl "WRITE AND COMPARE"
;
;write, read and verify the track written to floppy
;						
..3:
	lda	destdsk   ;get destin. disk
	call	chaMAPbyt ;and select it.
	lhld	bufbegin  ;get buffer address
	shld	bufloc    ;save for dma
	shld	cmpbuf    ;add where verify start
        lda     trknum
	sta	crnttrk	  ;first of 5 tracks
	cpi	0	  ;is it trk0 ?
	jrnz	wrttrk    ;if not, regular write
	call	setrk0	  ;else set trk0
	call 	write	  ;go write it
	lxi	b,sectbyt ;reset # of bytes to 
	call 	setbyt	  ;128 for next i/o
	lded	bufloc    
	lxi	h,trk0bytes ;increment buffer by
	dad	d	  ;# of bytes inn trk0
	shld	bufloc  
	jmpr	read1	  ;read back track and verify
;---------------
wrttrk:			  ;other than track0 
	call	setdisk	  ;set up disk for read
	lda	sectontrk ;get num of sec on
	mov	B,A	  ;this track in B.
..1:	push	B
	call	getsect	  ;Get next sector
	mov	C,A		
	call	setsect	  ;and select it.
	lbcd	bufloc	
	call	setdma	  ;Set DMA
	call	write	  ;write one sector
	lded	bufloc	  ;present buffer addr
	lxi	H,128     ;bytes per sector
	dad	D	  ;increment buffer to
	shld	bufloc    ;write the next sector
	pop	B
	djnz	..1	  ;Do all sectors
	shld	tmpbuf    ;save end of buffer addr
.page
; read back track just copied and verify it
read1:
	lda	crnttrk	  ;if trk0 then read
	cpi	0	  ;whole track. if not
	jrnz	..1	  ;read 1 sect. at a time
	mvi	c,1	  ;first sector
	call	setsect	  ;set it for read
	lxi	b,buf6	  ;buffer loc. to store
	call	setdma	  ;trk to be verified
	lxi	b,trk0bytes ;# of bytes in trk0
	call 	setbyt	 
	call	read	
	lxi	b,sectbyt ;reset # of bytes to
	call 	setbyt	  ;128 for next i/o
	jmpr    verify	  ;go verify track copied
..1:	lxi	h,buf6	  ;parameter passing to
	shld	bufloc	  ;subroutine readtrk
	call  	readtrk   ;read one track
	lhld	tmpbuf    ;restore init. value
	shld	bufloc    ;of buffer and verify copy
;---------------
VERIFY: 
	lda	crnttrk	  
	lxi	h,lasttrk	
	cmp	m		
	jrz	theend	  ;end of copy
	cpi	0	  ;is it track 0 ?
	jrnz	..1		
	lxi	h,trk0bytes ;# of comp for trk0
	shld	noofcomp  
	jmpr	..2	
..1:	lhld	cmpned	  ;# of comp for 
	shld	noofcomp  ;other tracks
..2:	call	compare	  ;go verify copied trk
	cpi	'/'	  ;if accum = '/', we have
	jrz	badcopy	  ;badcopy so print message
	lxi	h,trknum  ;have we written and
	inr	m	  ;verified the 5 tracks
	lda	lsttrkrd  ;read ? if so, go 
	sub	m	  ;read another 5 trks
	jrz	..3	  ;and repeat same thing
	lda	trknum    ;else keep copying and
	sta	crnttrk	  ;verifying
	lhld	bufloc    ;reset next loc in buf
	shld	cmpbuf    ;where verify start
	jmp     wrttrk
..3:	mov	a,m
	sta	crnttrk	  ;update current track
	jmp	read5	  ;read another 5 trks
.page
.sbttl "FINISH"
;------------------
; END OF R/W LOOP
;------------------
abort:			  ;didn't do it right
	call	resMAPbyt ;restore org assmt	
	lxi	D,instr9  ;load abort message
	call	prtmsg	  ;print message
	jmp	base	  ;wboot
;--------------- 
theend:	
        lhld	cmpned	  ;# of comp. needed
	shld	noofcomp  
	call 	compare	  
	cpi	'/'	  ;if accum = '/', we have
	jrnz	restart	  ;badcopy so print message
;---------------
badcopy:
	call	prttrk	  ;print bad track 
	lxi	d,error6  ;print 
	call	prtmsg	  ;copy error message
	lxi	d,crlflf  
	call	prtmsg	
	jmp	asksrc	  ;retry again
;---------------
; Successful disk copy has been made.  Loop back.
restart:
	call	HOMEboth
	lxi	D,instr7  ;job completed msg
	call	prtmsg	  ;print msg
	lxi	D,crlflf
	call	prtmsg	  ;Double line feed
	jmp	asksrc    ;and start over.
.page
.sbttl "SUBROUTINES"
;--------------
;  SUBROUTINES
;--------------
;
;  DISK I/O SUBROUTINES
;
;---------------
; HOMEboth seeks track 0 on both drives
HOMEboth:
	lda 	destdsk   ;destination disk
	call	chaMAPbyt ;Select destination disk
	call	HOME	  ;and home it.
	lda	srcedsk   ;source disk
	call	chaMAPbyt ;Select source disk
	call	HOME	  ; and home it.
	ret
;---------------
; Subroutine:	setrk0
; Regs in:	a = crnttrk
; Regs out:	none
; destroyed:	a,bc
;
setrk0:	
        mov	c,a	  ;argument for settrk
	call	settrk		
	mvi	c,1	  ;argument for setsect
	call	setsect	  ;set first sector
	lxi	b,trk0bytes ;# of bytes read
	call	setbyt		
	lbcd	bufloc    ;dma addr.
	call	setdma		
	ret			
;---------------  
; Subroutine readtrk: read a track on the floppy
; Regs in:	none
; Regs out:	none
; Destroyed:	all
readtrk:
	call	setdisk	  ;set up disk for read
	lda	sectontrk ;Get the num of secs
	mov	B,A	  ;on this track in B.
..1:	push	B	  ;Use it as a counter.
	call	getsect
	mov	C,A
	call	setsect
	lbcd	bufloc	
	call	setdma
	call	read	  ;read one sector
	lded	bufloc	  ;location of buffer
	lxi	H,128	  ;bytes per sector 
	dad	D	  ;increment the buffer
	shld	bufloc    ;to read the next track
	pop	B	  ;Restore the counter
	djnz	..1	  ;Do all sectors
	ret
.page
;---------------
; Subroutine setdisk: set number of sectors on track.
; Regs  in:	none
; Regs out:	none
; Select next track.
; Reset sector table address.
; Abort if ^C is received from the console.
;
setdisk:
	lda	crnttrk
        mov	C,A	  ;get current track
	call	settrk    ;and select it
	lda	numsect
	sta	sectontrk ;# of sect on track
	lhld	tablstrt  ;Get sect tabl addr
	shld	tabladdr  ;to start the start
	mvi	C,0Bh	  ;CPM constat function
	call	05	  ;BDOS
	ora	A	  ;Reset carry flag.
	rrc		  ;Set carry if console
			  ;chr is ready.
	rnc		  ;Return. No chr ready.
  	call	conin	  ;Read con chr
	cpi	cntrlC
	jz	abort	  ;abort if ^C
	ret		  ;otherwise return
;---------------
; Subroutine getcomp: find # of compares needed for
; each track ; i.e single density only need 128*26
; comparisons.
; regs in : none
; regs out : none
; destroyed : hl,bc
getcomp:
	.ifn	MINIopt,[
	lxi	h,numsect ;# of sectors per track
	mov	a,m	  ;is it single density ?
	cpi	26	  ;if not, goto double
	jrnz	..52sect  ;density routine
	lxi	d,trk0bytes ;get # of SD comparisons
	sded	cmpned	  ;save compares needed
	ret
..52sect:
	lxi	d,52*sectbyt ;# of comp. for DD disk
	]
	.ife	MINIopt,[
	lxi	D,32*sectbyt
	]
	sded	cmpned	  ;save compares needed
	ret
.page
;---------------
;Subroutine stoMAPbyt: save current disk assignment
; Regs  in:	none
; Regs out:	none
;Destroyed:	all registers
;
stoMAPbyt: 
	call	CPMmap	; get current assignment
	sta	UNITno	; save it for later restoration
	dcx	H	; point to media type
	mov	A,M	; get the media type
	sta	DEVtype	; store for later
	ret		; and return.
;---------------
;Subroutine chaMAPbyt:  Change the map byte
; Regs  in:	A = unit number to assign to
; Regs out:	none
;Destroyed:	all registers
;
; Change the assignment to the floppy disk of
; the unit number received in the accumulator.
;
chaMAPbyt:
	push	PSW	  ;Save unit number
	call	CPMmap	  ;get current MAPbyte byte addr
	pop	B	  ;Restore unit number in B
	mov	M,B	; put unit number in DPB
	dcx	H	; point at media type
	lda	DENSbyt	  ;Get floppy density code
	mov	M,A	  ;Store it in the BIOS
	ret
;---------------
; Subroutine  resMAPbyt: restore original disk 
; Regs  in:	none
; Regs out:	none
;Destroyed:	all registers
;
resMAPbyt:
	call	CPMmap	; get BIOSmap addr
	lda	UNITno	; original assignment
	mov	M,A	; restore previous assignment
	dcx	H	; point at media type
	lda	DEVtype	; get original media type
	mov	M,A	; store in DPB
	ret		; and return.
.page
;---------------
; Subroutine getsect: get next sector from table
; Regs  in:	none
; Regs out:	A = next sector in sector table
; Destroyed:	HL
; Increment to next address in table
;
getsect:
	lhld	tabladdr  ;get spot in sect tabl
	mov	A,M	  ;get sector value
	cpi	0FFh	  ;End of table?
	jrz	..1       ;Yes. abort.
	inx	H	  ;get to next table addr
	shld	tabladdr  ;and save it.
	ret		  
..1:			  ;fatal error
	lxi	D,error1  ;Print sector fall-
	call	prtmsg	  ;thru message.
	jmp	abort	  ;Fatal error. Abort.
;---------------
; Subroutine compare: compare the track just copied 
; with the same track read 
; regs in: none		
; regs out: none
; destroyed: all
;
compare:
	lxi	d,0	  ;initialize counter
	sded	compcntr  ;save it
	lhld	cmpbuf    ;where trk from source
	push	h	  ;is stored; save it
	lxi	b,buf6	  ;where dest. track is
..1:    pop	h	  ;get one byte
	mov	d,m	  ;from source
	ldax	b	  ;get one byte from dest
	cmp	d	  ;compare the two bytes
	jrnz	..exit	  ;copy error!!
	inx	h	  ;else get next byte 
	inx 	b	  ;from source & dest.
	push	h	  ;save next addr of compare
	lded	compcntr  ;get current count
	inx	d	  ;increment it
	sded	compcntr  ;save it
	lhld	noofcomp  ;max # of comp. needed
	ora	a	  ;clear carry bit
	dsbc	d	  ;done? if not,
	jrnz	..1	  ;keep comparing
	pop	h	  ;balance stack
	call	prttrk 	  ;print track copied
	ret		  ;and return to caller
..exit: mvi	A,'/'     ;we have copy error so
	ret		  ;return with flag in accum
.page
;---------------
;  CRT I/O SUBOUTINES
;---------------
; subroutine prttrk:  print track number we just copied
;
prttrk:
	lda	crnttrk
	mov	C,A	;save for low bit
	rrc
	rrc
	rrc
	rrc
	ani	0Fh
	adi	30h
	cpi	3Ah
	jrc	..1
	adi	'A'-':'
..1:	sta	trkmsg	;for display of track number
	mov	A,C
	ani	0Fh
	adi	30h
	cpi	3Ah	;10 or greater?
	jrc	..2	;skip if not
	adi	'A'-':'
..2:	sta	trkmsg + 1
	lxi	D,disptrk ;load track number copied
	call	prtmsg	;print it
	ret
;---------------
;  		Subroutine:  prtmsg  
; This subroutine sends string output to the CRT.
;
prtmsg:	
	mvi	C,9	; console output
	call	05	; bdos
	ret			
;---------------
;  		Subroutine:  conin
; This subroutine gets character input from the crt.
;
conin:		
	mvi	C,1	; console input
	call	05	; bdos
	ret
.page
.sbttl "CONSTANTS"
;------------------
;  Data and Address constants
;
cr	==      0Dh
lf	==	0Ah
cntrlB	==      2h
cntrlC	==      3h
sect5	==	32	; # CP/M secs/track on mini
srcedsk:.byte	0	;source disk
destdsk:.byte	0	;Destination disk
curdsk:	.byte	0	;current selected disk
bufloc:	.word 	00	;current DMA location
trknum:	.byte	0	;first track read or written
fsttrk:	.byte 	0	;first track to copy
lasttrk:.byte	0	;last track to copy
crnttrk:.byte	0	;current track for R/W
numsect:.byte	0	;sectors per track (26 or 52)
			;or 32, for mini
sectontrk:
	.byte	0	;num of secs on current track
tablstrt:
	.word	00	;start addr of sect tabl
tabladdr:
	.word	00	;current address in sect tabl
UNITno:	.byte	0	; original drive/partition no.
DEVtype:.byte	0	; original media type
DENSbyt:.byte	0	;Holds BIOS density code
MINI2	==	5<5
DDbyt	==	1<5	;Double density BIOS code
SDbyt	==	0<5	;Single density BIOS code
orgdriv:.byte  	0	;Current drive number
base	==	0	;base address
sectbyt ==	128
bufbase	==	1000h		;disk buffer base
	.ifn	MINIopt,[
bufsize ==	sectbyt*52*6 ;6 tracks of DD
trk0bytes ==   	sectbyt*26 ;# of bytes in track 0
buf6   == bufbase + 128*52*5
bufend == bufbase + 128*52*6
	]
	.ife	MINIopt,[
bufsize	==	sectbyt*32*6
trk0bytes ==	sectbyt*32
buf6   == bufbase + 128*32*5
bufend == bufbase + 128*32*6
	]
lsttrkrd:  .byte 0        ;lastest track read
cmpbuf:	   .word 0        ;loc where verify start
tmpbuf:	   .word 0        ;temporary storage
cmpned:    .word 0        ;# of compares needed
; 6 track disk I/O buffer
;
bufbegin : .word bufbase
compcntr : .word 0	  ;counter for # of comp.
noofcomp : .word 0	  ;# of comp. (sd or dd)
home:	jmp	0  	  ;BIOS addresses are filled in
seldsk:	jmp	0	  ;during the first part of the
settrk:	jmp	0	  ;MAIN  execution.
setsect:jmp	0
setdma:	jmp	0
read:	jmp	0
write:	jmp	0
CPMmap:	jmp	0
setbyt:	jmp	0
.page
;---------------
;Staggered sector tables for optimized Reads/Writes

SDscttbl:	; Single Density staggered sector table
	.ifn	MINIopt,[
	.byte 01,03,05,07,09,11,13,15,17,19,21,23,25,02
	.byte 04,06,08,10,12,14,16,18,20,22,24,26,0FFh
	]
DDscttbl:	; Double Density staggered sector table
	.ifn	MINIopt,[
	.byte 01,02,33,34,13,14,45,46,25,26,05,06,37,38
	.byte 17,18,49,50,29,30,09,10,41,42,21,22,11,12
	.byte 43,44,23,24,03,04,35,36,15,16,47,48,27,28
	.byte 07,08,39,40,19,20,51,52,31,32,0FFh
	]
	.ife	MINIopt,[
	.byte 01,02,03,04,05,06,07,08,09,10,11,12,13,14
	.byte 15,16,17,18,19,20,21,22,23,24,25,26,27,28
	.byte 29,30,31,32,0FFh
	]
;
; Unused sector table below. It may be useful
; someday.
;	.byte 01,02,05,06,09,10,13,14,17,18,21,22,25,26
;	.byte 29,30,03,04,07,08,11,12,15,16,19,20,23,24
;	.byte 27,28,31,32,0FFh
.page
;------------------
;  Messages to the operator
instr1:	.ascii	[cr][lf]'Floppy Copy Program '
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.ascii	' for '
	.byte	'5'+3*MINIopt
	.ascii	'-inch disks.'
instr2:	.ascii	[cr][lf]'$'
instr3:	.ascii	[cr][lf]'Density? (S/D) $'
instr4:	.ascii	[cr][lf]'Hit return when ready$'
instr7:	.ascii	[cr][lf]'**  JOB COMPLETED  **$'
instr8:	.ascii	[cr][lf]'**  JOB TERMINATED  **$'
instr9:	.ascii	[cr][lf]'**  JOB ABORTED  **$'
vermsg1:.ascii  [cr][lf]'**  VERIFICATION DONE  **$'
query1:	.ascii	[cr][lf]'Source disk (0-7) :$'
query2:	.ascii	[cr][lf]'Destination disk (0-7) :$'
query4:	.ascii	[cr][lf]'COPY: System tracks, Data'
	.ascii	' tracks, or '
	.ascii	[cr][lf]'      All tracks? '
	.ascii	' (S,D, or A)? $'
error1:	.ascii	[cr][lf]'FELL THROUGH SECTOR TABLE$'
error2:	.ascii	[cr][lf]'IMPROPER DISK SELECTION$'
error3:	.ascii	[cr][lf]'IMPROPER DENSITY SELECTION$'
error4:	.ascii	[cr][lf]'SAME SOURCE AND DESTINATION$'
error5: .ascii	[cr][lf]'IMPROPER COPY COMMAND$'
error6: .ascii  [cr][lf]'** BAD TRACK HERE ! retry-$'
disptrk:.ascii	[cr]'Track ' 
trkmsg:	.ascii	'00h'
	.ascii	' copied'[cr]	; tracknumber display
	.ascii	'$'
crlflf:	.ascii	[cr][lf][lf]'$'
;
;----------
; Stack room
	.blkb	30
stack:

.end
