


.title 'Key Saver for the FOX'
.ident keysave
.SBTTL 7EQUATE DEFINITION AREA7
	.PABS
	.PHEX
	.sall
	version == '1'
	revision == '0'
	assembly == ' '
;
; *****************************************
;	EQUATE AREA
;	
	lf==0AH
	cr==0DH
	true==0ffH
	false==0
	bell == 07h
	superesc == 0fbh

;  *  *  *  *  *  *  *  *  *  *  *  *
;  internal file has equates for standard BDOS calls
BDOS==5
BDSYSRES==0
BDCONIN==1
BDCONOUT==2
BDREADIN==3
BDPUNOUT==4
BDLSTOUT==5
BDDIRCONIO==6
BDGTIOBYTE==7
BDSTIOBYTE==8
BDPRINT==9
BDRDCONBUF==0AH
BDGTCONSTAT==0BH
BDVERNUM==0CH
BDRESDISK==0DH
BDSELDISK==0EH
BDOPFILE==0FH
BDCLFILE==10H
BDSRCFIRST==11H
BDSRCNEXT==12H
BDDLFILE==13H
BDRDSEQ==14H
BDWRSEQ==15H
BDMKFILE==16H
BDRNFILE==17H
BDLOGVECT==18H
BDCURDISK==19H
BDSTDMA==1AH
BDGTALLOC==1BH
BDWRPROT==1CH
BDGTROVECT==1DH
BDSTFILEATTR==1EH
BDGTDSKPARM==1FH
BDUSERCODE==20H
BDRDRAND==21H
BDWRRAND==22H
BDFLSIZE==23H
BDSTRAND==24H
;
; END BDOS CALL EQUATES
;    * * * * * * ;
	masktop3 == 1fh
	lastkey == 1fh
;
;  FCB equates
	fcbname==1
	fcbext==9
	fcbex==12
	fcbs1==14
	fcbcr==32
	fcbr0==33
;
;
;	END of EQUATE AREA
;
; **********************************************
.SBTTL 7MACRO DEFINITION AREA7
;    MACRO AREA
;
;  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
; OUTMESS - outputs message name to screen, saves 
;		environment	
.define outmess [messname]=
[	lxi	d,messname
	call	messout
]
; END OUTMESS MACRO
;  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
; jmpdegthl - jmp if de > HL
	.define	jmpdegthl[jmpaddr]=[
	ora	a	; clear cy
	dsbc	d
	jc	jmpaddr ]
; END JMPDEGTHL MACRO
; ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
; DRcomp - does double register compare
	.define	DRcomp [r1h,r1l,r2h,r2l,%DRC]=[
	mov	a,r1h
	cmp	r2h
	jnz	%DRC
	mov	a,r1l
	cmp	r2l
%DRC:
	]
;
;    END MACRO AREA
;*****************************************************

.PAGE
.SBTTL  7MAIN LOGIC7
;
	.LOC	100H
start:
;  com line processor
	outmess	headMess
	call	cmlproc
	lda	iscomline
	cpi	true
	jz	minFileopen
	call	fileOpen
flopret:
;  inits
	lxi	h,last
	shld	buffplace
; no shifted keys
	mvi	a,81h
	sta	curkey
	call	readset
; cap shift
	mvi	a,0A1h
	sta	curkey
	call	readset
; control shift
	mvi	a,0C1h
	sta	curkey
	call	readset
; puit trailing 0 in memory
	lhld	buffplace
	mvi	m,0
; write memory to file
	call	wtFile
; close file
	lxi	d,kbdFCB
	mvi	c,bdclFile
	call	bdos
	jmp	0
;
minfileopen:
	call	midFileopen
	jmp	flopret
;
;	end of main logic
;  *****      *****    **** 
; get keys for entire board of one shift type
readset:
	; ask for key string
	lxi	d,kreadSeq	;addr of key read string
	lxi	b,krSeqlen
	call	conout
	; wait loop for input
	lxi	b,20000
..wait:
	dcx	b
	mov	a,b	; waste
	ora	c
	jrnz	..wait
	; now read responxe
	call	conin
	; first byte in response is length
	; if a is zero do next key, 
	ora	a
	jz	nextkey
	; store curkey and length
	mov	b,a	; save length
	lda	curkey
	lhld	buffplace
	mov	m,a	; store key
	mov	a,b	; length
	inx	h
	mov	m,a	; store length
	inx	h
..keyloop:
	push	h
	push	b
	call	conin
	pop	b
	pop	h
	mov	m,a	; stoe char
	inx	h
	djnz	..keyloop
; sequence is now moved into memory, 
; h has addr of next place avail
	shld	buffplace
nextkey:
	; increment key 
	lda	curkey
	inr	a
	sta	curkey
	; see if last key 
	ani	masktop3
	cpi	lastkey
	rz
	jmp	readset	; get next key

; end of readset
;
;  +++++++++++++++++++++++++++++
;
;  WTFILE - writes memory out to file.  Keeps writing
;	 till de > buffplace
;
wtfile:
	lxi	d,last
..wtloop:
	push	d
	;set DMA
	mvi	c,bdstDMA
	call	bdos
	; write record
	lxi	d,kbdFCB
	mvi	c,bdWrSeq
	call	bdos
	pop	d
	lxi	h,128
	dad	d	; hl has next record to write
	xchg
	lhld	buffplace
	; compare de to hl
	ora	a	; reset carry
	dsbc	d
	jnc	..wtloop
	; on drop through done writing
	ret
;	END of WtFILE
;
; ++++++++++++++++++++++++++++++++++++++++++++++++
; FILEOPEN gets PRN file name, opens PRN file, erases old 
;	XRF file, and opens a work file  
fileOpen:
	outmess	nameMess	;prompts for file name
	call	inmess		; gets name from user
	mvi	a,false
	sta	isComLine	; if we jump here because
				; of bad filename reject 
				; command line
midfileopen:	; jumps here if got name from command line
	lda	conlength	; length name read > 0?
	ora	a
	jz	badfilename
	call	extractFN
	; put opening message and file name to screen
	outmess	opprnmess
	call	FNprint		
	; open KBD file
	lxi	d,KBDFCB
	call	loadFCB		; loads up PRNfcb
	lxi	d,KBDFCB
	mvi	c,bdOpFile	
	call	bdos	; open file, rets FFh on fail
	cpi	0FFh
	rnz	
	; make new file
	lxi	d,KBDfcb
	call	loadFCB
	lxi	d,KBDfcb
	mvi	c,bdMkfile
	call	bdos
	cpi	0ffh
	rnz	
	; no room on disk 
	lxi	d,dskfullmess
	mvi	c,9	;printstring
	call	bdos
	jmp	0

; FILEOPEN error routines
; 
;  if invalid PRN file name was entered
badfilename:
	outmess	badnamemess
	jmp	fileOpen
;

;
; FILE OPEN subroutines
;
; EXTRACTFN gets file name & drive number from console 
;	buffer, and loads them into FLNAME and DRVNUM
extractFN:
	; load DRVNUM with 0 and filename with blanks
	lxi	b,8
	lxi	d,filename
	lxi	h,blanks
	ldir
	lxi	b,3
	lxi	d,filext
	lxi	h,blanks
	ldir
	xra	a
	sta	DRVNUM	; set drivenum to zero
	;
	lxi	h,conlength
	mov	b,M
	inx	h	; addr of condata
	push	h
	call	capit
	; if length is less than 3 don''t check for :
	pop	h	; h has addr condata
	lda	conlength
	mov	c,a
	cpi	3
	jm	extrc1
	; check for : in second character of string
	inx	h	; h has second position
	mov	a,M
	dcx	h	; hl points to condata
	cpi	':'
	jnz	extrc1   ; leave drivenum at zero
	; change drivenum
	mov	a,M	; drive char is now in a 
	sta	drvChar
	sbi	'A'-1
	sta	drvnum
	inx	h
	inx	h	; hl has start of name
	lda	conlength
	dcr	a
	dcr	a	; a has length of file name
	mov	c,a
; MOVE FILE NAME
; At this point hl points to name in buffer and c holds its length. If length
;	is greater than 8 then truncate to 8
extrc1:
	lxi	d,filename
	mov	a,c
	cpi	9
	jm	extrc2
	mvi	c,8
extrc2:
	; now that c has the maxlength, 
	; h is source, d is target , start 
	; moving till endchar or max length is hit
	mov	a,m
	cpi	' '
	rz	; end of valid entry
	cpi	'.'
	jrz	extrc3
	stax	d
	inx	h
	inx	d
	dcr	c
	jrnz	extrc2
extrc3:
	; get extension if any 
	; at this point h points to . if there is an 
	; extension
	mov	a,m
	cpi	'.'
	rnz
	inx	h	; first char in extension
	push	h
	lxi	h,conlength
	mov	e,m
	mvi	d,0
	dad	d	
	inx	h  ; addr past last byte in string
	pop	b ; current byte
	push	b
	ora	a	;;reset carry
	dsbc	b	; hl has length of extenison
	mov	a,l	
	cpi	4      ; max length
	jm	extrc4
	mvi	a,3
extrc4:
	mov	c,a
	mvi	b,0
	pop	h    ; current byte in input string
	lxi	d,filext
	ldir
	ret
;	
;
; END of FILEOPEN subroutine
;
;
;
; +++++++++++++++++++++++++++++++++++++++++++
; checks for and processes command line
CmlProc:
	mvi	a,false
	sta	iscomLine
	lxi	h,80h
	mov	a,m	; length of command string
	cpi	2
	rc
	dcr	a	;drop leading blank from length
	sta	comlength
	inx	h
	inx	h
	mov	a,m
	cpi	' '
	rz	; second char is a blank, reject
		; command lline
	; there is a command string
	mvi	a,true
	sta	isComline
	; find end of file and extent name
	lxi	b,1
cml1:
	inx	h
	inr	c
	lda	comlength
	cmp	c
	jc	cml2
	mov	a,m
	cpi	' '
	jz	cml2
	jmpr	cml1
cml2:		; bc has length+1, move file name 
		; string into condata
	dcr	c
	lxi	d,conlength
	mov	a,c	; length
	stax	d
	inx	d
	lxi	h,82h	; begining of file name
	ldir
	ret

; ++++++++++++++++++++++++++++++++++++++++++
; CAPIT capitalizes all letters in string pointed to 
;	by hl of length b
capit:
	mov	a,M
	call	capOne
	inx	h
	dcr	b
	jnz	capit	
	; if we drop through whole string is exameined
	ret
capone:		; checks if char needs to be capped
	cpi	'a'
	rm
	cpi	'z'+1
	rp
	res	5,M
	ret
; END of CAPIT
;
; ++++++++++++++++++++++++++++++++++++++++++++
;  LOADFCB - moves file name and drivenum into FCB at 
;	addr in de
LOADFCB:
	push	d
	lxi	h,drvnum
	ldi
	lxi	h,filename
	lxi	b,8
	ldir
	lxi	h,filext
	lxi	b,3
	ldir
;	
	; zero out ex,cr,r0,r1,r2
	xra	a	
	pop	h
	lxi	d,fcbex
	dad	d
	mov	m,a	; zeroes ex
	lxi	d,fcbs1-fcbex
	dad	d
	mov	m,a	; zeroes cr
	lxi	d,fcbcr-fcbs1
	dad	d
	mov	m,a	; zeroes cr
	inx	h
	mov	m,a	; now zero three random bytes
	inx	h
	mov	m,a
	inx	h
	mov	m,a
	ret
; END of LOADFCB
; +++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; FNprint - prints out the file name, checking drive 
;	num to see if it needs to print out the drve 
;	character also
FNprint:
	lda	drvnum
	cpi	0
	jz	Fnpr1
; drive number not zero so print drive char also
	outmess	drvchar
	ret
FNpr1:
	outmess	filename
	ret
; END of FNPRINT
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; INMESS - gets message from screen of up to 80 chars, 
;	saves environment	
INMESS:
	push	h
	push	b
	push	d
	mvi	c,bdrdcon
	lxi	d,conbuff
	call	bdos
	outmess	crlfmess   ; put out carraige return
	pop	d
	pop	b
	pop	h
	ret
; END INMESS SUBROUTINE
;
;  ++++++++++++++++++++++++++++++++++++++++++++
;
;MESSOUT - outputs message to screen
messout:
	push	h
	push	b
	push	d
	mvi	c,bdprint
	call	bdos
	pop	d
	pop	b
	pop	h
	ret
; END OF MESSOUT
;
;    ++++++++++++++++++++++++++++++++++++++++++
;  CONOUT
; de has addr of message, bc has length
;
conout:
	xchg
..loop:
	push	h
	push	b
	mov	e,m	
	mvi	c,6
	call	bdos
	pop	b
	pop	h
	dcx	b
	mov	a,b
	ora	c
	rz
	inx	h
	jmp	..loop	
;
;	conin  - read one char into a
;
conin:
	; wait
	mvi	b,08fh
..cwait:
	mov	c,b
	djnz	..cwait
	; read
	mvi	e,0ffh
	mvi	c,6
	call	bdos
	ret
;


;
.PAGE
.SBTTL 'DATA AREA'
;
;  CONSTANTS
;
BLANKS:		.ASCII	'         '
;
;	MESSAGE AREA 
;	MESSAGE AREA 
headMess:	.ascii 'KeySaver version '
		.byte	version,'.',revision,assembly
crlfmess:		.byte	lf,cr,'$'

nameMess:	.byte	lf,cr
		.ascii 'Enter name of file to save keys to $'
badnameMess:	.byte	lf,cr
		.ascii 'No file with that name. Please try again'
		.byte	lf,cr
		.ascii	'or enter control C to abort.$'
opPrnmess:	.ascii	'Opening file $'
dskfullmess:	.byte	lf,cr
		.ascii	/Can't open file.  Check to see if disk is full.$/
		
;
;	END MESSAGE AREA	
;
;
;
;		
;
;  *****   data for key control
kreadSequence:	.byte	superesc,'g'
curkey:		.blkb	1
krseqlen == . - kreadSeqeunce
buffplace:	.blkw	1	; displacement of next char

;
;
;mainDMA:		.byte	0,80H     ; system default value of DMA 
;
;   File Name Variables
drvnum:		.blkb	1
drvchar:	.blkb	1
		.byte	':'
filename:	.blkb	8
		.byte	'.'
filext:	.blkb	3
		.byte	'$'
;
;    ***** FCB area ******
KBDfcb:		.BLKB	9	;drive number & file name
		.ascii	'   '	;extension
	
		.BLKB	21	;remainder of FCB
randrec:	.blkb	3


YYYfcb:		.BLKB	9	;drive number & file name
		.ascii	'YYY'	;extension
		.BLKB	24	;remainder of FCB

;		
;   **** input form console ****
conbuff:	.BYTE	80	; buffer for console 
			;messages (80 max input)
conlength:	.BLKB	1	; length of input
condata:	.BLKB	80	; input data
;
	
; DATA for handleing command line
;
iscomline:	.blkb	1	; is there a command line
comflag	:	.blkb	1	; whats in comand line
comlength:	.blkb	1   ; length of command string 
		            ; minus one for leading blank

	
;
last:
	.end	start
